package com.elitesland.scp.domain.service.msg.impl;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.cacheable.SysCacheUserRpcService;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.resp.msg.BaseScpMessageDetailRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.BaseScpMessageListRespVO;
import com.elitesland.scp.domain.entity.msg.ScpMessageDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.msg.ScpMessageChannelRepoProc;
import com.elitesland.scp.infr.repo.msg.ScpMessageReceiverRepoProc;
import com.elitesland.scp.infr.repo.msg.ScpMessageRepoProc;
import com.elitesland.scp.infr.repo.msg.ScpMessageTxtRepoProc;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
abstract class BaseScpMessageService extends BaseServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(BaseScpMessageService.class);

    @Autowired
    protected ScpMessageRepoProc repoProc;
    @Autowired
    protected ScpMessageChannelRepoProc channelRepoProc;
    @Autowired
    protected ScpMessageTxtRepoProc txtRepoProc;
    @Autowired
    protected ScpMessageReceiverRepoProc receiverRepoProc;

    @Autowired
    protected FileService fileService;
    @Autowired
    protected SysCacheUserRpcService cacheUserRpcService;
    @Autowired
    protected RmiOrgStoreRpcService orgStoreRpcService;

    protected <T extends BaseScpMessageDetailRespVO> void fillDetailInfo(ScpMessageDO messageDO, T messageVO) {
        // 公告内容
        if (messageDO.getTxtId() != null) {
            messageVO.setTxt(txtRepoProc.getTxt(messageDO.getTxtId()));
        }

        // 设置作者
        if (messageVO.getAuthorId() != null) {
            var author = cacheUserRpcService.getById(messageVO.getAuthorId());
            if (author != null) {
                messageVO.setAuthorName(author.getFullName());
            }
        }

        // 分类
        messageVO.setCategoryName(super.udcValue(ScpApplication.NAME, ScpUdcEnum.SCP_MESSAGE_CATEGORY_DEFAULT.getCodeName(), messageVO.getCategory()));

        // 封面附件
        messageVO.setFiles(queryFiles(messageDO.getFileCodesStr()));
    }

    protected <T extends BaseScpMessageListRespVO> void fillListInfo(List<T> messageList) {
        var categoryNameMap = super.udcMap(ScpApplication.NAME, ScpUdcEnum.SCP_MESSAGE_CATEGORY_DEFAULT.getCodeName());

        messageList.forEach(t -> {
            // 作者
            var author = cacheUserRpcService.getById(t.getAuthorId());
            if (author != null) {
                t.setAuthorName(author.getFullName());
            }

            t.setCategoryName(categoryNameMap.get(t.getCategory()));
        });
    }

    protected List<FileObjRespVO<?>> queryFiles(String fileCodeStr) {
        if (!StringUtils.hasText(fileCodeStr)) {
            return Collections.emptyList();
        }

        com.el.coordinator.core.common.api.ApiResult<List<FileObjRespVO<?>>> fileResult = fileService.query(Arrays.asList(fileCodeStr.split(",")));
        if (!fileResult.isSuccess()) {
            logger.error("查询附件异常：{}, {}", fileCodeStr, fileResult.getMsg());
        }
        return fileResult.getData();
    }
}
