package com.elitesland.scp.domain.entity.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;

@Data
@ApiModel("采购车")
public class ScpStoreCartDO implements Serializable {

    private static final long serialVersionUID = -329460122107182855L;

    @ApiModelProperty("登录用户ID")
    private Long userId;

    @ApiModelProperty("门店编码")
    private String demandWhStCode;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;

    @ApiModelProperty("spu-id")
    private Long spuId;

    @ApiModelProperty("spu编码")
    private String spuCode;

    @ApiModelProperty("spu名称")
    private String spuName;

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("含税单价")
    private BigDecimal itemPrice;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("是否选中")
    private Integer selectedStatus;

    @ApiModelProperty("图片url")
    private String url;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty("基本单位")
    private String uom2;

    @ApiModelProperty(value = "基本单位名称")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "商品分类")
    private String itemType;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty(value = "最小起订量")
    private BigDecimal moq;

    private Long activityId;

    @ApiModelProperty(value = "强配活动编码")
    private String activityCode;

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("子品组合数量")
    private BigDecimal combineQty;

    @ApiModelProperty("是否在订货周期")
    private Boolean inOrderCycle;

    @ApiModelProperty("单据类型")
    private String docType;

    public BigDecimal getTotalAmt() {
        return (this.itemPrice == null ? BigDecimal.ZERO : this.itemPrice).multiply(this.qty)
                .setScale(2, RoundingMode.HALF_UP);
    }
}
