package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitesland.inv.dto.invTro.InvTroPayRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.pur.dto.po.PurPoPayRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageParam;
import com.elitesland.scp.application.facade.vo.boh.StoreReceivePageVO;
import com.elitesland.scp.application.facade.vo.cart.CartToOrderSuccessRespVO;
import com.elitesland.scp.application.facade.vo.cart.OrderCheckRespVO;
import com.elitesland.scp.application.facade.vo.cart.OrderConfirmRespVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.order.*;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppRelateOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.freight.ScpStoreOrderFreightPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.*;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSubmitVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.order.ScpDemandOrderSetService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.rmi.*;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.scp.utils.TransactionCommitHandler;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Slf4j
@Service
@RequiredArgsConstructor
public class AppDemandOrderServiceImpl implements AppDemandOrderService {

    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final RmiItemService rmiItemService;
    private final CartRedisUtil cartRedisUtil;
    private final SysAreaRpcService sysAreaRpcService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpStoreCartService scpStoreCartService;
    private final CommonPriceService commonPriceService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiPurRpcService rmiPurRpcService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final RedisUtils redisUtils;
    private final MessageDelyQueueService messageDelyQueueService;
    private final TransactionCommitHandler transactionCommitHandler;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final TransactionTemplate transactionTemplate;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final ScpDemandOrderSetService scpDemandOrderSetService;
    private final CrmCustRpcService crmCustRpcService;
    private final StoreReceiveService storeReceiveService;
    @Override
    @Transactional(rollbackFor = Exception.class)
    public long submit(ScpDemandOrderSubmitVO saveVO) {
        List<ScpDemandOrderDSubmitVO> itemList = saveVO.getItemList();
        if (CollUtil.isEmpty(itemList)) {
            throw new BusinessException("订货单明细不能为空");
        }
        // 如果有赠品，重新平摊单价
        List<ScpDemandOrderDSubmitVO> giftList = itemList.stream().filter(e -> e.getGiftFlag() != null && e.getGiftFlag()).collect(Collectors.toList());
        if(!giftList.isEmpty()) {
            // 非赠品商品
            List<ScpDemandOrderDSubmitVO> mainList = itemList.stream().filter(e -> e.getGiftFlag() == null || !e.getGiftFlag()).collect(Collectors.toList());
            for (ScpDemandOrderDSubmitVO mainVO : mainList) {
                List<ScpDemandOrderDSubmitVO.ItemSpecObjectVO> itemSpecObjectVOS = mainVO.getItemSpecObjectVOS();
                if(!CollectionUtils.isEmpty(itemSpecObjectVOS)) {
                    ScpDemandOrderDSubmitVO.ItemSpecObjectVO mainObjectVO = itemSpecObjectVOS.get(0);
                    ScpDemandOrderDSubmitVO.WhAllocObject mainObjectDetailVO = mainObjectVO.getWhAllocObjects().get(0);
                    // 遍历赠品
                    for (ScpDemandOrderDSubmitVO giftVO : giftList) {
                        Long giftBindItemId = giftVO.getGiftBindItemId();
                        if(giftBindItemId.equals(mainObjectVO.getItemId())) {
                            List<ScpDemandOrderDSubmitVO.ItemSpecObjectVO> giftItemSpecObjectVOS = giftVO.getItemSpecObjectVOS();
                            if(!CollectionUtils.isEmpty(giftItemSpecObjectVOS)) {
                                ScpDemandOrderDSubmitVO.ItemSpecObjectVO giftObjectVO = giftItemSpecObjectVOS.get(0);
                                ScpDemandOrderDSubmitVO.WhAllocObject giftObjectDetailVO = giftObjectVO.getWhAllocObjects().get(0);
                                // 重新计算当前主品和赠品的单价
                                BigDecimal mainQuantity = mainObjectDetailVO.getQty();
                                BigDecimal giftQuantity = giftObjectDetailVO.getQty();
                                BigDecimal totalQuantity = mainQuantity.add(giftQuantity);
                                BigDecimal newPrice = mainObjectDetailVO.getItemPrice().multiply(mainQuantity).divide(totalQuantity,2, RoundingMode.HALF_UP);
                                mainObjectDetailVO.setItemPrice(newPrice);
                                giftObjectDetailVO.setItemPrice(newPrice);
                            }
                            break;
                        }
                    }
                }
            }
            mainList.addAll(giftList);
            itemList = mainList;
        }
        OrgStoreDetailRpcDTO orgStore = Optional.ofNullable(orgStoreRpcService.getByCode(saveVO.getDemandWhStCode())).orElseThrow(() -> new BusinessException("门店不存在"));
        // 校验是否有未补运费
        checkFillFeight(orgStore.getStoreCode());
        saveVO.setStoreLevel(orgStore.getStoreLevel());
        saveVO.setStoreType2(orgStore.getStoreType2());
        String itemCode = SysUtils.getOrderItemSetting();
        //构建订货单明细
        List<ScpDemandOrderDSaveVO> saveItemList = buildSaveItemList(itemList, itemCode);

        Long id = scpDemandOrderService.saveDemandOrder(ScpDemandOrderConvert.INSTANCE.submitVoToSaveVO(saveVO));
        scpDemandOrderDService.batchSaveDemandOrderD(id, "MG", saveItemList);

        //清空采购车
        clearCheckedStoreCartItems(saveVO, saveItemList);
        String orderSetting = SysUtils.getOrderSetting();
        if ("0".equals(orderSetting)) {
            return id;
        }
        //获取当前操作人id和name
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("当前登录用户信息:{}", JSONUtil.toJsonStr(currentUserDTO));
        if (ObjectUtils.isEmpty(currentUserDTO) || currentUserDTO.getDetail() == null) {
            throw new BusinessException("查询当前登录用户失败");
        }
        //事物提交之后写入mq队列,进行订单推送
        transactionCommitHandler.handle(() -> {
            ScpOrderSubmitMqParam orderSubmitMqParam = new ScpOrderSubmitMqParam();
            orderSubmitMqParam.setDemandOrderId(id);
            orderSubmitMqParam.setAgentEmpId(currentUserDTO.getDetail().getEmployeeId());
            orderSubmitMqParam.setBusinessKey(ScpOrderSubmitMqParam.SUBMIT_CHANNEL);
            orderSubmitMqParam.setDemandWhStCode(saveVO.getDemandWhStCode());
            List<Long> activityIds = saveItemList.stream().map(ScpDemandOrderDSaveVO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            orderSubmitMqParam.setActivityIds(activityIds);
            messageQueueTemplate.publishMessageSync("yst-suplan", ScpOrderSubmitMqParam.SUBMIT_CHANNEL, orderSubmitMqParam);
        });
        return id;
    }

    /**
     * 校验是否有未支付运费
     * @param storeCode
     */
    private void checkFillFeight(String storeCode) {
        ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
        paramVO.setDemandWhStCode(storeCode);
        paramVO.setDocStatus(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode());
        paramVO.setDocType("BF");
        paramVO.setPayStatusList(Arrays.asList("WAIT_PAY","PAYING"));
        PagingVO<ScpPayOrderPageRespVO> scpPayOrderPageRespVOPagingVO = scpDemandOrderService.payPage(paramVO);
        if(!CollUtil.isEmpty(scpPayOrderPageRespVOPagingVO.getRecords())){
            throw new BusinessException("存在未支付的补缴运费订单，请完成支付后再提交！");
        }
    }

    /**
     * 构建保存订货单明细
     *
     * @param itemList
     * @param itemCode
     * @return
     */
    private static List<ScpDemandOrderDSaveVO> buildSaveItemList(List<ScpDemandOrderDSubmitVO> itemList, String itemCode) {
        List<ScpDemandOrderDSaveVO> saveItemList = itemList.stream()
                .flatMap(item -> item.getItemSpecObjectVOS().stream()
                        .flatMap(row -> {
                            String uuid = UUIDUtil.getUUID();
                            return row.getWhAllocObjects().stream()
                                    .map(wh -> buildScpDemandOrderDVO(item, row, wh, uuid, itemCode));
                        }))
                .collect(Collectors.toList());
        return saveItemList;
    }

    /**
     * 清空采购车
     *
     * @param saveVO
     * @param saveItemList
     */
    private void clearCheckedStoreCartItems(ScpDemandOrderSubmitVO saveVO, List<ScpDemandOrderDSaveVO> saveItemList) {
        for (ScpDemandOrderDSaveVO item : saveItemList) {
            cartRedisUtil.clearCheckedStoreCartItems(saveVO.getDemandWhStCode(), UserService.currentUserId(), saveVO.getDocType(), SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode()));
        }
        //清除主品采购车
        for (ScpDemandOrderDSaveVO scpDemandOrderDSaveVO : saveItemList.stream().filter(item -> StringUtils.hasLength(item.getCombineItemCode())).collect(Collectors.toList())) {
            cartRedisUtil.clearCheckedStoreCartItems(saveVO.getDemandWhStCode(), UserService.currentUserId(), saveVO.getDocType(), SysUtils.getItemKey("", scpDemandOrderDSaveVO.getCombineItemCode()));
        }

    }

    /**
     * 构建订货单明细
     *
     * @param item
     * @param row
     * @param wh
     * @return
     */
    private static ScpDemandOrderDSaveVO buildScpDemandOrderDVO(ScpDemandOrderDSubmitVO item, ScpDemandOrderDSubmitVO.ItemSpecObjectVO row,
                                                                ScpDemandOrderDSubmitVO.WhAllocObject wh, String uuid, String freightItemCode) {
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setAllocationDeQuantity(wh.getQty());
        scpDemandOrderDSaveVO.setRatio(wh.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(wh.getSupplyType());
        scpDemandOrderDSaveVO.setSuppWhId(wh.getSupplyWhId());
        scpDemandOrderDSaveVO.setSuppWhCode(wh.getSupplyWhCode());
        scpDemandOrderDSaveVO.setSuppWhName(wh.getSupplyWhName());
        scpDemandOrderDSaveVO.setSpuItemCode(item.getSpuCode());
        scpDemandOrderDSaveVO.setSpuItemName(item.getSpuName());
        scpDemandOrderDSaveVO.setItemId(row.getItemId());
        scpDemandOrderDSaveVO.setItemCode(row.getItemCode());
        scpDemandOrderDSaveVO.setItemName(row.getItemName());
        scpDemandOrderDSaveVO.setDemandQuantity(row.getDemandQuantity());
        scpDemandOrderDSaveVO.setUnit(row.getUom());
        scpDemandOrderDSaveVO.setUnitName(row.getUomName());
        scpDemandOrderDSaveVO.setPrice(wh.getItemPrice());
        scpDemandOrderDSaveVO.setOuId(wh.getOuId());
        scpDemandOrderDSaveVO.setOuCode(wh.getOuCode());
        scpDemandOrderDSaveVO.setOuName(wh.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(row.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(row.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(row.getUomRatio());
        if (row.getUomRatio() != null) {
            scpDemandOrderDSaveVO.setQty2(wh.getQty().multiply(row.getUomRatio()).setScale(row.getDecimalPlaces(), RoundingMode.HALF_UP));
        }
        if (wh.getItemPrice() != null) {
            scpDemandOrderDSaveVO.setDemandAmt(SysUtils.processAmtScale(row.getDemandQuantity().multiply(wh.getItemPrice())));
        }
        scpDemandOrderDSaveVO.setFreightFlag(wh.getFreightFlag());
        scpDemandOrderDSaveVO.setFreightRatio(wh.getFreightRatio());
        scpDemandOrderDSaveVO.setFreightAmt(wh.getFreightAmt());
        scpDemandOrderDSaveVO.setSaleCustCode(wh.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(wh.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(wh.getSaleOuName());
        scpDemandOrderDSaveVO.setItemType(row.getItemType());
        scpDemandOrderDSaveVO.setPreRootUuid(uuid);
        scpDemandOrderDSaveVO.setImgUrl(item.getUrl());
        scpDemandOrderDSaveVO.setFreightLineFlag(freightItemCode.equals(row.getItemCode()));
        scpDemandOrderDSaveVO.setActivityId(row.getActivityId());
        scpDemandOrderDSaveVO.setActivityCode(row.getActivityCode());
        scpDemandOrderDSaveVO.setMinNum(row.getMinNum());
        scpDemandOrderDSaveVO.setCombineItemCode(item.getCombineItemCode());
        scpDemandOrderDSaveVO.setCombineItemName(item.getCombineItemName());
        return scpDemandOrderDSaveVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveDemandOrderD(List<ScpDemandOrderDSaveVO> saveVOS) {
        BigDecimal maxLineNo = scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(saveVOS.get(0).getMasId());
        //设置行号
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        for (ScpDemandOrderDSaveVO saveVO : saveVOS) {
            if (saveVO.getId() != null) {
                saveVO.setLineNo(BigDecimal.valueOf(lineNo.getAndIncrement()));
            }
        }
        scpDemandOrderDDomainService.batchSave(saveVOS, lineNo);
    }

    @Override
    public void addCart(Long id) {
        ScpDemandOrderRespVO demandOrder = scpDemandOrderService.findDemandOrderById(id).orElseThrow(new BusinessException("数据不存在"));
        List<ScpDemandOrderDMgmtRespVO> demandItemList = scpDemandOrderDService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(demandItemList)) {
            return;
        }
        //门店编码
        String storeCode = demandOrder.getDemandWhStCode();
        //单据类型
        String docType = demandOrder.getDocType();
        List<StoreCartSaveVO> cartSaveVOS = new ArrayList<>();
        String orderItemSetting = SysUtils.getOrderItemSetting();
        //查询商品图片
        List<Long> itemIds = demandItemList.stream().map(ScpDemandOrderDMgmtRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> itemList = rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        Map<Long, ItmItemScpBaseRpcDTO> itemMap = itemList.stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));

        //构建购物车保存属性
        for (ScpDemandOrderDMgmtRespVO item : demandItemList) {
            //过滤掉运费商品
            if (orderItemSetting.equals(item.getItemCode())) {
                continue;
            }
            StoreCartSaveVO cartSaveVO = new StoreCartSaveVO();
            ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = itemMap.get(item.getItemId());
            cartSaveVO.setDemandWhStCode(storeCode);
            cartSaveVO.setCartType(docType);
            cartSaveVO.setItemType(itmItemScpBaseRpcDTO.getItemType2());
            cartSaveVO.setItemId(item.getItemId());
            cartSaveVO.setItemCode(item.getItemCode());
            cartSaveVO.setItemName(itmItemScpBaseRpcDTO.getItemName());
            cartSaveVO.setUom(item.getUnit());
            cartSaveVO.setUomName(item.getUnitName());
            cartSaveVO.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
            cartSaveVO.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
            cartSaveVO.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
            cartSaveVO.setQty(item.getDemandQuantity());
            cartSaveVO.setSpec(itmItemScpBaseRpcDTO.getSpec());
            var skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
            var spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty(skuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                cartSaveVO.setUrl(first.isEmpty() ? skuAttchmentList.get(0).getUrl() : first.get().getUrl());
            } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                cartSaveVO.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
            }
            cartSaveVO.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
            cartSaveVO.setItemCateName(itmItemScpBaseRpcDTO.getItemCateName());
            cartSaveVOS.add(cartSaveVO);
        }

        //实时获取价格
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(docType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        var priceParamVOS = cartSaveVOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, List<PriPriceRpcDTO>> priceMap = commonPriceService.getPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, demandOrder.getType());
        //获取价格
        cartSaveVOS.forEach(row -> {
            if (priceMap.containsKey(row.getItemCode())) {
                row.setItemPrice(SysUtils.processPriceScale(priceMap.get(row.getItemCode()).get(0).getPrice()));
            }
        });
        //添加购物车
        scpStoreCartService.batchSaveCart(storeCode, docType, cartSaveVOS);
    }

    @Override
    @SysCodeProc
    public ScpDemandOrderRespVO findDemandOrderById(Long id) {
        ScpDemandOrderRespVO orderRespVO = scpDemandOrderService.findDemandOrderById(id).get();
        //转换区域名称
        Map<String, String> areaMap = buildAddr(orderRespVO.getRecvProvince(), orderRespVO.getRecvCity(), orderRespVO.getRecvCounty());
        if (CollUtil.isNotEmpty(areaMap)) {
            orderRespVO.setRecvProvinceName(areaMap.get(orderRespVO.getRecvProvince()));
            orderRespVO.setRecvCityName(areaMap.get(orderRespVO.getRecvCity()));
            orderRespVO.setRecvCountyName(areaMap.get(orderRespVO.getRecvCounty()));
        }
        //合计数据
        List<ScpDemandOrderDDTO> demandOrderD = scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        //循环订单明细
        AtomicReference<BigDecimal> itemTotalCount = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amt = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> noPayAmt = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> freightAmt = new AtomicReference<>(BigDecimal.ZERO);
        for (ScpDemandOrderDDTO row : demandOrderD) {
            if (row.getPlanQuantity() != null) {
                itemTotalCount.updateAndGet(v -> v.add(row.getPlanQuantity()));
            }
            if (row.getPlanAmt() != null) {
                amt.updateAndGet(v -> v.add(row.getPlanAmt()));
            } else {
                continue;
            }
            if (row.getPayStatus() != null && ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode().equals(row.getPayStatus())) {
                noPayAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
            if (row.getFreightLineFlag()) {
                freightAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            } else {
                goodAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
        }
        orderRespVO.setItemTotalCount(itemTotalCount.get());
        orderRespVO.setAmt(amt.get());
        orderRespVO.setNoPayAmt(noPayAmt.get());
        orderRespVO.setGoodAmt(goodAmt.get());
        orderRespVO.setFreightAmt(freightAmt.get());
        return orderRespVO;
    }

    @Override
    @SysCodeProc
    public AppPayOrderRespVO findPayOrderById(Long srcDocId) {
        AppPayOrderRespVO appPayOrderRespVO = scpDemandOrderDomainService.payOrderById(srcDocId);
        ScpDemandOrderDTO scpDemandOrderDTO = scpDemandOrderDomainService.findDemandOrderById(appPayOrderRespVO.getDocId()).get();
        appPayOrderRespVO.setDocCode(scpDemandOrderDTO.getDocCode());
        appPayOrderRespVO.setDocType(scpDemandOrderDTO.getDocType());
        appPayOrderRespVO.setCreateTime(scpDemandOrderDTO.getCreateTime());
        appPayOrderRespVO.setRecvContactName(scpDemandOrderDTO.getRecvContactName());
        appPayOrderRespVO.setRecvContactTel(scpDemandOrderDTO.getRecvContactTel());
        //如果是在线支付查询微企付订单并且更新订单支付状态
        String payStatus = queryWqfAndUpdatePayStatus(appPayOrderRespVO.getSrcDocNo(), appPayOrderRespVO.getPayStatus(), appPayOrderRespVO.getOnlinePayFlag());
        appPayOrderRespVO.setPayStatus(payStatus);
        Map<String, String> stringStringMap = this.buildAddr(scpDemandOrderDTO.getRecvProvince(), scpDemandOrderDTO.getRecvCity(),
                scpDemandOrderDTO.getRecvCounty());
        if (CollUtil.isNotEmpty(stringStringMap)) {
            appPayOrderRespVO.setRecvProvinceName(stringStringMap.get(scpDemandOrderDTO.getRecvProvince()));
            appPayOrderRespVO.setRecvCityName(stringStringMap.get(scpDemandOrderDTO.getRecvCity()));
            appPayOrderRespVO.setRecvCountyName(stringStringMap.get(scpDemandOrderDTO.getRecvCounty()));
        }
        if (!redisUtils.hasKey(ScpConstant.SCP_ONLINE_PAY + appPayOrderRespVO.getSrcDocNo())) {
            return appPayOrderRespVO;
        }
        appPayOrderRespVO.setCountdown(messageDelyQueueService.getOrderExpireTime(ScpConstant.SCP_ONLINE_PAY + appPayOrderRespVO.getSrcDocNo()));
        return appPayOrderRespVO;
    }

    private String queryWqfAndUpdatePayStatus(String srcDocNo, String payStatus, Boolean onlinePayFlag) {
        // 如果在线支付订单需要查询微企付订单支付信息
        if (!onlinePayFlag || ScpUdcEnum.PAY_STATUS_PAYED.getValueCode().equals(payStatus)) {
            return payStatus;
        }
        try {
            Payment payment = Payment.retrieveByOutPaymentId(srcDocNo);
            List<String> payStatusList = List.of("CLOSED", "PROCESSING");
            if (payStatusList.contains(payment.getPayStatus())) {
                return payStatus;
            }
            String updatePayStatus = "SUCCEEDED".equals(payment.getPayStatus()) ? ScpUdcEnum.PAY_STATUS_PAYED.getValueCode() : ScpUdcEnum.PAY_STATUS_PAYING.getValueCode();
            transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
            transactionTemplate.execute(transactionStatus -> {
                try {
                    scpDemandOrderDRepoProc.updatePayStatusBySrcDocId(srcDocNo, updatePayStatus);
                    return "ok";
                } catch (Exception e) {
                    log.error("更新订货单失败:{}", e.getMessage(), e);
                    // 回滚
                    transactionStatus.setRollbackOnly();
                    return "ok";
                }
            });
            return updatePayStatus;
        } catch (EntpayException e) {
            log.error("查询银行信息失败:{}", e);
        }
        return payStatus;
    }

    @Override
    public AppPayOrderItemRespVO findPayOrderItemById(Long srcDocId) {
        AppPayOrderItemRespVO result = new AppPayOrderItemRespVO();
        List<ScpDemandOrderDDTO> demandOrderDDTOS = scpDemandOrderDDomainService.findDemandOrderDBySrcDocId(srcDocId);
        if (CollUtil.isEmpty(demandOrderDDTOS)) {
            throw new BusinessException("订单明细不存在");
        }
        Map<String, String> uomCodeMap = rmiSysUDCService.getCodeMap("yst-supp", "UOM");

        List<Long> itemIds = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemScpBaseRpcDTO> scpItemMap = rmiItemService.findScpItemMap(itemIds);

        List<String> combineItemCodes = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getCombineItemCode).collect(Collectors.toList());
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam=new ArrayList<>();
        //判断非空
        boolean hasValidValue = combineItemCodes != null &&
                combineItemCodes.stream().anyMatch(s -> s != null && !s.trim().isEmpty());
        if(hasValidValue){
            ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
            param.setItemCodes(combineItemCodes);
            List<ItmItemScpBaseRpcDTO> rpcResult = Optional.ofNullable(
                    rmiItemService.findItemScpBaseRpcDtoByParam(param)
            ).orElseGet(ArrayList::new);
            itemRpcDtoByParam.addAll(rpcResult);
        }


        //合计商品数量
        BigDecimal totalNum = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amt = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        result.setAmt(amt);
        result.setTotalNum(totalNum);
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> freightAmt = new AtomicReference<>(BigDecimal.ZERO);
        for (ScpDemandOrderDDTO row : demandOrderDDTOS) {
            if (row.getPlanAmt() == null) {
                continue;
            }
            if (row.getFreightLineFlag()) {
                freightAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            } else {
                goodAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
        }
        result.setGoodAmt(goodAmt.get());
        result.setFreightAmt(freightAmt.get());
        result.setCateNum(demandOrderDDTOS.size());

        //过滤商品子品，获取组合商品信息
        List<ScpDemandOrderDDTO> subItemList = demandOrderDDTOS.stream().filter(row -> StringUtils.hasLength(row.getCombineItemCode())).collect(Collectors.toList());

        Map<String, List<ScpDemandOrderDDTO>> subItemMap = new HashMap<>();
        if (CollUtil.isNotEmpty(subItemList)) {
            demandOrderDDTOS.removeAll(subItemList);
            subItemMap = subItemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getCombineItemCode));
        }

        List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemSpecObjectVOList = new ArrayList<>();
        //构建商品明细信息
        List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemList = demandOrderDDTOS.stream().map(row -> {
            AppPayOrderItemRespVO.ItemSpecObjectVO specObj = new AppPayOrderItemRespVO.ItemSpecObjectVO();
            specObj.setItemCode(row.getItemCode());
            specObj.setItemName(row.getItemName());
            specObj.setUom(row.getUnit());
            if (uomCodeMap.containsKey(row.getUnit())) {
                specObj.setUomName(uomCodeMap.get(row.getUnit()));
            }
            if (scpItemMap.containsKey(row.getItemId())) {
                ItmItemScpBaseRpcDTO item = scpItemMap.get(row.getItemId());
                specObj.setItemAttrName(StrUtil.isBlank(item.getItemAttrName()) ? item.getSpec() : item.getItemAttrName());
                specObj.setAnotherName(item.getAnotherName());
                var spuAttchmentList = item.getSpuAttchmentList();
                if (CollUtil.isNotEmpty(item.getSkuAttchmentList())) {
                    Optional<ItmItemAttachmentRpcDTO> first = item.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    String url = first.isPresent() ? first.get().getUrl() : item.getSkuAttchmentList().get(0).getUrl();
                    specObj.setUrl(url);
                } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                    Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    specObj.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
                }
            }
            specObj.setAmt(row.getPlanAmt());
            specObj.setQty(row.getPlanQuantity());
            return specObj;
        }).collect(Collectors.toList());

        //设置商品子品
        if (!subItemMap.isEmpty()) {
            subItemMap.forEach((combineItemCode, values) -> {
                AppPayOrderItemRespVO.ItemSpecObjectVO mainItem = new AppPayOrderItemRespVO.ItemSpecObjectVO();
                mainItem.setItemCode(combineItemCode);
                mainItem.setItemName(values.get(0).getCombineItemName());
                itemRpcDtoByParam.stream().filter(row -> combineItemCode.equals(row.getItemCode()))
                        .findFirst()
                        .ifPresent(row -> {
                            mainItem.setUom(row.getUom2());
                            if (CollUtil.isNotEmpty(row.getSkuAttchmentList())) {
                                Optional<ItmItemAttachmentRpcDTO> first = row.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                                String url = first.isPresent() ? first.get().getUrl() : row.getSkuAttchmentList().get(0).getUrl();
                                mainItem.setUrl(url);
                            } else if (CollUtil.isNotEmpty(row.getSpuAttchmentList())) {
                                Optional<ItmItemAttachmentRpcDTO> first = row.getSpuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                                mainItem.setUrl(first.isEmpty() ? row.getSpuAttchmentList().get(0).getUrl() : first.get().getUrl());
                            }
                            mainItem.setItemAttrName(row.getItemAttrName());
                            mainItem.setAnotherName(row.getAnotherName());
                            mainItem.setAmt(values.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                            ScpDemandOrderDDTO scpDemandOrderDDTO = values.get(0);
                            row.getSubItems().stream().filter(a -> a.getId().equals(scpDemandOrderDDTO.getItemId()))
                                    .findFirst().ifPresent(b -> {
                                        mainItem.setQty(scpDemandOrderDDTO.getPlanQuantity().divide(b.getBomQty(), 0, RoundingMode.FLOOR));
                                    });
                        });
                if (uomCodeMap.containsKey(mainItem.getUom())) {
                    mainItem.setUomName(uomCodeMap.get(mainItem.getUom()));
                }
                List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemList2 = values.stream().map(row -> {
                    AppPayOrderItemRespVO.ItemSpecObjectVO specObj = new AppPayOrderItemRespVO.ItemSpecObjectVO();
                    specObj.setItemCode(row.getItemCode());
                    specObj.setItemName(row.getItemName());
                    specObj.setUom(row.getUnit());
                    if (uomCodeMap.containsKey(row.getUnit())) {
                        specObj.setUomName(uomCodeMap.get(row.getUnit()));
                    }
                    if (scpItemMap.containsKey(row.getItemId())) {
                        ItmItemScpBaseRpcDTO item = scpItemMap.get(row.getItemId());
                        specObj.setItemAttrName(StrUtil.isBlank(item.getItemAttrName()) ? item.getSpec() : item.getItemAttrName());
                        specObj.setAnotherName(item.getAnotherName());
                        var spuAttchmentList = item.getSpuAttchmentList();
                        if (CollUtil.isNotEmpty(item.getSkuAttchmentList())) {
                            Optional<ItmItemAttachmentRpcDTO> first = item.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                            String url = first.isPresent() ? first.get().getUrl() : item.getSkuAttchmentList().get(0).getUrl();
                            specObj.setUrl(url);
                        } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                            Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                            specObj.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
                        }
                    }
                    specObj.setAmt(row.getPlanAmt());
                    specObj.setQty(row.getPlanQuantity());
                    return specObj;
                }).collect(Collectors.toList());
                mainItem.setItemList(itemList2);
                itemSpecObjectVOList.add(mainItem);
            });

        }

        itemSpecObjectVOList.addAll(itemList);
        result.setItemList(itemSpecObjectVOList);
        return result;
    }

    @Override
    @SysCodeProc
    public List<AppRelateOrderRespVO> findRelateOrderById(Long id) {
        List<AppRelateOrderRespVO> result = new ArrayList<>();
        List<ScpDemandOrderDDTO> orderDDTOList = scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(orderDDTOList)) {
            throw new BusinessException("关联单据不存在");
        }
        Map<String, String> uomCodeMap = rmiSysUDCService.getCodeMap("yst-supp", "UOM");
        Map<String, List<ScpDemandOrderDDTO>> orderMap = orderDDTOList.stream().filter(row -> row.getSrcDocId() != null).collect(Collectors.groupingBy(row -> row.getSrcDocNo() + "@" + row.getSaleOuCode()));
        // 循环orderMap
        for (Map.Entry<String, List<ScpDemandOrderDDTO>> entry : orderMap.entrySet()) {
            String srcDocNo = entry.getKey().split("@")[0];
            AppRelateOrderRespVO appRelateOrderRespVO = new AppRelateOrderRespVO();
            // 获取关联单据明细
            List<ScpDemandOrderDDTO> value = entry.getValue();
            // 获取关联单据
            ScpDemandOrderDDTO scpDemandOrderDDTO = entry.getValue().get(0);
            //明细总金额
            BigDecimal amt = value.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

            List<String> combineItemCodes = value.stream().map(ScpDemandOrderDDTO::getCombineItemCode).filter(Objects::nonNull).collect(Collectors.toList());
            List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam =new ArrayList<>();
            if(!CollUtil.isEmpty(combineItemCodes)){
                ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
                param.setItemCodes(combineItemCodes);
                itemRpcDtoByParam = rmiItemService.findItemScpBaseRpcDtoByParam(param);
            }

            //组装主品展示
            Map<String, List<ScpDemandOrderDDTO>> subItemMap = new HashMap<>();
            List<ScpDemandOrderDDTO> subItemList = value.stream().filter(row -> StringUtils.hasLength(row.getCombineItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(subItemList)) {
                value.removeAll(subItemList);
                subItemMap = subItemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getCombineItemCode));
            }
            List<AppRelateOrderRespVO.ItemRespVO> allItemList = new ArrayList<>();
            List<AppRelateOrderRespVO.ItemRespVO> inItemList = value.stream().map(row -> {
                AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                itemRespVO.setItemCode(row.getItemCode());
                itemRespVO.setItemName(row.getItemName());
                itemRespVO.setQty(row.getPlanQuantity());
                itemRespVO.setAmt(row.getPlanAmt());
                itemRespVO.setUom(row.getUnit());
                if (uomCodeMap.containsKey(row.getUnit())) {
                    itemRespVO.setUomName(uomCodeMap.get(row.getUnit()));
                }
                return itemRespVO;
            }).collect(Collectors.toList());
            if (!subItemMap.isEmpty()) {
                for (Map.Entry<String, List<ScpDemandOrderDDTO>> subItemEntry : subItemMap.entrySet()) {
                    List<AppRelateOrderRespVO.ItemRespVO> subItemRespVOList = subItemEntry.getValue().stream().map(row -> {
                        AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                        itemRespVO.setItemCode(row.getItemCode());
                        itemRespVO.setItemName(row.getItemName());
                        itemRespVO.setQty(row.getPlanQuantity());
                        itemRespVO.setAmt(row.getPlanAmt());
                        itemRespVO.setUom(row.getUnit());
                        if (uomCodeMap.containsKey(row.getUnit())) {
                            itemRespVO.setUomName(uomCodeMap.get(row.getUnit()));
                        }
                        return itemRespVO;
                    }).collect(Collectors.toList());
                    AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                    List<ScpDemandOrderDDTO> value1 = subItemEntry.getValue();
                    itemRespVO.setItemCode(subItemEntry.getKey());
                    itemRespVO.setItemName(value1.get(0).getCombineItemName());
                    itemRpcDtoByParam.stream().filter(row -> subItemEntry.getKey().equals(row.getItemCode()))
                            .findFirst()
                            .ifPresent(row -> {
                                itemRespVO.setUom(row.getUom());
                                itemRespVO.setAmt(subItemEntry.getValue().stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                                ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = row.getSubItems().get(0);
                                subItemEntry.getValue().stream().filter(a -> a.getItemId().equals(itmItemScpBaseRpcDTO.getId()))
                                        .findFirst().ifPresent(b -> {
                                            itemRespVO.setQty(b.getPlanQuantity().divide(itmItemScpBaseRpcDTO.getBomQty(), 0, RoundingMode.FLOOR));
                                        });
                            });
                    itemRespVO.setItemList(subItemRespVOList);
                    allItemList.add(itemRespVO);
                }
            }
            allItemList.addAll(inItemList);
            appRelateOrderRespVO.setItemList(allItemList);

            //如果是在线支付查询微企付订单并且更新订单支付状态
            String payStatus = queryWqfAndUpdatePayStatus(srcDocNo, scpDemandOrderDDTO.getPayStatus(), scpDemandOrderDDTO.getOnlinePayFlag());
            appRelateOrderRespVO.setPayStatus(payStatus);
            appRelateOrderRespVO.setSrcDocNo(srcDocNo);
            appRelateOrderRespVO.setSrcDocId(scpDemandOrderDDTO.getSrcDocId());
            appRelateOrderRespVO.setSrcDocCls(scpDemandOrderDDTO.getSrcDocCls());
            appRelateOrderRespVO.setSaleOuName(scpDemandOrderDDTO.getSaleOuName());
            appRelateOrderRespVO.setSaleOuCode(scpDemandOrderDDTO.getSaleOuCode());
            appRelateOrderRespVO.setCreateTime(scpDemandOrderDDTO.getCreateTime());
            appRelateOrderRespVO.setAmt(amt);
            appRelateOrderRespVO.setPayerName(scpDemandOrderDDTO.getPayerName());
            result.add(appRelateOrderRespVO);
        }
        return result;
    }

    @Override
    public ScpOrderPayRespVO payInfo(String docCls, Long id) {
        ScpOrderPayRespVO scpOrderPayRespVO = new ScpOrderPayRespVO();
        LocalDateTime createTime = scpDemandOrderDDomainService.findDocCreateTimeBySrcDocId(id);
        if (createTime == null) {
            throw new BusinessException("订单不存在");
        }
        scpOrderPayRespVO.setDocDateTime(createTime);
        if ("STKTRO".equals(docCls)) {
            List<InvTroPayRpcDTO> invTroPayList = rmiInvStkRpcService.payInfo(id);
            if (CollUtil.isNotEmpty(invTroPayList)) {
                BigDecimal totalAmt = invTroPayList.stream().map(InvTroPayRpcDTO::getReceiptAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                List<ScpOrderPayRespVO.PayItem> payItems = ScpDemandOrderConvert.INSTANCE.troDtosToRespVOS(invTroPayList);
                scpOrderPayRespVO.setItemList(payItems);
                scpOrderPayRespVO.setAmt(totalAmt);
                scpOrderPayRespVO.setPayDateTime(invTroPayList.get(0).getReceiptDate());
            }
        }
        if ("PO".equals(docCls)) {
            List<PurPoPayRpcDTO> purPoPayList = rmiPurRpcService.payInfo(id);
            if (CollUtil.isNotEmpty(purPoPayList)) {
                BigDecimal totalAmt = purPoPayList.stream().map(PurPoPayRpcDTO::getReceiptAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                List<ScpOrderPayRespVO.PayItem> payItems = ScpDemandOrderConvert.INSTANCE.purDtosToRespVOS(purPoPayList);
                scpOrderPayRespVO.setItemList(payItems);
                scpOrderPayRespVO.setAmt(totalAmt);
                scpOrderPayRespVO.setPayDateTime(purPoPayList.get(0).getReceiptDate());
            }
        }
        return scpOrderPayRespVO;
    }

    private Map<String, String> buildAddr(String province, String city, String county) {
        //收货地址
        Set<String> areaCodes = new HashSet<>();
        areaCodes.add(province);
        areaCodes.add(city);
        areaCodes.add(county);
        SysAreaQueryDTO comCityCodeRpcDtoParam = new SysAreaQueryDTO();
        comCityCodeRpcDtoParam.setAreaCodes(areaCodes);
        List<SysAreaRespDTO> rpcDtos = sysAreaRpcService.queryList(comCityCodeRpcDtoParam).getData();
        if (CollUtil.isNotEmpty(rpcDtos)) {
            return rpcDtos.stream().collect(Collectors.toMap(t -> t.getAreaCode(), t -> t.getAreaName(), (t1, t2) -> t1));
        }
        return new HashMap<>();
    }


    @Override
    @Transactional
    public void fillFreightOrder() {
        LocalDateTime todayStart = LocalDate.now().atStartOfDay();
        // 0.获取当天全部/全部的订货集，用于每个门店补运费的订货集
        ScpDemandSetPageRespVO scpDemandSetPageRespVO = new ScpDemandSetPageRespVO();
        ScpDemandSetPageParamVO demandSetParamVO = new ScpDemandSetPageParamVO();
        demandSetParamVO.setDemandDateFrom(todayStart);
        demandSetParamVO.setDemandDateTo(todayStart.toLocalDate().atTime(LocalTime.MAX));
        demandSetParamVO.setDocType("all");
        demandSetParamVO.setStoreCode("all");
        demandSetParamVO.setIsPushed(false);
        demandSetParamVO.setType("0");
        demandSetParamVO.setStatus(true);
        List<ScpDemandSetPageRespVO> scpDemandSetPageRespVOS = scpDemandOrderSetService.commonNewPage(demandSetParamVO);
        if(!CollUtil.isEmpty(scpDemandSetPageRespVOS)) {
            scpDemandSetPageRespVO =  scpDemandSetPageRespVOS.get(0);
        }else {
            throw new BusinessException("未检查到当天的订货集！");
        }

        InvWhRpcDTO fillFreightDefaultWh ;
        // 0.获取补运费默认发货仓库
        String defaultBackScpOrderDeliveryWh = SysUtils.getDefaultBackScpOrderDeliveryWh();
        InvWhRpcDtoParam param = new InvWhRpcDtoParam();
        param.setWhCode(defaultBackScpOrderDeliveryWh);
        List<InvWhRpcDTO> fillFreightDefaultWhs = rmiInvStkRpcService.findWhDTOByParam(param).computeData();
        if(!CollectionUtils.isEmpty(fillFreightDefaultWhs)) {
            fillFreightDefaultWh = fillFreightDefaultWhs.get(0);
        }else{
            throw new BusinessException("请维护补运费默认发货仓库！");
        }

        List<String> docTypeList = new ArrayList<>();

        // 1.系统配置项获取单据类型
        String docTypr = SysUtils.getBackScpOrderDocTypr();
        if (StringUtils.hasText(docTypr)) {
            docTypeList = Arrays.stream(docTypr.split(",")).collect(Collectors.toList());
        }
        // 2.查询符合补运费条件的门店列表
        OrgStoreRpcParam orgStoreRpcParam = new OrgStoreRpcParam();
        orgStoreRpcParam.setFillFreightFlag(true);
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = rmiOrgStoreRpcService.appSearch(orgStoreRpcParam);
        if(CollUtil.isEmpty(orgStoreRpcDTOS)) {
            return;
        }
        // 所有门店
        List<String> storeCodes = orgStoreRpcDTOS.stream().map(e -> e.getStoreCode()).collect(Collectors.toList());
        // 查询与门店code一致的客户列表,过滤掉无法匹配客户的门店
        ApiResult<List<LmSaveCustRespVO>> invCust = crmCustRpcService.findInvCust(storeCodes);
        List<LmSaveCustRespVO> invCustList = invCust.getData();
        List<String> custCodes = invCustList.stream().map(e -> e.getCustCode()).collect(Collectors.toList());
        orgStoreRpcDTOS = orgStoreRpcDTOS.stream().filter(e -> !custCodes.contains(e.getCustCode())).collect(Collectors.toList());

        if(CollUtil.isEmpty(orgStoreRpcDTOS)) {
            return;
        }

        // 提取免运费数量
        Map<String, Integer> storeFreeFreightNumMap = orgStoreRpcDTOS.stream().collect(Collectors.toMap(OrgStoreRpcDTO::getStoreCode, OrgStoreRpcDTO::getFreeFreightNum));
        // 提取补运费单价
        Map<String, BigDecimal> storeFillFreightPriceMap = orgStoreRpcDTOS.stream().collect(Collectors.toMap(OrgStoreRpcDTO::getStoreCode, OrgStoreRpcDTO::getFillFreightPrice));
        // 提取门店code对应门店信息
        Map<String, OrgStoreRpcDTO> storeMap = orgStoreRpcDTOS.stream()
                .collect(Collectors.toMap(
                        OrgStoreRpcDTO::getStoreCode, // key: storeCode
                        Function.identity(),          // value: 对象本身
                        (v1, v2) -> v1
                ));


        // 3.获取门店上一个订货日内已推送的所有订货订单
        ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
        paramVO.setCreateTimeFrom(todayStart.minusDays(1));
        paramVO.setCreateTimeTo(todayStart.minusDays(1).toLocalDate().atTime(LocalTime.MAX));
        paramVO.setIsPushed(true);//已推送
        paramVO.setDemandWhStCodes(storeCodes);
        paramVO.setDocTypeList(docTypeList);//OB_DOC_TYPE
        paramVO.setListFlag(true);
        List<ScpDemandOrderPageRespVO> scpDemandOrderPageRespVOS = scpDemandOrderService.queryDemandOrderList(paramVO);
        if(CollUtil.isEmpty(scpDemandOrderPageRespVOS)) {
            return;
        }
        List<Long> masIds = scpDemandOrderPageRespVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        //4.获取这些订货单的明细，（非运费行的已付款状态的调拨订单），匹到主数据上
        //查询运费商品行
        String orderItemSetting = SysUtils.getOrderItemSetting();
        ScpDemandOrderDListParamVO scpDemandOrderDParamVO = new ScpDemandOrderDListParamVO();
        scpDemandOrderDParamVO.setMasIds(masIds);
        scpDemandOrderDParamVO.setPayStatus("PAYED");
        scpDemandOrderDParamVO.setItemCodeNe(orderItemSetting); //非运费行
        List<ScpDemandOrderDMgmtRespVO> scpDemandOrderDMgmtRespVOS = scpDemandOrderDService.queryList(scpDemandOrderDParamVO);
        if(CollUtil.isEmpty(scpDemandOrderDMgmtRespVOS)) {
            return;
        }else{
            // 将明细按主表ID分组
            Map<Long, List<ScpDemandOrderDMgmtRespVO>> detailMap = scpDemandOrderDMgmtRespVOS.stream()
                    .collect(Collectors.groupingBy(ScpDemandOrderDMgmtRespVO::getMasId));

            // 组装明细到主表对象，并过滤掉无明细的主单
            scpDemandOrderPageRespVOS = scpDemandOrderPageRespVOS.stream()
                    .peek(mas -> mas.setScpDemandOrderDMgmtRespVOS(detailMap.get(mas.getId())))
                    .filter(mas -> CollUtil.isNotEmpty(detailMap.get(mas.getId())))
                    .collect(Collectors.toList());
            if (CollUtil.isEmpty(scpDemandOrderPageRespVOS)) {
                return;
            }
        }


        // 4.按门店分组,再按单据类型分组
        Map<String, Map<String, List<ScpDemandOrderPageRespVO>>> groupedResult =
                scpDemandOrderPageRespVOS.stream()
                        // 第一级分组：按门店编码(demandWhStCode)
                        .collect(Collectors.groupingBy(ScpDemandOrderPageRespVO::getDemandWhStCode,
                                // 第二级分组：按单据类型(docType)
                                Collectors.groupingBy(ScpDemandOrderPageRespVO::getDocType)
                        ));
        // 5.遍历门店及订单计算补运费结果
        for (Map.Entry<String, Map<String, List<ScpDemandOrderPageRespVO>>> storeEntry : groupedResult.entrySet()) {
            BigDecimal totalFillNum = BigDecimal.ZERO;
            BigDecimal totalFillAmt = BigDecimal.ZERO;
            String storeCode = storeEntry.getKey(); // 门店编码
            Map<String, List<ScpDemandOrderPageRespVO>> docTypeGroups = storeEntry.getValue(); // 该门店下的所有单据类型分组

            Integer freeFreightNum = storeFreeFreightNumMap.get(storeCode);
            BigDecimal fillFreightPrice = storeFillFreightPriceMap.get(storeCode);
            if (freeFreightNum == null || fillFreightPrice == null) {
                throw new BusinessException("门店" + storeCode + "补运费相关参数缺失，请检查门店补运费配置参数");
            }

            // 打印门店信息
            log.info("门店编码{},免运费数量{}，补运费单价{}", storeCode, freeFreightNum, fillFreightPrice);
            // 遍历内层Map：key为单据类型(docType)，value为该类型的单据列表
            for (Map.Entry<String, List<ScpDemandOrderPageRespVO>> docTypeEntry : docTypeGroups.entrySet()) {
                String docType = docTypeEntry.getKey(); // 单据类型
                List<ScpDemandOrderPageRespVO> orderList = docTypeEntry.getValue(); // 该单据类型的所有单据
                orderList.stream().map(e->e.getScpDemandOrderDMgmtRespVOS()).collect(Collectors.toList());
                List<ScpDemandOrderDMgmtRespVO> allDetails = orderList.stream()
                        .filter(order -> CollUtil.isNotEmpty(order.getScpDemandOrderDMgmtRespVOS()))
                        .flatMap(order -> order.getScpDemandOrderDMgmtRespVOS().stream())
                        .collect(Collectors.toList());

                // 对该类型订单数量进行加总
                BigDecimal sumQty = allDetails.stream()
                        .map(ScpDemandOrderDMgmtRespVO::getDemandQuantity)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal freeFreightNum1 = BigDecimal.valueOf(freeFreightNum);
                if (sumQty.compareTo(freeFreightNum1) < 0) {
                    // 待补运费数量
                    BigDecimal fillNum = freeFreightNum1.subtract(sumQty);
                    totalFillNum = totalFillNum.add(fillNum);
                    // 计算补运费金额
                    totalFillAmt = fillFreightPrice.multiply(totalFillNum).setScale(2, RoundingMode.HALF_UP);
                }
            }
            if(totalFillAmt.compareTo(BigDecimal.ZERO) > 0) {
                // 创建并提交补运费订单
                ScpDemandOrderSubmitVO saveVO = buildFreightItem(storeMap.get(storeCode),totalFillAmt,scpDemandSetPageRespVO,fillFreightDefaultWh);
                submit(saveVO);
            }
        }
    }

    @Override
    public BigDecimal calculateSaleAmt(Long storeId,String storeCode) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalReturnAmt = BigDecimal.ZERO;
        LocalDateTime firstDayOfMonth = LocalDateTime.of(
                LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()),
                LocalTime.MIN // 表示 00:00:00
        );
        // 1.获取门店本年内已推送的所有订货订单
        ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
        paramVO.setDemandWhStCode(storeCode);//门店
        paramVO.setDemandDateFrom(firstDayOfMonth);
        paramVO.setIsPushed(true);//已推送
        paramVO.setListFlag(true);
        List<ScpDemandOrderPageRespVO> scpDemandOrderPageRespVOS = scpDemandOrderService.queryDemandOrderList(paramVO);
        if(CollUtil.isEmpty(scpDemandOrderPageRespVOS)) {
            return BigDecimal.ZERO;
        }
        List<Long> masIds = scpDemandOrderPageRespVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        // 2.获取这些订货单的明细
//        //查询运费商品行
//        String orderItemSetting = SysUtils.getOrderItemSetting();
        ScpDemandOrderDListParamVO scpDemandOrderDParamVO = new ScpDemandOrderDListParamVO();
        scpDemandOrderDParamVO.setMasIds(masIds);
        scpDemandOrderDParamVO.setPayStatusIn(Arrays.asList("PAYED","NO_PAY"));
//        scpDemandOrderDParamVO.setItemCodeNe(orderItemSetting); //非运费行
        List<ScpDemandOrderDMgmtRespVO> scpDemandOrderDMgmtRespVOS = scpDemandOrderDService.queryList(scpDemandOrderDParamVO);
        if(!CollUtil.isEmpty(scpDemandOrderDMgmtRespVOS)) {
            totalAmt = scpDemandOrderDMgmtRespVOS.stream()
                    .filter(vo -> vo != null)
                    .map(vo -> vo.getPlanAmt() != null ? vo.getPlanAmt() : BigDecimal.ZERO)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }

        // 3.查询慢点本年内已完成退货的所有退货单
        StoreReceivePageParam param = new StoreReceivePageParam();
        param.setRtType("T");
        param.setStoreIds(Arrays.asList(storeId));
        param.setCreateDateFrom(firstDayOfMonth);
        param.setSize(10000);
        PagingVO<StoreReceivePageVO> page = storeReceiveService.page(param);
        if(!CollUtil.isEmpty(page.getRecords())) {
            List<StoreReceivePageVO> records = page.getRecords();
            // 统计退货总金额totalAmt之和
            totalReturnAmt = records.stream()
                    .filter(vo -> vo != null)
                    .map(vo -> vo.getTotalAmt() != null ? vo.getTotalAmt() : BigDecimal.ZERO)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return totalAmt.subtract(totalReturnAmt);
    }

    /**
     * 计算运费商品
     *
     */
    private ScpDemandOrderSubmitVO buildFreightItem(OrgStoreRpcDTO storeRpcDTO,BigDecimal totalFillAmt,ScpDemandSetPageRespVO scpDemandSetPageRespVO,InvWhRpcDTO fillFreightDefaultWh) {



        ScpDemandOrderSubmitVO result = new ScpDemandOrderSubmitVO();
        // 订货集
        result.setDemandId(scpDemandSetPageRespVO.getId());
        result.setDemandCode(scpDemandSetPageRespVO.getDemandCode());
        result.setDemandDate(scpDemandSetPageRespVO.getDemandDate());
        result.setDemandName(scpDemandSetPageRespVO.getDemandName());
        // 门店
        result.setDemandWhStId(storeRpcDTO.getId());
        result.setDemandWhStCode(storeRpcDTO.getStoreCode());
        result.setDemandWhStName(storeRpcDTO.getStoreName());
        // 其它
        result.setType("0");
        result.setDocCls("ST");
        result.setDocType(SysUtils.getBackScpOrderObDocType());//补运费订货单类型
        // 收货信息yst/support/org/orgStore/contact/NXG200001
//        result.setRecvContactName(storeRpcDTO);
//        result.setRecvContactTel();
//        result.setRecvProvince();
//        result.setRecvCity();
//        result.setRecvCountry();
//        result.setRecvDetailaddr();


        // 订货单明细
        ScpDemandOrderDSubmitVO scpDemandOrderDSubmitVO = new ScpDemandOrderDSubmitVO();
        //门店订货单获取运费行商品
        String itemCode = SysUtils.getBackScpOrderItemSetting();
        String orderItemImgUrlSetting = SysUtils.getBackScpOrderItemImgUrlSetting();
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(Arrays.asList(itemCode));
        List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
            throw new BusinessException("补充运费商品编码：" + itemCode + "不存在");
        }
        //补充运费商品
        ItmItemBaseRpcDTO shipmentItem = itemBaseRpcDTOList.get(0);

        ScpDemandOrderDSubmitVO.ItemSpecObjectVO itemSpecObjectVO = new ScpDemandOrderDSubmitVO.ItemSpecObjectVO();
        ScpDemandOrderDSubmitVO.WhAllocObject whAllocObject = new ScpDemandOrderDSubmitVO.WhAllocObject();




        whAllocObject.setItemPrice(SysUtils.processAmtScale(totalFillAmt));
        whAllocObject.setRatio(BigDecimal.valueOf(100));
        whAllocObject.setQty(BigDecimal.ONE);
        String whType = fillFreightDefaultWh.getWhType();
        whAllocObject.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
//        whAllocObject.setSupplyType(whType.equals("STORE")?ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode():ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
        whAllocObject.setSupplyWhCode(fillFreightDefaultWh.getWhCode());
        whAllocObject.setSupplyWhId(fillFreightDefaultWh.getWhId());
        whAllocObject.setSupplyWhName(fillFreightDefaultWh.getWhName());
        whAllocObject.setFreightFlag(false);
        whAllocObject.setFreightRatio(null);
        whAllocObject.setSaleOuCode(fillFreightDefaultWh.getOuCode());
        whAllocObject.setSaleOuName(fillFreightDefaultWh.getOuName());
        // 获取门店的custCode
        whAllocObject.setSaleCustCode(storeRpcDTO.getStoreCode());
        List<ScpDemandOrderDSubmitVO.WhAllocObject> whAllocObjects = List.of(whAllocObject);

        itemSpecObjectVO.setItemId(shipmentItem.getId());
        itemSpecObjectVO.setItemCode(shipmentItem.getItemCode());
        itemSpecObjectVO.setItemName(shipmentItem.getItemName());
        itemSpecObjectVO.setDemandQuantity(BigDecimal.ONE);
        itemSpecObjectVO.setUom(shipmentItem.getUom2());
        itemSpecObjectVO.setUomName(shipmentItem.getUom2Name());
        itemSpecObjectVO.setUom2(shipmentItem.getUom());
        itemSpecObjectVO.setUom2Name(shipmentItem.getUomName());
        itemSpecObjectVO.setDecimalPlaces(shipmentItem.getDecimalPlaces());
        itemSpecObjectVO.setUomRatio(shipmentItem.getUomRatio2());
        itemSpecObjectVO.setItemType(shipmentItem.getItemType2());
        itemSpecObjectVO.setWhAllocObjects(whAllocObjects);

        List<ScpDemandOrderDSubmitVO.ItemSpecObjectVO> itemSpecObjectVOS = List.of(itemSpecObjectVO);

        scpDemandOrderDSubmitVO.setSpuCode(shipmentItem.getSpuCode());
        scpDemandOrderDSubmitVO.setSpuName(shipmentItem.getSpuName());
        scpDemandOrderDSubmitVO.setSpec(shipmentItem.getSpec());
        scpDemandOrderDSubmitVO.setUrl(orderItemImgUrlSetting);

        if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
            scpDemandOrderDSubmitVO.setItemSpecObjectVOS(itemSpecObjectVOS);
        }

        result.setItemList(Arrays.asList(scpDemandOrderDSubmitVO));
        return result;
    }
}
