package com.elitesland.scp.application.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.inv.dto.invTrn.StoreOrderTrnResultDTO;
import com.elitesland.inv.dto.invTrn.StoreOrderTrnRpcDTO;
import com.elitesland.inv.dto.invstk.*;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.inv.provider.StoreOrderTroProvider;
import com.elitesland.order.param.SalSoDSaveDTO;
import com.elitesland.order.param.SalSoSaveDTO;
import com.elitesland.pur.dto.PurPriceParamRpcDTO;
import com.elitesland.pur.dto.po.PurPoDSaveDTO;
import com.elitesland.pur.dto.po.PurPoSaveDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseAndBelongOuDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBelongOuDTO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingParamVO;
import com.elitesland.scp.application.facade.vo.param.order.*;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.*;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.strategy.EventContext;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDtoParam;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderRelateDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepoProc;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepo;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.rmi.*;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.DateTimeUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.*;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcDtoParam;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.org.dto.*;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpDemandOrderServiceImpl implements ScpDemandOrderService {

    private final EventContext eventContext;
    private final RmiItemService rmiItemService;
    private final RmiSalRpcService rmiSalRpcService;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiOrderRpcService orderRpcService;
    private final RmiInvStkRpcService rmiInvStkService;
    private final RmiSysSettingService rmiSysSettingService;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final TransactionTemplate transactionTemplate;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final ScpSupplyAllocationService scpSupplyAllocationService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final StoreOrderTroProvider storeOrderTroProvider;
    private final RmiOrgOuService rmiOrgOuService;
    private final RedisTemplate redisTemplate;
    private final MessageQueueTemplate messageQueueTemplate;
    private final TaskExecutor taskExecutor;

    private final ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc;
    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpAllocSettingStoreRepo scpAllocSettingStoreRepo;


    @Override
    public PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        return scpDemandOrderDomainService.queryDemandOrderPage(paramVO);
    }


    @Override
    public List<ScpDemandOrderPageRespVO> queryDemandOrderList(ScpDemandOrderPageParamVO paramVO) {
        return scpDemandOrderDomainService.queryDemandOrderList(paramVO);
    }

    @Override
    public PagingVO<ScpDemandOrderTitlePageRespVO> page(ScpDemandOrderPageParamVO paramVO) {
        return scpDemandOrderDomainService.page(paramVO);
    }

    @Override
    public PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        return scpDemandOrderDomainService.queryDemandOrderHeader(paramVO);
    }

    @Override
    public Optional<ScpDemandOrderRespVO> findDemandOrderCateById(Long id) {
        return scpDemandOrderDomainService.findDemandOrderById(id)
                .map(row -> {
                    ScpDemandOrderRespVO respVO = ScpDemandOrderConvert.INSTANCE.dtoToRespVO(row);
                    respVO.setItemCates(scpOrderSettingDomainService.findItemCatesByDocType(row.getDocType(), row.getType()));
                    return respVO;
                });
    }

    @Override
    public Optional<ScpDemandOrderRespVO> findDemandOrderById(Long id) {
        return scpDemandOrderDomainService.findDemandOrderById(id)
                .map(ScpDemandOrderConvert.INSTANCE::dtoToRespVO);
    }

    @Override
    public List<ScpDemandOrderRespVO> findDemandOrderByDemandIds(List<Long> demandIds) {
        return scpDemandOrderDomainService.findDemandOrderByDemandIds(demandIds).stream()
                .map(ScpDemandOrderConvert.INSTANCE::dtoToRespVO).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveDemandOrder(ScpDemandOrderSaveVO saveVO) {
        // 校验订货集是否合法
        Boolean status = scpDemandSetDomainService.getDemandSetStatusById(saveVO.getDemandId());
        if (Boolean.FALSE.equals(status)) {
            throw new BusinessException("订货集为禁用状态，不能新增订货单");
        }
        var paramVO = ScpDemandOrderParamVO.builder().demandCode(saveVO.getDemandCode()).docType(saveVO.getDocType())
                .demandWhStCode(saveVO.getDemandWhStCode()).build();
        if (saveVO.getId() == null) {
            scpDemandOrderDomainService.findDemandOrderByParam(paramVO).stream().findFirst().ifPresent(demandOrder -> {
                throw new BusinessException("此订货集中已存在订货门店【" + demandOrder.getDemandWhStName() + "】,单据类型【" + demandOrder.getDocType() + "】的订货单，不能重复新增");
            });
            //设置默认收货地址信息
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(saveVO.getType()) && (StrUtil.isBlank(saveVO.getRecvProvince()) || StrUtil.isBlank(saveVO.getRecvCity()))) {
                List<OrgContactRpcDTO> contactRpcDTOS = rmiOrgStoreRpcService.findContactByStoreCode(saveVO.getDemandWhStCode());
                if (CollUtil.isEmpty(contactRpcDTOS)) {
                    throw new BusinessException("门店编码：" + saveVO.getDemandWhStCode() + "未配置联系人信息");
                }
                List<OrgContactRpcDTO> filterContacts = contactRpcDTOS.stream().filter(row -> "BUSINESS".equals(row.getType())).collect(Collectors.toList());
                if (CollUtil.isEmpty(filterContacts)) {
                    throw new BusinessException("门店编码：" + saveVO.getDemandWhStCode() + "未配置业务联系人信息");
                }
                OrgContactRpcDTO orgContactRpcDTO = filterContacts.get(0);
                saveVO.setRecvProvince(orgContactRpcDTO.getProvince());
                saveVO.setRecvCity(orgContactRpcDTO.getCity());
                saveVO.setRecvCounty(orgContactRpcDTO.getCounty());
                saveVO.setRecvDetailaddr(orgContactRpcDTO.getDetailAddress());
            }
            String orderNo = rmiSysUserRpcService.sysNumberRuleGenerateCode(ScpConstant.OB, new ArrayList<>());
            saveVO.setStoreLevel(StrUtil.isBlank(saveVO.getStoreLevel()) ? "1" : saveVO.getStoreLevel());
            saveVO.setDocCode(orderNo);
            saveVO.setDocStatus(ScpUdcEnum.DEO_STATUS_WT.getValueCode());
        }

        return scpDemandOrderDomainService.saveDemandOrder(saveVO);
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDRespVO> getItemList(ScpDemandOrderItemParamVO paramVO) {
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(paramVO.getDocType(), paramVO.getType());
        if (orderSetting == null) {
            throw new BusinessException("请先配置或启用单据类型:" + paramVO.getDocType());
        }
        // 查询门店信息
        var orgStore = getOrgStore(paramVO.getType(), paramVO.getDemandWhStCode());
        List<ScpDemandOrderDRespVO> result = new ArrayList<>();
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        for (String priority : priorities) {
            if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                result.addAll(suppAllocStrategy(paramVO, orgStore, orderSetting.getSuppFreightFlag()));
            } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                result.addAll(whnetStrategy(paramVO, orgStore, orderSetting.getWhnetFreightFlag()));
            }
            if (!result.isEmpty()) {
                break;
            }
        }
        if (result.isEmpty()) {
            throw new BusinessException("请配置商品【" + paramVO.getItemName() + "】仓网供应关系或者供应商份额");
        }
        return result;
    }

    private OrgStoreBaseRpcDTO getOrgStore(String type, String demandWhStCode) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type)) {
            return Optional.ofNullable(rmiOrgStoreRpcService.getOrgStoreBase(demandWhStCode))
                    .orElseThrow(() -> new BusinessException("门店编码：" + demandWhStCode + "不存在"));
        }
        return new OrgStoreBaseRpcDTO();
    }

    private List<ScpDemandOrderDRespVO> whnetStrategy(ScpDemandOrderItemParamVO paramVO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag) {
        List<ScpDemandOrderDRespVO> result = new ArrayList<>();
        ScpWhNetRelationRpcDtoParam whNetRetParam = new ScpWhNetRelationRpcDtoParam();
        whNetRetParam.setItemCode(paramVO.getItemCode());
        whNetRetParam.setType(paramVO.getType());
        whNetRetParam.setDemandWhStCode(paramVO.getDemandWhStCode());
        var whNetRelationRpcDTOList = scpWhNetRelationService.findWhNetRelationRpcDtoByParam(whNetRetParam);
        log.info("商品编码：{},仓网供应关系信息：{}", paramVO.getItemCode(), JSONUtil.toJsonStr(whNetRelationRpcDTOList));
        if (CollUtil.isNotEmpty(whNetRelationRpcDTOList)) {
            // 查询销售价格
            List<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<>();
            for (ScpWhNetRelationRpcDTO row : whNetRelationRpcDTOList) {
                if (StrUtil.isBlank(row.getOuCode())) {
                    continue;
                }
                ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
                priceParam.setPriceCls(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
                priceParam.setPriceType(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
                priceParam.setItemId(paramVO.getItemId());
                priceParam.setCustCode(row.getCustCode());
                priceParam.setItemCode(paramVO.getItemCode());
                priceParam.setUom(paramVO.getUnit());
                priceParam.setCurrCode(ScpConstant.CNY);
                priceParam.setOuCode(row.getOuCode());
                priceParamList.add(priceParam);
            }
            Map<String, List<PriPriceRpcDTO>> priceMap = getSalePriceMap(priceParamList, paramVO);

            //获取商品图片信息
            Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap = getSkuImgMap(List.of(paramVO.fetchImageId()));

            int size = whNetRelationRpcDTOList.size();
            BigDecimal sum = BigDecimal.ZERO;
            for (int i = 0; i < size; i++) {
                ScpDemandOrderDRespVO scpDemandOrderDRespVO = buildScpDemandOrderDRespVOByWhNetRelate(paramVO, whNetRelationRpcDTOList.get(i),
                        priceMap, skuImgMap);
                if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(paramVO.getType()) && orgStore.getFreightFlag() && freightFlag) {
                    scpDemandOrderDRespVO.setFreightFlag(Boolean.TRUE);
                    scpDemandOrderDRespVO.setFreightRatio(orgStore.getFreightRatio());
                } else {
                    scpDemandOrderDRespVO.setFreightFlag(Boolean.FALSE);
                    scpDemandOrderDRespVO.setFreightRatio(BigDecimal.ZERO);
                }
                if (scpDemandOrderDRespVO.getDemandQuantity() == null) {
                    result.add(scpDemandOrderDRespVO);
                    continue;
                }
                if (i == size - 1) {
                    scpDemandOrderDRespVO.setAllocationDeQuantity(scpDemandOrderDRespVO.getDemandQuantity().subtract(sum));
                } else {
                    BigDecimal ratioQty = scpDemandOrderDRespVO.getDemandQuantity().multiply(scpDemandOrderDRespVO.getRatio()).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_DOWN);
                    scpDemandOrderDRespVO.setAllocationDeQuantity(ratioQty);
                    sum = sum.add(ratioQty);
                }
                result.add(scpDemandOrderDRespVO);
            }
            return result;
        } else {
            return new ArrayList<>();
        }
    }

    private List<ScpDemandOrderDRespVO> suppAllocStrategy(ScpDemandOrderItemParamVO paramVO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag) {
        List<ScpDemandOrderDRespVO> result = new ArrayList<>();
        // 查询供应商配额
        ScpSupplyAllocationRpcDtoParam supAllocParam = new ScpSupplyAllocationRpcDtoParam();
        supAllocParam.setItemCode(paramVO.getItemCode());
        supAllocParam.setType(paramVO.getType());
        supAllocParam.setValidDate(paramVO.getDemandDate());
        supAllocParam.setStoreWhCode(paramVO.getDemandWhStCode());
        List<ScpSupplyAllocationRpcDTO> suppAllocList =
                scpSupplyAllocationService.findSupplyAllocationRpcByParam(supAllocParam);
        log.info("供应商配额查询结果:{}", JSONUtil.toJsonStr(suppAllocList));
        if (CollUtil.isEmpty(suppAllocList)) {
            return new ArrayList<>();
        }
        // 销售价格
        List<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<>();
        for (ScpSupplyAllocationRpcDTO row : suppAllocList) {
            if (StrUtil.isBlank(row.getSaleOuCode())) {
                continue;
            }
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setPriceType(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setItemId(paramVO.getItemId());
            priceParam.setCustCode(row.getSaleCustCode());
            priceParam.setItemCode(paramVO.getItemCode());
            priceParam.setUom(paramVO.getUnit());
            priceParam.setCurrCode(ScpConstant.CNY);
            priceParam.setOuCode(row.getSaleOuCode());
            priceParamList.add(priceParam);
        }

        Map<String, List<PriPriceRpcDTO>> priceMap = getSalePriceMap(priceParamList, paramVO);

        //获取商品图片信息
        Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap = getSkuImgMap(List.of(paramVO.fetchImageId()));

        Map<String, Object> purOuInfo = getPurOuInfo(paramVO.getType(), orgStore, paramVO.getDemandWhStCode());
        int size = suppAllocList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; i++) {
            ScpDemandOrderDRespVO scpDemandOrderDRespVO = buildScpDemandOrderDRespVOBySupplyAlloc(paramVO, suppAllocList.get(i),
                    priceMap, purOuInfo, skuImgMap);
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(paramVO.getType()) && orgStore.getFreightFlag2() && freightFlag) {
                scpDemandOrderDRespVO.setFreightFlag(Boolean.TRUE);
                scpDemandOrderDRespVO.setFreightRatio(orgStore.getFreightRatio2());
            } else {
                scpDemandOrderDRespVO.setFreightFlag(Boolean.FALSE);
                scpDemandOrderDRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (scpDemandOrderDRespVO.getDemandQuantity() == null) {
                result.add(scpDemandOrderDRespVO);
                continue;
            }
            if (i == size - 1) {
                scpDemandOrderDRespVO.setAllocationDeQuantity(scpDemandOrderDRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = scpDemandOrderDRespVO.getDemandQuantity().multiply(scpDemandOrderDRespVO.getRatio()).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_DOWN);
                scpDemandOrderDRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(scpDemandOrderDRespVO);
        }
        return result;
    }

    private Map<Long, List<ItmItemAttachmentProviderDTO>> getSkuImgMap(List<Long> fetchImageIds) {
        //查询商品图片信息
        List<ItmItemAttachmentProviderDTO> skuImgList = rmiItemService.findSkuImgByItemIds(fetchImageIds);
        if (CollUtil.isNotEmpty(skuImgList)) {
            return skuImgList.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
        }
        return new HashMap<>();
    }


    private Map<String, List<PriPriceRpcDTO>> getSalePriceMap(List<ItmPriPriceRpcDtoParam> priceParamList, ScpDemandOrderItemParamVO paramVO) {
        if (CollUtil.isEmpty(priceParamList)) {
            return new HashMap<>();
        }
        List<PriPriceRpcDTO> priceByParam = rmiPriceRpcService.findPriceByParam(priceParamList);
        if (CollUtil.isEmpty(priceByParam)) {
            getBasePrice(priceParamList, priceByParam);
        }
        Map<String, List<PriPriceRpcDTO>> priceMap =
                priceByParam.stream().collect(Collectors.groupingBy(data -> data.getItemCode() + "@" + data.getOuCode()));
        log.info("批量查询商品价格信息:{}", JSONUtil.toJsonStr(priceMap));
        return priceMap;
    }


    @Override
    @SysCodeProc
    public Map<String, List<ScpDemandOrderDRespVO>> getItemListBatch(ScpDemandOrderItemBatchParamVO paramVO) {
        log.info("批量获取商品明细行信息入参:{}", JSONUtil.toJsonStr(paramVO));
        String demandWhStCode = paramVO.getDemandWhStCode();
        //查询门店信息
        OrgStoreBaseRpcDTO orgStore = getOrgStore(paramVO.getType(), paramVO.getDemandWhStCode());

        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(paramVO.getDocType(), paramVO.getType());
        if (orderSetting == null) {
            throw new BusinessException("请先配置或启用单据类型:" + paramVO.getDocType());
        }
        List<ScpDemandOrderItemBatchParamVO.Item> itemList = paramVO.getItemList();
        List<ScpStoreCartDO> dataList = itemList.stream().map(row -> {
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setItemCode(row.getItemCode());
            storeCartDO.setItemCateCode(row.getItemCateCode());
            storeCartDO.setUom(row.getUom());
            return storeCartDO;
        }).collect(Collectors.toList());

        List<String> itemCodes = itemList.stream().map(ScpDemandOrderItemBatchParamVO.Item::getItemCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        //获取仓网供应关系
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = scpWhNetRelationService.findWhNetByParam(demandWhStCode, paramVO.getType(), dataList);
        //获取供应商份额
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = scpSupplyAllocationService.findSupplyAllocationByParam(demandWhStCode, paramVO.getType(), itemCodes);
        List<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<>();
        List<ScpDemandOrderDRespVO> confirmRespVOS = new ArrayList<>();
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        //库存数量
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        for (ScpDemandOrderItemBatchParamVO.Item item : itemList) {
            List<ScpDemandOrderDRespVO> inConfirmList = new ArrayList<>();
            for (String priority : priorities) {
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    inConfirmList.addAll(suppAllocStrategy(item, orgStore, orderSetting.getSuppFreightFlag(), supplyAllocationMap,
                            priceParamList, paramVO.getType(), stockMapRef));
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    inConfirmList.addAll(whnetStrategy(item, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList, paramVO.getType()));
                }
                if (!inConfirmList.isEmpty()) {
                    confirmRespVOS.addAll(inConfirmList);
                    break;
                }
            }
        }
        //构建价格行map
        List<PriPriceRpcDTO> priceList = rmiPriceRpcService.findPriceByParam(priceParamList);
        Map<String, List<PriPriceRpcDTO>> priceMap = buildPriceMap(priceList, priceParamList);

        //查询商品图片
        List<Long> imgIds = confirmRespVOS.stream().map(ScpDemandOrderDRespVO::fetchImageId).distinct().collect(Collectors.toList());

        Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap = getSkuImgMap(imgIds);

        //封装返回
        Map<String, List<ScpDemandOrderDRespVO>> resultMap = confirmRespVOS.stream().map(item -> {
            if (priceMap.containsKey(item.getItemCode() + "@" + item.getSaleOuCode())) {
                item.setPrice(priceMap.get(item.getItemCode() + "@" + item.getSaleOuCode()).get(0).getPrice());
            }
            item.setPlanQuantity(item.getDemandQuantity());
            if (item.getPrice() != null) {
                item.setPlanAmt(SysUtils.processAmtScale(item.getPrice().multiply(item.getPlanQuantity())));
            }
            if (skuImgMap.containsKey(item.fetchImageId())) {
                List<ItmItemAttachmentProviderDTO> v = skuImgMap.get(item.fetchImageId());
                ItmItemAttachmentProviderDTO itmItemAttachmentProviderDTO = v.stream().filter(i -> i.getMajor() != null && i.getMajor()).findFirst().orElseGet(() -> null);
                if (itmItemAttachmentProviderDTO == null) {
                    itmItemAttachmentProviderDTO = v.get(0);
                }
                item.setImgUrl(itmItemAttachmentProviderDTO.getUrl());
            }
            return item;
        }).collect(Collectors.groupingBy(ScpDemandOrderDRespVO::getItemCode));

        log.info("批量获取商品明细行信息结果:{}", JSONUtil.toJsonStr(resultMap));
        return resultMap;
    }

    private Map<String, List<PriPriceRpcDTO>> buildPriceMap(List<PriPriceRpcDTO> priceList, List<ItmPriPriceRpcDtoParam> priceParamList) {
        if (CollUtil.isEmpty(priceList)) {
            //查询基本单位价格
            getBasePrice(priceParamList, priceList);
            if (CollUtil.isEmpty(priceList)) {
                return new HashMap<>();
            }
        } else {
            //查询基本单位价格
            Map<String, List<PriPriceRpcDTO>> inPriceMap =
                    priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
            priceParamList.removeAll(priceParamList.stream().filter(row -> inPriceMap.containsKey(row.getItemCode())).collect(Collectors.toList()));
            getBasePrice(priceParamList, priceList);
        }
        return priceList.stream().collect(Collectors.groupingBy(row -> row.getItemCode() + "@" + row.getOuCode()));
    }

    private void getBasePrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList) {
        if (CollUtil.isEmpty(priceParamList)) {
            return;
        }
        //查询商品
        List<Long> itemIds = priceParamList.stream().map(ItmPriPriceRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> simpleItemMap = rmiItemService.findBaseItemMap(itemIds);

        List<ItmPriPriceRpcDtoParam> baseUomList = priceParamList.stream().map(row -> {
            ItmPriPriceRpcDtoParam param = BeanUtils.copyProperties(row, ItmPriPriceRpcDtoParam.class);
            ItmItemSimpleRpcDTO simpleItem = simpleItemMap.get(row.getItemId());
            param.setUom(simpleItem.getUom());
            return param;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> basePriceList = rmiPriceRpcService.findPriceByParam(baseUomList);
        log.info("查询基本单位价格:{}", JSONUtil.toJsonStr(basePriceList));
        if (CollUtil.isNotEmpty(basePriceList)) {
            List<PriPriceRpcDTO> resultPriceList = basePriceList.stream().map(row -> {
                PriPriceRpcDTO priPriceRpcDTO = BeanUtils.copyProperties(row, PriPriceRpcDTO.class);
                ItmItemSimpleRpcDTO simpleItem = simpleItemMap.get(row.getItemId());
                if (simpleItem.getUomRatio2() == null) {
                    return null;
                }
                if (simpleItem.getDecimalPlaces() != null) {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale(simpleItem.getDecimalPlaces(), BigDecimal.ROUND_HALF_UP));
                } else {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()));
                }
                return priPriceRpcDTO;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            priceList.addAll(resultPriceList);
        }
    }

    private List<ScpDemandOrderDRespVO> suppAllocStrategy(ScpDemandOrderItemBatchParamVO.Item cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap,
                                                          List<ItmPriPriceRpcDtoParam> priceParamList, String type, AtomicReference<Map<String, BigDecimal>> stockMap) {
        List<ScpDemandOrderDRespVO> result = new ArrayList<>();
        // 查询供应商配额
        List<ScpSupplyAllocationRpcDTO> suppAllocList = supplyAllocationMap.get(cartDO.getItemCode());
        log.info("供应商配额查询结果:{}", JSONUtil.toJsonStr(suppAllocList));
        if (CollUtil.isEmpty(suppAllocList)) {
            return new ArrayList<>();
        }
        // 销售价格
        for (ScpSupplyAllocationRpcDTO row : suppAllocList) {
            if (StrUtil.isBlank(row.getSaleOuCode())) {
                continue;
            }
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setPriceType(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getSaleCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode(ScpConstant.CNY);
            priceParam.setOuCode(row.getSaleOuCode());
            priceParamList.add(priceParam);
        }
        int size = suppAllocList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; i++) {
            ScpSupplyAllocationRpcDTO row = suppAllocList.get(i);
            ScpDemandOrderDRespVO orderConfirmRespVO = new ScpDemandOrderDRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuItemCode(cartDO.getSpuItemCode());
            orderConfirmRespVO.setSpuItemName(cartDO.getSpuItemName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSuppId());
            orderConfirmRespVO.setSuppWhCode(row.getSuppCode());
            orderConfirmRespVO.setSuppWhName(row.getSuppName());
            orderConfirmRespVO.setRatio(row.getAllocation());
            orderConfirmRespVO.setCurrency(ScpConstant.CNY);
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
            orderConfirmRespVO.setSaleOuCode(row.getSaleOuCode());
            orderConfirmRespVO.setSaleOuName(row.getSaleOuName());
            orderConfirmRespVO.setSaleCustCode(row.getSaleCustCode());
            orderConfirmRespVO.setOuId(row.getOuId());
            orderConfirmRespVO.setOuCode(row.getOuCode());
            orderConfirmRespVO.setOuName(row.getOuName());
            orderConfirmRespVO.setDemandQuantity(cartDO.getDemandQuantity());
            orderConfirmRespVO.setItemType(cartDO.getItemType());
            orderConfirmRespVO.setQty2(cartDO.getQty2());
            orderConfirmRespVO.setUom2(cartDO.getUom2());
            orderConfirmRespVO.setUom2Name(cartDO.getUom2Name());
            orderConfirmRespVO.setDecimalPlaces(cartDO.getDecimalPlaces());
            orderConfirmRespVO.setUomRatio(cartDO.getUomRatio());
            orderConfirmRespVO.setIsCalculated(Boolean.FALSE);
            orderConfirmRespVO.setIsPushed(Boolean.FALSE);
            orderConfirmRespVO.setImgUrl(cartDO.getUrl());
            orderConfirmRespVO.setMinNum(cartDO.getDemandQuantity());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(cartDO.getItemCode(), new BigDecimal("9999"));
                return currentMap;
            });
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type) && orgStore.getFreightFlag2() && freightFlag) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio2());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private List<ScpDemandOrderDRespVO> whnetStrategy(ScpDemandOrderItemBatchParamVO.Item cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap,
                                                      List<ItmPriPriceRpcDtoParam> priceParamList, String type) {
        List<ScpDemandOrderDRespVO> result = new ArrayList<>();
        var whNetRelationRpcDTOList = whNetRelationMap.get(cartDO.getItemCode());
        log.info("商品编码：{},仓网供应关系信息：{}", cartDO.getItemCode(), JSONUtil.toJsonStr(whNetRelationRpcDTOList));
        if (CollUtil.isEmpty(whNetRelationRpcDTOList)) {
            return new ArrayList<>();
        }
        // 查询销售价格
        for (ScpWhNetRelationRpcDTO row : whNetRelationRpcDTOList) {
            if (StrUtil.isBlank(row.getOuCode())) {
                continue;
            }
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setPriceType(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode(ScpConstant.CNY);
            priceParam.setOuCode(row.getOuCode());
            priceParamList.add(priceParam);
        }
        int size = whNetRelationRpcDTOList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; i++) {
            ScpWhNetRelationRpcDTO row = whNetRelationRpcDTOList.get(i);
            ScpDemandOrderDRespVO orderConfirmRespVO = new ScpDemandOrderDRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuItemCode(cartDO.getSpuItemCode());
            orderConfirmRespVO.setSpuItemName(cartDO.getSpuItemName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSupplyWhId());
            orderConfirmRespVO.setSuppWhCode(row.getSupplyWhCode());
            orderConfirmRespVO.setSuppWhName(row.getSupplyWhName());
            orderConfirmRespVO.setRatio(row.getSupplyPercentage());
            orderConfirmRespVO.setCurrency(ScpConstant.CNY);
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
            orderConfirmRespVO.setDemandQuantity(cartDO.getDemandQuantity());
            orderConfirmRespVO.setSaleOuName(row.getOuName());
            orderConfirmRespVO.setSaleOuCode(row.getOuCode());
            orderConfirmRespVO.setSaleCustCode(row.getCustCode());
            orderConfirmRespVO.setItemType(cartDO.getItemType());
            orderConfirmRespVO.setQty2(cartDO.getQty2());
            orderConfirmRespVO.setUom2(cartDO.getUom2());
            orderConfirmRespVO.setUom2Name(cartDO.getUom2Name());
            orderConfirmRespVO.setDecimalPlaces(cartDO.getDecimalPlaces());
            orderConfirmRespVO.setUomRatio(cartDO.getUomRatio());
            orderConfirmRespVO.setIsCalculated(Boolean.FALSE);
            orderConfirmRespVO.setIsPushed(Boolean.FALSE);
            orderConfirmRespVO.setImgUrl(cartDO.getUrl());
            orderConfirmRespVO.setMinNum(cartDO.getDemandQuantity());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type) && orgStore.getFreightFlag() && freightFlag) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;

    }

    /**
     * 获取采购公司信息
     *
     * @param type
     * @param orgStore
     * @return
     */
    private Map<String, Object> getPurOuInfo(String type, OrgStoreBaseRpcDTO orgStore, String demandWhStCode) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type)) {
            return Map.of("ouId", orgStore.getOuId(),
                    "ouCode", orgStore.getOuCode(),
                    "ouName", orgStore.getOuName());
        }
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(type)) {
            Map<String, InvWhRpcSimpleDTO> whDtoMap = rmiInvStkService.findInvWhBaseMapByCode(List.of(demandWhStCode));
            InvWhRpcSimpleDTO invWhRpcDTO = whDtoMap.get(demandWhStCode);
            Map<Long, OrgOuRpcSimpleDTO> ouDtoMap = rmiOrgOuService.findOuDtoMap(List.of(invWhRpcDTO.getOuId()));
            return Map.of("ouId", invWhRpcDTO.getOuId(),
                    "ouCode", invWhRpcDTO.getOuCode(),
                    "ouName", ouDtoMap.get(invWhRpcDTO.getOuId()).getOuName());
        }
        return new HashMap<>();
    }

    /**
     * 构建订货单明细
     *
     * @param paramVO
     * @param row
     * @param priceMap
     * @return
     */
    private ScpDemandOrderDRespVO buildScpDemandOrderDRespVOByWhNetRelate(ScpDemandOrderItemParamVO paramVO,
                                                                          ScpWhNetRelationRpcDTO row,
                                                                          Map<String, List<PriPriceRpcDTO>> priceMap,
                                                                          Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap) {
        ScpDemandOrderDRespVO item = new ScpDemandOrderDRespVO();
        item.setItemId(paramVO.getItemId());
        item.setItemCode(paramVO.getItemCode());
        item.setItemName(paramVO.getItemName());
        item.setSpuItemCode(paramVO.getSpuItemCode());
        item.setSpuItemName(paramVO.getSpuItemName());
        item.setUnitName(paramVO.getUnitName());
        item.setUnit(paramVO.getUnit());
        item.setSuppWhId(row.getSupplyWhId());
        item.setSuppWhCode(row.getSupplyWhCode());
        item.setSuppWhName(row.getSupplyWhName());
        item.setRatio(row.getSupplyPercentage());
        item.setCurrency(ScpConstant.CNY);
        item.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
        item.setUom2(paramVO.getUom2());
        item.setUom2Name(paramVO.getUom2Name());
        item.setUomRatio(paramVO.getUomRatio());
        item.setDecimalPlaces(paramVO.getDecimalPlaces());
        item.setIsPushed(Boolean.FALSE);
        item.setIsCalculated(Boolean.FALSE);
        item.setDemandQuantity(paramVO.getDemandQuantity());
        item.setSaleOuName(row.getOuName());
        item.setSaleOuCode(row.getOuCode());
        item.setSaleCustCode(row.getCustCode());
        item.setItemType(paramVO.getItemType());
        if (skuImgMap.containsKey(paramVO.fetchImageId())) {
            List<ItmItemAttachmentProviderDTO> v = skuImgMap.get(paramVO.fetchImageId());
            ItmItemAttachmentProviderDTO itmItemAttachmentProviderDTO = v.stream().filter(i -> i.getMajor() != null && i.getMajor()).findFirst().orElseGet(() -> null);
            if (itmItemAttachmentProviderDTO == null) {
                itmItemAttachmentProviderDTO = v.get(0);
            }
            item.setImgUrl(itmItemAttachmentProviderDTO.getUrl());
        }
        //仓网供应关系，如果销售公司无值，属于同公司调拨需求，不需要带出含税单价，此行无需支付；
        String ouCode = row.getOuCode();
        if (StrUtil.isBlank(ouCode)) {
            return item;
        }
        List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(item.getItemCode() + "@" + ouCode);
        if (CollUtil.isNotEmpty(priceRpcDTOS)) {
            item.setPrice(priceRpcDTOS.get(0).getPrice());
        } else {
            throw new BusinessException("商品编码【" + item.getItemCode() + "】,公司编码【" + ouCode + "】,未配置结算价格信息");
        }
        return item;
    }

    /**
     * 构建订货单明细
     *
     * @param paramVO
     * @param row
     * @param priceMap
     * @return
     */
    private ScpDemandOrderDRespVO buildScpDemandOrderDRespVOBySupplyAlloc(ScpDemandOrderItemParamVO paramVO,
                                                                          ScpSupplyAllocationRpcDTO row,
                                                                          Map<String, List<PriPriceRpcDTO>> priceMap,
                                                                          Map<String, Object> purOuInfo,
                                                                          Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap) {
        ScpDemandOrderDRespVO item = new ScpDemandOrderDRespVO();
        item.setItemId(paramVO.getItemId());
        item.setItemCode(paramVO.getItemCode());
        item.setItemName(paramVO.getItemName());
        item.setSpuItemCode(paramVO.getSpuItemCode());
        item.setSpuItemName(paramVO.getSpuItemName());
        item.setUnitName(paramVO.getUnitName());
        item.setUnit(paramVO.getUnit());
        item.setSuppWhId(row.getSuppId());
        item.setSuppWhCode(row.getSuppCode());
        item.setSuppWhName(row.getSuppName());
        item.setRatio(row.getAllocation());
        item.setCurrency(ScpConstant.CNY);
        item.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
        item.setUom2(paramVO.getUom2());
        item.setUom2Name(paramVO.getUom2Name());
        item.setUomRatio(paramVO.getUomRatio());
        item.setDecimalPlaces(paramVO.getDecimalPlaces());
        item.setSaleOuCode(row.getSaleOuCode());
        item.setSaleOuName(row.getSaleOuName());
        item.setSaleCustCode(row.getSaleCustCode());
        item.setItemType(paramVO.getItemType());
        item.setOuId(Optional.ofNullable(row.getOuId()).orElse((Long) purOuInfo.get("ouId")));
        item.setOuCode(Optional.ofNullable(row.getOuCode()).orElse((String) purOuInfo.get("ouCode")));
        item.setOuName(Optional.ofNullable(row.getOuName()).orElse((String) purOuInfo.get("ouName")));
        item.setIsPushed(Boolean.FALSE);
        item.setIsCalculated(Boolean.FALSE);
        item.setDemandQuantity(paramVO.getDemandQuantity());
        if (skuImgMap.containsKey(paramVO.fetchImageId())) {
            List<ItmItemAttachmentProviderDTO> v = skuImgMap.get(paramVO.fetchImageId());
            ItmItemAttachmentProviderDTO itmItemAttachmentProviderDTO = v.stream().filter(i -> i.getMajor() != null && i.getMajor()).findFirst().orElseGet(() -> null);
            if (itmItemAttachmentProviderDTO == null) {
                itmItemAttachmentProviderDTO = v.get(0);
            }
            item.setImgUrl(itmItemAttachmentProviderDTO.getUrl());
        }

        //供应商份额分配，如果销售公司无值，属于同公司，不需要带出含税单价，此行无需支付；
        String ouCode = row.getSaleOuCode();
        if (StrUtil.isBlank(ouCode)) {
            return item;
        }
        List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(item.getItemCode() + "@" + ouCode);
        if (CollUtil.isNotEmpty(priceRpcDTOS)) {
            item.setPrice(priceRpcDTOS.get(0).getPrice());
        } else {
            throw new BusinessException("商品编码：" + item.getItemCode() + ",公司编码：" + ouCode + ",未配置结算价格信息");
        }
        return item;
    }

    @Override
    public void cancelScpDemand(Long id) {
        ScpDemandOrderDTO scpDemandOrderDTO =
                scpDemandOrderDomainService.findDemandOrderById(id).orElseThrow(new BusinessException("数据不存在"));
        if (!ScpUdcEnum.DEO_STATUS_WT.getValueCode().equals(scpDemandOrderDTO.getDocStatus()) && !ScpUdcEnum.DEO_STATUS_DOING.getValueCode()
                .equals(scpDemandOrderDTO.getDocStatus())) {
            throw new BusinessException("单据状态不可取消");
        }
        var demandOrderDDTOList =
                scpDemandOrderDDomainService.findDemandOrderDByMasId(id).stream().filter(row -> !row.getIsCalculated() && !row.getIsPushed()).map(
                        ScpDemandOrderDDTO::getId).collect(Collectors.toList());

        scpDemandOrderDDomainService.deleteByIds(demandOrderDDTOList);
    }

    /**
     * 订货集自动计算
     *
     * @param demandSetId
     */
    @Override
    public void compute(Long demandSetId) {
        TimeInterval timer = new TimeInterval();
        log.info("【订货集自动计算】订货集ID：{},开始配货", demandSetId);
        String redisKey = "ORDER_COMPUTE@".concat(demandSetId.toString());
        if (redisTemplate.hasKey(redisKey)) {
            log.info("【order-compute】订货集ID:{},正在计算中...");
            return;
        }
        // 设置防重复操作限时标记(前置通知)
        redisTemplate.opsForValue().set(redisKey, "ORDER_COMPUTE", 300, TimeUnit.SECONDS);
        try {
            var orderCount = scpDemandOrderDomainService.countDemandOrderByDemandIds(List.of(demandSetId));
            if (orderCount == 0) {
                log.info("【订货集自动计算】订货集ID：{}，无订货单信息", demandSetId);
                //更新订货集计算信息=计算完毕
                scpDemandSetDomainService.updateDemandSetMsgByIds(List.of(demandSetId), ScpConstant.NO_COMPUTE);
                return;
            }
            //查询订货集信息
            ScpDemandSetDTO scpDemandSetDTO = scpDemandSetDomainService.findDemandSetById(demandSetId).get();
            if (scpDemandSetDTO == null) {
                log.info("【订货集自动计算】订货集：{}，查询为空", demandSetId);
                return;
            }
            //仓库配货：订货分配算法配置
            var sysSetting = rmiSysSettingService.findSysSettingByNo(ScpConstant.ALLOC_COMPUTE_CONFIG);
            var stkSetting = rmiSysSettingService.findSysSettingByNo(ScpConstant.ORDER_PRODUCT_STATUS_VALUE);
            String allocComputeConfig = sysSetting == null ? "0" : sysSetting.getSettingVal();
            String stkStatusConfig = stkSetting == null ? "1" : stkSetting.getSettingVal();
            Integer totalPage = PageUtil.totalPage(orderCount, 500);
            for (int i = 1; i <= totalPage; i++) {
                ScpComputeDemandOrderPageParamVO pageParamVO = new ScpComputeDemandOrderPageParamVO();
                pageParamVO.setDemandId(demandSetId);
                pageParamVO.setSize(500);
                pageParamVO.setCurrent(i);
                List<OrderItem> orders = new ArrayList<>();
                OrderItem orderItem = new OrderItem();
                orderItem.setAsc(false);
                orderItem.setColumn("storeLevel");
                orders.add(orderItem);
                pageParamVO.setOrders(orders);
                List<Long> ids = scpDemandOrderDomainService.pageDemandOrderIds(pageParamVO);

                //检查结算路径和采购价格
                String checkMsg = checkTransactionPathAndPoPrice(demandSetId, ids, scpDemandSetDTO);
                if (StrUtil.isNotBlank(checkMsg)) {
                    scpDemandSetDomainService.updateDemandSetMsgByIds(List.of(demandSetId), checkMsg);
                    continue;
                }
                //自动配货分两种场景，供应商配货+仓库配货
                //供应商配货:计划数量 = 订货预分配数量
                scpDemandOrderDDomainService.updateSuppAllocPlanQty(demandSetId);

                List<ScpDemandOrderComputeVO> itemAndWhMapList =
                        scpDemandOrderDomainService.getItemAndWarehouseByIds(ids);

                Map<String, BigDecimal> itemStkMap = new HashMap<>();
                Map<Long, List<ScpDemandOrderComputeVO>> whMap = itemAndWhMapList.stream().collect(Collectors.groupingBy(ScpDemandOrderComputeVO::getSuppWhId));
                whMap.forEach((whId, list) -> {
                    // 获取库存可用数量
                    InvStkQueryRpcParam invStkRpcDtoParam = new InvStkQueryRpcParam();
                    invStkRpcDtoParam.setWhIds(List.of(whId));

                    List<String> stkStatusList = "0".equals(stkStatusConfig) ?
                            List.of(ScpUdcEnum.STK_ITM_STATUS_OK.getValueCode()) :
                            List.of(ScpUdcEnum.STK_ITM_STATUS_OK.getValueCode(), ScpUdcEnum.STK_ITM_STATUS_QC.getValueCode(),
                                    ScpUdcEnum.STK_ITM_STATUS_PASS.getValueCode());
                    // 商品明细
                    List<InvStkItemUomRpcDtoParam> itemList = list.stream().map(row -> {
                        InvStkItemUomRpcDtoParam invStkItemUomParam = new InvStkItemUomRpcDtoParam();
                        invStkItemUomParam.setItemId(row.getItemId());
                        invStkItemUomParam.setToUom(row.getUnit());
                        return invStkItemUomParam;
                    }).collect(Collectors.toList());
                    invStkRpcDtoParam.setInvStkItemUomParams(itemList);
                    invStkRpcDtoParam.setFilterAvalZero(Boolean.TRUE);
                    invStkRpcDtoParam.setIsSumFlag(Boolean.TRUE);
                    invStkRpcDtoParam.setLimit1s(stkStatusList);
                    List<InvStkQueryRpcResult> invStkRpcDTOList = rmiInvStkService.queryInvStk(invStkRpcDtoParam);
                    Map<String, BigDecimal> itemStkQtyMap = invStkRpcDTOList.stream().collect(Collectors.groupingBy(row -> row.getWhCode() + "@" + row.getItemCode(),
                            Collectors.reducing(BigDecimal.ZERO,
                                    InvStkQueryRpcResult::getAvalQty,
                                    BigDecimal::add)));

                    log.info("【订货集自动计算】库存ID：{},库存可用数量：{}", whId, JSONUtil.toJsonStr(itemStkQtyMap));
                    itemStkMap.putAll(itemStkQtyMap);
                });
                Map<String, List<ScpDemandOrderComputeVO>> computeList = itemAndWhMapList.stream().collect(Collectors.groupingBy(row -> row.getSuppWhCode() + "@" + row.getItemCode()));
                computeList.forEach((compute, list) -> {
                    String[] split = compute.split("@");
                    String suppWhCode = split[0];
                    String itemCode = split[1];
                    log.info("【订货集自动计算】订货单分配算法，订货集ID: " + demandSetId + ",商品编码 " + itemCode + " ,仓库编码: " + suppWhCode);
                    TimeInterval itemTimer = new TimeInterval();
                    BigDecimal orDefault = itemStkMap.getOrDefault(compute, BigDecimal.ZERO);
                    if (orDefault.compareTo(BigDecimal.ZERO) == 0) {
                        log.info("【订货集自动计算】商品编码：{},仓库编码：{},库存量为0", itemCode, suppWhCode);
                        return;
                    }
                    String unique = "SCP_COMPUTE@".concat(compute);
                    BigDecimal sumAvalQty = redisTemplate.opsForValue().get(unique) == null ? orDefault : new BigDecimal((String) redisTemplate.opsForValue().get(unique));

                    computeAndUpdateAllocation(unique, list, sumAvalQty, allocComputeConfig);
                    log.info("【订货集自动计算】订货集ID：{},商品编码：{},库存：{},分配耗时：{}", demandSetId, itemCode, suppWhCode, itemTimer.intervalMs());
                });
            }
            //删除redis key
            delPatternKey(redisTemplate, "SCP_COMPUTE@*");
            //更新订货集计算信息=计算完毕
            scpDemandSetDomainService.updateDemandSetMsgByIds(List.of(demandSetId), ScpConstant.COMPUTE_DONE);
            //更新订货单状态
            scpDemandOrderDomainService.updateAllocStatusByDemandId(demandSetId);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        } finally {
            redisTemplate.delete(redisKey);
        }
        log.info("【订货集自动计算】订货集ID：{},耗时：{}", demandSetId, timer.intervalMs());
    }


    @Override
    public void pushPo(List<PurPoSaveDTO> storeOrderPoRpcDTOs) {
        List<Long> dIdList = collectRelateDocDidPo(storeOrderPoRpcDTOs);
        AtomicReference<String> errorLog = new AtomicReference<>();
        log.info("开始推送采购单,参数:{},明细行id:{}", JSONUtil.toJsonStr(storeOrderPoRpcDTOs), JSONUtil.toJsonStr(dIdList));
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionTemplate.execute(transactionStatus -> {
            try {
                //调用接口生成调拨单
                List<PurPoSaveDTO> result = rmiPurRpcService.createPo(storeOrderPoRpcDTOs);
                // 更新订货单明细推送状态=已推送
                scpDemandOrderDDomainService.updateIsPushed(dIdList);
                log.info("更新明细行推送状态成功");
                processPoInfoCallback(result);
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, "成功");
                log.info("更新明细行同步消息成功");
                return "ok";
            } catch (Exception e) {
                log.error("创建采购单出错:{}", e.getMessage(), e);
                errorLog.set(e.getMessage());
                // 回滚
                transactionStatus.setRollbackOnly();
                return "ok";
            }
        });
        //更新订货单推送状态
        List<Long> ids = storeOrderPoRpcDTOs.stream().map(PurPoSaveDTO::getRelateDocId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (StrUtil.isNotBlank(errorLog.get())) {
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, StringUtils.substring(errorLog.toString(), 0,
                    200));
        } else {
            ids.stream().filter(Objects::nonNull).forEach(id -> scpDemandOrderDomainService.updatePushStatusById(id));
        }
        ids.stream().filter(Objects::nonNull).forEach(id -> redisTemplate.delete("PO" + id.toString()));
    }

    @Override
    public void pushTrn(List<StoreOrderTrnRpcDTO> storeOrderTrnRpcDTOs) {
        List<Long> dIdList = collectRelateDocDid(storeOrderTrnRpcDTOs);
        AtomicReference<String> errorLog = new AtomicReference<>();
        log.info("开始推送调拨单,参数:{},明细行id:{}", JSONUtil.toJsonStr(storeOrderTrnRpcDTOs), JSONUtil.toJsonStr(dIdList));
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionTemplate.execute(transactionStatus -> {
            //调用接口生成调拨单

            try {
                List<StoreOrderTrnResultDTO> result =
                        storeOrderTroProvider.generateTro(storeOrderTrnRpcDTOs).computeData();
                // 更新订货单明细推送状态=已推送
                scpDemandOrderDDomainService.updateIsPushed(dIdList);
                log.info("更新明细行推送状态成功");
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, "成功");
                log.info("更新明细行同步消息成功");
                processTrnInfoMsg(result);
                return "ok";
            } catch (Exception e) {
                log.error("创建调拨单出错:{}", e.getMessage(), e);
                errorLog.set(e.getMessage());
                // 回滚
                transactionStatus.setRollbackOnly();
                return "ok";
            }
        });
        //更新订货单推送状态
        List<Long> ids = storeOrderTrnRpcDTOs.stream().map(StoreOrderTrnRpcDTO::getRelateDocId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (StrUtil.isNotBlank(errorLog.get())) {
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, StringUtils.substring(errorLog.toString(), 0,
                    200));
        } else {
            ids.stream().filter(Objects::nonNull).forEach(id -> scpDemandOrderDomainService.updatePushStatusById(id));
        }
        ids.stream().filter(Objects::nonNull).forEach(id -> redisTemplate.delete("TRN" + id.toString()));
    }

    @Override
    public void pushSo(List<SalSoSaveDTO> salSoSaveDTOS) {
        for (SalSoSaveDTO salSoSaveDTO : salSoSaveDTOS) {
            List<Long> dIdList =
                    salSoSaveDTO.getSalSoDSaveVOList().stream().map(SalSoDSaveDTO::getRootDocDId).collect(Collectors.toList());
            AtomicReference<String> errorLog = new AtomicReference<>();
            transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
            transactionTemplate.execute(transactionStatus -> {
                try {
                    log.info("【开始推送销售订单】创建销售订单：{}", JSONObject.toJSONString(salSoSaveDTO));
                    //调用销售订单创建接口
                    orderRpcService.createSalSo(salSoSaveDTO);
                    // 更新订货单明细推送状态=已推送
                    scpDemandOrderDDomainService.updateIsPushed(dIdList);
                    return "ok";
                } catch (Exception e) {
                    log.error("销售订单创建,线程:{},出错:{},参数:{}", Thread.currentThread().getName(), e,
                            JSONObject.toJSONString(salSoSaveDTO));
                    errorLog.set(e.getMessage());
                    // 回滚
                    transactionStatus.setRollbackOnly();
                    return "ok";
                }
            });
            if (StrUtil.isNotBlank(errorLog.get())) {
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, StringUtils.substring(errorLog.toString()
                        , 0, 200));
            } else {
                scpDemandOrderDomainService.updatePushStatusById(salSoSaveDTO.getRelateDocId());
            }
            //更新订货单推送状态
            redisTemplate.delete("SO" + salSoSaveDTO.getRelateDocId().toString());
        }
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderPayInfoRespVO> payInfo(Long id) {
        ScpDemandOrderDTO scpDemandOrderDTO = scpDemandOrderDomainService.findDemandOrderById(id).orElseThrow(() -> new BusinessException("订货单不存在"));
        List<String> payStatusList = List.of(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode(), ScpUdcEnum.PAY_STATUS_PART_PAY.getValueCode(),
                ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
        if (!payStatusList.contains(scpDemandOrderDTO.getPayStatus())) {
            throw new BusinessException("付款状态不为【待支付】、【支付中】、【部分付款】");
        }
        return scpDemandOrderDDomainService.payInfo(id);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpPayOrderPageRespVO> payPage(ScpDemandOrderPageParamVO paramVO) {
        return scpDemandOrderDomainService.payPage(paramVO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void close(Long id, String source) {
        Optional<ScpDemandOrderDTO> demandOrderById = scpDemandOrderDomainService.findDemandOrderById(id);
        if (demandOrderById.isEmpty()) {
            throw new BusinessException("订货单不存在");
        }
        List<String> docStatusList = List.of(ScpUdcEnum.DEO_STATUS_PART_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_SHIP.getValueCode(),
                ScpUdcEnum.DEO_STATUS_PART_RECV.getValueCode(), ScpUdcEnum.DEO_STATUS_RECV.getValueCode());
        ScpDemandOrderDTO scpDemandOrderDTO = demandOrderById.get();
        String docStatus = scpDemandOrderDTO.getDocStatus();
        if (docStatusList.contains(docStatus)) {
            throw new BusinessException("订货单不允许关闭");
        }
        var demandItemList = scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        if (!"APP".equals(source) && CollUtil.isNotEmpty(demandItemList)) {
            var relateOrderList = demandItemList.stream().filter(row -> row.getSrcDocId() != null).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(relateOrderList)) {
                Map<String, List<ScpDemandOrderDDTO>> docMap = relateOrderList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getSrcDocCls));
                //循环docMap
                for (Map.Entry<String, List<ScpDemandOrderDDTO>> entry : docMap.entrySet()) {
                    List<Long> ids = entry.getValue().stream().map(ScpDemandOrderDDTO::getSrcDocId).collect(Collectors.toList());
                    if ("PO".equals(entry.getKey())) {
                        rmiPurRpcService.closePo(ids);
                    } else {
                        rmiInvStkService.closeTro(ids);
                    }
                }
            }
        }
        //关闭订货单
        scpDemandOrderDomainService.closeDemandOrder(id);
        if (CollUtil.isEmpty(demandItemList)) {
            return;
        }
        //更新门店已强配次数
        List<Long> activityIds = demandItemList.stream().map(ScpDemandOrderDDTO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(activityIds)) {
            scpAllocSettingStoreRepo.minAllocNumByParam(activityIds, scpDemandOrderDTO.getDemandWhStCode());
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void closePoOrTro(Long id, String type) {
        if ("PO".equals(type)) {
            rmiPurRpcService.closePo(List.of(id));
        } else {
            rmiInvStkService.closeTro(List.of(id));
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void closePoOrTro(String docNo) {
        List<ScpDemandOrderDDTO> demandOrderDBySrcDocNo = scpDemandOrderDDomainService.findDemandOrderDBySrcDocNo(docNo);
        if(CollUtil.isEmpty(demandOrderDBySrcDocNo)){
            log.error("closePoOrTro失败，未查询到订货单子单,参数:{}", docNo);
        }
        ScpDemandOrderDDTO scpDemandOrderDDTO = demandOrderDBySrcDocNo.get(0);
        String type = docNo.substring(0, 2);
        Long id = scpDemandOrderDDTO.getSrcDocId();
        if ("PO".equals(type)) {
            rmiPurRpcService.closePo(List.of(id));
        } else {
            rmiInvStkService.closeTro(List.of(id));
        }
    }

    @Override
    public void closeOrderByDocNo(String docNo) {
        ScpDemandOrderParamVO paramVO = ScpDemandOrderParamVO.builder().docCode(docNo).build();
        List<ScpDemandOrderDTO> demandOrderDTOS = scpDemandOrderDomainService.findDemandOrderByParam(paramVO);
        if (CollUtil.isEmpty(demandOrderDTOS)) {
            throw new BusinessException("订货单不存在");
        }
        ScpDemandOrderDTO scpDemandOrderDTO = demandOrderDTOS.get(0);
        List<String> docStatusList = List.of(ScpUdcEnum.DEO_STATUS_PART_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_SHIP.getValueCode(),
                ScpUdcEnum.DEO_STATUS_PART_RECV.getValueCode(), ScpUdcEnum.DEO_STATUS_RECV.getValueCode());
        String docStatus = scpDemandOrderDTO.getDocStatus();
        if (docStatusList.contains(docStatus)) {
            throw new BusinessException("订货单不允许关闭");
        }
        //查询关联的调拨订单和采购订单信息
        List<ScpDemandOrderRelateDTO> relateOrderList = scpDemandOrderDDomainService.findRelateOrderByMasId(scpDemandOrderDTO.getId());
        if (CollUtil.isNotEmpty(relateOrderList)) {
            Map<String, List<ScpDemandOrderRelateDTO>> docMap = relateOrderList.stream().collect(Collectors.groupingBy(ScpDemandOrderRelateDTO::getSrcDocCls));
            //循环docMap
            for (Map.Entry<String, List<ScpDemandOrderRelateDTO>> entry : docMap.entrySet()) {
                List<Long> ids = entry.getValue().stream().map(ScpDemandOrderRelateDTO::getSrcDocId).collect(Collectors.toList());
                if ("PO".equals(entry.getKey())) {
                    rmiPurRpcService.closePo(ids);
                } else {
                    rmiInvStkService.closeTro(ids);
                }
            }
        }
        //关闭订货单
        scpDemandOrderDomainService.closeDemandOrder(scpDemandOrderDTO.getId());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void autoPush(Long masId) {
        Optional<ScpDemandOrderDTO> demandOrderOpt = scpDemandOrderDomainService.findDemandOrderById(masId);
        if (demandOrderOpt.isEmpty()) {
            throw new BusinessException("订货单ID:" + masId + "不存在");
        }
        // 仓库类型需要自动推送
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.equals(demandOrderOpt.get().getType())) {
            push(masId);
        }
    }

    @Override
    @SysCodeProc
    public Map<String, List<ScpDemandOrderDRespVO>> findEnableAllocSetting(ScpAllocSettingParamVO paramVO) {
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(paramVO.getDocType(), paramVO.getType());
        if (orderSetting == null) {
            throw new BusinessException("请先配置或启用单据类型:" + paramVO.getDocType());
        }
        String storeCode = paramVO.getStoreCode();
        List<String> itemTypes = StrUtil.split(orderSetting.getItemCate(), ",");
        var allocSettingList = scpAllocSettingItemRepoProc.getAllocSettingItemByStoreCode(storeCode, paramVO.getDocType(), itemTypes);
        if (CollUtil.isEmpty(allocSettingList)) {
            return new HashMap<>();
        }
        // 查询门店信息
        var orgStore = getOrgStore(paramVO.getType(), storeCode);
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        List<String> itemCodes = allocSettingList.stream().map(ScpAllocSettingItemRespVO::getItemCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());

        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemCodes(itemCodes);
        List<ItmItemScpBaseRpcDTO> itmItemScpBaseList = rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        if (CollUtil.isEmpty(itmItemScpBaseList)) {
            log.info("findEnableAllocSetting 查询商品信息失败");
            return new HashMap<>();
        }
        Map<Long, ItmItemScpBaseRpcDTO> skuMap = itmItemScpBaseList.stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));
        List<ScpStoreCartDO> dataList = itmItemScpBaseList.stream().map(row -> {
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setItemCode(row.getItemCode());
            storeCartDO.setItemCateCode(row.getItemCateCode());
            storeCartDO.setUom(row.getUom());
            return storeCartDO;
        }).collect(Collectors.toList());

        //获取仓网供应关系
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = scpWhNetRelationService.findWhNetByParam(storeCode, paramVO.getType(), dataList);
        //获取供应商份额
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = scpSupplyAllocationService.findSupplyAllocationByParam(storeCode, paramVO.getType(), itemCodes);
        List<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<>();
        List<ScpDemandOrderDRespVO> confirmRespVOS = new ArrayList<>();
        //库存数量
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        for (ScpAllocSettingItemRespVO row : allocSettingList) {
            ScpDemandOrderItemBatchParamVO.Item item = new ScpDemandOrderItemBatchParamVO.Item();
            ItmItemScpBaseRpcDTO simpleRpcDTO = skuMap.get(row.getItemId());
            if (simpleRpcDTO == null) {
                continue;
            }
            item.setItemId(simpleRpcDTO.getId());
            item.setItemCode(simpleRpcDTO.getItemCode());
            item.setItemName(simpleRpcDTO.getItemName());
            item.setItemCateCode(simpleRpcDTO.getItemCateCode());
            item.setItemCateName(simpleRpcDTO.getItemCateName());
            item.setSpuId(simpleRpcDTO.getSpuId());
            item.setSpuItemCode(simpleRpcDTO.getSpuCode());
            item.setSpuItemName(simpleRpcDTO.getSpuName());
            item.setUom(simpleRpcDTO.getUom2());
            item.setUomName(simpleRpcDTO.getUom2Name());
            item.setDecimalPlaces(simpleRpcDTO.getDecimalPlaces());
            item.setUomRatio(simpleRpcDTO.getUomRatio2());
            item.setItemType(row.getItemType2());
            item.setDemandQuantity(row.getMinNum());
            item.setQty2(row.getMinNum().multiply(simpleRpcDTO.getUomRatio2()).setScale(simpleRpcDTO.getDecimalPlaces(), RoundingMode.HALF_UP));
            item.setUom2(simpleRpcDTO.getUom());
            item.setUom2Name(simpleRpcDTO.getUomName());
            item.setActivityCode(row.getActivityCode());
            item.setActivityId(row.getMasId());
            item.setItemType(row.getItemType2());
            var skuAttchmentList = simpleRpcDTO.getSkuAttchmentList();
            var spuAttchmentList = simpleRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty(skuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                item.setUrl(first.isEmpty() ? skuAttchmentList.get(0).getUrl() : first.get().getUrl());
            } else if (CollUtil.isNotEmpty(spuAttchmentList)) {
                Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                item.setUrl(first.isEmpty() ? spuAttchmentList.get(0).getUrl() : first.get().getUrl());
            }
            List<ScpDemandOrderDRespVO> inConfirmList = new ArrayList<>();
            for (String priority : priorities) {
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    inConfirmList.addAll(suppAllocStrategy(item, orgStore, orderSetting.getSuppFreightFlag(), supplyAllocationMap,
                            priceParamList, paramVO.getType(), stockMapRef));
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    inConfirmList.addAll(whnetStrategy(item, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList, paramVO.getType()));
                }
                if (!inConfirmList.isEmpty()) {
                    confirmRespVOS.addAll(inConfirmList);
                    break;
                }
            }
        }
        if (CollUtil.isEmpty(confirmRespVOS)) {
            return new HashMap<>();
        }
        InvWhItemTotalStkRpcParam stockParam = buildStockParam(confirmRespVOS);
        CompletableFuture<List<PriPriceRpcDTO>> future1 = CompletableFuture.supplyAsync(() -> {
            if (CollUtil.isEmpty(priceParamList)) {
                return new ArrayList<>();
            } else {
                return rmiPriceRpcService.findPriceByParam(priceParamList);
            }
        }, taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> getWhStockMap(stockParam, stockMapRef), taskExecutor);
        CompletableFuture.allOf(future1, future2).join();
        //构建价格行map
        List<PriPriceRpcDTO> priceList = new ArrayList<>();
        try {
            priceList = future1.get();
        } catch (Exception e) {
            log.info("查询价格报错：{}", e);
            throw new BusinessException("查询价格报错：" + e.toString());
        }
        //构建价格行map
        Map<String, List<PriPriceRpcDTO>> priceMap = buildPriceMap(priceList, priceParamList);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        //检查库存可供量
        var filterList = confirmRespVOS.stream().filter(item -> {
            // 库存可供量
            if (ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode().equals(item.getSupplyType())) {
                return true;
            }
            if (stockMap != null && stockMap.containsKey(item.getItemCode())) {
                BigDecimal avalQty = stockMap.get(item.getItemCode());
                return item.getDemandQuantity().compareTo(avalQty) <= 0;
            } else {
                return false;
            }
        }).collect(Collectors.toList());
        //封装返回
        var resultMap = filterList.stream().map(item -> {
            if (priceMap.containsKey(item.getItemCode() + "@" + item.getSaleOuCode())) {
                item.setPrice(priceMap.get(item.getItemCode() + "@" + item.getSaleOuCode()).get(0).getPrice());
            }
            item.setPlanQuantity(item.getDemandQuantity());
            if (item.getPrice() != null) {
                item.setPlanAmt(SysUtils.processAmtScale(item.getPrice().multiply(item.getPlanQuantity())));
            }
            return item;
        }).collect(Collectors.groupingBy(ScpDemandOrderDRespVO::getItemCode));

        log.info("批量获取商品明细行信息结果:{}", JSONUtil.toJsonStr(resultMap));
        return resultMap;
    }

    private InvWhItemTotalStkRpcParam buildStockParam(List<ScpDemandOrderDRespVO> confirmRespVOS) {
        if (CollUtil.isNotEmpty(confirmRespVOS)) {
            List<Long> itemIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(ScpDemandOrderDRespVO::getItemId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Long> whIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(ScpDemandOrderDRespVO::getSuppWhId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
                log.info("查询库存商品或者仓库为空，无需查询");
                return null;
            }
            InvWhItemTotalStkRpcParam invWhItemTotalStkRpcParam = new InvWhItemTotalStkRpcParam();
            invWhItemTotalStkRpcParam.setItemIds(itemIds);
            invWhItemTotalStkRpcParam.setWhIds(whIds);
            invWhItemTotalStkRpcParam.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
            return invWhItemTotalStkRpcParam;
        }
        return null;
    }

    private void getWhStockMap(InvWhItemTotalStkRpcParam stkRpcParam, AtomicReference<Map<String, BigDecimal>> stockMap) {
        if (stkRpcParam == null) {
            return;
        }
        List<InvWhItemTotalStkRpcDTO> invWhItemTotalStkRpcDTOS = rmiInvStkRpcService.queryInvWhItemTotalStk(stkRpcParam);
        if (CollUtil.isEmpty(invWhItemTotalStkRpcDTOS)) {
            return;
        }
        for (InvWhItemTotalStkRpcDTO dto : invWhItemTotalStkRpcDTOS) {
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(dto.getItemCode(), dto.getAvalQty2());
                return currentMap;
            });
        }
    }


    /**
     * 检查结算路径
     *
     * @param demandSetId
     * @return
     */
    private String checkTransactionPathAndPoPrice(Long demandSetId, List<Long> orderIds, ScpDemandSetDTO scpDemandSetDTO) {
        var demandOrderComputeVOS = scpDemandOrderDomainService.findComputeDemandOrderD(orderIds);
        if (CollUtil.isEmpty(demandOrderComputeVOS)) {
            return "订单集没有需要计算的订货单明细";
        }
        //非采购订货单明细,校验结算路径
        String checkMsg = checkTransactionPath(demandSetId, scpDemandSetDTO.getType(), demandOrderComputeVOS);
        if (StrUtil.isNotBlank(checkMsg)) {
            return checkMsg;
        }
        //采购订货单明细,校验采购价格
        var poDemandOrders =
                demandOrderComputeVOS.stream().filter(row -> StrUtil.isNotBlank(row.getOuCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(poDemandOrders)) {
            return checkMsg;
        }
        List<PurPriceParamRpcDTO> purPriceParamRpcDTOS = new ArrayList<>();
        for (ScpDemandOrderComputeVO row : poDemandOrders) {
            PurPriceParamRpcDTO purPriceParamRpcDTO = new PurPriceParamRpcDTO();
            purPriceParamRpcDTO.setUuid((long) Math.abs(UUID.randomUUID().hashCode()));
            purPriceParamRpcDTO.setItemId(row.getItemId());
            purPriceParamRpcDTO.setOuId(row.getOuId());
            purPriceParamRpcDTO.setSuppId(row.getSuppWhId());
            purPriceParamRpcDTO.setUom(row.getUnit());
            purPriceParamRpcDTO.setCurrCode(ScpConstant.CNY);
            purPriceParamRpcDTO.setDocTime(LocalDateTime.now());
            purPriceParamRpcDTO.setQty(row.getAllocationDeQuantity());
            purPriceParamRpcDTOS.add(purPriceParamRpcDTO);
        }
        return rmiPurRpcService.checkItemPurPrice(purPriceParamRpcDTOS);
    }

    public void delPatternKey(RedisTemplate<String, Object> redisTemplate, String pattern) {
        Set<String> keys = redisTemplate.keys(pattern);
        redisTemplate.delete(keys);
    }

    /**
     * 校验结算路径
     *
     * @param demandSetId           订货集ID
     * @param type                  订货集类型
     * @param demandOrderComputeVOS 订货单计算VO列表
     * @return 事务路径标志
     */
    private String checkTransactionPath(Long demandSetId, String type, List<ScpDemandOrderComputeVO> demandOrderComputeVOS) {

        //非采购订货单明细,查询供应仓库信息
        List<ScpDemandOrderComputeVO> noPoDemandOrders = demandOrderComputeVOS.stream().filter(Objects::nonNull)
                .filter(row -> StrUtil.isBlank(row.getOuCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(noPoDemandOrders)) {
            log.info("【订货集自动计算】订货集：{},非采购订货单明细查询为空", demandSetId);
            return "";
        }
        List<String> demandWhCodes =
                noPoDemandOrders.stream().map(ScpDemandOrderComputeVO::getDemandWhStCode).distinct().collect(Collectors.toList());
        // 获取供应仓库编码列表
        List<String> suppWhCodes =
                noPoDemandOrders.stream().map(ScpDemandOrderComputeVO::getSuppWhCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> suppWhMap = buildInvWhMap(suppWhCodes);
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(type)) {
            List<OrgStoreBaseRpcDTO> orgStoreList = rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandWhCodes);
            Map<String, OrgStoreBaseRpcDTO> storeMap = orgStoreList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity()));
            // 遍历非采购订货单明细列表
            List<SupportTransactionPathRpcParam> rpcParams = new ArrayList<>();
            for (ScpDemandOrderComputeVO row : noPoDemandOrders) {
                Long ouId = storeMap.get(row.getDemandWhStCode()).getOuId();
                Long whOuId = suppWhMap.get(row.getSuppWhCode()).getOuId();
                if (ouId.equals(whOuId)) {
                    continue;
                }
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
            // 去除相同属性的元素
            List<SupportTransactionPathRpcParam> disPathParams = rpcParams.stream().collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(SupportTransactionPathRpcParam::getCompanyIdStart)
                                    .thenComparing(SupportTransactionPathRpcParam::getCompanyIdEnd))), ArrayList::new));
            Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = checkTransactionPathAndBuild(disPathParams);
            for (ScpDemandOrderComputeVO row : noPoDemandOrders) {
                Long ouId = storeMap.get(row.getDemandWhStCode()).getOuId();
                String ouCode = storeMap.get(row.getDemandWhStCode()).getOuCode();
                Long whOuId = suppWhMap.get(row.getSuppWhCode()).getOuId();
                String whOuCode = suppWhMap.get(row.getSuppWhCode()).getOuCode();
                if (ouId.equals(whOuId)) {
                    continue;
                }
                List<SupportTransactionPathRpcDTO> pathList = suppTransactionPathMap.get(whOuId + "@" + ouId);
                if (CollUtil.isEmpty(pathList) || StrUtil.isBlank(pathList.get(0).getPathCode())) {
                    log.info("从公司 {}到公司 {}的结算路径不存在，请维护", whOuId, ouId);
                    return "从公司:" + whOuCode + "到公司:" + ouCode + "的结算路径不存在，请维护";
                }
            }

        } else {
            Map<String, InvWhRpcSimpleDTO> whMap = buildInvWhMap(demandWhCodes);
            // 遍历非采购订货单明细列表
            List<SupportTransactionPathRpcParam> rpcParams = new ArrayList<>();
            for (ScpDemandOrderComputeVO row : noPoDemandOrders) {
                Long ouId = whMap.get(row.getDemandWhStCode()).getOuId();
                Long whOuId = suppWhMap.get(row.getSuppWhCode()).getOuId();
                if (ouId.equals(whOuId)) {
                    continue;
                }
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
            // 去除相同属性的元素
            List<SupportTransactionPathRpcParam> disPathParams = rpcParams.stream().collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(SupportTransactionPathRpcParam::getCompanyIdStart)
                                    .thenComparing(SupportTransactionPathRpcParam::getCompanyIdEnd))), ArrayList::new));
            Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = checkTransactionPathAndBuild(disPathParams);
            for (ScpDemandOrderComputeVO row : noPoDemandOrders) {
                Long ouId = whMap.get(row.getDemandWhStCode()).getOuId();
                String ouCode = whMap.get(row.getDemandWhStCode()).getOuCode();
                Long whOuId = suppWhMap.get(row.getSuppWhCode()).getOuId();
                String whOuCode = suppWhMap.get(row.getSuppWhCode()).getOuCode();
                if (ouId.equals(whOuId)) {
                    continue;
                }
                List<SupportTransactionPathRpcDTO> pathList = suppTransactionPathMap.get(whOuId + "@" + ouId);
                if (CollUtil.isEmpty(pathList) || StrUtil.isBlank(pathList.get(0).getPathCode())) {
                    log.info("从公司 {}到公司 {}的结算路径不存在，请维护", whOuId, ouId);
                    return "从公司:" + whOuCode + "到公司:" + ouCode + "的结算路径不存在，请维护";
                }
            }
        }
        return "";
    }

    /**
     * 构建需求仓库信息
     *
     * @param demandWhCodes
     * @return
     */
    private Map<String, InvWhRpcSimpleDTO> buildInvWhMap(List<String> demandWhCodes) {
        if (CollUtil.isEmpty(demandWhCodes)) {
            return new HashMap<>();
        }
        return rmiInvStkService.findInvWhBaseMapByCode(demandWhCodes);
    }

    //采购单单号，行号回写
    private void processPoInfoCallback(List<PurPoSaveDTO> result) {
        log.info("更新采购单信息：{}", JSONUtil.toJsonStr(result));
        for (PurPoSaveDTO dto : result) {
            String docNo = dto.getDocNo();
            for (PurPoDSaveDTO poDSaveDTO : dto.getPurPoDCreateParamVOList()) {
                scpDemandOrderDDomainService.updatePOSrcInfo(poDSaveDTO.getRelateDocDid(), dto.getId(), docNo,
                        String.valueOf(poDSaveDTO.getLineNo()));
            }
        }
    }


    @Override
    public List<AppDemandOrderCountRespVO> countStatus(ScpDemandOrderAppCountParamVO countParamVO) {
        if (StrUtil.isBlank(countParamVO.getDemandWhStCode())) {
            throw new BusinessException("需求门店编码不能为空");
        }
        List<AppDemandOrderCountRespVO> result = CollUtil.newCopyOnWriteArrayList(new ArrayList<>());
        //获取系统配置，开启订货单设置
        String orderSetting = SysUtils.getOrderSetting();
        if ("1".equals(orderSetting)) {

            CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
                ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
                BeanUtils.copyProperties(countParamVO, paramVO);

                //已收货"PART_RECV", "RECV"
                List<String> statusList = List.of(ScpUdcEnum.DEO_STATUS_PART_RECV.getValueCode(), ScpUdcEnum.DEO_STATUS_RECV.getValueCode());
                paramVO.setDocStatusList(statusList);
                Long recvCount = scpDemandOrderDomainService.countAppOrderByParam(paramVO);

                //待发货"PUSHED", "PUSHING"
                List<String> shipStatusList = List.of(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode(), ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode());
                paramVO.setDocStatusList(shipStatusList);
                Long shipCount = scpDemandOrderDomainService.countAppOrderByParam(paramVO);

                //待推送
                List<String> unPushList = List.of(ScpUdcEnum.DEO_STATUS_DONE.getValueCode(), ScpUdcEnum.DEO_STATUS_DOING.getValueCode());
                paramVO.setDocStatusList(unPushList);
                Long unPushCount = scpDemandOrderDomainService.countAppOrderByParam(paramVO);

                //已发货"PART_SHIP", "SHIP"
                List<String> partShipStatusList = List.of(ScpUdcEnum.DEO_STATUS_PART_SHIP.getValueCode(), ScpUdcEnum.DEO_STATUS_SHIP.getValueCode());
                paramVO.setDocStatusList(partShipStatusList);
                Long shipedCount = scpDemandOrderDomainService.countAppOrderByParam(paramVO);

                result.add(new AppDemandOrderCountRespVO().setDocStatus("RECV").setCount(recvCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("SHIP").setCount(shipCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("PUSH").setCount(unPushCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("SHIPED").setCount(shipedCount));
            }, taskExecutor);

            CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
                ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
                BeanUtils.copyProperties(countParamVO, paramVO);
                //全部
                paramVO.setDocStatusList(null);
                Long allCount = scpDemandOrderDomainService.countAppOrderByParam(paramVO);

                //待评价
                List<String> replyStatusList = List.of(ScpUdcEnum.DEO_STATUS_RECV.getValueCode());
                paramVO.setDocStatusList(replyStatusList);
                paramVO.setReplyFlag(Boolean.FALSE);
                Long replyCount = scpDemandOrderDomainService.countAppOrderByParam(paramVO);

                //待支付WAIT_PAY
                List<String> payStatusList = List.of(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode(), ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
                paramVO.setDocStatusList(null);
                paramVO.setReplyFlag(null);
                paramVO.setPayStatusList(payStatusList);
                Long payCount = scpDemandOrderDomainService.countAppPayOrderByParam(paramVO);

                result.add(new AppDemandOrderCountRespVO().setDocStatus("REPLY").setCount(replyCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("ALL").setCount(allCount));
                result.add(new AppDemandOrderCountRespVO().setDocStatus("PAY").setCount(payCount));
            }, taskExecutor);

            CompletableFuture.allOf(future1, future2).join();

            return result;
        }
        ScpDemandOrderPageParamVO paramVO = new ScpDemandOrderPageParamVO();
        BeanUtils.copyProperties(countParamVO, paramVO);
        return scpDemandOrderDomainService.countStatus(paramVO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpDemandOrderDomainService.deleteByIds(ids);
    }

    @Override
    public void push(Long id, Long agentEmpId, Boolean appFlag) {
        TimeInterval timer = new TimeInterval();
        log.info("【订货单推送其他业务域】订货单ID：{},开始推送", id);
        Object poObj = redisTemplate.opsForValue().get("PO" + id.toString());
        Object soObj = redisTemplate.opsForValue().get("SO" + id.toString());
        Object trnObj = redisTemplate.opsForValue().get("TRN" + id.toString());
        if (poObj != null || soObj != null || trnObj != null) {
            throw new BusinessException("订货单正在推送中,请稍后重试");
        }
        Optional<ScpDemandOrderDTO> demandOrderOpt = scpDemandOrderDomainService.findDemandOrderById(id);
        if (demandOrderOpt.isEmpty()) {
            throw new BusinessException("订货单ID:" + id + "不存在");
        }
        ScpDemandOrderDTO demandOrderDTO = demandOrderOpt.get();
        List<String> docStatusList = List.of(ScpUdcEnum.DEO_STATUS_DONE.getValueCode(), ScpUdcEnum.DEO_STATUS_PUSHING.getValueCode());
        if (!docStatusList.contains(demandOrderDTO.getDocStatus())) {
            throw new BusinessException("【全部分配】和【部分推送】的单据才能推送");
        }

        Long empId = getAgentEmpId(agentEmpId);

        ScpOrderSettingRespVO setting = scpOrderSettingDomainService.findCacheByDocType(demandOrderDTO.getDocType(), demandOrderDTO.getType());
        Map<String, List<OrgStoreWhDTO>> orgStoreMap = getOrgStoreMap(demandOrderDTO);
        //仓库类型数据收集
        Map<Long, InvWhRpcSimpleDTO> whMap = getWhMap(demandOrderDTO);
        List<ScpDemandOrderDDTO> demandOrderDList = scpDemandOrderDDomainService.findDemandOrderDByMasId(demandOrderDTO.getId());
        try {
            //调拨单入参
            var storeOrderTrnRpcDTOS = prepareDataTrnPush(demandOrderDTO, orgStoreMap, whMap, empId, demandOrderDList, setting);

            //采购单入参
            var purPoSaveDTOS = prepareDataPoPush(demandOrderDTO, orgStoreMap, empId, demandOrderDList, setting);

            //销售单入参
            var salSoSaveDTOS = prepareDataSoPush(demandOrderDTO, orgStoreMap, demandOrderDList);

            if (Boolean.TRUE.equals(appFlag)) {
                if (CollUtil.isNotEmpty(storeOrderTrnRpcDTOS)) {
                    //推送调拨订单
                    this.pushTrn(storeOrderTrnRpcDTOS);
                }
                if (CollUtil.isNotEmpty(purPoSaveDTOS)) {
                    //推送采购订单
                    this.pushPo(purPoSaveDTOS);
                }
                if (CollUtil.isNotEmpty(salSoSaveDTOS)) {
                    //推送销售订单
                    this.pushSo(salSoSaveDTOS);
                }
            } else {
                //推送消息队列
                if (CollUtil.isNotEmpty(storeOrderTrnRpcDTOS)) {
                    //写入mq队列
                    ScpTrnOrderCreateMqParam orderCreateMqParam = new ScpTrnOrderCreateMqParam();
                    orderCreateMqParam.setTrnList(storeOrderTrnRpcDTOS);
                    orderCreateMqParam.setBusinessKey(ScpTrnOrderCreateMqParam.CREATE_CHANNEL);
                    messageQueueTemplate.publishMessageSync("yst-suplan", ScpTrnOrderCreateMqParam.CREATE_CHANNEL, orderCreateMqParam);
                }
                if (CollUtil.isNotEmpty(purPoSaveDTOS)) {
                    //写入mq队列
                    ScpPoOrderCreateMqParam poCreateMqParam = new ScpPoOrderCreateMqParam();
                    poCreateMqParam.setPoList(purPoSaveDTOS);
                    poCreateMqParam.setBusinessKey(ScpPoOrderCreateMqParam.CREATE_CHANNEL);
                    messageQueueTemplate.publishMessageSync("yst-suplan", ScpPoOrderCreateMqParam.CREATE_CHANNEL, poCreateMqParam);
                }

                if (CollUtil.isNotEmpty(salSoSaveDTOS)) {
                    //写入mq队列
                    ScpSaleOrderCreateMqParam saleCreateMqParam = new ScpSaleOrderCreateMqParam();
                    saleCreateMqParam.setSaleList(salSoSaveDTOS);
                    saleCreateMqParam.setBusinessKey(ScpSaleOrderCreateMqParam.CREATE_CHANNEL);
                    messageQueueTemplate.publishMessageSync("yst-suplan", ScpSaleOrderCreateMqParam.CREATE_CHANNEL, saleCreateMqParam);
                }
            }
        } catch (Exception e) {
            log.info("订货单：{},发送mq消息失败：{}", demandOrderDTO.getDocCode(), e.toString());
            redisTemplate.delete("TRN" + id.toString());
            redisTemplate.delete("PO" + id.toString());
            redisTemplate.delete("SO" + id.toString());
        }
        log.info("【订货单推送其他业务域】订货单推送结束，耗时:" + timer.intervalRestart() + "ms");
    }

    private Long getAgentEmpId(Long agentEmpId) {
        if (agentEmpId == null) {
            //获取当前操作人id和name
            CurrentUserDTO currentUserDTO = UserService.currentUser();
            log.info("当前登录用户信息:{}", JSONUtil.toJsonStr(currentUserDTO));
            if (ObjectUtils.isEmpty(currentUserDTO) || currentUserDTO.getDetail() == null) {
                throw new BusinessException("查询当前登录用户失败");
            }
            return currentUserDTO.getDetail().getEmployeeId();
        } else {
            return agentEmpId;
        }
    }


    @Override
    public List<SalSoSaveDTO> prepareDataSoPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> orgStoreMap, List<ScpDemandOrderDDTO> demandOrderDList) {
        if (!(ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(demandOrderDTO.getType()) && ScpUdcEnum.STORE_TYPE2_JOIN.getValueCode().equals(demandOrderDTO.getStoreType2()))) {
            log.info("【订货集推送销售订单】订货单编码：{}，没有需方方是门店类型并且门店性质是加盟店的订单", demandOrderDTO.getDocCode());
            return new ArrayList<>();
        }
        //需方方是门店类型，且门店性质是加盟店，且门店主数据下无真实仓库对应，需生成销售订单
        List<OrgStoreWhDTO> noWhStoreList = orgStoreMap.get(demandOrderDTO.getDemandWhStCode());
        if (CollUtil.isNotEmpty(noWhStoreList)) {
            log.info("【订货集推送销售订单】订货单编码：{}，门店性质是加盟店的订单，且门店主数据下有真实仓库对应", demandOrderDTO.getDocCode());
            List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, "门店编码:" + demandOrderDTO.getDemandWhStCode() + "未配置真实仓库");
            return new ArrayList<>();
        }

        List<SalSoSaveDTO> salSoSaveDTOS = CollUtil.newCopyOnWriteArrayList(new ArrayList<>());
        List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS = rmiOrgStoreRpcService.queryByStoreCodes(List.of(demandOrderDTO.getDemandWhStCode()));
        OrgStoreDetailRpcDTO storeInfo = orgStoreDetailRpcDTOS.get(0);
        String custCode = storeInfo.getCustCode();
        String storeCode = storeInfo.getStoreCode();
        if (StrUtil.isBlank(custCode)) {
            log.info("订单编码：{},门店编码：{},未配置客户信息", demandOrderDTO.getDocCode(), custCode);
            List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, "门店编码:" + storeCode + "未配置客户信息");
            return new ArrayList<>();
        }
        List<CustBaseAndBelongOuDTO> custBaseAndBelongOuList = rmiSalRpcService.findCustBaseAndBelongOuByParam(List.of(custCode));

        CustBaseAndBelongOuDTO crmCustDTO = custBaseAndBelongOuList.get(0);
        List<CustBelongOuDTO> custBelongOuDTOS = crmCustDTO.getBelongOuDTOS();
        if (CollUtil.isEmpty(custBelongOuDTOS)) {
            log.info("订单编码：{},门店编码：{},客户编码:{},未配置归属公司信息", demandOrderDTO.getDocCode(), storeCode,
                    custCode);
            List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, "门店编码:" + storeCode + "客户编码:" + custCode + "未配置归属公司信息");
            return new ArrayList<>();
        }
        Optional<CustBelongOuDTO> first =
                custBelongOuDTOS.stream().filter(row -> row.getIsFranchisee() != null && row.getIsFranchisee() && "0".equals(row.getStatus())).findFirst();
        if (first.isEmpty()) {
            log.info("订单编码：{},门店编码：{},客户编码:{},未配置加盟商归属公司信息", demandOrderDTO.getDocCode(),
                    storeCode, custCode);
            List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, "门店编码:" + storeCode + "客户编码:" + custCode + "未配置加盟商归属公司信息");
            return new ArrayList<>();
        }
        CustBelongOuDTO custBelongOuDTO = first.get();
        demandOrderDList.stream().filter(row -> !row.getIsPushed() && row.getIsCalculated() && ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())
                && (row.getPlanQuantity() != null && row.getPlanQuantity().compareTo(BigDecimal.ZERO) > 0)).collect(Collectors.toList());
        if (demandOrderDList.isEmpty()) {
            log.info("订单编码：{},门店编码：{},没有满足转销售订单条件的订货单明细", demandOrderDTO.getDocCode(), storeCode);
            List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, "没有满足转销售订单条件的订货单明细");
            return new ArrayList<>();
        }

        Map<Long, List<ScpDemandOrderDDTO>> orderDMap =
                demandOrderDList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getSuppWhId));
        //查询商品信息
        val itemCodes =
                demandOrderDList.stream().map(ScpDemandOrderDDTO::getItemCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        ItmItemBusinessRpcDtoParam itmItemBusinessRpcDtoParam = new ItmItemBusinessRpcDtoParam();
        itmItemBusinessRpcDtoParam.setItemCodes(itemCodes);
        itmItemBusinessRpcDtoParam.setBuCodes(Lists.newArrayList(custBelongOuDTO.getOuCode()));
        List<ItmItemBusinessRpcDTO> itemBusinessRpcDTOS =
                rmiItemService.selectItmItemBusinessByParam(itmItemBusinessRpcDtoParam);
        Map<String, ItmItemBusinessRpcDTO> itemMap =
                itemBusinessRpcDTOS.stream().collect(Collectors.toMap(ItmItemBusinessRpcDTO::getItemCode,
                        Function.identity()));

        //4，查询价格信息
        Map<String, List<PriPriceRpcDTO>> groupedBasePriceList = new HashMap<>();
        Map<String, List<PriPriceRpcDTO>> groupedPriceList = new HashMap<>();
        handleSalePrice(groupedBasePriceList, groupedPriceList, itemBusinessRpcDTOS, crmCustDTO,
                custBelongOuDTO.getOuCode());

        for (Map.Entry<Long, List<ScpDemandOrderDDTO>> entry : orderDMap.entrySet()) {
            List<ScpDemandOrderDDTO> demandOrderDDTOList = entry.getValue();
            List<SalSoDSaveDTO> salSoDSaveDTOList = new ArrayList<>();
            AtomicReference<String> errorLog = new AtomicReference<>();
            for (ScpDemandOrderDDTO demandOrderDDTO : demandOrderDDTOList) {
                // 构建销售订单明细入参
                SalSoDSaveDTO salSoDSaveDTO = createSalSoDSaveDTO(demandOrderDDTO, demandOrderDTO.getDocCode(),
                        itemMap.get(demandOrderDDTO.getItemCode()), groupedBasePriceList, groupedPriceList, errorLog, custBelongOuDTO);
                if (StrUtil.isNotBlank(errorLog.get())) {
                    break;
                }
                salSoDSaveDTOList.add(salSoDSaveDTO);
            }
            if (StrUtil.isNotBlank(errorLog.get())) {
                List<Long> dIdList = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, StringUtils.substring(errorLog.get(), 0,
                        200));
                break;
            }
            // 构建销售订单入参
            SalSoSaveDTO salSoSaveDTO = createSalSoSaveDTO(custBelongOuDTO, crmCustDTO, demandOrderDTO, storeInfo);
            salSoSaveDTO.setSalSoDSaveVOList(salSoDSaveDTOList);
            // 含税总价
            var amt = sumBigDecimal(salSoSaveDTO, SalSoDSaveDTO::getAmt);
            salSoSaveDTO.setAmt(amt);
            // 未税总额
            var netAmt = sumBigDecimal(salSoSaveDTO, SalSoDSaveDTO::getNetAmt);
            salSoSaveDTO.setNetAmt(netAmt);
            // 税额
            var taxAmt = sumBigDecimal(salSoSaveDTO, SalSoDSaveDTO::getTaxAmt);
            salSoSaveDTO.setTaxAmt(taxAmt);
            //销售单表头仓库信息赋值
            var scpDemandOrderDDTO = demandOrderDDTOList.get(0);
            salSoSaveDTO.setWhId(scpDemandOrderDDTO.getSuppWhId());
            salSoSaveDTO.setWhCode(scpDemandOrderDDTO.getSuppWhCode());
            salSoSaveDTO.setWhName(scpDemandOrderDDTO.getSuppWhName());
            salSoSaveDTOS.add(salSoSaveDTO);
        }
        String redisKey = "SO" + demandOrderDTO.getId().toString();
        redisTemplate.opsForValue().set(redisKey, "20", 2, TimeUnit.HOURS);
        return salSoSaveDTOS;
    }

    private Map<Long, InvWhRpcSimpleDTO> getWhMap(ScpDemandOrderDTO demandOrderDTO) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(demandOrderDTO.getType()) && demandOrderDTO.getDemandWhStId() != null) {
            Map<Long, InvWhRpcSimpleDTO> invWhBaseMap = rmiInvStkService.findInvWhBaseMap(List.of(demandOrderDTO.getDemandWhStId()));

            log.info("仓库类型数据whIdMap:{}", JSONUtil.toJsonStr(invWhBaseMap));
            return invWhBaseMap;
        }
        return new HashMap<>();
    }

    @Override
    public Map<Long, InvWhRpcSimpleDTO> getWhMap(List<ScpDemandOrderDTO> demandOrderDTOS) {
        //仓库类型数据收集
        List<Long> whIds =
                demandOrderDTOS.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType()) && row.getDemandWhStId() != null).map(ScpDemandOrderDTO::getDemandWhStId).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(whIds)) {
            return rmiInvStkService.findInvWhBaseMap(whIds);
        }
        return new HashMap<>();
    }

    private Map<String, List<OrgStoreWhDTO>> getOrgStoreMap(ScpDemandOrderDTO demandOrderDTO) {
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(demandOrderDTO.getType()) && StrUtil.isNotBlank(demandOrderDTO.getDemandCode())) {
            //门店类型数据收集
            List<OrgStoreWhDTO> orgStoreWhDTOS = rmiOrgStoreRpcService.listWhByCode(List.of(demandOrderDTO.getDemandWhStCode()));
            if (CollUtil.isEmpty(orgStoreWhDTOS)) {
                log.info("【订货集推送调拨单】订货单编码：{},门店编码：{}不存在", demandOrderDTO.getDocCode(), demandOrderDTO.getDemandWhStCode());
                return new HashMap<>();
            }
            List<OrgStoreWhDTO> haveWhStoreList =
                    orgStoreWhDTOS.stream().filter(whDto -> whDto.getWhType() != null && 1 == whDto.getWhType()).collect(Collectors.toList());
            if (CollUtil.isEmpty(haveWhStoreList)) {
                log.info("【订货集推送调拨单】订货单ID：{}，门店主数据下没有真实仓库对应", demandOrderDTO.getId());
                return new HashMap<>();
            }
            var haveWhStoreMap =
                    haveWhStoreList.stream().collect(Collectors.groupingBy(OrgStoreWhDTO::getStoreCode));
            log.info("真实仓库数据字典haveWhStoreMap:{}", JSONUtil.toJsonStr(haveWhStoreMap));
            return haveWhStoreMap;
        }
        return new HashMap<>();
    }

    @Override
    public Map<String, List<OrgStoreWhDTO>> getOrgStoreMap(List<ScpDemandOrderDTO> demandOrderDTOS) {
        //门店类型数据收集
        List<String> storeCodes =
                demandOrderDTOS.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) && StrUtil.isNotBlank(row.getDemandCode())).map(ScpDemandOrderDTO::getDemandWhStCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        List<OrgStoreWhDTO> orgStoreWhDTOS = rmiOrgStoreRpcService.listWhByCode(storeCodes);
        List<OrgStoreWhDTO> haveWhStoreList =
                orgStoreWhDTOS.stream().filter(whDto -> whDto.getWhType() != null && 1 == whDto.getWhType()).collect(Collectors.toList());
        if (CollUtil.isEmpty(haveWhStoreList)) {
            log.info("【订货集推送调拨单】订货单没有门店主数据下有真实仓库对应");
            return new HashMap<>();
        }
        Map<String, List<OrgStoreWhDTO>> haveWhStoreMap =
                haveWhStoreList.stream().collect(Collectors.groupingBy(OrgStoreWhDTO::getStoreCode));
        log.info("真实仓库数据字典haveWhStoreMap:{}", JSONUtil.toJsonStr(haveWhStoreMap));
        return haveWhStoreMap;
    }


    /**
     * 构建销售订单保存参数
     *
     * @param custBelongOuDTO
     * @param crmCustDTO
     * @param demandOrderDTO
     * @param storeInfo
     * @return
     */
    private SalSoSaveDTO createSalSoSaveDTO(CustBelongOuDTO custBelongOuDTO, CustBaseAndBelongOuDTO crmCustDTO,
                                            ScpDemandOrderDTO demandOrderDTO, OrgStoreDetailRpcDTO storeInfo) {
        SalSoSaveDTO salSoSaveDTO = new SalSoSaveDTO();
        salSoSaveDTO.setDocType(ScpConstant.BTB);
        //销售订单状态=已确认
        salSoSaveDTO.setDocStatus("CF");
        salSoSaveDTO.setSoScene(ScpConstant.SO);
        salSoSaveDTO.setSoSource(ScpConstant.POS);
        salSoSaveDTO.setOuId(custBelongOuDTO.getOuId());
        salSoSaveDTO.setOuCode(custBelongOuDTO.getOuCode());
        salSoSaveDTO.setOuName(custBelongOuDTO.getOuName());
        salSoSaveDTO.setBuId(custBelongOuDTO.getBuId());
        salSoSaveDTO.setBuCode(custBelongOuDTO.getBuCode());
        salSoSaveDTO.setBuName(custBelongOuDTO.getBuName());
        salSoSaveDTO.setCustId(crmCustDTO.getId());
        salSoSaveDTO.setCustCode(crmCustDTO.getCustCode());
        salSoSaveDTO.setCustName(crmCustDTO.getCustName());
        salSoSaveDTO.setDocTime(LocalDateTimeUtil.format(demandOrderDTO.getDemandDate(),
                DateTimeUtil.FORMATTER_DATETIME));
        salSoSaveDTO.setDemandDate(LocalDateTimeUtil.format(demandOrderDTO.getDemandDate(),
                DateTimeUtil.FORMATTER_DATETIME));
        salSoSaveDTO.setCustContactName(storeInfo.getStoreManager());
        salSoSaveDTO.setCustContactTel(storeInfo.getStoreContPhone());
        salSoSaveDTO.setRecvContactName(storeInfo.getStoreManager());
        salSoSaveDTO.setRecvContactTel(storeInfo.getStoreContPhone());
        OrgAddrAddressRpcDTO addressRpcDTO = storeInfo.getAddressRpcDTO();
        if (addressRpcDTO != null) {
            salSoSaveDTO.setRecvCity(addressRpcDTO.getCity());
            salSoSaveDTO.setRecvCountry(addressRpcDTO.getCountry());
            salSoSaveDTO.setRecvCounty(addressRpcDTO.getCounty());
            salSoSaveDTO.setRecvProvince(addressRpcDTO.getProvince());
            salSoSaveDTO.setRecvDetailaddr(addressRpcDTO.getDetailAddr());
        }
        salSoSaveDTO.setRemark(demandOrderDTO.getDocCode());
        salSoSaveDTO.setCurrCode(ScpConstant.CNY);
        salSoSaveDTO.setCurrName(ScpConstant.CNY_NAME);
        salSoSaveDTO.setPaymentTerm(crmCustDTO.getPaymentTerm());
        salSoSaveDTO.setHomeCurr(ScpConstant.CNY);
        salSoSaveDTO.setAgentEmpId(crmCustDTO.getAgentEmpId());
        salSoSaveDTO.setPreCustCode(crmCustDTO.getPreCustCode());
        salSoSaveDTO.setPreCustName(crmCustDTO.getPreCustName());
        salSoSaveDTO.setCustChannel(crmCustDTO.getSaleChannel());
        return salSoSaveDTO;
    }

    /**
     * 构建销售订单明细
     *
     * @param demandOrderDDTO
     * @param demandOrderCode
     * @param itmItemBusinessRpcDTO
     * @return
     */
    private SalSoDSaveDTO createSalSoDSaveDTO(ScpDemandOrderDDTO demandOrderDDTO, String demandOrderCode,
                                              ItmItemBusinessRpcDTO itmItemBusinessRpcDTO,
                                              Map<String, List<PriPriceRpcDTO>> groupedBasePriceList,
                                              Map<String, List<PriPriceRpcDTO>> groupedPriceList,
                                              AtomicReference<String> errorLog, CustBelongOuDTO custBelongOuDTO) {
        SalSoDSaveDTO salSoDSaveDTO = new SalSoDSaveDTO();
        salSoDSaveDTO.setItemId(demandOrderDDTO.getItemId());
        salSoDSaveDTO.setItemCode(demandOrderDDTO.getItemCode());
        salSoDSaveDTO.setItemBrand(itmItemBusinessRpcDTO.getBrand());
        salSoDSaveDTO.setItemName(demandOrderDDTO.getItemName());
        salSoDSaveDTO.setQty(SysUtils.processQtyScale(demandOrderDDTO.getQty2()));
        salSoDSaveDTO.setWhId(demandOrderDDTO.getSuppWhId());
        salSoDSaveDTO.setWhCode(demandOrderDDTO.getSuppWhCode());
        salSoDSaveDTO.setWhName(demandOrderDDTO.getSuppWhName());
        salSoDSaveDTO.setUom(demandOrderDDTO.getUom2());
        salSoDSaveDTO.setPrice(demandOrderDDTO.getPrice());
        List<PriPriceRpcDTO> basePriceDTOS = groupedBasePriceList.get(demandOrderDDTO.getItemCode());
        if (CollUtil.isEmpty(basePriceDTOS)) {
            errorLog.set("商品编码：" + demandOrderDDTO.getItemCode() + "公司编码：" + custBelongOuDTO.getOuCode() + "客户编码:" + custBelongOuDTO.getCustCode() + "没有配置基准价格");
            return salSoDSaveDTO;
        }
        salSoDSaveDTO.setBasePrice(basePriceDTOS.get(0).getPrice());
        List<PriPriceRpcDTO> priceRpcDTOS = groupedPriceList.get(demandOrderDDTO.getItemCode());
        if (CollUtil.isEmpty(priceRpcDTOS)) {
            errorLog.set("商品编码：" + demandOrderDDTO.getItemCode() + "公司编码：" + custBelongOuDTO.getOuCode() + "客户编码:" + custBelongOuDTO.getCustCode() + "没有配置销售价格");
            return salSoDSaveDTO;
        }
        salSoDSaveDTO.setSalePrice(priceRpcDTOS.get(0).getPrice());
        salSoDSaveDTO.setRefPrice(demandOrderDDTO.getPrice());
        salSoDSaveDTO.setTaxRateNo(itmItemBusinessRpcDTO.getTaxCode());
        salSoDSaveDTO.setRootDocId(demandOrderDDTO.getMasId());
        salSoDSaveDTO.setRootDocNo(demandOrderCode);
        salSoDSaveDTO.setRootDocCls(ScpConstant.BTB);
        salSoDSaveDTO.setRootDocDId(demandOrderDDTO.getId());
        salSoDSaveDTO.setRootDocLineno(demandOrderDDTO.getLineNo().longValue());
        salSoDSaveDTO.setTaxRate(itmItemBusinessRpcDTO.getTaxRate2());
        var netPrice = salSoDSaveDTO.getPrice().divide(salSoDSaveDTO.getTaxRate().add(BigDecimal.ONE), SysUtils.getPricePlace(), RoundingMode.HALF_UP);
        salSoDSaveDTO.setNetPrice(netPrice);
        var netAmt = SysUtils.processQtyScale(netPrice.multiply(salSoDSaveDTO.getQty()));
        salSoDSaveDTO.setNetAmt(netAmt);
        var amt = SysUtils.processAmtScale(salSoDSaveDTO.getPrice().multiply(salSoDSaveDTO.getQty()));
        salSoDSaveDTO.setAmt(amt);
        salSoDSaveDTO.setTaxAmt(amt.subtract(netAmt));
        salSoDSaveDTO.setSuppFlag("0");
        salSoDSaveDTO.setQty2(demandOrderDDTO.getPlanQuantity());
        salSoDSaveDTO.setUom2(demandOrderDDTO.getUnit());
        return salSoDSaveDTO;
    }

    private void handleSalePrice(Map<String, List<PriPriceRpcDTO>> groupedBasePriceList, Map<String,
            List<PriPriceRpcDTO>> groupedPriceList,
                                 List<ItmItemBusinessRpcDTO> itemList, CustBaseAndBelongOuDTO custInfo, String ouCode) {
        List<ItmPriPriceRpcDtoParam> priceParams = itemList.stream().map(item -> {
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls(ScpConstant.SALE_PRICE_CLS);
            priceParam.setItemId(item.getId());
            priceParam.setCustCode(custInfo.getCustCode());
            priceParam.setItemCode(item.getItemCode());
            priceParam.setUom(item.getUom());
            priceParam.setCurrCode(ScpConstant.CNY);
            priceParam.setOuCode(ouCode);
            if (StrUtil.isNotBlank(custInfo.getSaleChannel())) {
                priceParam.setSaleChannel(custInfo.getSaleChannel());
            }
            return priceParam;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> priceList = rmiPriceRpcService.findPriceByParam(priceParams);

        //基准价格
        List<ItmPriPriceRpcDtoParam> basePriceParams = new ArrayList<>();
        for (ItmPriPriceRpcDtoParam e : priceParams) {
            e.setPriceType(ScpConstant.RETAIL_PRICE);
            e.setPriceCls("");
            basePriceParams.add(e);
        }
        List<PriPriceRpcDTO> basePriceList = rmiPriceRpcService.findPriceByParam(basePriceParams);

        groupedBasePriceList.putAll(basePriceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode)));
        groupedPriceList.putAll(priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode)));
    }

    /**
     * 计算并更新分配
     *
     * @param unique                 唯一标识
     * @param computeDemandOrderList 计算需求订单列表
     * @param sumAvalQty             库存可用数量
     * @param allocComputeConfig     分配计算配置
     */
    private void computeAndUpdateAllocation(String unique, List<ScpDemandOrderComputeVO> computeDemandOrderList, BigDecimal sumAvalQty,
                                            String allocComputeConfig) {

        /// 应用分配策略
        eventContext.consumeEventInvStk(computeDemandOrderList, sumAvalQty, allocComputeConfig);

        // 更新分配数量
        updateAllocationQuantity(unique, computeDemandOrderList, sumAvalQty);
    }

    /**
     * 更新分配数量
     *
     * @param computeDemandOrderList 计算需求订单列表
     */
    private void updateAllocationQuantity(String unique, List<ScpDemandOrderComputeVO> computeDemandOrderList, BigDecimal sumAvalQty) {
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionTemplate.execute(trans -> {
            try {
                //更新分配数量
                computeDemandOrderList.forEach(row -> {
                    log.info("【订货单自动分配】订货订单编码：{},商品编码：{},库存编码：{},分配数量：{}", row.getDocCode(), row.getItemCode(),
                            row.getSuppWhCode(), row.getPlanQuantity());
                    scpDemandOrderDDomainService.updatePlanQtyAndAmtById(row.getId(), row.getPlanQuantity());
                });
                BigDecimal sumPlanQty = computeDemandOrderList.stream().collect(Collectors.reducing(BigDecimal.ZERO, ScpDemandOrderComputeVO::getPlanQuantity, BigDecimal::add));

                redisTemplate.opsForValue().set(unique, (sumAvalQty.subtract(sumPlanQty)).toString(), 300, TimeUnit.SECONDS);
                return "OK";
            } catch (Exception e) {
                trans.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, e.getMessage());
            }
        });
    }

    /**
     * 获取结算路径信息
     *
     * @param rpcParams
     * @return
     */
    private Map<String, List<SupportTransactionPathRpcDTO>> checkTransactionPathAndBuild(List<SupportTransactionPathRpcParam> rpcParams) {
        //查询结算路径
        log.info("查询启用状态的结算路径,参数:{}", JSONObject.toJSONString(rpcParams));
        List<SupportTransactionPathRpcDTO> data = supportTransactionPathRpcService.queryListByParam(rpcParams).getData();
        log.info("查询启用状态的结算路径结束,返回:{}", JSONObject.toJSONString(data));
        if (CollUtil.isEmpty(data)) {
            return new HashMap<>();
        }
        return data.stream().collect(Collectors.groupingBy(row -> row.getCompanyIdStart() + "@" + row.getCompanyIdEnd()));
    }

    private BigDecimal sumBigDecimal(SalSoSaveDTO payload, Function<SalSoDSaveDTO, BigDecimal> function) {
        return payload.getSalSoDSaveVOList().stream().map(function).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static List<Long> collectRelateDocDid(List<StoreOrderTrnRpcDTO> data) {
        return data.stream()
                .flatMap(dto -> dto.getDetails().stream())
                .map(StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail::getRelateDocDid)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
    }

    public static List<Long> collectRelateDocDidPo(List<PurPoSaveDTO> data) {
        return data.stream()
                .flatMap(dto -> dto.getPurPoDCreateParamVOList().stream())
                .map(PurPoDSaveDTO::getRelateDocDid)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
    }

    private void processTrnInfoMsg(List<StoreOrderTrnResultDTO> result) {
        log.info("回写创建调拨信息：{}", JSONUtil.toJsonStr(result));
        for (StoreOrderTrnResultDTO dto : result) {
            Long did = dto.getOrderDid();
            String errorMsg = dto.getErrorMsg();
            if (!dto.isSuccess()) {
                scpDemandOrderDDomainService.updateErrorMsg(did, errorMsg);
            }
        }
    }

    @Override
    public List<PurPoSaveDTO> prepareDataPoPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> haveWhStoreMap, Long employeeId,
                                                List<ScpDemandOrderDDTO> demandOrderDList, ScpOrderSettingRespVO setting) {
        List<PurPoSaveDTO> poResult = CollUtil.newCopyOnWriteArrayList(new ArrayList<>());
        String whCode = "";
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(demandOrderDTO.getType())) {
            whCode = demandOrderDTO.getDemandWhStCode();
        } else if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(demandOrderDTO.getType())) {
            List<OrgStoreWhDTO> orgStoreWhDTOS1 = haveWhStoreMap.get(demandOrderDTO.getDemandWhStCode());
            if (CollUtil.isEmpty(orgStoreWhDTOS1)) {
                log.info("订货单编码：{},门店编码：{},未配置真实仓库", demandOrderDTO.getDocCode(),
                        demandOrderDTO.getDemandWhStCode());
                List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, "门店编码:" + demandOrderDTO.getDemandWhStCode() + "未配置真实仓库");
                return new ArrayList<>();
            }
            Optional<OrgStoreWhDTO> priorityWhDto = findMinWhLevelElement(orgStoreWhDTOS1);
            if (priorityWhDto.isPresent()) {
                whCode = priorityWhDto.get().getWhCode();
            } else {
                log.info("订货单编码：{},门店编码:{},未配置最高优先级真实仓库", demandOrderDTO.getDocCode(), demandOrderDTO.getDemandWhStCode());
                List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, "门店编码:" + demandOrderDTO.getDemandWhStCode() + "未配置最高优先级真实仓库");
                return new ArrayList<>();
            }
        }

        //供应商类型的明细才需要生成采购单
        demandOrderDList = demandOrderDList.stream().filter(row -> !row.getIsPushed() && "SUPP".equals(row.getSupplyType()) && row.getIsCalculated() && row.getPlanQuantity().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (demandOrderDList.isEmpty()) {
            log.info("订货单Id:{},没有订货单明细,跳过处理", demandOrderDTO.getId());
            List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, "没有订货单明细,跳过处理");
            return new ArrayList<>();
        }

        //按采购公司分组，再按供应商编码分组
        Map<String, Map<String, List<ScpDemandOrderDDTO>>> orderDMap = groupByOuCodeAndSuppWhCode(demandOrderDList);
        List<String> purOuCodes = new ArrayList<>(orderDMap.keySet());
        Map<String, OrgOuRpcSimpleDTO> ouCodeBuIdMap = rmiOrgOuService.findOuDtoMapByOuCodes(purOuCodes);
        log.info("whCode的值:{}", whCode);
        for (Map.Entry<String, Map<String, List<ScpDemandOrderDDTO>>> stringMapEntry : orderDMap.entrySet()) {
            String ouCode = stringMapEntry.getKey();
            for (Map.Entry<String, List<ScpDemandOrderDDTO>> entry : stringMapEntry.getValue().entrySet()) {
                String suppCode = entry.getKey();

                PurPoSaveDTO dto = new PurPoSaveDTO();
                dto.setPoSource(ScpConstant.OB);
                dto.setSceneTypeCode(setting.getPurScene());
                dto.setDocStatus("APPING");

                dto.setOuCode(ouCode);
                dto.setSuppCode(suppCode);
                dto.setWhCode(whCode);
                dto.setAgentEmpId(employeeId);
                //采购公司的buId
                dto.setBuId(ouCodeBuIdMap.get(ouCode).getBuId());

                dto.setRelateDocId(demandOrderDTO.getId());
                dto.setRelateDocNo(demandOrderDTO.getDocCode());
                dto.setRelateDocCls(ScpConstant.OB);
                dto.setDemandType(demandOrderDTO.getType());
                dto.setStoreCode(demandOrderDTO.getDemandWhStCode());
                dto.setStoreName(demandOrderDTO.getDemandWhStName());

                List<ScpDemandOrderDDTO> demandOrderDDTOList = entry.getValue();
                List<PurPoDSaveDTO> purPoDCreateParamVOList = new ArrayList<>();
                for (ScpDemandOrderDDTO demandOrderDDTO : demandOrderDDTOList) {
                    // 构建采购单明细入参

                    PurPoDSaveDTO purPoDSaveDTO = new PurPoDSaveDTO();
                    purPoDSaveDTO.setItemId(demandOrderDDTO.getItemId());
                    purPoDSaveDTO.setCurrCode(demandOrderDDTO.getCurrency());
                    purPoDSaveDTO.setItemCode(demandOrderDDTO.getItemCode());
                    purPoDSaveDTO.setQty(demandOrderDDTO.getPlanQuantity());
                    purPoDSaveDTO.setUom(demandOrderDDTO.getUnit());
                    // purPoDSaveDTO.setTaxRate();
                    //  purPoDSaveDTO.setCurrPrice(demandOrderDDTO.getPrice());
                    purPoDSaveDTO.setRelateDocId(demandOrderDTO.getId());
                    purPoDSaveDTO.setRelateDocNo(demandOrderDTO.getDocCode());
                    purPoDSaveDTO.setRelateDocCls(ScpConstant.OB);
                    purPoDSaveDTO.setRelateDocDid(demandOrderDDTO.getId());
                    purPoDSaveDTO.setRelateDocLineno(demandOrderDDTO.getLineNo());
                    // 不考虑是运费行还是商品行，都从上游单据带过去
//                    if (demandOrderDDTO.getFreightLineFlag()) {
                        purPoDSaveDTO.setLastPathSalePrice(demandOrderDDTO.getPrice());
                        purPoDSaveDTO.setLastPathSaleAmt(demandOrderDDTO.getPlanAmt());
//                    }
                    purPoDSaveDTO.setFreightRate(demandOrderDDTO.getFreightRatio());
                    purPoDCreateParamVOList.add(purPoDSaveDTO);
                }
                dto.setPurPoDCreateParamVOList(purPoDCreateParamVOList);
                poResult.add(dto);
            }
        }
        String redisKey = "PO" + demandOrderDTO.getId().toString();
        redisTemplate.opsForValue().set(redisKey, "20", 2, TimeUnit.HOURS);
        return poResult;
    }

    public static Map<String, Map<String, List<ScpDemandOrderDDTO>>> groupByOuCodeAndSuppWhCode(List<ScpDemandOrderDDTO> demandOrderDList) {
        return demandOrderDList.stream()
                .collect(Collectors.groupingBy(ScpDemandOrderDDTO::getOuCode,
                        Collectors.groupingBy(ScpDemandOrderDDTO::getSuppWhCode)));
    }

    @Override
    public List<StoreOrderTrnRpcDTO> prepareDataTrnPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> haveWhStoreMap, Map<Long, InvWhRpcSimpleDTO> whIdMap,
                                                        Long employeeId, List<ScpDemandOrderDDTO> demandOrderDList, ScpOrderSettingRespVO setting) {
        List<StoreOrderTrnRpcDTO> result = CollUtil.newCopyOnWriteArrayList(new ArrayList<>());
        //需方方是门店类型，且门店主数据下有真实仓库对应或者需求方是仓库，需生成调拨单
        Long inWhId = null;
        String inWhCode = "";
        Long inOuId = null;
        String inOuCode = null;
        if (ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(demandOrderDTO.getType())) {
            inWhId = demandOrderDTO.getDemandWhStId();
            inWhCode = demandOrderDTO.getDemandWhStCode();
            if (whIdMap.containsKey(inWhId)) {
                inOuId = whIdMap.get(inWhId).getOuId();
                inOuCode = whIdMap.get(inWhId).getOuCode();
            } else {
                log.info("订货单编码：{},仓库公司信息不存在", demandOrderDTO.getDocCode());
                List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, "仓库:" + inWhCode + "信息不存在");
                return new ArrayList<>();
            }
        } else if (ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(demandOrderDTO.getType())) {
            List<OrgStoreWhDTO> orgStoreWhDTOS1 = haveWhStoreMap.get(demandOrderDTO.getDemandWhStCode());
            if (CollUtil.isEmpty(orgStoreWhDTOS1)) {
                log.info("订货单编码：{},门店编码：{},未配置真实仓库", demandOrderDTO.getDocCode(),
                        demandOrderDTO.getDemandWhStCode());
                List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, "门店编码:" + demandOrderDTO.getDemandWhStCode() + "未配置真实仓库");
                return new ArrayList<>();
            }
            Optional<OrgStoreWhDTO> priorityWhDto = findMinWhLevelElement(orgStoreWhDTOS1);
            if (priorityWhDto.isPresent()) {
                //   inWhId = priorityWhDto.get().getWhId();
                inWhCode = priorityWhDto.get().getWhCode();
                log.info("高优先级仓库,inWhCode的值:{}", inWhCode);
                InvWhRpcSimpleDTO whInfoByCode = getWhInfoByCode(inWhCode);
                log.info("whInfoByCode的值:{}", JSONUtil.toJsonStr(whInfoByCode));
                if (whInfoByCode != null) {
                    inOuId = whInfoByCode.getOuId();
                    inOuCode = whInfoByCode.getOuCode();
                }

            } else {
                log.info("订货单编码：{},门店编码:{},未配置最高优先级真实仓库", demandOrderDTO.getDocCode(), demandOrderDTO.getDemandWhStCode());
                List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
                scpDemandOrderDDomainService.updateSyncMsg(dIdList, "门店编码:" + demandOrderDTO.getDemandWhStCode() + "未配置最高优先级真实仓库");
                return new ArrayList<>();
            }
        }

        //非供应商类型的明细  未计算和数量为0的不推
        demandOrderDList = demandOrderDList.stream().filter(row -> !row.getIsPushed() && !"SUPP".equals(row.getSupplyType()) && row.getIsCalculated() && row.getPlanQuantity().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (demandOrderDList.isEmpty()) {
            log.info("订货单Id:{},没有订货单明细,跳过处理", demandOrderDTO.getId());
            List<Long> dIdList = demandOrderDList.stream().map(ScpDemandOrderDDTO::getId).collect(Collectors.toList());
            scpDemandOrderDDomainService.updateSyncMsg(dIdList, "没有订货单明细,跳过处理");
            return new ArrayList<>();
        }

        //供应商仓库信息获取
        List<Long> suppWhIds =
                demandOrderDList.stream().filter(row -> row.getSuppWhId() != null).map(ScpDemandOrderDDTO::getSuppWhId
                ).distinct().collect(Collectors.toList());
        Map<Long, InvWhRpcSimpleDTO> suppWhIdMap = rmiInvStkService.findInvWhBaseMap(suppWhIds);
        log.info("供应商仓库数据whIdMap:{}", JSONUtil.toJsonStr(suppWhIdMap));

        //查询商品信息
        Map<Long, List<ScpDemandOrderDDTO>> orderDMap =
                demandOrderDList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getSuppWhId));
        log.info("inWhId:{},inWhCode:{},inOuId:{},inOuCode:{}", inWhId, inWhCode, inOuId, inOuCode);
        for (Map.Entry<Long, List<ScpDemandOrderDDTO>> entry : orderDMap.entrySet()) {
            StoreOrderTrnRpcDTO dto = new StoreOrderTrnRpcDTO();
            dto.setApplyEmpId(employeeId);
            dto.setApplyDate(LocalDateTime.now());
            //  dto.setInWhId(inWhId);
            dto.setInOuId(inOuId);
            dto.setInOuCode(inOuCode);
            if (inWhId != null) {
                dto.setInWhId(inWhId);
            }
            dto.setInWhCode(inWhCode);
            dto.setOutWhId(entry.getKey());
            dto.setOutWhCode(entry.getValue().get(0).getSuppWhCode());
            if (suppWhIdMap.containsKey(entry.getKey())) {
                InvWhRpcSimpleDTO whRpcSimpleDTO = suppWhIdMap.get(entry.getKey());
                dto.setOutOuId(whRpcSimpleDTO.getOuId());
                dto.setOutOuCode(whRpcSimpleDTO.getOuCode());
            }
            dto.setRelateDocId(demandOrderDTO.getId());
            dto.setRelateDocNo(demandOrderDTO.getDocCode());
            dto.setOrderSetId(demandOrderDTO.getDemandId());
            dto.setDocType(setting.getTrnType());
            dto.setRelateDocCls(ScpConstant.OB);
            dto.setDemandType(demandOrderDTO.getType());
            dto.setInStoreCode(demandOrderDTO.getDemandWhStCode());
            List<ScpDemandOrderDDTO> demandOrderDDTOList = entry.getValue();
            List<StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail> itemList = new ArrayList<>();
            for (ScpDemandOrderDDTO demandOrderDDTO : demandOrderDDTOList) {
                // 构建调拨单明细入参
                StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail storeOrderTrnRpcDTODetail =
                        new StoreOrderTrnRpcDTO.StoreOrderTrnRpcDTODetail();
                storeOrderTrnRpcDTODetail.setItemId(demandOrderDDTO.getItemId());
                storeOrderTrnRpcDTODetail.setQty(demandOrderDDTO.getPlanQuantity());
                storeOrderTrnRpcDTODetail.setUom(demandOrderDDTO.getUnit());
                storeOrderTrnRpcDTODetail.setRelateDocDid(demandOrderDDTO.getId());
                storeOrderTrnRpcDTODetail.setPrice(demandOrderDDTO.getPrice());
                if (demandOrderDDTO.getFreightLineFlag()) {
                    storeOrderTrnRpcDTODetail.setLastPathSalePrice(demandOrderDDTO.getPrice());
                    storeOrderTrnRpcDTODetail.setLastPathSaleAmt(demandOrderDDTO.getPlanAmt());
                }
                storeOrderTrnRpcDTODetail.setFreightRate(demandOrderDDTO.getFreightRatio());
                storeOrderTrnRpcDTODetail.setFreightAmt(demandOrderDDTO.getFreightAmt());
                storeOrderTrnRpcDTODetail.setRelateDocLineno(demandOrderDDTO.getLineNo().intValue());
                itemList.add(storeOrderTrnRpcDTODetail);
            }
            dto.setDetails(itemList);
            result.add(dto);
        }
        String redisKey = "TRN" + demandOrderDTO.getId().toString();
        redisTemplate.opsForValue().set(redisKey, "20", 2, TimeUnit.HOURS);
        return result;
    }

    private InvWhRpcSimpleDTO getWhInfoByCode(String whCode) {
        Map<String, InvWhRpcSimpleDTO> invWhBaseMapByCode = rmiInvStkService.findInvWhBaseMapByCode(List.of(whCode));
        return invWhBaseMapByCode.get(whCode);
    }

    public static Optional<OrgStoreWhDTO> findMinWhLevelElement(List<OrgStoreWhDTO> orgStoreWhDTOs) {
        return orgStoreWhDTOs.stream()
                .min(Comparator.comparingInt(OrgStoreWhDTO::getWhLevel));
    }

}
