package com.elitesland.scp.domain.entity.order;

import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "scp_demand_order_d")
@org.hibernate.annotations.Table(appliesTo = "scp_demand_order_d", comment = "订货订单明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货订单明细", description = "订货订单明细")
@Where(clause = "delete_flag = 0")
public class ScpDemandOrderDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -7561115166247463873L;

    @ApiModelProperty("订货订单ID")
    @Comment("订货订单ID")
    @Column()
    private Long masId;

    @ApiModelProperty("原始id")
    @Comment("原始id")
    @Column()
    private Long sourceId;

    @ApiModelProperty("行号")
    @Comment("行号")
    @Column()
    private BigDecimal lineNo;

    @ApiModelProperty("SPU商品编码")
    @Comment("商品编码")
    @Column()
    private String spuItemCode;

    @ApiModelProperty("SPU商品名称")
    @Comment("商品名称")
    @Column()
    private String spuItemName;

    @ApiModelProperty("商品id")
    @Comment("商品id")
    @Column()
    private Long itemId;

    @ApiModelProperty("商品编码")
    @Comment("商品编码")
    @Column()
    private String itemCode;

    @ApiModelProperty("商品名称")
    @Comment("商品名称")
    @Column()
    private String itemName;

    @ApiModelProperty("商品分类")
    @Comment("商品分类")
    @Column()
    private String itemType;

    @ApiModelProperty("需求数量")
    @Comment("需求数量")
    @Column()
    private BigDecimal demandQuantity;

    @ApiModelProperty("拆分需求数量")
    @Comment("拆分需求数量")
    @Column()
    private BigDecimal allocationDeQuantity;

    @ApiModelProperty("订货单位")
    @Comment("订货单位")
    @Column()
    private String unit;

    @ApiModelProperty("单位")
    @Comment("单位")
    @Column()
    private String unitName;

    @ApiModelProperty("含税单价")
    @Comment("含税单价")
    @Column()
    private BigDecimal price;

    @ApiModelProperty("币种，默认CNY")
    @Comment("币种，默认CNY")
    @Column()
    private String currency;

    @ApiModelProperty("分配数量")
    @Comment("分配数量")
    @Column()
    private BigDecimal allocationQuantity;

    @ApiModelProperty("计划数量")
    @Comment("计划数量")
    @Column()
    private BigDecimal planQuantity;

    @ApiModelProperty("供应类型：WH:仓库，SUPP:供应商")
    @Comment("供应类型")
    @Column()
    private String supplyType;

    @ApiModelProperty("供应仓库id、供应商id")
    @Comment("供应仓库id、供应商id")
    @Column()
    private Long suppWhId;

    @ApiModelProperty("供应仓库编码、供应商编码")
    @Comment("供应仓库编码、供应商编码")
    @Column()
    private String suppWhCode;

    @ApiModelProperty("供应仓库名称、供应商名称")
    @Comment("供应仓库名称、供应商名称")
    @Column()
    private String suppWhName;

    @ApiModelProperty("采购公司id")
    @Comment("采购公司id")
    @Column()
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    @Comment("采购公司编码")
    @Column()
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    @Comment("采购公司名称")
    @Column()
    private String ouName;

    @ApiModelProperty("分配单据id")
    @Comment("分配单据id")
    @Column()
    private Long srcDocId;

    @ApiModelProperty("分配单据编码")
    @Comment("分配单据编码")
    @Column()
    private String srcDocNo;

    @ApiModelProperty("分配单据类别")
    @Comment("分配单据类别")
    @Column()
    private String srcDocCls;

    @ApiModelProperty("分配单据明细行号")
    @Comment("分配单据明细行号")
    @Column()
    private String srcDocLineNo;

    @ApiModelProperty("发货数量")
    @Comment("发货数量")
    @Column()
    private BigDecimal quantity;

    @ApiModelProperty("是否已计算")
    @Comment("是否已计算")
    @Column()
    private Boolean isCalculated;

    @ApiModelProperty("是否已推送")
    @Comment("是否已推送")
    @Column()
    private Boolean isPushed;

    @ApiModelProperty("含税金额")
    @Comment("含税金额")
    @Column()
    private BigDecimal planAmt;

    @ApiModelProperty("仓库/供应商分配比例")
    @Comment("仓库/供应商分配比例")
    @Column()
    private BigDecimal ratio;

    @ApiModelProperty("预分配唯一值")
    @Comment("预分配唯一值")
    @Column()
    private String preRootUuid;

    @ApiModelProperty("推送订单信息")
    @Comment("推送订单信息")
    @Column()
    private String syncMsg;

    @ApiModelProperty("基本单位")
    @Comment("基本单位")
    @Column()
    private String uom2;

    @ApiModelProperty("基本单位名称")
    @Comment("基本单位名称")
    @Column(name = "uom2_name", columnDefinition = "varchar(30) comment '基本单位名称'")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    @Comment("单位转换系数")
    @Column()
    private BigDecimal uomRatio;

    @ApiModelProperty("基本单位数量")
    @Comment("基本单位数量")
    @Column()
    private BigDecimal qty2;

    @ApiModelProperty(name = "有效小数位数")
    @Column(name = "decimal_places", columnDefinition = "int(2) comment '有效小数位数'")
    private Integer decimalPlaces;

    @ApiModelProperty("运费是否计费")
    @Comment("运费是否计费")
    @Column()
    private Boolean freightFlag;

    @ApiModelProperty("运费比例")
    @Comment("运费比例")
    @Column(name = "freight_ratio", columnDefinition = "decimal(20,8)")
    private BigDecimal freightRatio;

    @ApiModelProperty("运费金额")
    @Comment("运费金额")
    @Column(name = "freight_amt", columnDefinition = "decimal(20,8)")
    private BigDecimal freightAmt;

    @ApiModelProperty("销售公司编码")
    @Comment("销售公司编码")
    @Column()
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    @Comment("销售公司名称")
    @Column()
    private String saleOuName;

    @ApiModelProperty("销售客户编码")
    @Comment("销售客户编码")
    @Column()
    private String saleCustCode;

    @ApiModelProperty("付款状态")
    @Comment("付款状态")
    @Column()
    private String payStatus;

    @ApiModelProperty("收货数量")
    @Comment("收货数量")
    @Column()
    private BigDecimal recvQty;

    @ApiModelProperty("运费行标记")
    @Comment("运费行标记")
    @Column()
    private Boolean freightLineFlag;

    @ApiModelProperty("表分区字段：月")
    @Comment("表分区字段：月")
    @Column(updatable = false)
    @PartitionField(PartitionField.PartitionType.YEAR_MONTH)
    private Integer ym;

    @ApiModelProperty("商品图片")
    @Comment("商品图片")
    @Column()
    private String imgUrl;

    @ApiModelProperty("强配活动编码")
    @Comment("强配活动编码")
    @Column()
    private String activityCode;

    @ApiModelProperty("强配活动ID")
    @Comment("强配活动ID")
    @Column()
    private Long activityId;

    @ApiModelProperty("最小强配数量")
    @Comment("最小强配数量")
    @Column()
    private BigDecimal minNum;

    @ApiModelProperty("在线支付标识")
    @Comment("在线支付标识")
    @Column()
    private Boolean onlinePayFlag;

    @ApiModelProperty("付款人")
    @Comment("付款人")
    @Column()
    private String payerName;

    @ApiModelProperty("组合商品编码")
    @Comment("组合商品编码")
    @Column()
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    @Comment("组合商品名称")
    @Column()
    private String combineItemName;

    public String groupByUuid() {
        return this.itemId.toString() + this.preRootUuid;
    }
}
