package com.elitesland.scp.domain.service.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.feedback.ScpStoreFeedbackConvert;
import com.elitesland.scp.domain.entity.feedback.QScpStoreFeedbackDO;
import com.elitesland.scp.domain.entity.feedback.ScpStoreFeedbackDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.feedback.ScpStoreFeedbackRepoProc;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import com.elitesland.scp.infr.repo.feedback.ScpStoreFeedbackRepo;
import com.elitesland.scp.domain.service.feedback.ScpStoreFeedbackDomainService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.github.houbb.sensitive.word.bs.SensitiveWordBs;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.util.IOUtils;
import org.springframework.http.HttpEntity;
import org.springframework.stereotype.Service;
import lombok.RequiredArgsConstructor;
import lombok.val;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.transaction.annotation.Transactional;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import java.nio.file.*;
import java.io.*;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2025-09-23 18:08:05
 */
@Service("scpStoreFeedbackDomainService")
@RequiredArgsConstructor
@Slf4j
public class ScpStoreFeedbackDomainServiceImpl implements ScpStoreFeedbackDomainService {
    
    private final ScpStoreFeedbackRepo scpStoreFeedbackRepo;
    
    private final ScpStoreFeedbackRepoProc scpStoreFeedbackRepoProc;

    private final SensitiveWordBs sensitiveWordBs;

    private final FileService fileService;

 
    @Override
    public PagingVO<ScpStoreFeedbackRespVO> search(ScpStoreFeedbackQueryParamVO param){
        val ret = scpStoreFeedbackRepo.findAll(scpStoreFeedbackRepoProc.where(param), param.getPageRequest());
        val vos = ret.getContent().stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
        vos.forEach(item -> {
            if (item.getFileUrl() != null)
                item.setFileUrlList(JSONObject.parseArray(item.getFileUrl(), ScpStoreFeedbackRespVO.FileObject.class));
            String replace = sensitiveWordBs.replace(item.getEvaluationComment());
            item.setEvaluationComment(replace);
            String replace1 = sensitiveWordBs.replace(item.getOptimizationSuggestion());
            item.setOptimizationSuggestion(replace1);
        });
        return PagingVO.<ScpStoreFeedbackRespVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }

    @Override
    public void exportZip(ScpStoreFeedbackQueryParamVO param, HttpServletRequest request, HttpServletResponse response) {
        Path tempDir = null;
        FileInputStream inputStream = null;
        ServletOutputStream out = null;

        try {
            tempDir = Files.createTempDirectory("feedback_files_");
            val ret = scpStoreFeedbackRepo.findAll(scpStoreFeedbackRepoProc.where(param), param.getPageRequest());
            val vos = ret.getContent().stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());

            // 收集所有需要下载的文件
            List<DownloadFileInfo> downloadFiles = new ArrayList<>();
            vos.forEach(item -> {
                if (item.getFileUrl() != null) {
                    item.setFileUrlList(JSONObject.parseArray(item.getFileUrl(), ScpStoreFeedbackRespVO.FileObject.class));
                    item.getFileUrlList().forEach(fileObj -> {
                        DownloadFileInfo downloadFileInfo = new DownloadFileInfo();
                        downloadFileInfo.setFileCode(fileObj.getFileCode());
                        downloadFileInfo.setFileName((item.getDcoNo() == null ? "" : item.getDcoNo())+"-"+fileObj.getFileCode());
                        downloadFileInfo.setFileUrl(fileObj.getFileUrl());
                        downloadFiles.add(downloadFileInfo);
                    });
                }
            });

            // 下载文件到临时目录
            Path finalTempDir = tempDir;
            List<Path> downloadedFiles = downloadFiles.stream()
                    .map(fileInfo -> downloadFileToTemp(fileInfo, finalTempDir))
                    .filter(Objects::nonNull)
                    .collect(Collectors.toList());

            // 创建 ZIP 文件
            String zipFileName = "门店反馈图片视频" + System.currentTimeMillis() + ".zip";
            Path zipFilePath = tempDir.resolve(zipFileName);
            createZipFile(downloadedFiles, zipFilePath);

            // 设置正确的响应头以输出 ZIP 格式
            response.setContentType("application/zip");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + java.net.URLEncoder.encode(zipFileName, "UTF-8"));

            // 输出 ZIP 文件流
            inputStream = new FileInputStream(zipFilePath.toFile());
            out = response.getOutputStream();

            byte[] buffer = new byte[8192];
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }

            out.flush();

        } catch (IOException e) {
            log.error("创建 ZIP 文件失败", e);
            throw new BusinessException(ApiCode.FAIL, "文件打包失败: " + e.getMessage());
        } finally {
            // 清理资源
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    log.warn("关闭输入流失败", e);
                }
            }

            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    log.warn("关闭输出流失败", e);
                }
            }

            // 清理临时目录
            cleanupTempDirectory(tempDir);
        }
    }


    // 辅助方法：清理临时目录
    private void cleanupTempDirectory(Path tempDir) {
        if (tempDir != null) {
            try {
                Files.walk(tempDir)
                        .sorted(Comparator.reverseOrder())
                        .map(Path::toFile)
                        .forEach(File::delete);
            } catch (IOException e) {
                log.warn("清理临时文件失败", e);
            }
        }
    }

    // 辅助类用于存储文件信息
    @Data
    private static class DownloadFileInfo {
        private String fileName;
        private String fileUrl;
        private String fileCode;

    }

    // 下载文件到临时目录
    private Path downloadFileToTemp(DownloadFileInfo fileInfo, Path tempDir) {
        Path filePath = null;
        try {
            // 构造安全文件名，防止路径遍历攻击
            String fileName = fileInfo.getFileName();
            String[] split = fileInfo.getFileUrl().split("\\.");
            filePath = tempDir.resolve(fileName+"."+split[split.length - 1]);

            // 下载文件内容并保存到 filePath
            try (InputStream in = new URL(fileInfo.getFileUrl()).openStream()) {
                Files.copy(in, filePath, StandardCopyOption.REPLACE_EXISTING);
            }

            return filePath;
        } catch (MalformedURLException e) {
            log.warn("无效的文件URL: {}", fileInfo.getFileUrl(), e);
            // 清理可能已创建的文件
            if (filePath != null) {
                try {
                    Files.deleteIfExists(filePath);
                } catch (IOException deleteEx) {
                    log.warn("清理临时文件失败: {}", filePath, deleteEx);
                }
            }
            return null;
        } catch (IOException e) {
            log.warn("下载文件失败: {}", fileInfo.getFileName(), e);
            // 清理可能已创建的文件
            if (filePath != null) {
                try {
                    Files.deleteIfExists(filePath);
                } catch (IOException deleteEx) {
                    log.warn("清理临时文件失败: {}", filePath, deleteEx);
                }
            }
            return null;
        }
    }


    // 创建 ZIP 文件
    private void createZipFile(List<Path> files, Path zipFilePath) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipFilePath))) {
            byte[] buffer = new byte[1024];

            for (Path file : files) {
                if (Files.exists(file)) {
                    ZipEntry zipEntry = new ZipEntry(file.getFileName().toString());
                    zos.putNextEntry(zipEntry);

                    try (InputStream fis = Files.newInputStream(file)) {
                        int length;
                        while ((length = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, length);
                        }
                    }

                    zos.closeEntry();
                }
            }
        }
    }

 
    @Override
    public Optional<ScpStoreFeedbackRespVO> findCodeOne(String itemCode) {
        JPAQuery<ScpStoreFeedbackRespVO> jpaQuery = scpStoreFeedbackRepoProc.select(null);
        val jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        //设置查询条件
        //jpaQuery.where(jpaQDo.itemCode.eq(itemCode));
        ScpStoreFeedbackRespVO vo = jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }
    @Override
    public Optional<ScpStoreFeedbackRespVO> findIdOne(Long id) {
        return scpStoreFeedbackRepo.findById(id).map(ScpStoreFeedbackConvert.INSTANCE::doToVO);
    }
    
    @Override
    public List<ScpStoreFeedbackRespVO> findIdBatch(List<Long> idList) {
         return scpStoreFeedbackRepo.findAllById(idList).stream().map(
               ScpStoreFeedbackConvert.INSTANCE::doToVO
        ).collect(Collectors.toList());
    }

    
    
    @Override
    @Transactional
    public Long createOne(ScpStoreFeedbackSaveVO param){
        ScpStoreFeedbackDO objDo = ScpStoreFeedbackConvert.INSTANCE.saveParamToDo(param);
        if(param.getId()!=null&&param.getId()>0){
            Optional<ScpStoreFeedbackDO> optional = scpStoreFeedbackRepo.findById(objDo.getId());
            if(optional.isPresent()){
                BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
                scpStoreFeedbackRepo.save(optional.get());
            }else{
                throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+objDo.getId());
            }
        }

       return scpStoreFeedbackRepo.save(objDo).getId();
    }
    
    @Override
    @Transactional
    public List<ScpStoreFeedbackRespVO> createBatch(List<ScpStoreFeedbackSaveVO> list){
        List<ScpStoreFeedbackDO> dos = list.stream().map(ScpStoreFeedbackConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
       return scpStoreFeedbackRepo.saveAll(dos).stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> statusChangeByProcess(long id, ProcInstStatus procInstStatus, String approveComment) {
        log.info("门店反馈工作流回调:{},{}", id, procInstStatus);
        //1,查询单据是否存在
        Optional<ScpStoreFeedbackRespVO> optional =  this.findIdOne(id);
        if (optional.isEmpty()) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        ScpStoreFeedbackRespVO scpStoreFeedbackRespVO = optional.get();
        Map<String, String> result = new HashMap<>();
        //2,修改审批状态
        scpStoreFeedbackRespVO.setProcInstStatus(procInstStatus);
        String docStatus = null;
        String approveStatus = null;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        //3,修改单据状态
        switch (procInstStatus) {
            // 未提交
            case NOTSUBMIT:
                // 中断执行
            case INTERRUPT:
                //草稿
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode();
//                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode();
                break;
            // 审批拒绝
            case REJECTED:
                //拒绝
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_INVALID.getValueCode();
                break;
            // 作废
            case INVALID:
                //作废
//                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
//                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_INVALID.getValueCode();
                break;
            // 审批中
            case APPROVING:
                //审批中(已提交)
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_APPROVING.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode();
                break;
            // 审批通过
            case APPROVED:
                //审批通过//审批完成时间
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_VALID.getValueCode();
                scpStoreFeedbackRespVO.setApprovalTime(LocalDateTime.now());
                if (currentUserDTO != null) {
                    scpStoreFeedbackRespVO.setApprovedBy(currentUserDTO.getDetail().getLastName());
                }
                break;
            default:
                throw new IllegalStateException("非法访问");
        }
        //执行
        scpStoreFeedbackRespVO.setFeedbackStatus(docStatus);
        scpStoreFeedbackRespVO.setApprovalStatus(approveStatus);
        scpStoreFeedbackRespVO.setProcInstStatus(procInstStatus);
        scpStoreFeedbackRespVO.setRemark(approveComment);
        this.updateById(scpStoreFeedbackRespVO);

        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {

        }
        return result;
    }

    @Override
    @Transactional
    public void updateById(ScpStoreFeedbackRespVO param) {
        scpStoreFeedbackRepoProc.update(param);
    }
    
    @Override
    @Transactional
    public void update(ScpStoreFeedbackSaveVO param) {
      ScpStoreFeedbackDO objDo = ScpStoreFeedbackConvert.INSTANCE.saveParamToDo(param);
        Optional<ScpStoreFeedbackDO> optional = scpStoreFeedbackRepo.findById(objDo.getId());
        if(optional.isPresent()){
             BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
             scpStoreFeedbackRepo.save(optional.get());
        }else{
            throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+objDo.getId());
        }
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        val jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
                Optional<ScpStoreFeedbackDO> optionalItem=scpStoreFeedbackRepo.findOne(predicate);
        if(optionalItem.isPresent()) {
            ScpStoreFeedbackDO do1 = optionalItem.get();
            do1.setDeleteFlag(1);
            scpStoreFeedbackRepo.save(do1);
        }else{
             throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+id);
        }
    }

    
    
    @Override
    @Transactional
    public void deleteOne(Long id) {
     
      this.scpStoreFeedbackRepo.deleteById(id) ;
      
    }
    
    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id-> scpStoreFeedbackRepo.deleteById(id));
    }
}


