package com.elitesland.scp.infr.repo.stock;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockParamVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockRespVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageParam;
import com.elitesland.scp.domain.entity.stock.QScpPredictStStockCalcDO;
import com.elitesland.scp.application.facade.vo.stock.*;
import com.elitesland.scp.domain.entity.stock.QScpPredictStStockCalcDO;
import com.elitesland.scp.domain.entity.stock.QScpPredictStStockDO;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Stream;

/**
 * @description:
 * @author: jeesie.jiang
 * @create: 2025-01-21
 * @Version 1.0
 **/
@Component
public class ScpPredictStStockRepoProc extends BaseRepoProc<ScpPredictStStockDO> {

    private static final QScpPredictStStockDO qScpPredictStStockDO = QScpPredictStStockDO.scpPredictStStockDO;
    private static final QScpPredictStStockCalcDO qScpPredictStStockCalcDO = QScpPredictStStockCalcDO.scpPredictStStockCalcDO;

    public ScpPredictStStockRepoProc() {
        super(qScpPredictStStockDO);
    }


    public PagingVO<ScpPredictStStockRespVO> stStockDetailPage(ScpPredictStStockParamVO param){
        JPAQuery<ScpPredictStStockRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpPredictStStockRespVO.class,
                qScpPredictStStockDO.id,
                qScpPredictStStockDO.tenantId,
                qScpPredictStStockDO.remark,
                qScpPredictStStockDO.createUserId,
                qScpPredictStStockDO.creator,
                qScpPredictStStockDO.createTime,
                qScpPredictStStockDO.modifyUserId,
                qScpPredictStStockDO.updater,
                qScpPredictStStockDO.modifyTime,
                qScpPredictStStockDO.deleteFlag,
                qScpPredictStStockDO.auditDataVersion,
                qScpPredictStStockDO.ouId,
                qScpPredictStStockDO.ouCode,
                qScpPredictStStockDO.ouName,
                qScpPredictStStockDO.whId,
                qScpPredictStStockDO.whCode,
                qScpPredictStStockDO.whName,
                qScpPredictStStockDO.itemId,
                qScpPredictStStockDO.itemCode,
                qScpPredictStStockDO.itemName,
                qScpPredictStStockDO.safetyQty,
                qScpPredictStStockDO.targetQty,
                qScpPredictStStockDO.planUom,
                qScpPredictStStockDO.itemType2,
                qScpPredictStStockDO.itemCateCode,
                qScpPredictStStockDO.brand,
                qScpPredictStStockDO.predSafetyQty,
                qScpPredictStStockDO.predTargetQty,
                qScpPredictStStockDO.mrpFlag,
                qScpPredictStStockDO.stId,
                qScpPredictStStockDO.businessId,
                qScpPredictStStockDO.ioQty,
                qScpPredictStStockDO.uomRatio
        )).from(qScpPredictStStockDO);
        jpaQuery.where(where(param));
        return queryByPage(jpaQuery,param.getPageRequest());


    }


    private Predicate where(ScpPredictStStockParamVO param){
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(CollectionUtils.isNotEmpty(param.getOuIds())){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockDO.ouId.in(param.getOuIds()));
        }
        if(CollectionUtils.isNotEmpty(param.getItemIds())){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockDO.itemId.in(param.getItemIds()));
        }
        if(CollectionUtils.isNotEmpty(param.getWhIds())){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockDO.whId.in(param.getWhIds()));
        }
        if(param.getMasId() != null){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockDO.stId.eq(param.getMasId()));
        }
        if(param.getPredTargetQtySt() != null){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockDO.predTargetQty.goe(param.getPredTargetQtySt()));
        }
        if(param.getPredTargetQtyEn() != null){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockDO.predTargetQty.loe(param.getPredTargetQtyEn()));
        }
        if(param.getPredSafetyQtySt() != null){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockDO.predSafetyQty.goe(param.getPredSafetyQtySt()));
        }
        if(param.getPredSafetyQtyEn() != null){
            predicate = ExpressionUtils.and(predicate, qScpPredictStStockDO.predSafetyQty.loe(param.getPredSafetyQtyEn()));
        }
        return predicate;
    }


    @Transactional
    public void deleteAllByBusinessIdAndStId(List<String> businessIds, List<Long> stIds){
        jpaQueryFactory.delete(qScpPredictStStockDO).where(qScpPredictStStockDO.businessId.in(businessIds)
                .and(qScpPredictStStockDO.stId.in(stIds))).execute();
    }

    public List<Long> findStIdsByWhIds(List<Long> whIds){
        return jpaQueryFactory.select(qScpPredictStStockDO.stId).from(qScpPredictStStockDO)
                .where(qScpPredictStStockDO.whId.in(whIds).and(qScpPredictStStockDO.deleteFlag.eq(0)
                        .or(qScpPredictStStockDO.deleteFlag.isNull()))).fetch();
    }


    public List<Long> findStIdsByItemIds(List<Long> itemIds){
        return jpaQueryFactory.select(qScpPredictStStockDO.stId).from(qScpPredictStStockDO)
                .where(qScpPredictStStockDO.itemId.in(itemIds).and(qScpPredictStStockDO.deleteFlag.eq(0)
                        .or(qScpPredictStStockDO.deleteFlag.isNull()))).fetch();
    }


    public PagingVO<ScpPredictStStockDownloadVO> findDownloadPredictStStock(ScpPredictStStockDownLoadParam param){
        QScpPredictStStockCalcDO qScpPredictStStockCalcDO = QScpPredictStStockCalcDO.scpPredictStStockCalcDO;
        JPAQuery<ScpPredictStStockDownloadVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ScpPredictStStockDownloadVO.class,
                        qScpPredictStStockDO.stId,
                        qScpPredictStStockDO.ouCode,
                        qScpPredictStStockDO.ouName,
                        qScpPredictStStockDO.whCode,
                        qScpPredictStStockDO.whName,
                        qScpPredictStStockDO.itemCode,
                        qScpPredictStStockDO.itemName,
                        qScpPredictStStockDO.itemId,
                        qScpPredictStStockDO.safetyQty,
                        qScpPredictStStockDO.targetQty,
                        qScpPredictStStockDO.planUom,
                        qScpPredictStStockDO.predSafetyQty,
                        qScpPredictStStockDO.predTargetQty
                )).from(qScpPredictStStockDO).innerJoin(qScpPredictStStockCalcDO)
                .on(qScpPredictStStockDO.stId.eq(qScpPredictStStockCalcDO.id));
        if(param.getStId() != null){
            jpaQuery.where(qScpPredictStStockDO.stId.eq(param.getStId()));
        }
        if(StringUtils.isNotEmpty(param.getPredLotNo())){
            jpaQuery.where(qScpPredictStStockCalcDO.predLotNo.eq(param.getPredLotNo()));
        }
        return queryByPage(jpaQuery,param.getPageRequest());
    }


    public JPAQuery<ScpPredictStStockRespVO> selectDetail() {
        return jpaQueryFactory.select(Projections.bean(
                        ScpPredictStStockRespVO.class,
                        qScpPredictStStockDO.id,
                        qScpPredictStStockDO.stId,
                        qScpPredictStStockDO.masId,
                        qScpPredictStStockDO.ouId,
                        qScpPredictStStockDO.ouCode,
                        qScpPredictStStockDO.ouName,
                        qScpPredictStStockDO.whId,
                        qScpPredictStStockDO.whCode,
                        qScpPredictStStockDO.whName,
                        qScpPredictStStockDO.itemId,
                        qScpPredictStStockDO.itemCode,
                        qScpPredictStStockDO.itemName,
                        qScpPredictStStockDO.safetyQty,
                        qScpPredictStStockDO.targetQty,
                        qScpPredictStStockDO.planUom,
                        qScpPredictStStockDO.itemType2,
                        qScpPredictStStockDO.itemCateCode,
                        qScpPredictStStockDO.brand,
                        qScpPredictStStockDO.predSafetyQty,
                        qScpPredictStStockDO.predTargetQty,
                        qScpPredictStStockDO.ioQty,
                        qScpPredictStStockDO.uomRatio,
                        qScpPredictStStockCalcDO.predLotNo
                )).from(qScpPredictStStockDO)
                .leftJoin(qScpPredictStStockCalcDO).on(qScpPredictStStockCalcDO.id.eq(qScpPredictStStockDO.stId));
    }

    public List<ScpPredictStStockRespVO> findByMasIdAndMrpFlag(Long masId, Boolean mrpFlag) {
        return selectDetail().where(qScpPredictStStockDO.stId.eq(masId).and(qScpPredictStStockDO.mrpFlag.eq(mrpFlag))).fetch();
    }

    @Transactional
    public void updateMrpFlag(List<Long> ids, Boolean mrpFlag) {
        jpaQueryFactory.update(qScpPredictStStockDO)
                .set(qScpPredictStStockDO.mrpFlag, mrpFlag)
                .where(qScpPredictStStockDO.id.in(ids)).execute();
    }
}