/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.whnet;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationExportRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageVO;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.scp.infr.dto.whnet.ScpWhNetRelationDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepo;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpWhNetRelationDomainServiceImpl
implements ScpWhNetRelationDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpWhNetRelationDomainServiceImpl.class);
    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    private final ScpWhNetRelationRepo scpWhNetRelationRepo;

    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpWhNetRelationPageVO> page = this.scpWhNetRelationRepoProc.page(queryParam);
        if (CollUtil.isNotEmpty((Collection)page.getRecords())) {
            List<String> concatKey = page.getRecords().stream().map(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())).collect(Collectors.toList());
            List<ScpWhNetRelationDO> relationDOList = this.scpWhNetRelationRepo.findByConcatKey(concatKey);
            Map<String, List<ScpWhNetRelationDO>> scpWhNetMap = relationDOList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())));
            page.getRecords().forEach(d -> {
                if (scpWhNetMap.get(d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())) != null) {
                    BigDecimal sum = ((List)scpWhNetMap.get(d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode()))).stream().map(ScpWhNetRelationDO::getSupplyPercentage).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    d.setSupplyPercentageSum(sum);
                }
            });
        }
        return page;
    }

    public String setEmptyStringStr(String str) {
        return str == null ? "" : str;
    }

    @Override
    public List<ScpWhNetRelationDO> findByConcatKey(Set<String> concatKey) {
        ArrayList<String> stringList = new ArrayList<String>(concatKey);
        return this.scpWhNetRelationRepo.findByConcatKey(stringList);
    }

    @Override
    public List<ScpWhNetRelationDO> findByAllConcatKey(Set<String> concatKey) {
        ArrayList<String> stringList = new ArrayList<String>(concatKey);
        return this.scpWhNetRelationRepo.findByAllConcatKey(stringList);
    }

    @Override
    public List<ScpWhNetRelationDO> findByBussinessKey(String concatKey) {
        return this.scpWhNetRelationRepo.findByAllBussinessKey(concatKey);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByConcatKey(Set<String> concatKey) {
        if (CollUtil.isEmpty(concatKey)) {
            return;
        }
        ArrayList<String> stringList = new ArrayList<String>(concatKey);
        this.scpWhNetRelationRepo.deleteByConcatKey(stringList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<ScpWhNetRelationDTO> scpWhNetRelationList) {
        this.scpWhNetRelationRepo.saveAll(scpWhNetRelationList.stream().map(ScpWhNetRelationConvert.INSTANCE::dtoToDo).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        this.scpWhNetRelationRepo.deleteAllById(ids);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpWhNetRelationExportRespVO> page = this.scpWhNetRelationRepoProc.exportSearch(queryParam);
        if (CollUtil.isNotEmpty((Collection)page.getRecords())) {
            this.pageHandeler(page);
        }
        return page;
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationPageVO> queryitemByStoreCode(AppItemPageParamVO paramVO) {
        PagingVO<ScpWhNetRelationPageVO> page = this.scpWhNetRelationRepoProc.queryitemByStoreCode(paramVO);
        return page;
    }

    @Override
    public List<ScpWhNetRelationDO> findByIds(List<Long> ids) {
        return this.scpWhNetRelationRepo.findByIdIn(ids);
    }

    private void pageHandeler(PagingVO<ScpWhNetRelationExportRespVO> page) {
        List<String> concatKey = page.getRecords().stream().map(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())).collect(Collectors.toList());
        List<ScpWhNetRelationDO> relationDOList = this.scpWhNetRelationRepo.findByConcatKey(concatKey);
        Map<String, List<ScpWhNetRelationDO>> scpWhNetMap = relationDOList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())));
        page.getRecords().forEach(d -> {
            d.setStatusName("\u542f\u7528");
            if (Boolean.FALSE.equals(d.getStatus())) {
                d.setStatusName("\u7981\u7528");
            }
            if (scpWhNetMap.get(d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode())) != null) {
                BigDecimal sum = ((List)scpWhNetMap.get(d.getDemandWhStCode() + this.setEmptyStringStr(d.getItemCateCode()) + this.setEmptyStringStr(d.getItemCode()))).stream().map(ScpWhNetRelationDO::getSupplyPercentage).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                d.setSupplyPercentageSum(sum);
            }
        });
    }

    public ScpWhNetRelationDomainServiceImpl(ScpWhNetRelationRepoProc scpWhNetRelationRepoProc, ScpWhNetRelationRepo scpWhNetRelationRepo) {
        this.scpWhNetRelationRepoProc = scpWhNetRelationRepoProc;
        this.scpWhNetRelationRepo = scpWhNetRelationRepo;
    }
}

