/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.calendar;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLinePageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLinePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineDelVO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreCalendarSetDO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreCalendarSetLineDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScpStoreCalendarSetLineRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpStoreCalendarSetLineDO scpStoreCalendarSetLineDO = QScpStoreCalendarSetLineDO.scpStoreCalendarSetLineDO;
    private static final QScpStoreCalendarSetDO scpStoreCalendarSetDO = QScpStoreCalendarSetDO.scpStoreCalendarSetDO;
    private final QBean<ScpStoreCalendarSetLinePageRespVO> pageList;

    public long count(ScpStoreCalendarSetLinePageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)scpStoreCalendarSetLineDO.count()).from((EntityPath)scpStoreCalendarSetLineDO)).leftJoin((EntityPath)scpStoreCalendarSetLineDO)).on((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.id.eq(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId));
        jpaQuery.where(this.whereCalendarSet(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpStoreCalendarSetLinePageRespVO> queryCalendarSetLine(ScpStoreCalendarSetLinePageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)scpStoreCalendarSetLineDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpStoreCalendarSetLineDO);
        jpaQuery.where(this.whereCalendarSet(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereCalendarSet(ScpStoreCalendarSetLinePageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (paramVO.getMasId() != null) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId.eq((Object)paramVO.getMasId()));
        }
        if (paramVO.getTodayWeek() != null) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.todayWeek.eq((Object)paramVO.getTodayWeek()));
        }
        if (paramVO.getStoreId() != null) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeId.eq((Object)paramVO.getStoreId()));
        }
        if (paramVO.getOuId() != null) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.ouId.eq((Object)paramVO.getOuId()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getBrandCode())) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.brandCode.eq((Object)paramVO.getBrandCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getRegionCode())) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.regionCode.eq((Object)paramVO.getRegionCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getStoreType2())) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeType2.eq((Object)paramVO.getStoreType2()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long deleteByMasIds(List<Long> masIds) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId.in(masIds));
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)scpStoreCalendarSetLineDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public long deleteByParam(ScpStoreCalendarSetLineDelVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollUtil.isNotEmpty(paramVO.getIds())) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.id.in(paramVO.getIds()));
        }
        if (paramVO.getTodayWeek() != null) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.todayWeek.eq((Object)paramVO.getTodayWeek()));
        }
        if (paramVO.getMasId() != null) {
            predicates.add(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId.eq((Object)paramVO.getMasId()));
        }
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)scpStoreCalendarSetLineDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public List<ScpStoreCalendarSetLineRespVO> findStoreByParam(Long masId, Integer todayWeek) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpStoreCalendarSetLineRespVO.class, (Expression[])new Expression[]{ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.todayWeek, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeName})).from((EntityPath)scpStoreCalendarSetLineDO);
        jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.todayWeek.eq((Object)todayWeek));
        jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId.eq((Object)masId));
        return jpaQuery.fetch();
    }

    public Long countCalendarSetLine(ScpStoreCalendarSetLineParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.id.count()).from((EntityPath)scpStoreCalendarSetLineDO);
        if (paramVO.getMasId() != null) {
            jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId.eq((Object)paramVO.getMasId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreIds())) {
            jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeId.in(paramVO.getStoreIds()));
        }
        return jpaQuery.fetchCount();
    }

    public List<ScpStoreCalendarSetLineRespVO> findStoreCodeByMasId(Long masId, Integer year) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpStoreCalendarSetLineRespVO.class, (Expression[])new Expression[]{ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeName})).from((EntityPath)scpStoreCalendarSetLineDO)).leftJoin((EntityPath)scpStoreCalendarSetDO)).on((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId.eq(ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetDO.id));
        jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId.eq((Object)masId));
        jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetDO.startYear.eq((Object)year));
        jpaQuery.groupBy(new Expression[]{ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeName});
        return jpaQuery.fetch();
    }

    public List<ScpStoreCalendarSetLineRespVO> findStoreByParam(ScpStoreCalendarSetLineParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpStoreCalendarSetLineRespVO.class, (Expression[])new Expression[]{ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.todayWeek, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeName})).from((EntityPath)scpStoreCalendarSetLineDO);
        if (paramVO.getMasId() != null) {
            jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId.eq((Object)paramVO.getMasId()));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreIds())) {
            jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeId.in(paramVO.getStoreIds()));
        }
        if (paramVO.getTodayWeek() != null) {
            jpaQuery.where((Predicate)ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.todayWeek.eq((Object)paramVO.getTodayWeek()));
        }
        return jpaQuery.fetch();
    }

    public ScpStoreCalendarSetLineRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(ScpStoreCalendarSetLinePageRespVO.class, (Expression[])new Expression[]{ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.id, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.masId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.todayWeek, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeName, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.ouCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.ouId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.custId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.custCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.brandCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.regionCode, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.storeType2, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.creator, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.createUserId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.createTime, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.updater, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.modifyUserId, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.modifyTime, ScpStoreCalendarSetLineRepoProc.scpStoreCalendarSetLineDO.remark});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

