/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarParamVO;
import com.elitesland.scp.domain.convert.calendar.ScpSuppDemandCalendarConvert;
import com.elitesland.scp.domain.entity.calendar.ScpSuppDemandCalendarDO;
import com.elitesland.scp.domain.service.calendar.ScpSuppDemandCalendarDomainService;
import com.elitesland.scp.infr.dto.calendar.ScpSuppDemandCalendarDTO;
import com.elitesland.scp.infr.repo.calendar.ScpSuppDemandCalendarRepo;
import com.elitesland.scp.infr.repo.calendar.ScpSuppDemandCalendarRepoProc;
import io.seata.common.util.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpSuppDemandCalendarDomainServiceImpl
implements ScpSuppDemandCalendarDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpSuppDemandCalendarDomainServiceImpl.class);
    private final ScpSuppDemandCalendarRepo scpSuppDemandCalendarRepo;
    private final ScpSuppDemandCalendarRepoProc scpSuppDemandCalendarRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpSuppDemandCalendarPageVO> searchPage(ScpSuppDemandCalendarPageParamVO paramVo) {
        return this.scpSuppDemandCalendarRepoProc.searchPage(paramVo);
    }

    @Override
    public List<ScpSuppDemandCalendarDTO> findCalendarListByConcatStr(List<String> concatKey) {
        List<ScpSuppDemandCalendarDO> calendarDOList = this.scpSuppDemandCalendarRepo.findByConcatYearAndMonthKey(concatKey);
        if (CollectionUtils.isNotEmpty(calendarDOList)) {
            List<ScpSuppDemandCalendarDTO> dtoList = calendarDOList.stream().map(ScpSuppDemandCalendarConvert.INSTANCE::doToDto).collect(Collectors.toList());
            return dtoList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ScpSuppDemandCalendarDTO> findCalendarByStoreDayConcatStr(List<String> storeDayConcatStr) {
        List<ScpSuppDemandCalendarDO> calendarDOList = this.scpSuppDemandCalendarRepo.findCalendarByStoreDayConcatStr(storeDayConcatStr);
        if (CollectionUtils.isNotEmpty(calendarDOList)) {
            List<ScpSuppDemandCalendarDTO> dtoList = calendarDOList.stream().map(ScpSuppDemandCalendarConvert.INSTANCE::doToDto).collect(Collectors.toList());
            return dtoList;
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<ScpSuppDemandCalendarDTO> createParams) {
        List saveList = createParams.stream().map(ScpSuppDemandCalendarConvert.INSTANCE::dtoToDo).collect(Collectors.toList());
        this.scpSuppDemandCalendarRepo.saveAll(saveList);
    }

    @Override
    @SysCodeProc
    public List<ScpSuppDemandCalendarDTO> findSuppCalendarListByParam(ScpSuppDemandCalendarParamVO param) {
        return this.scpSuppDemandCalendarRepoProc.findSuppCalendarListByParam(param);
    }

    @Override
    public void deleteBatch(List<Long> ids) {
        this.scpSuppDemandCalendarRepo.deleteAllByIdInBatch(ids);
    }

    public ScpSuppDemandCalendarDomainServiceImpl(ScpSuppDemandCalendarRepo scpSuppDemandCalendarRepo, ScpSuppDemandCalendarRepoProc scpSuppDemandCalendarRepoProc) {
        this.scpSuppDemandCalendarRepo = scpSuppDemandCalendarRepo;
        this.scpSuppDemandCalendarRepoProc = scpSuppDemandCalendarRepoProc;
    }
}

