/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderSubmitMqParam;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRedisDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingStoreDomainService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ScpOrderSubmitListener
implements MessageQueueListener<ScpOrderSubmitMqParam> {
    private static final Logger log = LoggerFactory.getLogger(ScpOrderSubmitListener.class);
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService;
    private final RedisTemplate redisClient;
    private final TransactionTemplate transactionTemplate;

    @NotEmpty
    public String[] channels() {
        return new String[]{"scp_demand_order_submit"};
    }

    public void onConsume(@NotBlank String s, @NotNull ScpOrderSubmitMqParam orderSubmitMqParam) {
        if (CollUtil.isNotEmpty(orderSubmitMqParam.getActivityIds())) {
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(trans -> {
                try {
                    ScpAllocSettingRedisDO scpAllocSettingRedisDO = new ScpAllocSettingRedisDO();
                    String key = "SCP:ALLOC:SETTING:" + orderSubmitMqParam.getDemandWhStCode();
                    Object obj = this.redisClient.opsForValue().get((Object)key);
                    if (obj != null) {
                        String str = (String)obj;
                        ScpAllocSettingRedisDO setting = (ScpAllocSettingRedisDO)JSON.parseObject((String)str, ScpAllocSettingRedisDO.class);
                        List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList().stream().filter(row -> {
                            if (row.getValidFrom().compareTo(LocalDateTime.now()) > 0 || row.getValidTo().compareTo(LocalDateTime.now()) < 0) {
                                return false;
                            }
                            if (!orderSubmitMqParam.getActivityIds().contains(row.getActivityId())) {
                                return true;
                            }
                            return row.getAllocNum() + 1 < row.getMaxNum();
                        }).map(row -> {
                            row.setAllocNum(row.getAllocNum() + 1);
                            return row;
                        }).collect(Collectors.toList());
                        scpAllocSettingRedisDO.setActivityList(activityList);
                        this.redisClient.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)scpAllocSettingRedisDO));
                    }
                    this.scpAllocSettingStoreDomainService.updateAllocNumByParam(orderSubmitMqParam.getActivityIds(), orderSubmitMqParam.getDemandWhStCode());
                    return null;
                }
                catch (Exception e) {
                    trans.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.getMessage());
                }
            });
        }
        this.scpDemandOrderService.push(orderSubmitMqParam.getDemandOrderId(), orderSubmitMqParam.getAgentEmpId(), Boolean.TRUE);
    }

    public ScpOrderSubmitListener(ScpDemandOrderService scpDemandOrderService, ScpAllocSettingStoreDomainService scpAllocSettingStoreDomainService, RedisTemplate redisClient, TransactionTemplate transactionTemplate) {
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpAllocSettingStoreDomainService = scpAllocSettingStoreDomainService;
        this.redisClient = redisClient;
        this.transactionTemplate = transactionTemplate;
    }
}

