package com.elitesland.scp.application.service.collect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.ScpStoreItemParamVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectCancelVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectParamVO;
import com.elitesland.scp.application.facade.vo.resp.collect.ScpUserCollectRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.collect.ScpUserCollectSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.collect.ScpUserCollectConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.collect.ScpUserCollectDO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSpuBusinessRpcDTO;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpUserCollectServiceImpl implements ScpUserCollectService {

    private final CartRedisUtil cartRedisUtil;
    private final ScpCacheService scpCacheService;
    private final CollectRedisUtil collectRedisUtil;
    private final CommonPriceService commonPriceService;
    private final RmiItemService rmiItemService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;

    @Override
    public List<ScpUserCollectRespVO> getUserList(ScpUserCollectParamVO paramVO) {
        // 获取当前登录任信息
        Long currentUserId = UserService.currentUserId();
        List<ScpUserCollectDO> userCollectItems = collectRedisUtil.getUserCollectItems(paramVO.getDemandWhStCode(), currentUserId);
        if (CollUtil.isEmpty(userCollectItems)) {
            return new ArrayList<>();
        }
        // 实时获取商品价格
        Map<String, List<PriPriceRpcDTO>> priceMap = getItemPrice(paramVO, userCollectItems);
        List<ScpUserCollectRespVO> resultList = new ArrayList<>();
        Map<String, List<ScpUserCollectDO>> spuMap =
                userCollectItems.stream().collect(Collectors.groupingBy(ScpUserCollectDO::getSpuCode));

        //查询商品的moq
        List<String> spuCodes = userCollectItems.stream().map(ScpUserCollectDO::getSpuCode).distinct().collect(Collectors.toList());
        Map<String, List<ItmItemSpuBusinessRpcDTO>> moqMap = rmiItemService.findMoqByParam(spuCodes, paramVO.getOuCode());
        //封装返回
        for (Map.Entry<String, List<ScpUserCollectDO>> entry : spuMap.entrySet()) {
            ScpUserCollectRespVO vo = new ScpUserCollectRespVO();
            List<ScpUserCollectDO> storeCartDOS = entry.getValue();
            // SPU信息赋值
            ScpUserCollectDO scpUserCollectDO = storeCartDOS.get(0);
            vo.setSpuId(scpUserCollectDO.getSpuId());
            vo.setSpuCode(scpUserCollectDO.getSpuCode());
            vo.setSpuName(scpUserCollectDO.getSpuName());
            vo.setSpec(scpUserCollectDO.getSpec());
            vo.setAnotherName(scpUserCollectDO.getAnotherName());
            // 如果SPU存在主图取主图，否则任取一张图片
            if (CollUtil.isNotEmpty(scpUserCollectDO.getSpuAttchmentList())) {
                Optional<ItmItemAttachmentRpcDTO> attachOpt = scpUserCollectDO.getSpuAttchmentList().stream().filter(attach -> attach.getMajor()).findFirst();
                vo.setUrl(attachOpt.isPresent() ? attachOpt.get().getUrl() : scpUserCollectDO.getSpuAttchmentList().get(0).getUrl());
            }
            // 如果SPU存在主图取主图，否则任取一张图片
            if (CollUtil.isNotEmpty(scpUserCollectDO.getSpuAttchmentList())) {
                Optional<ItmItemAttachmentRpcDTO> attachOpt = scpUserCollectDO.getSpuAttchmentList().stream().filter(attach -> attach.getMajor()).findFirst();
                vo.setUrl(attachOpt.isPresent() ? attachOpt.get().getUrl() : scpUserCollectDO.getSpuAttchmentList().get(0).getUrl());
            }
            vo.setItemCateCode(scpUserCollectDO.getItemCateCode());
            vo.setItemCateName(scpUserCollectDO.getItemCateName());
            vo.setDocType(scpUserCollectDO.getDocType());
            var moqList = moqMap.get(scpUserCollectDO.getSpuCode());
            // SKU商品信息赋值
            List<ScpUserCollectRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<>();
            for (ScpUserCollectDO collectDO : storeCartDOS) {
                ScpUserCollectRespVO.ItemSpecObjectVO detailVo = new ScpUserCollectRespVO.ItemSpecObjectVO();
                detailVo.setUom(collectDO.getUom());
                detailVo.setUomName(collectDO.getUomName());
                detailVo.setItemCode(collectDO.getItemCode());
                detailVo.setItemId(collectDO.getItemId());
                detailVo.setItemName(collectDO.getItemName());
                detailVo.setItemAttrName(collectDO.getItemAttrName());
                List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(collectDO.getItemCode());
                if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                    detailVo.setItemPrice(SysUtils.processPriceScale(priceRpcDTOS.get(0).getPrice()));
                }
                //查询购物车商品数量
                ScpStoreCartDO storeCartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(collectDO.getCombineItemCode() , collectDO.getItemCode()), paramVO.getDemandWhStCode(), collectDO.getDocType(), currentUserId);
                if (storeCartItem != null) {
                    detailVo.setQty(storeCartItem.getQty());
                } else {
                    detailVo.setQty(BigDecimal.ZERO);
                }
                detailVo.setUom2(collectDO.getUom2());
                detailVo.setUom2Name(collectDO.getUom2Name());
                detailVo.setDecimalPlaces(collectDO.getDecimalPlaces());
                detailVo.setUomRatio(collectDO.getUomRatio());
                detailVo.setItemType(collectDO.getItemType());
                // 最小起订量
                if (CollUtil.isNotEmpty(moqList)) {
                    detailVo.setMoq(moqList.get(0).getMoq());
                }
                itemSpecObjectVOS.add(detailVo);
            }
            vo.setItemSpecObjectVOS(itemSpecObjectVOS);
            resultList.add(vo);
        }
        return resultList;
    }

    /**
     * 获取商品价格
     *
     * @param paramVO
     * @param userCollectItems
     * @return
     */
    private Map<String, List<PriPriceRpcDTO>> getItemPrice(ScpUserCollectParamVO paramVO, List<ScpUserCollectDO> userCollectItems) {
        Map<String, List<PriPriceRpcDTO>> resultMap = new HashMap<>();
        //实时获取价格
        Map<String, List<ScpUserCollectDO>> docTypeMap = userCollectItems.stream().collect(Collectors.groupingBy(ScpUserCollectDO::getDocType));
        docTypeMap.forEach((docType, userCollectDOS) -> {
            //获取单据类型配置
            ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(docType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            var priceParamVOS = userCollectDOS.stream().map(row -> {
                AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                priceParamVO.setItemCode(row.getItemCode());
                priceParamVO.setItemId(row.getItemId());
                priceParamVO.setItemCateCode(row.getItemCateCode());
                priceParamVO.setUom(row.getUom());
                return priceParamVO;
            }).collect(Collectors.toList());
            Map<String, List<PriPriceRpcDTO>> priceMap = commonPriceService.getPriceAndStockDetails(priceParamVOS, paramVO.getDemandWhStCode(), orderSetting,
                    ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            resultMap.putAll(priceMap);
        });
        return resultMap;
    }

    @Override
    public Long add(ScpUserCollectSaveVO saveVO) {
        // 获取当前登录人信息
        Long currentUserId = UserService.currentUserId();
        // 要操作的收藏信息
        var cartOps = collectRedisUtil.getUserCollectOps(saveVO.getDemandWhStCode(), currentUserId);
        // 判断Redis是否有该商品的信息
        String product = (String) cartOps.get(SysUtils.generateRedisKey(ScpConstant.SPU, saveVO.getCombineItemCode(), saveVO.getItemCode()));
        if (StrUtil.isBlank(product)) {
            ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
            scpStoreItemParamVO.setSpuId(saveVO.getSpuId());
            scpStoreItemParamVO.setOuCode(saveVO.getOuCode());
            List<ScpStoreItemDO> itemDOS = scpCacheService.getItem(scpStoreItemParamVO);
            if (CollUtil.isEmpty(itemDOS)) {
                throw new BusinessException("未查询到商品");
            }
            // 编辑收藏夹商品
            List<ScpUserCollectDO> userCollectDOS = itemDOS.stream().map(row -> {
                ScpUserCollectDO scpUserCollectDO = ScpUserCollectConvert.INSTANCE.itemDoToCollectDo(row);
                scpUserCollectDO.setDocType(saveVO.getDocType());
                scpUserCollectDO.setUserId(currentUserId);
                scpUserCollectDO.setDemandWhStCode(saveVO.getDemandWhStCode());
                scpUserCollectDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                scpUserCollectDO.setSkuAttchmentList(row.getSkuAttachmentList());
                scpUserCollectDO.setSpuAttchmentList(row.getSpuAttachmentList());
                return scpUserCollectDO;
            }).collect(Collectors.toList());
            // 收藏夹保存
            cartOps.put(SysUtils.generateRedisKey(ScpConstant.SPU, saveVO.getCombineItemCode(), saveVO.getItemCode()), JSON.toJSONString(userCollectDOS));
        }
        return 1L;
    }

    @Override
    public Boolean deleteBySpuIdAndUid(ScpUserCollectCancelVO cancelVO) {
        // 获取当前登录人信息
        Long currentUserId = UserService.currentUserId();
        // 要操作的收藏信息
        var cartOps = collectRedisUtil.getUserCollectOps(cancelVO.getDemandWhStCode(), currentUserId);
        Long delete = cartOps.delete(SysUtils.generateRedisKey(ScpConstant.SPU, cancelVO.getCombineItemCode(), cancelVO.getItemCode()));
        return delete > 0;
    }
}
