package com.elitesland.scp.application.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.whnet.*;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 22日 15:35
 * @version: 1.0
 */
@Component
@RequiredArgsConstructor
public class ScpWhNetRelationServiceExportImpl implements DataExport<ScpWhNetRelationExportRespVO, ScpWhNetRelationPageParamVO> {

    private final ScpWhNetRelationService scpWhNetRelationService;

    @Override
    public String getTmplCode() {
        return "scp_wh_net_relation_export";
    }

    @Override
    public PagingVO<ScpWhNetRelationExportRespVO> executeExport(ScpWhNetRelationPageParamVO queryParam) {
        return scpWhNetRelationService.exportSearch(queryParam);
    }


}
