package com.elitesland.scp.application.facade.vo.param.item;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
@ApiModel("小程序商品分页入参")
public class ScpCateItemPageParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("是否热销，热销：true，非热销：false")
    private Boolean hotFlag;

    @ApiModelProperty("门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("商品分类")
    private String itemType2;

    private List<String> scpCateCodes;
}
