package com.elitesland.scp.application.facade.vo.resp.app;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("订货单关联单据信息")
public class AppRelateOrderRespVO implements Serializable {
    private static final long serialVersionUID = 4891499920429376377L;

    @ApiModelProperty("销售公司编码")
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    private String saleOuName;

    @ApiModelProperty("关联单据号")
    private String srcDocNo;

    @ApiModelProperty("关联单据类别")
    private String srcDocCls;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("付款状态")
    @SysCode(sys = "yst-suplan", mod = "PAY_STATUS")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("分配时间")
    private LocalDateTime createTime;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("付款人")
    private String payerName;

    @ApiModelProperty("明细")
    private List<ItemRespVO> itemList;

    @Data
    public static class ItemRespVO {

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("商品属性")
        private String itemAttrName;

        @ApiModelProperty("别名")
        private String anotherName;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("金额")
        private BigDecimal amt;

        @ApiModelProperty("订货单位")
        private String uom;
        private String uomName;

        @ApiModelProperty("子品明细")
        private List<ItemRespVO> itemList;
    }

}
