package com.elitesland.scp.application.service.export;

import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationImportVO;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 22日 16:55
 * @version: 1.0
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ScpWhNetRelationImportServiceImpl implements DataImport<ScpWhNetRelationImportVO> {

    private final ScpWhNetRelationService scpWhNetRelationService;


    @Override
    public String getTmplCode() {
        return "scp_wh_net_relation_import";
    }

    @Override
    public List<String> executeImport(List<ScpWhNetRelationImportVO> dataList, int startRowIndex) {
        return scpWhNetRelationService.executeImport(dataList, startRowIndex);
    }

    @Override
    public Integer stepSize() {
        return 1000;
    }

    @Override
    public Set<Integer> sheetNoList() {
        return Set.of(1);
    }
}
