package com.elitesland.scp.application.service.stock;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.scp.application.facade.vo.stock.mq.ScpPredictStStockCalcSendParam;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 02月 05日 17:30
 * @version: 1.0
 */
public class ScpPredictStockSendUtil {

    public static final String PREDICT_STOCK_CHANNEL = "PREDICT_STOCK_CHANNEL";
    private static MessageQueueTemplate messageQueueTemplate;


    static {
        messageQueueTemplate = SpringContextHolder.getBean(MessageQueueTemplate.class);
    }


    public static void send(ScpPredictStStockCalcSendParam sendParam, String channel){
        sendParam.setBusinessKey("PREDICT_STOCK_CHANNEL" + channel);
        messageQueueTemplate.publishMessage("yst-scp", channel, sendParam);
    }
}
