package com.elitesland.scp.application.web.user;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.web.bind.annotation.*;
import lombok.extern.slf4j.Slf4j;

import com.aliyun.dingtalkoauth2_1_0.models.GetSsoAccessTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoAccessTokenResponse;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoUserInfoHeaders;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoUserInfoRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetSsoUserInfoResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;

import java.util.Objects;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/api")
public class UserOssController {
    @Value("${dingtalk.corpId}")
    private String corpId;
    @Value("${dingtalk.ssoSecret}")
    private String ssoSecret;

    @Autowired
    private UserRpcService userRpcService;

    @Autowired
    private TextEncryptor textEncryptor;

    @Autowired
    private SysUserPermissionRpcService sysUserPermissionRpcService;

    @GetMapping("/ssoUserInfo")
    public ApiResult<Object> ssoUserInfo(
        @RequestParam String code) {
        
        if (code == null || code.isEmpty()) {
            log.error("请求缺少 code 参数");
            return ApiResult.fail("请求参数错误：缺少授权码");
        }
        
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        
        try {
            String accessToken = getAccessToken();
            if (accessToken == null || accessToken.isEmpty()) {
                log.error("获取访问令牌失败, corpId: {}", corpId);
                return ApiResult.fail( "系统无法获取钉钉访问令牌");
            }

            com.aliyun.dingtalkoauth2_1_0.Client client = new com.aliyun.dingtalkoauth2_1_0.Client(config);
            GetSsoUserInfoHeaders getSsoUserInfoHeaders = new GetSsoUserInfoHeaders();
            getSsoUserInfoHeaders.xAcsDingtalkAccessToken = accessToken;
            
            GetSsoUserInfoRequest getSsoUserInfoRequest = new GetSsoUserInfoRequest()
                    .setCode(code);
            
            GetSsoUserInfoResponse getSsoUserInfoResponse = client.getSsoUserInfoWithOptions(
                getSsoUserInfoRequest, 
                getSsoUserInfoHeaders, 
                new RuntimeOptions()
            );
            //获取登录 toekn
            log.info("获取用户信息成功, body: {}", getSsoUserInfoResponse.getBody());
            ApiResult<SysUserBasicDTO> mobile = userRpcService.getByUsername(Objects.requireNonNull(getSsoUserInfoResponse.getBody()).getUserName());
            if (mobile == null || mobile.getData() == null){
                return ApiResult.fail();
            }
            Long id = mobile.getData().getId();

            String encrypt = textEncryptor.encrypt(String.valueOf(id));
            AuthUserIdQueryDTO authUserIdQueryDTO = new AuthUserIdQueryDTO();
            authUserIdQueryDTO.setUserIdCypher(encrypt);
            ApiResult<OAuthToken> oAuthTokenApiResult = sysUserPermissionRpcService.authByUserId(authUserIdQueryDTO);
            if (oAuthTokenApiResult.isSuccess()) {
                JSONObject body = new JSONObject();
                body.put("accessToken", Objects.requireNonNull(oAuthTokenApiResult.getData()).getTokenType()+" "+Objects.requireNonNull(oAuthTokenApiResult.getData()).getAccessToken());
                return ApiResult.ok(body);
            }
            return ApiResult.ok(getSsoUserInfoResponse.getBody());
            
        } catch (Exception e) {
            log.error("获取用户信息过程中出现异常, code: {}", code, e);
            return ApiResult.fail(
                "获取用户信息失败"
            );
        }
    }

    private String getAccessToken() {        
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        
        try {
            com.aliyun.dingtalkoauth2_1_0.Client client = new com.aliyun.dingtalkoauth2_1_0.Client(config);
            GetSsoAccessTokenRequest getSsoAccessTokenRequest = new GetSsoAccessTokenRequest()
                .setCorpid(corpId)
                .setSsoSecret(ssoSecret);     
                
            GetSsoAccessTokenResponse getSsoAccessTokenResponse = client.getSsoAccessToken(getSsoAccessTokenRequest);
            String accessToken = getSsoAccessTokenResponse.getBody().getAccessToken();
            return accessToken;
            
        } catch (Exception e) {
            log.error("获取访问令牌过程中出现异常, corpId: {}", corpId, e);
            return null;
        }
    }
}
