package com.elitesland.scp.infr.repo.supalloc;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationExportRespVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageParamVO;
import com.elitesland.scp.application.facade.vo.supalloc.ScpSupplyAllocationPageVO;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.elitesland.scp.domain.entity.supalloc.QScpSupplyAllocationDO;
import com.elitesland.scp.domain.entity.supalloc.ScpSupplyAllocationDO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-25
* @Version 1.0
**/
@Component
public class ScpSupplyAllocationRepoProc extends BaseRepoProc<ScpSupplyAllocationDO> {

    private static final QScpSupplyAllocationDO qScpSupplyAllocationDO = QScpSupplyAllocationDO.scpSupplyAllocationDO;
    public ScpSupplyAllocationRepoProc(){
        super(qScpSupplyAllocationDO);
    }


    @NotNull
    private QBean<ScpSupplyAllocationPageVO> getBean() {
        return Projections.bean(
                ScpSupplyAllocationPageVO.class,
                qScpSupplyAllocationDO.id,
                qScpSupplyAllocationDO.type,
                qScpSupplyAllocationDO.suppId,
                qScpSupplyAllocationDO.suppCode,
                qScpSupplyAllocationDO.suppName,
                qScpSupplyAllocationDO.ouId,
                qScpSupplyAllocationDO.ouCode,
                qScpSupplyAllocationDO.ouName,
                qScpSupplyAllocationDO.storeWhCode,
                qScpSupplyAllocationDO.storeWhId,
                qScpSupplyAllocationDO.storeWhName,
                qScpSupplyAllocationDO.itemCateCode,
                qScpSupplyAllocationDO.itemCateName,
                qScpSupplyAllocationDO.itemId,
                qScpSupplyAllocationDO.itemCode,
                qScpSupplyAllocationDO.itemName,
                qScpSupplyAllocationDO.allocation,
                qScpSupplyAllocationDO.minimumOrderQuantity,
                qScpSupplyAllocationDO.purchaseLeadTime,
                qScpSupplyAllocationDO.startTime,
                qScpSupplyAllocationDO.status,
                qScpSupplyAllocationDO.endTime,
                qScpSupplyAllocationDO.createTime,
                qScpSupplyAllocationDO.createUserId,
                qScpSupplyAllocationDO.creator,
                qScpSupplyAllocationDO.modifyTime,
                qScpSupplyAllocationDO.modifyUserId,
                qScpSupplyAllocationDO.updater,
                qScpSupplyAllocationDO.tenantId,
                qScpSupplyAllocationDO.auditDataVersion,
                qScpSupplyAllocationDO.belongOrgId,
                qScpSupplyAllocationDO.remark,
                qScpSupplyAllocationDO.secBuId,
                qScpSupplyAllocationDO.secOuId,
                qScpSupplyAllocationDO.secUserId
        );
    }

    public PagingVO<ScpSupplyAllocationPageVO> page(ScpSupplyAllocationPageParamVO param) {
        JPAQuery<ScpSupplyAllocationPageVO> jpaQuery = jpaQueryFactory.select(getBean())
                .from(qScpSupplyAllocationDO);
        if(param != null){
           jpaQuery.where(where(param));
        }
        assert param != null;
        return queryByPage(jpaQuery,param.getPageRequest());

    }

    private Predicate where(ScpSupplyAllocationPageParamVO param){
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(CollectionUtils.isNotEmpty(param.getItemIds())){
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.itemId.in(param.getItemIds()));
        }

        if (CollectionUtils.isNotEmpty(param.getTypes())) {
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.type.in(param.getTypes()));
        }
        if (CollectionUtils.isNotEmpty(param.getStoreWhIds())) {
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.storeWhId.in(param.getStoreWhIds()));
        }
        if (CollectionUtils.isNotEmpty(param.getSuppIds())) {
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.suppId.in(param.getSuppIds()));
        }
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            predicate = whereScpmanAuthority(param, predicate);
        }
        if (CollUtil.isNotEmpty(param.getOuCodes())) {
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.ouCode.in(param.getOuCodes()));
        }
        return predicate;

    }

    private Predicate whereScpmanAuthority(BaseScpmanAuthorityParam param, Predicate predicate) {
        if(CollectionUtils.isNotEmpty(param.getStores()) && CollectionUtils.isNotEmpty(param.getWhCodes())){
            predicate = ExpressionUtils.or(
                    qScpSupplyAllocationDO.type.eq("1").and(qScpSupplyAllocationDO.storeWhCode.in(param.getWhCodes())),
                    qScpSupplyAllocationDO.type.eq("0").and(qScpSupplyAllocationDO.storeWhCode.in(param.getStores()))
            );
        }else if(CollectionUtils.isNotEmpty(param.getWhCodes())){
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.type.eq("1"));
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.storeWhCode.in(param.getWhCodes()));
        }else if(CollectionUtils.isNotEmpty(param.getStores())){
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.type.eq("0"));
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.storeWhCode.in(param.getStores()));
        }
        return predicate;
    }


    public PagingVO<ScpSupplyAllocationExportRespVO> exportSearch(ScpSupplyAllocationPageParamVO param){
        JPAQuery<ScpSupplyAllocationExportRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpSupplyAllocationExportRespVO.class,
                qScpSupplyAllocationDO.type,
                qScpSupplyAllocationDO.suppId,
                qScpSupplyAllocationDO.suppCode,
                qScpSupplyAllocationDO.suppName,
                qScpSupplyAllocationDO.ouId,
                qScpSupplyAllocationDO.ouCode,
                qScpSupplyAllocationDO.ouName,
                qScpSupplyAllocationDO.storeWhCode,
                qScpSupplyAllocationDO.storeWhId,
                qScpSupplyAllocationDO.storeWhName,
                qScpSupplyAllocationDO.itemCateCode,
                qScpSupplyAllocationDO.itemCateName,
                qScpSupplyAllocationDO.itemId,
                qScpSupplyAllocationDO.status,
                qScpSupplyAllocationDO.itemCode,
                qScpSupplyAllocationDO.itemName,
                qScpSupplyAllocationDO.allocation,
                qScpSupplyAllocationDO.minimumOrderQuantity,
                qScpSupplyAllocationDO.purchaseLeadTime
                )).from(qScpSupplyAllocationDO);
        if(param != null){
            jpaQuery.where(where(param));
        }
        return queryByPage(jpaQuery,param.getPageRequest());

    }

    public List<ScpSupplyAllocationRpcDTO> findSupplyAllocationRpcByParam(ScpSupplyAllocationRpcDtoParam param){
        JPAQuery<ScpSupplyAllocationRpcDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpSupplyAllocationRpcDTO.class,
                qScpSupplyAllocationDO.id,
                qScpSupplyAllocationDO.type,
                qScpSupplyAllocationDO.suppId,
                qScpSupplyAllocationDO.suppCode,
                qScpSupplyAllocationDO.suppName,
                qScpSupplyAllocationDO.ouId,
                qScpSupplyAllocationDO.ouCode,
                qScpSupplyAllocationDO.ouName,
                qScpSupplyAllocationDO.storeWhCode,
                qScpSupplyAllocationDO.storeWhId,
                qScpSupplyAllocationDO.storeWhName,
                qScpSupplyAllocationDO.itemCateCode,
                qScpSupplyAllocationDO.itemCateName,
                qScpSupplyAllocationDO.itemId,
                qScpSupplyAllocationDO.itemCode,
                qScpSupplyAllocationDO.itemName,
                qScpSupplyAllocationDO.allocation,
                qScpSupplyAllocationDO.minimumOrderQuantity,
                qScpSupplyAllocationDO.purchaseLeadTime,
                qScpSupplyAllocationDO.startTime,
                qScpSupplyAllocationDO.endTime,
                qScpSupplyAllocationDO.createTime,
                qScpSupplyAllocationDO.createUserId,
                qScpSupplyAllocationDO.creator,
                qScpSupplyAllocationDO.modifyTime,
                qScpSupplyAllocationDO.modifyUserId,
                qScpSupplyAllocationDO.updater,
                qScpSupplyAllocationDO.tenantId,
                qScpSupplyAllocationDO.auditDataVersion,
                qScpSupplyAllocationDO.belongOrgId,
                qScpSupplyAllocationDO.remark,
                qScpSupplyAllocationDO.secBuId,
                qScpSupplyAllocationDO.secOuId,
                qScpSupplyAllocationDO.secUserId,
                qScpSupplyAllocationDO.saleOuCode,
                qScpSupplyAllocationDO.saleOuName,
                qScpSupplyAllocationDO.saleCustCode
        )).from(qScpSupplyAllocationDO);
        jpaQuery.where(qScpSupplyAllocationDO.status.eq(Boolean.TRUE));
        if(param != null){
           jpaQuery.where(where(param));
        }
        return jpaQuery.fetch();

    }

    private Predicate where(ScpSupplyAllocationRpcDtoParam param){
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(StringUtils.isNotEmpty(param.getItemCode())){
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.itemCode.eq(param.getItemCode()));
        }

        if(StringUtils.isNotEmpty(param.getType())){
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.type.eq(param.getType()));
        }

        if(StringUtils.isNotEmpty(param.getStoreWhCode())){
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.storeWhCode.eq(param.getStoreWhCode()));
        }
        if(StringUtils.isNotEmpty(param.getItemCateCode())){
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.itemCateCode.eq(param.getItemCateCode()));
        }
        if(CollUtil.isNotEmpty(param.getItemCodes())){
            predicate = ExpressionUtils.and(predicate, qScpSupplyAllocationDO.itemCode.in(param.getItemCodes()));
        }
        return predicate;

    }

    @Transactional(rollbackFor = Exception.class)
    public Long updateStoreNameByStoreId(Long storeId,String storeName){
        return jpaQueryFactory.update(qScpSupplyAllocationDO)
                .set(qScpSupplyAllocationDO.storeWhName, storeName)
                .where(qScpSupplyAllocationDO.storeWhId.eq(storeId))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public Long updateItemNameByItemId(Long itemId,String itemName){
        return jpaQueryFactory.update(qScpSupplyAllocationDO)
                .set(qScpSupplyAllocationDO.itemName, itemName)
                .where(qScpSupplyAllocationDO.itemId.eq(itemId))
                .execute();
    }
}