package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.support.provider.out.ItmItemCateUpdateMqParam;
import com.elitesland.support.provider.out.ItmItemSpuUpdateMqParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * 门店收货单发货回写
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ItmItemCateUpdateListener implements MessageQueueListener<ItmItemCateUpdateMqParam> {

    private final ScpCateItemRepoProc scpCateItemRepoProc;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{ItmItemSpuUpdateMqParam.ITEM_UPDATE_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull ItmItemCateUpdateMqParam itmItemCateUpdateMqParam) {
        log.info("商品品类变更：" + JSON.toJSONString(itmItemCateUpdateMqParam));
        if (CollUtil.isEmpty(itmItemCateUpdateMqParam.getBrandCodes())) {
            log.info("商品品类变更：品牌为空");
            return;
        }
        String brand = String.join(";", itmItemCateUpdateMqParam.getBrandCodes());
        scpCateItemRepoProc.updateItemBrand(brand, itmItemCateUpdateMqParam.getRootCateId());
    }

}
