package com.elitesland.scp.pay.controller;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitesland.scp.pay.service.AccountBatchBindService;
import com.elitesland.scp.pay.service.PaymentService;
import com.elitesland.scp.pay.service.RefundsService;
import com.tenpay.business.entpay.mse.sdk.common.NotifyHandler;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.exception.ApiException;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.RefundNotifyModel;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@RestController
@RequestMapping("/notify")
@RequiredArgsConstructor
public class NotifyVerifyController {

    private final PaymentService paymentService;
    private final RefundsService refundsService;
    private final AccountBatchBindService accountBatchBindService;

    // 支付回调
    @ResponseBody
    @PostMapping("/payments/app-registering-pay")
    public String paymentNotify(HttpServletRequest request, @RequestBody String body,
                                @RequestHeader("TBEP-Authorization") String authorization) throws EntpayException, JSONException {
        log.info("支付回调通知数据,body：{},authorization:{}", JSONUtil.toJsonStr(body), JSONUtil.toJsonStr(authorization));
        return paymentService.paymentNotify(body, authorization);
    }

    // 退款回调
    @ResponseBody
    @PostMapping("/refund")
    public String refundNotify(HttpServletRequest request, @RequestBody String body,
                               @RequestHeader("TBEP-Authorization") String authorization) throws EntpayException, JSONException {
        return refundsService.refundNotify(body, authorization);
    }

    // 批量开户
    @ResponseBody
    @PostMapping("/bind")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE,
            operationDescription = "批量开户回调通知", allowRepeatRequest = false,
            repeatIntervalMillis = 3000,businessParamValueKey = "#p0")
    public String bindNotify(HttpServletRequest request, @RequestBody String body,
                               @RequestHeader("TBEP-Authorization") String authorization) throws EntpayException, JSONException {
        log.info("批量开户回调通知数据,body：{},authorization:{}", JSONUtil.toJsonStr(body), JSONUtil.toJsonStr(authorization));
        return accountBatchBindService.accountBindNotify(body, authorization);
    }
}
