package com.elitesland.scp.pay.service;

import com.elitesland.scp.pay.vo.AccountBindNotifyModel;
import com.elitesland.scp.pay.vo.PayNoficeParamVO;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.PaymentNotifyModel;
import com.tenpay.business.entpay.mse.sdk.model.RefundNotifyModel;

public interface NotifyVerifyService {

    /**
     * 处理支付回调
     *
     * @param notifyData
     */
    void processNotify(PaymentNotifyModel notifyData) throws EntpayException;

    /**
     * 处理退款回调
     *
     * @param notifyData
     */
    void processRefundNotify(RefundNotifyModel notifyData);

    /**
     * 运维-处理支付回调
     *
     * @param paramVO
     */
    void devopsPayNotify(PayNoficeParamVO paramVO) throws EntpayException;

    /**
     * 处理绑定回调
     *
     * @param notifyData
     */
    void processAccountBindNotify(AccountBindNotifyModel notifyData) throws EntpayException;
}
