package com.elitesland.scp.application.facade.vo.supalloc;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 25日 11:24
 * @version: 1.0
 */
@Data
public class ScpSupplyAllocationPageParamVO extends AbstractOrderQueryParam implements BaseScpmanAuthorityParam {

    @ApiModelProperty(value = "供应仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> suppIds;

    @ApiModelProperty(value = "类型")
    private List<String> types;

    @ApiModelProperty(value = "门店id/门店仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> storeWhIds;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> itemIds;

    @ApiModelProperty(value = "计划员数据权限")
    private Boolean scpmanAuthority;

    @ApiModelProperty(value = "仓库集合")
    private List<String> whCodes;

    @ApiModelProperty(value = "门店集合")
    private List<String> stores;

    @ApiModelProperty(value = "采购公司编码集合")
    private List<String> ouCodes;
}
