package com.elitesland.scp.domain.entity.template;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 16:08
 * @Description:
 */
@Entity
@Table(name = "scp_template_order")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "scp_template_order", comment = "模板表单")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "scp_template_order", description = "模板表单表")
public class ScpTemplateOrderDO extends BaseModel {
    private static final long serialVersionUID = 815011868646699454L;

    @ApiModelProperty("主表id")
    @Column(name = "mas_id", columnDefinition = "bigint(20) not null comment '主表id'")
    private Long masId;

    @ApiModelProperty("类型")
    @Column(name = "type", columnDefinition = "int comment '类型'")
    private Integer type;

    @ApiModelProperty("门店/仓库/区域id")
    @Column(name = "wh_st_zo_id", columnDefinition = "bigint comment '门店/仓库/区域id'")
    private Long whStZoId;

    @ApiModelProperty("门店/仓库/区域编号")
    @Column(name = "wh_st_zo_code", columnDefinition = "varchar(30) comment '门店/仓库/区域编号'")
    private String whStZoCode;

    @ApiModelProperty("门店/仓库/区域名称")
    @Column(name = "wh_st_zo_name", columnDefinition = "varchar(50) comment '门店/仓库/区域名称'")
    private String whStZoName;

    @ApiModelProperty("详细地址")
    @Column(name = "detailed_address", columnDefinition = "varchar(50) comment '详细地址'")
    private String detailedAddress;

    @ApiModelProperty("所属组织编码")
    @Column(name = "belong_org_code", columnDefinition = "varchar(50) comment '所属组织编码'")
    private String belongOrgCode;

    @ApiModelProperty("所属组织名称")
    @Column(name = "belong_org_name", columnDefinition = "varchar(50) comment '所属组织名称'")
    private String belongOrgName;

    @ApiModelProperty("所属公司编码")
    @Column(name = "belong_ou_code", columnDefinition = "varchar(50) comment '所属公司编码'")
    private String belongOuCode;

    @ApiModelProperty("所属公司名称")
    @Column(name = "belong_ou_name", columnDefinition = "varchar(50) comment '所属公司名称'")
    private String belongOuName;

    @ApiModelProperty("经营性质")
    @Column(name = "store_type", columnDefinition = "varchar(30) comment '经营性质'")
    private String storeType;

    @ApiModelProperty("商品id")
    @Column(name = "item_id", columnDefinition = "bigint comment '商品id'")
    private Long itemId;

    @ApiModelProperty("商品编号")
    @Column(name = "item_code", columnDefinition = "varchar(30) comment '商品编号'")
    private String itemCode;

    @ApiModelProperty("商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(50) comment '商品名称'")
    private String itemName;

    @ApiModelProperty("商品分类/品类")
    @Column(name = "item_cate_code", columnDefinition = "varchar(30) comment '商品分类/品类编码'")
    private String itemCateCode;

    @ApiModelProperty("商品分类/品类")
    @Column(name = "item_cate_name", columnDefinition = "varchar(50) comment '商品分类/品类名称'")
    private String itemCateName;

    @ApiModelProperty("商品规格")
    @Column(name = "item_spec", columnDefinition = "varchar(30) comment '商品规格'")
    private String itemSpec;

    @ApiModelProperty("基本计量单位")
    @Column(name = "basic_unit_measure", columnDefinition = "varchar(30) comment '基本计量单位'")
    private String basicUnitMeasure;

    @ApiModelProperty("基本计量单位名称")
    @Column(name = "basic_unit_measure_name", columnDefinition = "varchar(30) comment '基本计量单位名称'")
    private String basicUnitMeasureName;

    @ApiModelProperty("重量")
    @Column(name = "weight", columnDefinition = "varchar(30) comment '重量'")
    private BigDecimal weight;

    @ApiModelProperty("重量单位")
    @Column(name = "weight_uom", columnDefinition = "varchar(30) comment '重量单位'")
    private String weightUom;

    @ApiModelProperty("重量单位名称")
    @Column(name = "weight_uom_name", columnDefinition = "varchar(30) comment '重量单位名称'")
    private String weightUomName;

    @ApiModelProperty("订货数量")
    @Column(name = "demand_quantity", columnDefinition = "decimal(20, 8) comment '订货数量'")
    private BigDecimal demandQuantity;

    @ApiModelProperty("总重量")
    @Column(name = "total_weight", columnDefinition = "varchar(30) comment '总重量'")
    private BigDecimal totalWeight;

    @ApiModelProperty("错误原因")
    @Column(name = "error_reason", columnDefinition = "varchar(50) comment '错误原因'")
    private String errorReason;

    @ApiModelProperty("辅助单位")
    @Column(name = "uom2", columnDefinition = "varchar(30) comment '辅助单位'")
    private String uom2;

    @ApiModelProperty("辅助单位名称")
    @Column(name = "uom2_name", columnDefinition = "varchar(30) comment '辅助单位名称'")
    private String uom2Name;

    @ApiModelProperty("辅助数量2")
    @Column(name = "qty2", columnDefinition = "decimal(20, 8) comment '辅助数量2'")
    private BigDecimal qty2;

    @ApiModelProperty("单位转换系数")
    @Column(name = "uom_ratio", columnDefinition = "decimal(20, 8) comment '辅助数量2'")
    private BigDecimal uomRatio;

    @ApiModelProperty(name = "有效小数位数")
    @Column(name = "decimal_places", columnDefinition = "int(2) comment '有效小数位数'")
    private Integer decimalPlaces;
}
