package com.elitesland.scp.pay.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("收款账户信息")
public class BankAccountParamVO implements Serializable {
    private static final long serialVersionUID = -2303910088960681205L;

    @ApiModelProperty("收款账户类型")
    private String accountType;

    @ApiModelProperty("收款银行账户名称")
    private String bankAccountName;

    @ApiModelProperty("银行账号")
    private String bankAccountNumber;

    @ApiModelProperty("开户银行")
    private String bankName;

    @ApiModelProperty("开户银行联行号，account_type 为ENTERPRISE_ACCOUNT是必传，和 bank_branch_name 二选一")
    private String bankBranchId;

    @ApiModelProperty("开户银行支行名称，account_type 为ENTERPRISE_ACCOUNT是必传，和 bank_branch_id 二选一")
    private String bankBranchName;
}
