/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveRollbackSendParam;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreReceiveRollbackListener
implements MessageQueueListener<StoreReceiveRollbackSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveRollbackListener.class);
    private final StoreReceiveRepo storeReceiveRepo;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_order_rollback"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveRollbackSendParam storeReceiveSendParam) {
        log.info("\u95e8\u5e97\u6536\u8d27\u5355\u64a4\u56de\u52a8\u4f5c\uff1a" + JSON.toJSONString((Object)storeReceiveSendParam));
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollectionUtil.isNotEmpty(receiveDOS)) {
            StoreReceiveDO storeReceiveDO = receiveDOS.get(0);
            if (Objects.equals(storeReceiveSendParam.getBackType(), "S")) {
                this.storeReceiveRepo.deleteById(storeReceiveDO.getId());
            } else if (Objects.equals(storeReceiveSendParam.getBackType(), "O")) {
                storeReceiveDO.setStatus("CL");
                this.storeReceiveRepo.save(storeReceiveDO);
            } else {
                storeReceiveDO.setStatus("DR");
                this.storeReceiveRepo.save(storeReceiveDO);
            }
        }
        Map<Long, BigDecimal> itemMap = storeReceiveSendParam.getItems().stream().collect(Collectors.groupingBy(StoreReceiveRollbackSendParam.OrderItem::getOrderDid, Collectors.mapping(StoreReceiveRollbackSendParam.OrderItem::getQty, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (Map.Entry<Long, BigDecimal> item : itemMap.entrySet()) {
            Long did = item.getKey();
            BigDecimal qty = item.getValue();
            this.scpDemandOrderDDomainService.resetSrcDocQuantity(did, qty);
        }
        this.scpDemandOrderDomainService.updateDocStatusById(storeReceiveSendParam.getOrderId(), "ZF");
    }

    public StoreReceiveRollbackListener(StoreReceiveRepo storeReceiveRepo, ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService) {
        this.storeReceiveRepo = storeReceiveRepo;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
    }
}

