package com.elitesland.scp.application.facade.vo.query.msg;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 消息管理分页查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Getter
@Setter
@ApiModel(description = "消息管理分页查询参数")
public class ScpMessagePageMngQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -4852451627144753175L;

    @ApiModelProperty(value = "消息标题")
    private String title;

    @ApiModelProperty(value = "作者ID")
    private Long authorId;

    @ApiModelProperty(value = "分类，[UDC]yst-suplan:MESSAGE_CATEGORY")
    private String category;

    @ApiModelProperty(value = "消息类型")
    private String messageType;

    @ApiModelProperty(value = "是否置顶")
    private Boolean top;

    @ApiModelProperty(value = "是否已发布")
    private Boolean published;

    @ApiModelProperty(value = "发布时间-起始")
    private LocalDateTime publishTimeStart;

    @ApiModelProperty(value = "发布时间-截止")
    private LocalDateTime publishTimeEnd;
}
