package com.elitesland.scp.application.facade.vo.feedback;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "ScpStoreFeedbackExportRespVO", description = "门店反馈")
public class ScpStoreFeedbackExportRespVO implements Serializable {
    private static final long serialVersionUID = -87963489777322531L;
    /**
    * 主键
    */    
    @ApiModelProperty("主键")
    private Long id;
    /**
    * 反馈类型
    */    
    @ApiModelProperty("反馈类型")
    @SysCode(sys = "yst-suplan", mod = "FEEDBACK_TYPE")
    private String feedbackType;
    private String feedbackTypeName;
    /**
    * 反馈原因
    */    
    @ApiModelProperty("反馈原因")
    @SysCode(sys = "yst-suplan", mod = "FEEDBACK_REASON")
    private String feedbackReason;
    private String feedbackReasonName;
    /**
    * 反馈门店编码
    */    
    @ApiModelProperty("反馈门店编码")
    private String feedbackStoreCode;
    /**
    * 反馈门店名称
    */    
    @ApiModelProperty("反馈门店名称")
    private String feedbackStoreName;

    @ApiModelProperty("反馈单号")
    private String dcoNo;

    @ApiModelProperty("反馈状态")
    @SysCode(sys = "yst-suplan", mod = "FEEDBACK_STATUS")
    private String feedbackStatus;
    private String feedbackStatusName;
    /**
    * 商品编码
    */    
    @ApiModelProperty("商品编码")
    private String itemCode;
    /**
    * 商品名称
    */    
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
    * 反馈评分
    */    
    @ApiModelProperty("反馈评分")
    private BigDecimal feedbackScore;
    /**
    * 评价意见
    */    
    @ApiModelProperty("评价意见")
    private String evaluationComment;
    /**
    * 优化意见
    */    
    @ApiModelProperty("优化意见")
    private String optimizationSuggestion;
    /**
    * 图片编码
    */    
    @ApiModelProperty("图片编码")
    private String fileCode;
    /**
    * 图片url
    */    
    @ApiModelProperty("图片url")
    private String fileUrl;

    /**
    * 审批状态
    */    
    @ApiModelProperty("审批状态")
    @SysCode(sys = "yst-suplan", mod = "FEEDBACK_APPROVAL_STATUS")
    private String approvalStatus;
    private String approvalStatusName;
    /**
    * 反馈时间
    */    
    @ApiModelProperty("反馈时间")
    private LocalDateTime feedbackTime;
    /**
    * 反馈人
    */    
    @ApiModelProperty("反馈人")
    private String feedbackBy;
    /**
    * 审批人
    */    
    @ApiModelProperty("审批人")
    private String approvedBy;
    /**
    * 审批时间
    */    
    @ApiModelProperty("审批时间")
    private LocalDateTime approvalTime;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    /**
    * 租户ID
    */    
    @ApiModelProperty("租户ID")
    private Long tenantId;
    /**
    * 备注
    */    
    @ApiModelProperty("备注")
    private String remark;
    /**
    * 记录创建者ID
    */    
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
    * 记录创建者
    */    
    @ApiModelProperty("记录创建者")
    private String creator;
    /**
    * 记录创建时间
    */    
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
    * 记录最后更新者ID
    */    
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;
    /**
    * 记录最后更新者
    */    
    @ApiModelProperty("记录最后更新者")
    private String updater;
    /**
    * 记录最后更新时间
    */    
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
    * 记录最后更新时间
    */    
    @ApiModelProperty("记录最后更新时间")
    private Integer deleteFlag;
    /**
    * 锁版本
    */    
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;
    /**
    * 数据归属组织id
    */    
    @ApiModelProperty("数据归属组织id")
    private Long secBuId;
    /**
    * 数据归属雇员id
    */    
    @ApiModelProperty("数据归属雇员id")
    private Long secUserId;
    /**
    * 数据归属公司id
    */    
    @ApiModelProperty("数据归属公司id")
    private Long secOuId;
    /**
    * 所属组织ID
    */    
    @ApiModelProperty("所属组织ID")
    private Long belongOrgId;
    /**
    * 租户组织ID
    */    
    @ApiModelProperty("租户组织ID")
    private Long tenantOrgId;

        
}
