package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserTypeDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSaveVO;
import com.elitesland.scp.common.Constant;
import com.elitesland.scp.domain.convert.StoreInfoConvert;
import com.elitesland.scp.domain.convert.scpsman.SalesmanInfoConvert;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.elitesland.scp.dto.authority.ItemObject;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcPageDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepoProc;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import com.elitesland.scp.infr.repo.scpsman.SalesmanRegionRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.param.StoreAuthorityParam;
import com.elitesland.scp.param.StoreContactParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.service.authority.InvWhAuthorityRpcService;
import com.elitesland.scp.service.authority.StoreAuthorityRpcService;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/3/27 10:48
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
@RestController
@RequestMapping(ScpApplication.URI_PREFIX + StoreAuthorityRpcService.PATH)
public class StoreAuthorityRpcServiceImpl implements StoreAuthorityRpcService {

    public static final String SCPSMAN = "scpsman";
    private final RmiOrgStoreRpcService rmiOrgStoreService;
    private final RmiItemService rmiItemService;
    @Autowired
    private UserRpcService userRpcService;
    @Autowired
    private SysSettingService settingService;
    @Autowired
    private OrgOuRpcService orgRpcService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private ScpsmanInfoRepo scpsmanInfoRepo;
    @Autowired
    private SalesmanRegionRepo salesmanRegionRepo;
    @Autowired
    private ScpDemandAuthorityRepo scpDemandAuthorityRepo;
    @Autowired
    private ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc;
    @Autowired
    private ScpDemandAuthorityDRepo scpDemandAuthorityDRepo;

    @Autowired
    private ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc;
    @Autowired
    private Constant constant;

    @SysCodeProc
    @Override
    public ApiResult<PagingVO<ItemObject>> getStoreAuthorityDataPage(StoreAuthorityRpcPageDTO storeAuthorityRpcPageDTO) {
        log.info("门店要货权限数据分页获取，入参:{}", JSONUtil.toJsonStr(storeAuthorityRpcPageDTO));
        String storeCode = storeAuthorityRpcPageDTO.getStoreCode();
        if (StrUtil.isBlank(storeCode)) {
            throw new BusinessException("参数门店编码不能为空");
        }
        OrgStoreBaseRpcDTO storeDto = rmiOrgStoreService.getOrgStoreBase(storeCode);
        log.info("门店信息:{}", JSONUtil.toJsonStr(storeDto));
        if (storeDto == null) {
            return ApiResult.ok();
        }

        String ouCode = storeDto.getOuCode();
        String brandCode = storeDto.getBrandCode();

        ItmItemBusinessRpcPagingParam param = new ItmItemBusinessRpcPagingParam();
        if (StrUtil.isNotBlank(ouCode)) {
            param.setBuCodes(Collections.singletonList(ouCode));
        }
        if (StrUtil.isNotBlank(brandCode)) {
            param.setBrandList(Collections.singletonList(brandCode));
        }
        if (StrUtil.isNotBlank(storeAuthorityRpcPageDTO.getItemCodeName())) {
            param.setItemCodeName(storeAuthorityRpcPageDTO.getItemCodeName());
        }
        if (CollUtil.isNotEmpty(storeAuthorityRpcPageDTO.getItemType2s())) {
            param.setItemType2s(storeAuthorityRpcPageDTO.getItemType2s());
        }
        param.setPurFreeze(storeAuthorityRpcPageDTO.getPurFreeze());
        param.setSaleFreeze(storeAuthorityRpcPageDTO.getSaleFreeze());
        param.setEnable(storeAuthorityRpcPageDTO.getEnable());
        param.setCurrent(storeAuthorityRpcPageDTO.getCurrent() + 2);
        param.setSize(storeAuthorityRpcPageDTO.getSize());
        PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDTOS = rmiItemService.findItemBusinessRpcDtoByParam(param);

        long total = itemBusinessRpcDTOS.getTotal();
        List<ItmItemBusinessRpcPagingDTO> records = itemBusinessRpcDTOS.getRecords();
        log.info("调用基础域分页查询商品结果:{}", JSONUtil.toJsonStr(records));
        List<ItemObject> itemInfoList = new ArrayList<>();
        for (ItmItemBusinessRpcPagingDTO dto : records) {
            ItemObject itemInfo = new ItemObject();
            itemInfo.setItemCode(dto.getItemCode());
            itemInfo.setItemId(dto.getItemId());
            itemInfo.setItemName(dto.getItemName());
            itemInfo.setUom(dto.getUom());
            itemInfo.setUomName(dto.getUomName());
            itemInfo.setTaxRate(dto.getTaxRate2());
            itemInfo.setBrand(dto.getBrand());
            itemInfo.setBrandName(dto.getBrandName());
            itemInfo.setItemCateCode(dto.getItemCateCode());
            itemInfo.setItemCateFullName(dto.getItemCateFullName());
            itemInfo.setItemCatePathName(dto.getItemCatePathName());
            itemInfo.setSpec(dto.getSpec());
            itemInfo.setSpuCode(dto.getSpuCode());
            itemInfo.setSpuName(dto.getSpuName());
            itemInfo.setPackageSpec(dto.getPackageSpec());
            itemInfo.setSuppCode(dto.getSuppCode());
            itemInfo.setSuppName(dto.getSuppName());
            itemInfo.setUom2(dto.getUom2());
            itemInfo.setUom2Name(dto.getUom2Name());
            itemInfo.setItemType(dto.getItemType2());
            itemInfo.setSpuId(dto.getSpuId());
            itemInfoList.add(itemInfo);
        }
        PagingVO<ItemObject> result = new PagingVO<>();
        result.setRecords(itemInfoList);
        result.setTotal(total);
        log.info("门店要货权限数据-分页:{}", JSONUtil.toJsonStr(result));
        return ApiResult.ok(result);
    }

    @Transactional
    @Override
    public ApiResult updateStoreAuthorityData(StoreAuthorityParam storeAuthorityParam) {
        log.info("门店要货权限数据更新，入参:{}", JSONUtil.toJsonStr(storeAuthorityParam));
        SysSettingVO sysSettingVO = settingService.oneByNo("BELONG_OU");
        if (sysSettingVO == null) {
            throw new BusinessException("请检查默认所属公司配置");
        }
        String ouCodes = sysSettingVO.getSettingVal();
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(Collections.singletonList(ouCodes));
        List<OrgOuRpcDTO> ouDtoByParam = orgRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        OrgOuRpcDTO orgOuRpcDTO = ouDtoByParam.get(0);
        List<StoreContactParam> contactParams = storeAuthorityParam.getContactParams().stream().filter(vod -> {
            return !StringUtils.isEmpty(vod.getMobile()) && !StringUtils.isEmpty(vod.getType()) && (vod.getType().equals("LEGAL_PERSON") || vod.getType().equals("BUSINESS") || vod.getType().equals("FINANCE"));
        }).toList();
        Map<String, List<StoreContactParam>> contacts = contactParams.stream().collect(Collectors.groupingBy(StoreContactParam::getMobile));
        //加盟
        if (storeAuthorityParam.getStoreType2().equals("DIRECTSALE")) {
            //根据手机号生成业务员 value是多个门店的信息
            for (String key : contacts.keySet()) {
                //根据手机号查询账号数据 如果账号和员工已存在 则重新分配明细   为空重新创建
                SysUserBasicDTO data = userRpcService.getByUsername(key).getData();
                if (data == null) {
                    //获取关联员工数据
                    ScpsmanInfoDO bySalesmanNo = scpsmanInfoRepo.findByScpsmanNo(key);
                    SalesmanInfoSaveVO salesmanInfoSaveVO = new SalesmanInfoSaveVO();
                    //如果已经存在就更新
                    if (bySalesmanNo != null) {
                        //更新
                        salesmanInfoSaveVO.setId(bySalesmanNo.getId());
                    }
                    StoreContactParam orgContactRpcDTO = contacts.get(key).get(0);
                    salesmanInfoSaveVO.setName(orgContactRpcDTO.getName());
                    salesmanInfoSaveVO.setLoginAccount(key);
                    salesmanInfoSaveVO.setPhone(key);
                    salesmanInfoSaveVO.setScpsmanNo(key);
                    salesmanInfoSaveVO.setSource("ADD");
                    //所属组织
                    salesmanInfoSaveVO.setBuId(storeAuthorityParam.getBuId());

                    salesmanInfoSaveVO.setEnableStatus(1);
                    salesmanInfoSaveVO.setOuId(storeAuthorityParam.getOuId().toString());
                    salesmanInfoSaveVO.setOuCode(storeAuthorityParam.getOuCode());
                    salesmanInfoSaveVO.setOuName(storeAuthorityParam.getOuName());
                    salesmanInfoSaveVO.setOrgIdBelong(orgOuRpcDTO.getBuId().toString());
                    ScpsmanInfoDO scpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
                    //保存计划员信息
                    EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveVOToUpsertDTO(salesmanInfoSaveVO);
                    if (StringUtils.isNotBlank(salesmanInfoSaveVO.getBirthdayTime())) {
                        upsertDTO.setBirthDate(constant.stringToLocalDate(salesmanInfoSaveVO.getBirthdayTime()));
                    }
                    if (StringUtils.isNotBlank(salesmanInfoSaveVO.getJoinTime())) {
                        upsertDTO.setJoinTime(constant.swapTimeMin(salesmanInfoSaveVO.getJoinTime()));
                    }
                    if ("EMP".equals(scpsmanInfoDO.getSource())) {
                        upsertDTO.setType("SCPSMAN");
                    }
                    ScpsmanInfoDO save = scpsmanInfoRepo.save(scpsmanInfoDO);
                    buildEmployee(salesmanInfoSaveVO, scpsmanInfoDO, upsertDTO, String.valueOf(save.getId()));

                    //删除掉计划员权限主表
                    List<ScpsmanAuthorityVO> authorityVOList = scpDemandAuthorityRepoProc.listQuery(storeAuthorityParam.getStoreCode(), save.getId());
                    //删除掉重新生成
                    log.info("删除的数据ID条件"+save.getId());
                    scpDemandAuthorityRepo.deleteByScpsmanId(save.getId());
                    //组装权限数据
                    ScpsmanAuthorityDO scpManAuthoritySaveVO = new ScpsmanAuthorityDO();
                    scpManAuthoritySaveVO.setOuCode(storeAuthorityParam.getOuCode());
                    scpManAuthoritySaveVO.setOuName(storeAuthorityParam.getOuName());
                    scpManAuthoritySaveVO.setOuId(storeAuthorityParam.getOuId());
                    scpManAuthoritySaveVO.setScpsmanNo(save.getScpsmanNo());
                    scpManAuthoritySaveVO.setEnableStatus(true);
                    scpManAuthoritySaveVO.setScpsmanId(save.getId());
                    ScpsmanAuthorityDO save1 = scpDemandAuthorityRepo.save(scpManAuthoritySaveVO);
                    List<Long> authId = authorityVOList.stream().map(ScpsmanAuthorityVO::getAuthorityId).distinct().collect(Collectors.toList());
                    if(CollectionUtils.isNotEmpty(authId)){
                        log.info("删除的数据ID条件"+authId);
                        scpDemandAuthorityDRepo.deleteByMasIdInAndAuthSource(authId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    }
                    ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                    scpsmanAuthorityDDO.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    scpsmanAuthorityDDO.setMasId(save1.getId());
                    scpsmanAuthorityDDO.setType(0);
                    scpsmanAuthorityDDO.setRegion(storeAuthorityParam.getRegion());
                    scpsmanAuthorityDDO.setStWhId(storeAuthorityParam.getStoreId());
                    scpsmanAuthorityDDO.setStWhCode(storeAuthorityParam.getStoreCode());
                    scpsmanAuthorityDDO.setStWhName(storeAuthorityParam.getStoreName());
                    scpDemandAuthorityDRepo.save(scpsmanAuthorityDDO);
                    if(CollectionUtils.isNotEmpty(authorityVOList)){
                        List<ScpsmanAuthorityVO> oldData = authorityVOList.stream().filter(vo -> {
                            return !vo.getAuthSource().equals(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                        }).collect(Collectors.toList());
                        if(CollectionUtils.isNotEmpty(oldData)){
                            List<Long> oldAuthData = oldData.stream().map(ScpsmanAuthorityVO::getAuthorityDid).collect(Collectors.toList());
                            scpDemandAuthorityDRepoProc.updateMasId(oldAuthData, save1.getId());
                        }
                    }

                } else {
                    //获取关联员工数据
                    ScpsmanInfoDO save = scpsmanInfoRepo.findByScpsmanNo(key);
                    //删除掉计划员权限主表
                    List<ScpsmanAuthorityVO> authorityVOList = scpDemandAuthorityRepoProc.listQuery(storeAuthorityParam.getStoreCode(), save.getId());
                    //删除掉重新生成
                    log.info("删除的数据ID条件"+save.getId());
                    scpDemandAuthorityRepo.deleteByScpsmanId(save.getId());
                    //组装权限数据
                    ScpsmanAuthorityDO scpManAuthoritySaveVO = new ScpsmanAuthorityDO();
                    scpManAuthoritySaveVO.setOuCode(storeAuthorityParam.getOuCode());
                    scpManAuthoritySaveVO.setOuName(storeAuthorityParam.getOuName());
                    scpManAuthoritySaveVO.setOuId(storeAuthorityParam.getOuId());
                    scpManAuthoritySaveVO.setScpsmanNo(save.getScpsmanNo());
                    scpManAuthoritySaveVO.setEnableStatus(true);
                    scpManAuthoritySaveVO.setScpsmanId(save.getId());
                    ScpsmanAuthorityDO save1 = scpDemandAuthorityRepo.save(scpManAuthoritySaveVO);
                    List<Long> authId = authorityVOList.stream().map(ScpsmanAuthorityVO::getAuthorityId).distinct().collect(Collectors.toList());
                    if(CollectionUtils.isNotEmpty(authId)){
                        log.info("删除的数据ID条件"+authId);
                        scpDemandAuthorityDRepo.deleteByMasIdInAndAuthSource(authId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    }
                    ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                    scpsmanAuthorityDDO.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    scpsmanAuthorityDDO.setMasId(save1.getId());
                    scpsmanAuthorityDDO.setType(0);
                    scpsmanAuthorityDDO.setRegion(storeAuthorityParam.getRegion());
                    scpsmanAuthorityDDO.setStWhId(storeAuthorityParam.getStoreId());
                    scpsmanAuthorityDDO.setStWhCode(storeAuthorityParam.getStoreCode());
                    scpsmanAuthorityDDO.setStWhName(storeAuthorityParam.getStoreName());
                    scpDemandAuthorityDRepo.save(scpsmanAuthorityDDO);
                    if(CollectionUtils.isNotEmpty(authorityVOList)){
                        List<ScpsmanAuthorityVO> oldData = authorityVOList.stream().filter(vo -> {
                            return !vo.getAuthSource().equals(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                        }).collect(Collectors.toList());
                        if(CollectionUtils.isNotEmpty(oldData)){
                            List<Long> oldAuthData = oldData.stream().map(ScpsmanAuthorityVO::getAuthorityDid).collect(Collectors.toList());
                            scpDemandAuthorityDRepoProc.updateMasId(oldAuthData, save1.getId());
                        }
                    }
                }
            }
        } else if (storeAuthorityParam.getStoreType2().equals("DIRECTSALE2")) {
            //直营
            for (String key : contacts.keySet()) {
                SysUserBasicDTO data = userRpcService.getByUsername(key).getData();
                // 直营店现有员工  如果有员工直接绑定  没有略过
                if (data != null) {
                    //获取关联员工数据
                    SysEmployeeBasicDTO empData = employeeRpcService.getByUserId(data.getId()).getData();
                    //根据业务员编码查询是否已经存在了账号
                    ScpsmanInfoDO bySalesmanNo = scpsmanInfoRepo.findByScpsmanNo(empData.getCode());
                    SalesmanInfoSaveVO salesmanInfoSaveVO = new SalesmanInfoSaveVO();
                    //如果已经存在就更新
                    if (bySalesmanNo != null) {
                        //更新
                        salesmanInfoSaveVO.setId(bySalesmanNo.getId());
                    }
                    salesmanInfoSaveVO.setEmail(empData.getEmail());
                    salesmanInfoSaveVO.setName(empData.getLastName());
                    //加入时间 取不到
                    //salesmanInfoSaveVO.setJoinTime(empData.get);
                    salesmanInfoSaveVO.setLoginAccount(key);
                    salesmanInfoSaveVO.setPhone(key);
                    salesmanInfoSaveVO.setScpsmanNo(empData.getCode());
                    salesmanInfoSaveVO.setSource("EMP");
                    //salesmanInfoSaveVO.setSourceStoreCode(vo.getStoreCode());
                    //所属组织
                    salesmanInfoSaveVO.setBuId(empData.getOrgId());
                    ScpsmanInfoDO scpsmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
                    scpsmanInfoDO.setEnableStatus(1);
                    scpsmanInfoDO.setOuId(orgOuRpcDTO.getId());
                    scpsmanInfoDO.setOuCode(orgOuRpcDTO.getOuCode());
                    scpsmanInfoDO.setOuName(orgOuRpcDTO.getOuName());
                    //保存计划员信息
                    ScpsmanInfoDO save = scpsmanInfoRepo.save(scpsmanInfoDO);
                    //删除掉计划员权限主表
                    List<ScpsmanAuthorityVO> authorityVOList = scpDemandAuthorityRepoProc.listQuery(storeAuthorityParam.getStoreCode(), save.getId());
                    //删除掉重新生成
                    log.info("删除的数据ID条件"+save.getId());
                    scpDemandAuthorityRepo.deleteByScpsmanId(save.getId());
                    //组装权限数据
                    ScpsmanAuthorityDO scpManAuthoritySaveVO = new ScpsmanAuthorityDO();
                    scpManAuthoritySaveVO.setOuCode(storeAuthorityParam.getOuCode());
                    scpManAuthoritySaveVO.setOuName(storeAuthorityParam.getOuName());
                    scpManAuthoritySaveVO.setOuId(storeAuthorityParam.getOuId());
                    scpManAuthoritySaveVO.setScpsmanNo(save.getScpsmanNo());
                    scpManAuthoritySaveVO.setEnableStatus(true);
                    scpManAuthoritySaveVO.setScpsmanId(save.getId());
                    ScpsmanAuthorityDO save1 = scpDemandAuthorityRepo.save(scpManAuthoritySaveVO);
                    List<Long> authId = authorityVOList.stream().map(ScpsmanAuthorityVO::getAuthorityId).distinct().collect(Collectors.toList());
                    if(CollectionUtils.isNotEmpty(authId)){
                        log.info("删除的数据ID条件"+authId);
                        scpDemandAuthorityDRepo.deleteByMasIdInAndAuthSource(authId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    }
                    ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                    scpsmanAuthorityDDO.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                    scpsmanAuthorityDDO.setMasId(save1.getId());
                    scpsmanAuthorityDDO.setType(0);
                    scpsmanAuthorityDDO.setRegion(storeAuthorityParam.getRegion());
                    scpsmanAuthorityDDO.setStWhId(storeAuthorityParam.getStoreId());
                    scpsmanAuthorityDDO.setStWhCode(storeAuthorityParam.getStoreCode());
                    scpsmanAuthorityDDO.setStWhName(storeAuthorityParam.getStoreName());
                    scpDemandAuthorityDRepo.save(scpsmanAuthorityDDO);
                    if(CollectionUtils.isNotEmpty(authorityVOList)){
                        List<ScpsmanAuthorityVO> oldData = authorityVOList.stream().filter(vo -> {
                            return !vo.getAuthSource().equals(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode());
                        }).collect(Collectors.toList());
                        if(CollectionUtils.isNotEmpty(oldData)){
                            List<Long> oldAuthData = oldData.stream().map(ScpsmanAuthorityVO::getAuthorityDid).collect(Collectors.toList());
                            scpDemandAuthorityDRepoProc.updateMasId(oldAuthData, save1.getId());
                        }
                    }
                }
            }
        }
        return ApiResult.ok();
    }


    @SysCodeProc
    @Override
    public ApiResult<StoreAuthorityRespDTO> getStoreAuthorityData(StoreAuthorityRpcDTO storeAuthorityRpcDTO) {
        String storeCode = storeAuthorityRpcDTO.getStoreCode();
        if (StrUtil.isBlank(storeCode)) {
            throw new BusinessException("参数门店编码不能为空");
        }
        OrgStoreBaseRpcDTO storeDto = rmiOrgStoreService.getOrgStoreBase(storeCode);
        log.info("门店信息:{}", JSONUtil.toJsonStr(storeDto));
        if (storeDto == null) {
            return ApiResult.ok();
        }
        StoreAuthorityRespDTO storeAuthorityRespDTO = StoreInfoConvert.INSTANCE.toStoreAuthorityRespDTO(storeDto);
        String ouCode = storeAuthorityRespDTO.getOuCode();
        String brandCode = storeAuthorityRespDTO.getBrandCode();
        List<ItmItemBusinessRpcDTO> itmItemBusinessRpcDTOS =
                rmiItemService.findItmItemBusinessByBUCodeAndBrand(ouCode, brandCode);
        log.info("调用基础域查询商品结果:{}", JSONUtil.toJsonStr(itmItemBusinessRpcDTOS));

        List<StoreAuthorityRespDTO.ItemInfo> itemInfoList = new ArrayList<>();
        for (ItmItemBusinessRpcDTO dto : itmItemBusinessRpcDTOS) {
            StoreAuthorityRespDTO.ItemInfo itemInfo = new StoreAuthorityRespDTO.ItemInfo();
            itemInfo.setItemCode(dto.getItemCode());
            itemInfo.setItemId(dto.getId());
            itemInfo.setItemName(dto.getItemName());
            itemInfo.setUom(dto.getUom());
            itemInfo.setUomName(dto.getUomName());
            itemInfo.setTaxRate(dto.getTaxRate2());
            itemInfoList.add(itemInfo);
        }
        storeAuthorityRespDTO.setItemInfos(itemInfoList);
        log.info("门店要货权限数据:{}", JSONUtil.toJsonStr(storeAuthorityRespDTO));
        return ApiResult.ok(storeAuthorityRespDTO);
    }

    private void buildEmployee(SalesmanInfoSaveVO salesmanInfoSaveVO, ScpsmanInfoDO scpsmanInfoDO,
                               EmployeeUpsertDTO employeeUpsertDTO, String id) {
        var empId = salesmanInfoSaveVO.getUserId();
        if (empId != null) {
            // 绑定已有员工，则只需增加账号类型即可
            var userId = userRpcService.getIdByUsername(scpsmanInfoDO.getLoginAccount()).computeData();
            if (userId != null) {
                userRpcService.addUserType(userId, SCPSMAN, id);
                return;
            }
        }

        AreaVO areaVO = new AreaVO();
        areaVO.setProvinceCode(salesmanInfoSaveVO.getProvince());
        areaVO.setCityCode(salesmanInfoSaveVO.getCity());
        areaVO.setCountyCode(salesmanInfoSaveVO.getArea());
        EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
        employeeOrg.setOrgId(salesmanInfoSaveVO.getBuId());
        employeeOrg.setLeaderUserId(salesmanInfoSaveVO.getLeaderUserId());
        if (salesmanInfoSaveVO.getSex() != null) {
            employeeUpsertDTO.setGender(salesmanInfoSaveVO.getSex().equals(1) ? "MALE" : "FEMALE");
        }
        employeeUpsertDTO.setAreaVO(areaVO);
        if (StrUtil.isNotBlank(salesmanInfoSaveVO.getPhone())) {
            employeeUpsertDTO.setPhone(salesmanInfoSaveVO.getPhone());
        }
        employeeUpsertDTO.setId(empId);
        employeeUpsertDTO.setOrgList(List.of(employeeOrg));
        employeeUpsertDTO.setCode(scpsmanInfoDO.getScpsmanNo());
        employeeUpsertDTO.setOuterKey(salesmanInfoSaveVO.getOuterKey());

        //传递计划员id和类型
        appendUserTypeToEmployeeUpsertDTO(employeeUpsertDTO, id);
        ApiResult<String> result = employeeRpcService.upsert(employeeUpsertDTO);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMsg() + " 保存员工失败");
        }
    }

    private void appendUserTypeToEmployeeUpsertDTO(EmployeeUpsertDTO employeeUpsertDTO, String id) {
        SysUserTypeDTO sysUserTypeDTO = new SysUserTypeDTO();
        sysUserTypeDTO.setIdentityId(id);
        sysUserTypeDTO.setUserType(SCPSMAN);
        employeeUpsertDTO.setUserTypeList(Collections.singletonList(sysUserTypeDTO));
    }
}
