package com.elitesland.scp.application.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.sale.api.vo.resp.crm.CrmCustDetailRespVO;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.sale.sync.SaleSyncTypeEnum;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderPayMqParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.whnet.*;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.whnet.ScpWhNetRelationDomainService;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.whnet.ScpWhNetRelationDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.item.dto.*;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.mq.SyncMqMessage;
import com.elitesland.support.provider.mq.SyncMqSender;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathDRpcDTO;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 20日 14:02
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpWhNetRelationServiceImpl implements ScpWhNetRelationService {

    private final ScpWhNetRelationDomainService scpWhNetRelationDomainService;

    private final ItmItemRpcService itmItemRpcService;

    private final UdcProvider udcProvider;

    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;

    private final UdcProvider systemService;

    private final InvWhProvider whProvider;

    private final OrgStoreRpcService orgStoreRpcService;

    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiInvStkRpcService rmiInvStkService;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final CrmCustRpcService crmCustRpcService;
    private final MessageQueueTemplate messageQueueTemplate;



    @Override
    public PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO<>();
            }
            extractedAuthorityParam(queryParam, pagingVO);
        }
        return scpWhNetRelationDomainService.page(queryParam);
    }

    @Override
    public OuInfo findOuInfo(OuInfoQueryParamVO queryParam) {
        OuInfo ouInfo = getOuInfoFromPathCode(queryParam.getSupplyWhCode(), queryParam.getDemandWhStCode(),
                queryParam.getType());
        log.info("仓网关系,查询销售公司信息:{}", JSONUtil.toJsonStr(ouInfo));
        return ouInfo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult saveWhNetRelation(ScpWhNetRelationSaveVO createParam) {
        List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelationList = createParam.getScpWhNetRelations();
        Map<String, List<ScpWhNetRelationSaveVO.ScpWhNetRelation>> groupMap = whNetRelationList.stream()
                .collect(Collectors.groupingBy(d -> d.getDemandWhStCode() + setEmptyStringStr(d.getItemCateCode()) + setEmptyStringStr(d.getItemCode())));
        Set<String> strings = groupMap.keySet();
        List<ScpWhNetRelationDO> existList = scpWhNetRelationDomainService.findByConcatKey(strings);
        Map<String, List<ScpWhNetRelationDO>> existMap =
                existList.stream().collect(Collectors.groupingBy(d -> d.getDemandWhStCode() +
                        setEmptyStringStr(d.getItemCateCode()) + setEmptyStringStr(d.getItemCode())));
        Set<String> modifySet = new HashSet<>();
        ScpWhNetRelationResultVO result = new ScpWhNetRelationResultVO();
        List<ScpWhNetRelationResultVO.ResultVO> failList = new ArrayList<>();
        List<ScpWhNetRelationResultVO.ResultVO> successList = new ArrayList<>();

        for (var scpWhNetRelation : groupMap.entrySet()) {
            String relationKey = scpWhNetRelation.getKey();
            val whNetRelations = scpWhNetRelation.getValue();
            long count = whNetRelations.stream().filter(d -> d.getId() != null).count();
            var activateList =
                    whNetRelations.stream().filter(d -> Boolean.TRUE.equals(d.getStatus())).collect(Collectors.toList());
            //数据重复校验
            long count1 = activateList.stream().map(d -> d.getSupplyWhCode()
                    + d.getDemandWhStCode() + d.getType()
                    + d.getItemCateCode() + d.getItemCode() + d.getStatus()).count();
            long count2 = activateList.stream().map(d -> d.getSupplyWhCode()
                    + d.getDemandWhStCode() + d.getType()
                    + d.getItemCateCode() + d.getItemCode() + d.getStatus()).distinct().count();
            if (count2 != count1) {
                String errorMsg = String.format("需求仓库-商品品类-商品【%s-%s-%s】存在相同【供应商仓-类型】组合数据，请检查",
                        whNetRelations.get(0).getDemandWhStCode(), whNetRelations.get(0).getItemCateCode(),
                        whNetRelations.get(0).getItemCode());
                throw new BusinessException(ApiCode.FAIL, errorMsg);
            }
            //同组合配置校验
            if (CollUtil.isNotEmpty(activateList)) {
                if (count == 0 && existMap.containsKey(relationKey)) {
                    StringBuilder msgBuilder = new StringBuilder("数据重复，需求仓库-商品品类-商品【")
                            .append(whNetRelations.get(0).getDemandWhStName());

                    if (StringUtils.isNotEmpty(whNetRelations.get(0).getItemCateName())) {
                        msgBuilder.append("-").append(whNetRelations.get(0).getItemCateName());
                    }

                    if (StringUtils.isNotEmpty(whNetRelations.get(0).getItemName())) {
                        msgBuilder.append("-").append(whNetRelations.get(0).getItemName());
                    }

                    msgBuilder.append("】满足供货百分比配置已存在，请修改");

                    throw new BusinessException(ApiCode.FAIL, msgBuilder.toString());
                } else if (count > 0 && existMap.containsKey(relationKey)) {
                    modifySet.add(relationKey);
                }
                BigDecimal sumPercent = activateList.stream()
                        .filter(d -> Boolean.TRUE.equals(d.getStatus()))
                        .map(ScpWhNetRelationSaveVO.ScpWhNetRelation::getSupplyPercentage)
                        .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                //不满足配置要求
                List<ScpWhNetRelationResultVO.ResultVO> resultVOS = getResultVOS(whNetRelations);
                if (sumPercent.compareTo(new BigDecimal("100")) == 0) {
                    successList.addAll(resultVOS);
                } else {
                    failList.addAll(resultVOS);
                }
            }
        }
        result.setFailList(failList);
        result.setSuccessList(successList);
        if (CollUtil.isEmpty(failList)) {
            List<ScpWhNetRelationDTO> whNetRelationDOS = createParam.getScpWhNetRelations().stream()
                    .map(ScpWhNetRelationConvert.INSTANCE::saveVoDto).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(modifySet)) {
                List<ScpWhNetRelationDO> modifyList = scpWhNetRelationDomainService.findByConcatKey(modifySet);
                List<Long> existIds = modifyList.stream().map(ScpWhNetRelationDO::getId).collect(Collectors.toList());
                scpWhNetRelationDomainService.deleteBatch(existIds);
            }
            // 校验结算路径
            checkTransactionPath(whNetRelationDOS);
            scpWhNetRelationDomainService.createBatch(whNetRelationDOS);
            sync(whNetRelationDOS);
            return ApiResult.builder().success(true).code(200).data(result).msg("操作成功").build();
        } else {
            return ApiResult.builder().success(false).code(0).data(result).msg("操作失败").build();
        }
    }

    private void sync(List<ScpWhNetRelationDTO> whNetRelationDOS) {
        List<ScpWhNetRelationDTO> relationDTOS = whNetRelationDOS.stream()
                .filter(d -> "0".equals(d.getType())).collect(Collectors.toList());
        InvWhRpcDtoParam invWhRpcDtoParam = new InvWhRpcDtoParam();
        invWhRpcDtoParam.setWhIds(relationDTOS.stream().map(ScpWhNetRelationDTO::getSupplyWhId)
                .distinct().collect(Collectors.toList()));
        Map<Long, InvWhRpcDTO> whMap = whProvider.findWhDTOByParam(invWhRpcDtoParam).computeData()
                .stream().collect(Collectors.toMap(InvWhRpcDTO::getWhId, d -> d));
        Map<String, OrgStoreDetailRpcDTO> storeDetailRpcDTOMap = rmiOrgStoreRpcService
                .queryByStoreCodes(relationDTOS.stream()
                .map(ScpWhNetRelationDTO::getDemandWhStCode).collect(Collectors.toList())).stream()
                .collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, d -> d));

        relationDTOS.forEach(d -> {
            Long supplyWhId = d.getSupplyWhId();
            InvWhRpcDTO invWhRpcDTO = whMap.get(supplyWhId);
            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = storeDetailRpcDTOMap.get(d.getDemandWhStCode());
            if (Objects.nonNull(invWhRpcDTO) && Objects.nonNull(orgStoreDetailRpcDTO) && "HD".equals(invWhRpcDTO.getOtherWhType())){
                CrmCustDTO crmCustDTO = crmCustRpcService.getCustInfo(orgStoreDetailRpcDTO.getStoreCode()).computeData();
                if (Objects.nonNull(crmCustDTO)){
                    SyncMqMessage syncMqMessage = new SyncMqMessage();
                    syncMqMessage.setBusinessKey(orgStoreDetailRpcDTO.getStoreCode());
                    syncMqMessage.setEntityId(crmCustDTO.getId());
                    syncMqMessage.setOutSysType("HD");
                    syncMqMessage.setEntityKey(orgStoreDetailRpcDTO.getStoreCode());
                    messageQueueTemplate.publishMessage("yst-suplan", SaleSyncTypeEnum.CUST.name() + "__HD", syncMqMessage);
                }
            }else if (Objects.nonNull(invWhRpcDTO) && Objects.nonNull(orgStoreDetailRpcDTO) && "ShWms".equals(invWhRpcDTO.getOtherWhType())) {
//                SyncParam shWms = SyncParam.builder().outSysType("ShWms").syncType(SaleSyncTypeEnum.CUST.name()).entityId(Long.valueOf(orgStoreDetailRpcDTO.getCustId())).entityKey(orgStoreDetailRpcDTO.getCustCode()).build();
                CrmCustDTO crmCustDTO = crmCustRpcService.getCustInfo(orgStoreDetailRpcDTO.getStoreCode()).computeData();
                if (Objects.nonNull(crmCustDTO)){
                    SyncMqMessage syncMqMessage = new SyncMqMessage();
                    syncMqMessage.setBusinessKey(orgStoreDetailRpcDTO.getStoreCode());
                    syncMqMessage.setEntityId(crmCustDTO.getId());
                    syncMqMessage.setOutSysType("ShWms");
                    syncMqMessage.setEntityKey(orgStoreDetailRpcDTO.getStoreCode());
                    messageQueueTemplate.publishMessage("yst-suplan", SaleSyncTypeEnum.CUST.name() + "__ShWms", syncMqMessage);
                }

            }
        });

    }

    /**
     * 校验结算路径
     *
     * @param whNetRelationList
     */
    private void checkTransactionPath(List<ScpWhNetRelationDTO> whNetRelationList) {
        List<String> whCodes = whNetRelationList.stream().map(ScpWhNetRelationDTO::getSupplyWhCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> whMap = buildInvWhMap(whCodes);

        List<String> demandWhCodes = whNetRelationList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(row.getType())).map(ScpWhNetRelationDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
        Map<String, InvWhRpcSimpleDTO> demandWhMap = buildInvWhMap(demandWhCodes);

        List<String> demandStoreCodes = whNetRelationList.stream().filter(row -> ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType())).map(ScpWhNetRelationDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
        Map<String, OrgStoreBaseRpcDTO> fStoreMap = getStoreMap(demandStoreCodes);

        List<SupportTransactionPathRpcParam> rpcParams = new ArrayList<>();
        whNetRelationList.forEach(row -> {

            String demandWhStCode = row.getDemandWhStCode();
            String supplyWhCode = row.getSupplyWhCode();

            Long ouId = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? fStoreMap.get(demandWhStCode).getOuId() : demandWhMap.get(demandWhStCode).getOuId();
            Long whOuId = whMap.get(supplyWhCode).getOuId();
            if (!ouId.equals(whOuId)) {
                SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
                rpcParam.setCompanyIdStart(whOuId);
                rpcParam.setCompanyIdEnd(ouId);
                rpcParams.add(rpcParam);
            }
        });
        Map<String, List<SupportTransactionPathRpcDTO>> suppTransactionPathMap = checkTransactionPathAndBuild(rpcParams);
        whNetRelationList.forEach(row -> {
            String demandWhStCode = row.getDemandWhStCode();
            String supplyWhCode = row.getSupplyWhCode();

            Long ouId = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? fStoreMap.get(demandWhStCode).getOuId() : demandWhMap.get(demandWhStCode).getOuId();
            String ouCode = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(row.getType()) ? fStoreMap.get(demandWhStCode).getOuCode() : demandWhMap.get(demandWhStCode).getOuCode();

            Long whOuId = whMap.get(supplyWhCode).getOuId();
            String whOuCode = whMap.get(supplyWhCode).getOuCode();
            if (!ouId.equals(whOuId)) {
                List<SupportTransactionPathRpcDTO> pathList = suppTransactionPathMap.get(whOuId + "@" + ouId);
                if (CollUtil.isEmpty(pathList) || StrUtil.isBlank(pathList.get(0).getPathCode())) {
                    log.info("从公司 {}到公司 {}的结算路径不存在，请维护", whOuId, ouId);
                    throw new BusinessException("从公司【" + whOuCode + "】至公司【" + ouCode + "】的结算路径不存在，请维护");
                }
                var detailList = pathList.get(0).getDetailList();
                int size = detailList.size();
                SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
                row.setCustCode(dto.getCompanyCodeStart());
                row.setOuCode(dto.getCompanyCodeStart());
                row.setOuName(dto.getCompanyNameStart());
                row.setCustCode(dto.getCustCodeEnd());
            }
        });
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreMap(List<String> demandStoreCodes) {
        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOS = rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStoreCodes);
        if (CollUtil.isEmpty(orgStoreBaseRpcDTOS)) {
            return new HashMap<>();
        }
        return orgStoreBaseRpcDTOS.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity(), (k1, k2) -> k1));
    }

    /**
     * 获取结算路径信息
     *
     * @param rpcParams
     * @return
     */
    private Map<String, List<SupportTransactionPathRpcDTO>> checkTransactionPathAndBuild(List<SupportTransactionPathRpcParam> rpcParams) {
        //查询结算路径
        log.info("查询启用状态的结算路径,参数:{}", JSONObject.toJSONString(rpcParams));
        List<SupportTransactionPathRpcDTO> data = supportTransactionPathRpcService.queryListByParam(rpcParams).getData();
        log.info("查询启用状态的结算路径结束,返回:{}", JSONObject.toJSONString(data));
        if (CollUtil.isEmpty(data)) {
            return new HashMap<>();
        }
        return data.stream().collect(Collectors.groupingBy(row -> row.getCompanyIdStart() + "@" + row.getCompanyIdEnd()));
    }

    private Map<String, InvWhRpcSimpleDTO> buildInvWhMap(List<String> demandWhCodes) {
        if (CollUtil.isEmpty(demandWhCodes)) {
            return new HashMap<>();
        }
        return rmiInvStkService.findInvWhBaseMapByCode(demandWhCodes);
    }

    private Map<String, OrgStoreBaseRpcDTO> getStoreInfoBy(List<String> demandStCodes) {
        log.info("批量查询门店信息入参{}", JSONUtil.toJsonStr(demandStCodes));
        List<OrgStoreBaseRpcDTO> resultList = rmiOrgStoreRpcService.findOrgStoreBaseByParam(demandStCodes);
        log.info("批量查询门店信息结果{}", JSONUtil.toJsonStr(resultList));
        Map<String, OrgStoreBaseRpcDTO> resultMap =
                resultList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, Function.identity()));
        log.info("批量查询门店信息结果字典{}", JSONUtil.toJsonStr(resultMap));
        return resultMap;
    }

    /**
     * 取得从供应仓库所在公司到需求仓库/门店所在公司之间的结算路径，取不到则销售公司为空（暂时不报错）。
     * <p>
     * 如果取到了，则取这个结算路径的最后一条明细的从公司，做为销售公司
     *
     * @param fromWhCode
     * @param toWhStCode
     * @return
     */
    private OuInfo getOuInfoFromPathCode(String fromWhCode, String toWhStCode, String type) {
        log.info("获取结算路径参数,从仓库编码:{},至仓库/门店编码:{}", fromWhCode, toWhStCode);
        InvWhRpcSimpleDTO invWhMap = rmiInvStkService.findSimpleWhByCode(fromWhCode);
        Long fromOuId = invWhMap.getOuId();
        String fromOuCode = invWhMap.getOuCode();
        Long toOuId;
        String toOuCode;
        if ("1".equals(type)) {  //仓库
            InvWhRpcSimpleDTO simpleDTO = rmiInvStkService.findSimpleWhByCode(toWhStCode);
            toOuCode = simpleDTO.getOuCode();
            toOuId = simpleDTO.getOuId();
        } else { //门店
            OrgStoreBaseRpcDTO orgStore = getOuIdByStoreCode(toWhStCode);
            toOuCode = orgStore.getOuCode();
            toOuId = orgStore.getOuId();
        }
        log.info("fromOuId的值:{},toOuId的值:{}", fromOuId, toOuId);
        if (fromOuId == null || toOuId == null) {
            return null;
        }
        SupportTransactionPathRpcDTO pathCodeResult = getPathCodeResult(fromOuId, toOuId);
        if (pathCodeResult == null) {
            throw new BusinessException("从公司【" + fromOuCode + "】至公司【" + toOuCode + "】的结算路径不存在，请维护");
        }
        log.info("获取到结算路径信息:{}", JSONUtil.toJsonStr(pathCodeResult));
        List<SupportTransactionPathDRpcDTO> detailList = pathCodeResult.getDetailList();
        int size = detailList.size();
        SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
        OuInfo ouInfo = new OuInfo();
        ouInfo.setOuCode(dto.getCompanyCodeStart());
        ouInfo.setOuName(dto.getCompanyNameStart());
        ouInfo.setOuId(dto.getCompanyIdStart());
        log.info("根据结算路径获取到销售公司信息:{}", JSONUtil.toJsonStr(ouInfo));
        return ouInfo;
    }

    private OrgStoreBaseRpcDTO getOuIdByStoreCode(String storeCode) {
        Map<String, OrgStoreBaseRpcDTO> storeInfoBy = getStoreInfoBy(Arrays.asList(storeCode));
        if (!storeInfoBy.containsKey(storeCode)) {
            throw new BusinessException("门店编码:" + storeCode + "不存在，请检查");
        }
        return storeInfoBy.get(storeCode);
    }


    private SupportTransactionPathRpcDTO getPathCodeResult(Long from, Long to) {
        log.info("查询结算路径参数,from:{},to:{}", from, to);
        SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
        rpcParam.setCompanyIdStart(from);
        rpcParam.setCompanyIdEnd(to);
        SupportTransactionPathRpcDTO result = supportTransactionPathRpcService.queryByParam(rpcParam).getData();
        log.info("查询结算路径结果:{}", JSONUtil.toJsonStr(result));
        return result;
    }

    public String setEmptyStringStr(String str) {
        return str == null ? "" : str;
    }

    private List<ScpWhNetRelationResultVO.ResultVO> getResultVOS(List<ScpWhNetRelationSaveVO.ScpWhNetRelation> whNetRelations) {
        return whNetRelations.stream().map(w -> {
            ScpWhNetRelationResultVO.ResultVO resultVO = new ScpWhNetRelationResultVO.ResultVO();
            resultVO.setSupplyWhId(w.getId());
            resultVO.setSupplyWhCode(w.getSupplyWhCode());
            resultVO.setSupplyWhName(w.getSupplyWhName());
            resultVO.setDemandWhStCode(w.getDemandWhStCode());
            resultVO.setDemandWhStId(w.getDemandWhStId());
            resultVO.setDemandWhStName(w.getDemandWhStName());
            resultVO.setType(w.getType());
            resultVO.setItemCode(w.getItemCode());
            resultVO.setItemId(w.getItemId());
            resultVO.setItemName(w.getItemName());
            resultVO.setItemCateCode(w.getItemCateCode());
            if (StringUtils.isNotEmpty(w.getItemCateName())) {
                String itemCateName = w.getItemCateName().replace(",", ">");
                resultVO.setItemCateName(itemCateName);

            }
            resultVO.setSupplyPercentage(w.getSupplyPercentage());
            resultVO.setLineNo(w.getLineNo());
            return resultVO;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ScpWhNetRelationRespVO> findWhNetList(ScpWhNetRelationBaseParamVO param) {
        String bussinessKey = param.getDemandWhStCode();
        if (StringUtils.isNotEmpty(param.getItemCateCode())) {
            bussinessKey = bussinessKey.concat(param.getItemCateCode());
            if (StringUtils.isNotEmpty(param.getItemCode())) {
                bussinessKey = bussinessKey.concat(param.getItemCode());
            }
        }
        List<ScpWhNetRelationDO> relationDOS = scpWhNetRelationDomainService.findByBussinessKey(bussinessKey);
        List<ScpWhNetRelationRespVO> relationRespVOList = relationDOS.stream().map(ScpWhNetRelationConvert.INSTANCE::doToRespVO).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(relationRespVOList)) {
            Map<String, Map<String, String>> typeMap = udcProvider.getValueMapByUdcCode("yst-suplan", Set.of("DEMAND_SET_TYPE"));
            relationRespVOList.forEach(d -> {
                d.setTypeName(typeMap.getOrDefault("DEMAND_SET_TYPE", new HashMap<>()).get(d.getType()));
                if (StringUtils.isNotEmpty(d.getItemCateCode())) {
                    List<ItmItemCateSimpleTreeRpcDTO> itemCatePath = itmItemRpcService.findItemCatePath(d.getItemCateCode());
                    d.setItemCatePath(itemCatePath);
                }
            });
        }
        return relationRespVOList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteWhNetRelation(List<Long> ids) {
        scpWhNetRelationDomainService.deleteBatch(ids);
    }


    @Override
    public List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam queryParam) {
        if (StringUtils.isNotEmpty(queryParam.getItemCode()) && StringUtils.isEmpty(queryParam.getItemCateCode())) {
            //商品品类
            ItmItemBaseRpcParam itemRpcDtoParam = new ItmItemBaseRpcParam();
            itemRpcDtoParam.setItemCodes(List.of(queryParam.getItemCode()));
            List<ItmItemBaseRpcDTO> itemRpcDtoByParam = itmItemRpcService.findItemBaseRpcDtoByParam(itemRpcDtoParam);
            queryParam.setItemCateCode(itemRpcDtoByParam.get(0).getItemCateCode());
        }
        log.info("ScpWhNetRelationRpcDtoParam:{} ", JSON.toJSONString(queryParam));
        List<ScpWhNetRelationRpcDTO> relationRpcDTOS = scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(queryParam);
        if (CollUtil.isEmpty(relationRpcDTOS)) {
            return new ArrayList<>();
        }
        List<ScpWhNetRelationRpcDTO> itemCodeLevelList = relationRpcDTOS.stream()
                .filter(d -> Objects.equals(queryParam.getItemCode(), d.getItemCode())
                        && Objects.equals(queryParam.getItemCateCode(), d.getItemCateCode()))
                .collect(Collectors.toList());

        List<ScpWhNetRelationRpcDTO> cateLevelList = relationRpcDTOS.stream()
                .filter(d -> Objects.equals(queryParam.getItemCateCode(), d.getItemCateCode()))
                .collect(Collectors.toList());
        List<ScpWhNetRelationRpcDTO> demandCodeList = relationRpcDTOS.stream()
                .filter(d -> Objects.equals(queryParam.getDemandWhStCode(), d.getDemandWhStCode()))
                .collect(Collectors.toList());
        if (CollUtil.isNotEmpty(itemCodeLevelList)) {
            return itemCodeLevelList;
        } else if (CollUtil.isNotEmpty(cateLevelList)) {
            return cateLevelList;
        } else {
            return demandCodeList;
        }
    }

    @Override
    public PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO queryParam) {
        if (Boolean.TRUE.equals(queryParam.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> pagingVO = getAuthorityPageRespVOPagingVO();
            if (pagingVO.isEmpty()) {
                return new PagingVO<>();
            }
            extractedAuthorityParam(queryParam, pagingVO);
        }
        return scpWhNetRelationDomainService.exportSearch(queryParam);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<String> executeImport(List<ScpWhNetRelationImportVO> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        List<String> errorList = new ArrayList<>();
        checkImportParam(dataList, errorList);
        List<String> result = validResult(errorList);
        List<String> successDocGroup = getSuccessDocGroup(result, dataList);
        if (successDocGroup.isEmpty()) {
            return result;
        }
        log.info("仓网关系导入节点一");
        List<String> suplyWhCodes = dataList.stream()
                .map(ScpWhNetRelationImportVO::getSupplyWhCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        InvWhRpcDtoParam whRpcDtoParam = new InvWhRpcDtoParam();
        whRpcDtoParam.setWhCodes(suplyWhCodes);

        ApiResult<List<InvWhRpcDTO>> whList = whProvider.findWhDTOByParam(whRpcDtoParam);
        Map<String, InvWhRpcDTO> supplyWhMap = whList.getData().stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n));

        //需求门店
        Map<String, OrgStoreBaseRpcDTO> storeMap = new HashMap<>();
        List<String> storeCodes = dataList.stream()
                .filter(d -> UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(d.getType()))
                .map(ScpWhNetRelationImportVO::getDemandWhStCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(storeCodes)) {
            OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
            orgStoreBaseRpcParam.setStoreCodeList(storeCodes);
            List<OrgStoreBaseRpcDTO> storeList = orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam).getData();
            storeMap = storeList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, i -> i, (o, n) -> n));
        }
        //需求仓库
        List<String> demandWhCodes = dataList.stream()
                .filter(d -> UdcEnum.DEMAND_SET_TYPE_1.getValueCode().equals(d.getType()))
                .map(ScpWhNetRelationImportVO::getDemandWhStCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        Map<String, InvWhRpcDTO> demandWhMap = new HashMap<>();
        if (CollUtil.isNotEmpty(demandWhCodes)) {
            InvWhRpcDtoParam whRpcDtoParam2 = new InvWhRpcDtoParam();
            whRpcDtoParam2.setWhCodes(demandWhCodes);
            ApiResult<List<InvWhRpcDTO>> demandWhList = whProvider.findWhDTOByParam(whRpcDtoParam2);
            demandWhMap = demandWhList.getData().stream().collect(Collectors.toMap(InvWhRpcDTO::getWhCode, i -> i, (o, n) -> n));
        }
        //商品品类
        List<String> itemCateCodes = dataList.stream()
                .map(ScpWhNetRelationImportVO::getItemCateCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        Map<String, ItmCateCodeAndNameRpcDTO> cateMap = new HashMap<>();
        if (CollUtil.isNotEmpty(itemCateCodes)) {
            ItmItemCateCodeParam cateCodeParam = new ItmItemCateCodeParam();
            cateCodeParam.setItemCateCodes(itemCateCodes);
            ItmItemCateCodeRpcDTO itemCateCodeRpcDTO = itmItemRpcService.findCateCodeReItemCateCode(cateCodeParam);
            cateMap = itemCateCodeRpcDTO.getCateMap();
            log.info("cateMap:{} ", JSON.toJSONString(cateMap));
        }
        //商品编码
        List<String> itemCodes = dataList.stream()
                .map(ScpWhNetRelationImportVO::getItemCode)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        Map<String, ItmItemRpcDTO> itemMap = new HashMap<>();
        if (CollUtil.isNotEmpty(itemCodes)) {
            ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
            itemRpcDtoParam.setItemCodes(itemCodes);
            List<ItmItemRpcDTO> itemRpcDtoByParam = itmItemRpcService.findItemRpcDtoByParam(itemRpcDtoParam);
            itemMap = itemRpcDtoByParam.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, i -> i, (o, e) -> e));
        }
        Map<Integer, List<String>> errorMap = new HashMap<>();
        HashMap<String, List<ScpWhNetRelationDTO>> whNetRelationMap = new HashMap<>();
        for (ScpWhNetRelationImportVO importEntity : dataList) {
            if (!successDocGroup.contains(importEntity.getType()+importEntity.getSupplyWhCode()
                    +importEntity.getDemandWhStCode()+importEntity.getItemCateCode()
                    +importEntity.getItemCode())) {
                continue;
            }
            errorMap.put(importEntity.getLineNo(), new ArrayList<>());
            List<ScpWhNetRelationDTO> relationDTOList = whNetRelationMap.get(importEntity.getType()
                    +importEntity.getSupplyWhCode()
                    +importEntity.getDemandWhStCode()+importEntity.getItemCateCode()
                    +importEntity.getItemCode());
            if (CollUtil.isEmpty(relationDTOList)) {
                relationDTOList = new ArrayList<>();
                whNetRelationMap.put(importEntity.getType()+importEntity.getSupplyWhCode()
                        +importEntity.getDemandWhStCode()+importEntity.getItemCateCode()
                        +importEntity.getItemCode(), relationDTOList
                );
            }
            ScpWhNetRelationDTO scpWhNetRelationDTO = new ScpWhNetRelationDTO();
            scpWhNetRelationDTO.setType(importEntity.getType());
            scpWhNetRelationDTO.setSupplyWhCode(importEntity.getSupplyWhCode());
            InvWhRpcDTO supplyWhRpcDTO = supplyWhMap.get(importEntity.getSupplyWhCode());
            if (supplyWhRpcDTO == null) {
                errorMap.get(importEntity.getLineNo()).add("供应仓库编码" + importEntity.getSupplyWhCode() + " 不存在");
            } else {
                scpWhNetRelationDTO.setSupplyWhId(supplyWhRpcDTO.getId());
                scpWhNetRelationDTO.setSupplyWhName(supplyWhRpcDTO.getWhName());
            }
            if (UdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(importEntity.getType())) {
                OrgStoreBaseRpcDTO storeDetailRpcDTO = storeMap.get(importEntity.getDemandWhStCode());
                if (storeDetailRpcDTO == null) {
                    errorMap.get(importEntity.getLineNo()).add("需求仓库编码/门店编码" + importEntity.getDemandWhStCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setDemandWhStId(storeDetailRpcDTO.getId());
                    scpWhNetRelationDTO.setDemandWhStCode(importEntity.getDemandWhStCode());
                    scpWhNetRelationDTO.setDemandWhStName(storeDetailRpcDTO.getStoreName());
                }
                if (!storeDetailRpcDTO.getOuId().equals(supplyWhRpcDTO.getOuId())) {
                    SupportTransactionPathRpcParam pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(supplyWhRpcDTO.getOuId());
                    pathRpcParam.setCompanyIdEnd(storeDetailRpcDTO.getOuId());
                    SupportTransactionPathRpcDTO data = supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("查询启用状态的结算路径结束,返回:{}", JSONObject.toJSONString(data));
                    if (data == null || StrUtil.isBlank(data.getPathCode())) {
                        log.info("从公司 {}到公司 {}的结算路径不存在，请维护", supplyWhRpcDTO.getOuId(), storeDetailRpcDTO.getOuId());
                        errorMap.get(importEntity.getLineNo()).add("从公司:" + supplyWhRpcDTO.getOuCode() + "到公司:" + storeDetailRpcDTO.getOuCode() + "的结算路径不存在，请维护");
                    }
                    var detailList = data.getDetailList();
                    int size = detailList.size();
                    SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
                    scpWhNetRelationDTO.setCustCode(dto.getCompanyCodeStart());
                    scpWhNetRelationDTO.setOuCode(dto.getCompanyCodeStart());
                    scpWhNetRelationDTO.setOuName(dto.getCompanyNameStart());
                    scpWhNetRelationDTO.setCustCode(dto.getCustCodeEnd());
                }
            } else {
                InvWhRpcDTO demandWhDto = demandWhMap.get(importEntity.getDemandWhStCode());
                if (demandWhDto == null) {
                    errorMap.get(importEntity.getLineNo()).add("需求仓库编码/门店编码" + importEntity.getDemandWhStCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setDemandWhStId(demandWhDto.getId());
                    scpWhNetRelationDTO.setDemandWhStCode(importEntity.getDemandWhStCode());
                    scpWhNetRelationDTO.setDemandWhStName(demandWhDto.getWhName());
                }
                if (!demandWhDto.getOuId().equals(supplyWhRpcDTO.getOuId())) {
                    SupportTransactionPathRpcParam pathRpcParam = new SupportTransactionPathRpcParam();
                    pathRpcParam.setCompanyIdStart(supplyWhRpcDTO.getOuId());
                    pathRpcParam.setCompanyIdEnd(demandWhDto.getOuId());
                    SupportTransactionPathRpcDTO data = supportTransactionPathRpcService.queryByParam(pathRpcParam).getData();
                    log.info("查询启用状态的结算路径结束,返回:{}", JSONObject.toJSONString(data));
                    if (data == null || StrUtil.isBlank(data.getPathCode())) {
                        log.info("从公司 {}到公司 {}的结算路径不存在，请维护", supplyWhRpcDTO.getOuId(), demandWhDto.getOuId());
                        errorMap.get(importEntity.getLineNo()).add("从公司:" + supplyWhRpcDTO.getOuCode() + "到公司:" + demandWhDto.getOuCode() + "的结算路径不存在，请维护");
                    }
                    var detailList = data.getDetailList();
                    int size = detailList.size();
                    SupportTransactionPathDRpcDTO dto = detailList.get(size - 1);
                    scpWhNetRelationDTO.setCustCode(dto.getCompanyCodeStart());
                    scpWhNetRelationDTO.setOuCode(dto.getCompanyCodeStart());
                    scpWhNetRelationDTO.setOuName(dto.getCompanyNameStart());
                    scpWhNetRelationDTO.setCustCode(dto.getCustCodeEnd());
                }
            }
            if (StringUtils.isNotEmpty(importEntity.getItemCateCode())) {
                ItmCateCodeAndNameRpcDTO itmCateCodeAndNameRpcDTO = cateMap.get(importEntity.getItemCateCode());
                if (itmCateCodeAndNameRpcDTO == null) {
                    errorMap.get(importEntity.getLineNo()).add("商品品类编码" + importEntity.getItemCateCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setItemCateName(String.join(">",
                            itmCateCodeAndNameRpcDTO.getCateNameList()));
                    scpWhNetRelationDTO.setItemCateCode(importEntity.getItemCateCode());
                }
            }
            if (StringUtils.isNotEmpty(importEntity.getItemCode())) {
                ItmItemRpcDTO itmItemRpcDTO = itemMap.get(importEntity.getItemCode());
                if (itmItemRpcDTO == null) {
                    errorMap.get(importEntity.getLineNo()).add("商品编码" + importEntity.getItemCode() + " 不存在");
                } else {
                    scpWhNetRelationDTO.setItemCode(importEntity.getItemCode());
                    scpWhNetRelationDTO.setItemId(itmItemRpcDTO.getId());
                    scpWhNetRelationDTO.setItemName(itmItemRpcDTO.getItemName());
                    scpWhNetRelationDTO.setItemCateName(String.join(">",
                            itmItemRpcDTO.getItemCatePathName()));
                    if(StringUtils.isNotEmpty(importEntity.getItemCateCode())
                            && !itmItemRpcDTO.getItemCateCode()
                            .equals(importEntity.getItemCateCode())){
                        errorMap.get(importEntity.getLineNo()).add("商品编码" +
                                importEntity.getItemCode() + "的品类和导入品类"
                                +importEntity.getItemCateCode()+" 不一致");
                    }else{
                        scpWhNetRelationDTO.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                    }
                }
            }
            scpWhNetRelationDTO.setTransferLeadTime(importEntity.getTransferLeadTime());
            scpWhNetRelationDTO.setSupplyPercentage(importEntity.getSupplyPercentage());
            scpWhNetRelationDTO.setStatus(Boolean.TRUE);
            scpWhNetRelationDTO.setEs1(importEntity.getImportBillNum());
            scpWhNetRelationDTO.setLineNo(importEntity.getLineNo());
            relationDTOList.add(scpWhNetRelationDTO);
        }
        log.info("仓网关系导入节点二");
        for (String key : whNetRelationMap.keySet()) {
            List<ScpWhNetRelationDTO> scpWhNetRelationDTOS = whNetRelationMap.get(key);
//            BigDecimal sumPercent = scpWhNetRelationDTOS.stream()
//                    .map(ScpWhNetRelationDTO::getSupplyPercentage)
//                    .reduce(BigDecimal.ZERO, BigDecimal::add);
//            if (sumPercent.compareTo(new BigDecimal("100")) != 0) {
//                scpWhNetRelationDTOS.forEach(a -> {
//                    errorMap.get(a.getLineNo()).add("序号组 " + a.getEs1() + "供应百分比不符合百分之百");
//                });
//            }
//            类型+供应仓库+需求门店+物料编码 唯一

            if(scpWhNetRelationDTOS.size()>=2){
                scpWhNetRelationDTOS.forEach(a -> {
                    errorMap.get(a.getLineNo()).add("类型+供应仓库+需求门店+品类编码+物料编码["+a.getType()+a.getSupplyWhCode()
                            +a.getDemandWhStCode()+a.getItemCateCode()
                            +a.getItemCode()+ "]导入存在重复数据");
                });
            }
            //默认赋值 100
            scpWhNetRelationDTOS.forEach(a -> {
                a.setSupplyPercentage(BigDecimal.valueOf(100L));
            });
            //校验数据是否存在
            Set<String> existsList = scpWhNetRelationDTOS.stream()
                    .map(d -> d.getType() + setEmptyStringStr(d.getSupplyWhCode())
                            + setEmptyStringStr(d.getDemandWhStCode())
                            + setEmptyStringStr(d.getItemCateCode())
                            + setEmptyStringStr(d.getItemCode()))
                    .collect(Collectors.toSet());
            List<ScpWhNetRelationDO> existList = scpWhNetRelationDomainService.findByAllConcatKey(existsList);
            if (CollUtil.isNotEmpty(existList)) {
                scpWhNetRelationDTOS.forEach(a -> {
                    errorMap.get(a.getLineNo()).add("类型+供应仓库+需求门店+品类编码+物料编码["+a.getType()+a.getSupplyWhCode()
                            +a.getDemandWhStCode()+a.getItemCateCode()+a.getItemCode()+ "]已有数据存在重复");
                });
            }
            //查询数据是否重复
//            HashMap<String, Integer> duplicateMap = new HashMap<>();
//            for (ScpWhNetRelationDTO d : scpWhNetRelationDTOS) {
//                if (duplicateMap.get(d.getDemandWhStCode()
//                        + setEmptyStringStr(d.getItemCateCode())
//                        + setEmptyStringStr(d.getItemCode())
//                        + d.getSupplyWhCode() + d.getType()) == null) {
//                    duplicateMap.put(d.getDemandWhStCode()
//                                    + setEmptyStringStr(d.getItemCateCode())
//                                    + setEmptyStringStr(d.getItemCode())
//                                    + d.getSupplyWhCode()
//                                    + d.getType()
//                            , d.getLineNo());
//                } else {
//                    errorMap.get(d.getLineNo()).add("序号组 " + d.getEs1() + "数据重复，需求仓库-商品品类-商品 存在相同【供应商仓-类型】组合数据，请检查");
//                }
//                if (CollUtil.isNotEmpty(existList)) {
//                    errorMap.get(d.getLineNo()).add("序号组 " + d.getEs1() + "配置已存在，需求仓库-商品品类-商品 满足供货百分比配置已存在，请修改");
//                }
//            }
        }
        log.info("仓网关系导入节点三");
        for (Integer line : errorMap.keySet()) {
            if (errorMap.get(line).isEmpty()) {
                continue;
            }
            if (Objects.equals(errorList.get(line - 1), "-")) {
                errorList.set(line - 1, String.join(",", errorMap.get(line)));
            } else {
                errorList.set(line - 1, errorList.get(line - 1) + String.join(",", errorMap.get(line)));
            }
        }
        successDocGroup = getSuccessDocGroup(errorList, dataList);
        List<ScpWhNetRelationDTO> ddos = new ArrayList<>();
        if (!successDocGroup.isEmpty()) {
            List<String> finalSuccessDocGroup = successDocGroup;
            for (String key : whNetRelationMap.keySet()) {
                List<ScpWhNetRelationDTO> scpWhNetRelationDTOS = whNetRelationMap.get(key);
                List<ScpWhNetRelationDTO> doList = scpWhNetRelationDTOS.stream()
                        .filter(i -> finalSuccessDocGroup.contains(i.getType()
                                +i.getSupplyWhCode()+i.getDemandWhStCode()
                                + i.getItemCateCode()
                                +i.getItemCode()))
                        .collect(Collectors.toList());
                if (doList.isEmpty()) {
                    continue;
                }
                ddos.addAll(doList);
            }
//            scpWhNetRelationDomainService.createBatch(ddos);
        }
        List<String> newResult = new ArrayList<>();
        List<String> errorNewList = new ArrayList<>();
        for (int i = 0; i < errorList.size(); i++) {
            String error = errorList.get(i);
            String importDocGroup = dataList.get(i).getType()
                    +dataList.get(i).getSupplyWhCode()
                    +dataList.get(i).getDemandWhStCode()
                    + dataList.get(i).getItemCateCode()
                    +dataList.get(i).getItemCode();
            if (!successDocGroup.contains(importDocGroup)) {
                if (Objects.equals(error, "-")) {
                    newResult.add("-");
                } else {
                    newResult.add(error);
                    errorNewList.add(error);
                }
            } else {
                newResult.add(null);
            }
        }
        if(CollUtil.isEmpty(errorNewList)){
            log.info("仓网关系导入节点四:{}",ddos);
            scpWhNetRelationDomainService.createBatch(ddos);
        }
        return newResult;
    }

    @Override
    public PagingVO<ScpWhNetRelationPageVO> scpmanAuthorityPage(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = getAuthorityPageRespVOPagingVO();
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return new PagingVO<>();
        }
        extractedAuthorityParam(queryParam, scpManAuthorityPageRespVOPagingVO);
        return page(queryParam);
    }

    @Override
    public Map<String, List<ScpWhNetRelationRpcDTO>> findWhNetByParam(String demandWhStCode, String type, List<ScpStoreCartDO> storeCartDOS) {
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap = new HashMap<>();
        // 查询仓网关系
        ScpWhNetRelationRpcDtoParam scpWhNetRelationRpcDtoParam = new ScpWhNetRelationRpcDtoParam();
        scpWhNetRelationRpcDtoParam.setType(type);
        scpWhNetRelationRpcDtoParam.setDemandWhStCode(demandWhStCode);
        List<ScpWhNetRelationRpcDTO> relationList = scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(scpWhNetRelationRpcDtoParam);
        // 匹配商品仓库关系
        for (ScpStoreCartDO cartDO : storeCartDOS) {
            //匹配商品code
            List<ScpWhNetRelationRpcDTO> itemCodeResults = relationList.stream().filter(row -> cartDO.getItemCode().equals(row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCodeResults)) {
                whNetRelationMap.put(cartDO.getItemCode(), itemCodeResults);
                continue;
            }
            //匹配商品品类
            List<ScpWhNetRelationRpcDTO> itemCateCodeResults = relationList.stream().filter(row -> cartDO.getItemCateCode().equals(row.getItemCateCode()) && StrUtil.isBlank(row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(itemCateCodeResults)) {
                whNetRelationMap.put(cartDO.getItemCode(), itemCateCodeResults);
                continue;
            }
            //匹配剩余的仓网关系
            List<ScpWhNetRelationRpcDTO> resultList = relationList.stream().filter(row -> StrUtil.isBlank(row.getItemCateCode()) && StringUtils.isBlank(row.getItemCode())).collect(Collectors.toList());
            if (CollUtil.isEmpty(resultList)) {
                continue;
            }
            whNetRelationMap.put(cartDO.getItemCode(), resultList);
        }
        return whNetRelationMap;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchDelete(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        List<ScpWhNetRelationDO> whNetRelationDOS = scpWhNetRelationDomainService.findByIds(ids).stream().filter(row -> Boolean.TRUE.equals(row.getStatus())).collect(Collectors.toList());

        List<ScpWhNetRelationDO> itemCodeGroups = whNetRelationDOS.stream().filter(row -> StrUtil.isNotBlank(row.getItemCode())).collect(Collectors.toList());
        List<ScpWhNetRelationDO> itemCateCodeGroups = whNetRelationDOS.stream().filter(row -> StrUtil.isNotBlank(row.getItemCateCode()) && StrUtil.isBlank(row.getItemCode())).collect(Collectors.toList());
        List<ScpWhNetRelationDO> whGroups = whNetRelationDOS.stream().filter(row -> StrUtil.isBlank(row.getItemCode()) && StrUtil.isBlank(row.getItemCateCode())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(itemCodeGroups)) {
            Map<String, List<ScpWhNetRelationDO>> itemCodeMap = itemCodeGroups.stream().collect(Collectors.groupingBy(row -> row.getDemandWhStCode() + row.getItemCode()));
            itemCodeMap.forEach((k, v) -> {
                BigDecimal sumAlloc = v.stream().map(ScpWhNetRelationDO::getSupplyPercentage).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                if (sumAlloc.compareTo(new BigDecimal("100")) != 0) {
                    ScpWhNetRelationDO scpWhNetRelationDO = v.get(0);
                    throw new BusinessException("门店/仓库【" + scpWhNetRelationDO.getDemandWhStName() + "】,商品【  " + scpWhNetRelationDO.getItemName() + "】配置比额不符合百分之百");
                }
            });
        }
        if (CollUtil.isNotEmpty(itemCateCodeGroups)) {
            Map<String, List<ScpWhNetRelationDO>> itemCateCodeMap = itemCateCodeGroups.stream().collect(Collectors.groupingBy(row -> row.getDemandWhStCode() + row.getItemCateCode()));
            itemCateCodeMap.forEach((k, v) -> {
                BigDecimal sumAlloc = v.stream().map(ScpWhNetRelationDO::getSupplyPercentage).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                if (sumAlloc.compareTo(new BigDecimal("100")) != 0) {
                    ScpWhNetRelationDO scpWhNetRelationDO = v.get(0);
                    throw new BusinessException("门店/仓库【" + scpWhNetRelationDO.getDemandWhStName() + "】,商品分类【  " + scpWhNetRelationDO.getItemCateName() + "】配置比额不符合百分之百");
                }
            });
        }
        if (CollUtil.isNotEmpty(whGroups)) {
            Map<String, List<ScpWhNetRelationDO>> whMap = whGroups.stream().collect(Collectors.groupingBy(row -> row.getDemandWhStCode()));
            whMap.forEach((k, v) -> {
                BigDecimal sumAlloc = v.stream().map(ScpWhNetRelationDO::getSupplyPercentage).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
                if (sumAlloc.compareTo(new BigDecimal("100")) != 0) {
                    ScpWhNetRelationDO scpWhNetRelationDO = v.get(0);
                    throw new BusinessException("门店/仓库【" + scpWhNetRelationDO.getDemandWhStName() + ",配置比额不符合百分之百");
                }
            });
        }
        scpWhNetRelationDomainService.deleteBatch(ids);
    }

    private void extractedAuthorityParam(ScpWhNetRelationPageParamVO queryParam, PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO) {
        List<ScpManAuthorityPageRespVO> records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List<Long> whIds = records.stream()
                .filter(v -> 1 == v.getType())
                .map(ScpManAuthorityPageRespVO::getStWhId)
                .filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> storeIds = records.stream()
                .filter(v -> 0 == v.getType())
                .map(ScpManAuthorityPageRespVO::getStWhId)
                .filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhIds(whIds);
        queryParam.setStoreIds(storeIds);
    }

    private PagingVO<ScpManAuthorityPageRespVO> getAuthorityPageRespVOPagingVO() {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty(currentUserDTO)) {
            throw new BusinessException("当前登录人查询异常");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setTypes(List.of(1, 0));
        scpManAuthorityParam.setEnableStatus(Boolean.TRUE);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        return scpManAuthorityPageRespVOPagingVO;
    }

    private List<String> validResult(List<String> errorList) {
        errorList.replaceAll(new UnaryOperator<String>() {
            @Override
            public String apply(String s) {
                if (StringUtils.isEmpty(s)) {
                    return "-";
                }
                return s;
            }
        });
        return errorList;
    }

    private List<String> getSuccessDocGroup(List<String> errorList, List<ScpWhNetRelationImportVO> dataList) {
        List<String> docGroupNo = dataList.stream()
                .map(a->a.getType()+a.getSupplyWhCode()
                        +a.getDemandWhStCode()+a.getItemCateCode()
                        +a.getItemCode())
                .distinct().collect(Collectors.toList());
        for (int i = 0; i < dataList.size(); i++) {
            ScpWhNetRelationImportVO entity = dataList.get(i);
            if (!Objects.equals("-", errorList.get(i))) {
                docGroupNo.remove(entity.getType()+entity.getSupplyWhCode()
                        +entity.getDemandWhStCode()+entity.getItemCateCode()
                        +entity.getItemCode());
            }
        }
        return docGroupNo;
    }


    //校验入参
    private void checkImportParam(List<ScpWhNetRelationImportVO> dataList, List<String> errorList) {
        Map<Integer, List<String>> errorMap = new HashMap<>();
        Map<String, String> typeMap = MapUtil.reverse(systemService.getValueMapByUdcCode("yst-suplan", "DEMAND_SET_TYPE"));
        Map<String, Integer> dumpMap = new HashMap<>();
        for (int i = 0; i < dataList.size(); i++) {
            ScpWhNetRelationImportVO importEntity = dataList.get(i);
            int line = i + 1;
            importEntity.setLineNo(line);
            errorMap.put(importEntity.getLineNo(), new ArrayList<>());
//            if (importEntity.getImportBillNum() == null) {
//                errorMap.get(line).add("列[分组编号]不能为空");
//            }
            if (StringUtils.isEmpty(importEntity.getTypeName())) {
                errorMap.get(line).add("列[类型]不能为空");
            } else {
                String lineType = typeMap.get(importEntity.getTypeName());
                if (StringUtils.isEmpty(lineType)) {
                    errorMap.get(importEntity.getLineNo()).add("列[类型名]" + importEntity.getTypeName() + " 不存在");
                } else {
                    importEntity.setType(lineType);
                }
            }
            if (StringUtils.isEmpty(importEntity.getDemandWhStCode())) {
                errorMap.get(line).add("列[需求仓库/门店编码]不能为空");
            }
            if (StringUtils.isEmpty(importEntity.getSupplyWhCode())) {
                errorMap.get(line).add("列[供应仓库编码]不能为空");
            }
//            if (importEntity.getSupplyPercentage() == null) {
//                errorMap.get(line).add("列[供货百分比]不能为空");
//            }
            if (StringUtils.isNotEmpty(importEntity.getDemandWhStCode())
                    && StringUtils.isNotEmpty(importEntity.getSupplyWhCode())
                    && StringUtils.isNotEmpty(importEntity.getType())) {
                String key = importEntity.getDemandWhStCode()
                        + setEmptyStringStr(importEntity.getItemCode())
                        + setEmptyStringStr(importEntity.getItemCateCode())
                        + importEntity.getSupplyWhCode() + importEntity.getType();
                if (dumpMap.get(key) == null) {
                    dumpMap.put(key, line);
                } else {
                    errorMap.get(line).add("需求仓库["+importEntity.getDemandWhStCode()+"],供应仓库/门店["+importEntity.getSupplyWhCode()+
                            "],商品 存在相同【供应商仓-类型】组合数据，请检查");
                }
            }
        }
        for (Integer line : errorMap.keySet()) {
            errorList.add(String.join(",", errorMap.get(line)));
        }
    }


}
