package com.elitesland.scp.infr.repo.authority;


import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface ScpDemandAuthorityDRepo extends JpaRepository<ScpsmanAuthorityDDO, Long>, QuerydslPredicateExecutor<ScpsmanAuthorityDDO>
{

    List<ScpsmanAuthorityDDO> findByMasIdAndStWhCode(Long masId,String storeCode);


    void deleteByMasIdAndStWhCode(Long masId,String storeCode);

    @Transactional//事务的注解
    @Modifying
//增删改必须有这个注解
    void deleteByMasIdInAndAuthSource(List<Long> ids,String authSource);
}
