package com.elitesland.scp.infr.repo.authority;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityDRespVO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Repository
public class ScpDemandAuthorityDRepoProc extends BaseRepoProc<ScpsmanAuthorityDDO> {

    private static final QScpsmanAuthorityDDO scpsmanAuthorityDDO = QScpsmanAuthorityDDO.scpsmanAuthorityDDO;

    public ScpDemandAuthorityDRepoProc() {
        super(scpsmanAuthorityDDO);
    }

    private final QBean<ScpsmanAuthorityDRespVO> pageList = Projections.bean(
            ScpsmanAuthorityDRespVO.class,
            scpsmanAuthorityDDO.id,
            scpsmanAuthorityDDO.masId,
            scpsmanAuthorityDDO.type,
            scpsmanAuthorityDDO.stWhId,
            scpsmanAuthorityDDO.stWhCode,
            scpsmanAuthorityDDO.stWhName,
            scpsmanAuthorityDDO.region,
            scpsmanAuthorityDDO.authSource,
            scpsmanAuthorityDDO.authSourceId,
            scpsmanAuthorityDDO.creator,
            scpsmanAuthorityDDO.createUserId,
            scpsmanAuthorityDDO.createTime,
            scpsmanAuthorityDDO.updater,
            scpsmanAuthorityDDO.modifyUserId,
            scpsmanAuthorityDDO.modifyTime
    );


    public Long deleteByIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpsmanAuthorityDDO.masId.in(ids));
        var delete = jpaQueryFactory.delete(scpsmanAuthorityDDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

    public Long deleteByDIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpsmanAuthorityDDO.id.in(ids));
        var delete = jpaQueryFactory.delete(scpsmanAuthorityDDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

    public void updateMasId(List<Long> ids,Long masId){
        jpaQueryFactory.update(scpsmanAuthorityDDO)
                .set(scpsmanAuthorityDDO.masId, masId)
                .where(scpsmanAuthorityDDO.id.in(ids))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByAuthSource(long masId, @NotBlank String authSource, Collection<String> authSourceIds) {
        Assert.hasText(authSource, "权限来源为空");

        var predicate = PredicateBuilder.builder()
                .andEq(scpsmanAuthorityDDO.masId, masId)
                .andEq(scpsmanAuthorityDDO.authSource, authSource)
                .andIn(scpsmanAuthorityDDO.authSourceId, authSourceIds)
                .build();
        super.delete(predicate);
    }

    public List<ScpsmanAuthorityDRespVO> findbyMasId(Long id) {
        JPAQuery<ScpsmanAuthorityDRespVO> respVOJPAQuery =
                jpaQueryFactory.select(pageList).from(scpsmanAuthorityDDO).where(scpsmanAuthorityDDO.masId.eq(id));

        return respVOJPAQuery.fetch();
    }

    public List<Long> getStWhIdListByMasId(long masId, Integer type) {
        var predicate = PredicateBuilder.builder()
                .andEq(scpsmanAuthorityDDO.masId, masId)
                .andEq(scpsmanAuthorityDDO.type, type)
                .build();
        return super.getValueList(scpsmanAuthorityDDO.stWhId, predicate);
    }

    public long countByMasId(long masId) {
        return super.count(scpsmanAuthorityDDO.masId, masId);
    }

    public List<Long> filterNoManual(Collection<Long> ids) {
        return super.jpaQueryFactory.select(scpsmanAuthorityDDO.id)
                .from(scpsmanAuthorityDDO)
                .where(scpsmanAuthorityDDO.id.in(ids).and(scpsmanAuthorityDDO.authSource.ne(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode())))
                .fetch();
    }

    public List<ScpsmanAuthorityDDO> listByMasId(long masId) {
        return super.getListByValue(scpsmanAuthorityDDO.masId, masId);
    }
}
