package com.elitesland.scp.infr.repo.authority;


import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityVO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@Repository
public class ScpDemandAuthorityRepoProc extends BaseRepoProc<ScpsmanAuthorityDO> {

    private static final QScpsmanAuthorityDO scpsmanAuthorityDO = QScpsmanAuthorityDO.scpsmanAuthorityDO;
    private static final QScpsmanAuthorityDDO scpsmanAuthorityDDO = QScpsmanAuthorityDDO.scpsmanAuthorityDDO;
    private static final QScpsmanInfoDO scpsmanInfoDO = QScpsmanInfoDO.scpsmanInfoDO;

    public ScpDemandAuthorityRepoProc() {
        super(scpsmanAuthorityDO);
    }

    public long countDemandSet(ScpManAuthorityParam param) {
        var jpaQuery = jpaQueryFactory.select(scpsmanAuthorityDO.count())
                .from(scpsmanAuthorityDO)
                .leftJoin(scpsmanAuthorityDDO).on(scpsmanAuthorityDO.id.eq(scpsmanAuthorityDDO.masId))
                .leftJoin(scpsmanInfoDO).on(scpsmanInfoDO.scpsmanNo.eq(scpsmanAuthorityDO.scpsmanNo));
        jpaQuery.where(this.whereDemandSet(param));
        return jpaQuery.fetchCount();
    }

    /**
     * 计划员权限主表加明细加计划员表字段
     */
    private final QBean<ScpManAuthorityPageRespVO> pageList = Projections.bean(
            ScpManAuthorityPageRespVO.class,
            scpsmanAuthorityDO.id,
            scpsmanAuthorityDO.scpsmanId,
            scpsmanAuthorityDO.scpsmanNo,
            scpsmanAuthorityDO.ouId,
            scpsmanAuthorityDO.ouName,
            scpsmanAuthorityDO.ouCode,
            scpsmanAuthorityDO.enableStatus,
            scpsmanAuthorityDO.creator,
            scpsmanAuthorityDO.createUserId,
            scpsmanAuthorityDO.createTime,
            scpsmanAuthorityDO.updater,
            scpsmanAuthorityDO.modifyUserId,
            scpsmanAuthorityDO.modifyTime,
            scpsmanAuthorityDDO.id.as("detailId"),
            scpsmanAuthorityDDO.masId,
            scpsmanAuthorityDDO.type,
            scpsmanAuthorityDDO.stWhId,
            scpsmanAuthorityDDO.stWhCode,
            scpsmanAuthorityDDO.stWhName,
            scpsmanAuthorityDDO.region,
            scpsmanInfoDO.name.as("scpsman")

    );

    private final QBean<ScpsmanAuthorityVO> queryWhere = Projections.bean(
            ScpsmanAuthorityVO.class,
            scpsmanAuthorityDO.id.as("authorityId"),
            scpsmanAuthorityDDO.id.as("authorityDid"),
            scpsmanAuthorityDDO.authSource
    );

    public List<ScpManAuthorityPageRespVO> queryPageDemandAuthority(ScpManAuthorityParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpsmanAuthorityDO)
                .leftJoin(scpsmanAuthorityDDO).on(scpsmanAuthorityDO.id.eq(scpsmanAuthorityDDO.masId))
                .leftJoin(scpsmanInfoDO).on(scpsmanInfoDO.scpsmanNo.eq(scpsmanAuthorityDO.scpsmanNo));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpsmanAuthorityDO);
        jpaQuery.where(this.whereDemandSet(paramVO));
        return jpaQuery.fetch();
    }


    public List<ScpManAuthorityPageRespVO> listQuery(ScpManAuthorityParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpsmanAuthorityDO)
                .leftJoin(scpsmanAuthorityDDO).on(scpsmanAuthorityDO.id.eq(scpsmanAuthorityDDO.masId))
                .leftJoin(scpsmanInfoDO).on(scpsmanInfoDO.scpsmanNo.eq(scpsmanAuthorityDO.scpsmanNo));
        jpaQuery.where(this.whereDemandSet(paramVO));
        return jpaQuery.fetch();
    }


    public List<ScpsmanAuthorityVO> listQuery(String StoreCode,Long manId) {
        var jpaQuery = jpaQueryFactory.select(queryWhere)
                .from(scpsmanAuthorityDO)
                .leftJoin(scpsmanAuthorityDDO).on(scpsmanAuthorityDO.id.eq(scpsmanAuthorityDDO.masId))
                .where(scpsmanAuthorityDO.scpsmanId.eq(manId))
                .where(scpsmanAuthorityDDO.stWhCode.eq(StoreCode));
                //.where(scpsmanAuthorityDDO.authSource.ne(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getCode()));
        return jpaQuery.fetch();
    }




    private Predicate whereDemandSet(ScpManAuthorityParam paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (CollUtil.isNotEmpty(paramVO.getRegions())) {
            predicates.add(scpsmanAuthorityDDO.region.in(paramVO.getRegions()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getIds())) {
            predicates.add(scpsmanAuthorityDO.id.in(paramVO.getIds()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDetailIds())) {
            predicates.add(scpsmanAuthorityDDO.id.in(paramVO.getDetailIds()));
        }
        if (StrUtil.isNotBlank(paramVO.getScpsmanNo())) {
            predicates.add(scpsmanAuthorityDO.scpsmanNo.eq(paramVO.getScpsmanNo()));
        }
        if (paramVO.getScpsmanId() != null) {
            predicates.add(scpsmanAuthorityDO.scpsmanId.eq(paramVO.getScpsmanId()));
        }
        if (StrUtil.isNotBlank(paramVO.getScpsmanName())) {
            predicates.add(scpsmanInfoDO.name.like("%"+paramVO.getScpsmanName()+"%"));
        }
        if (StrUtil.isNotBlank(paramVO.getOuCode())) {
            predicates.add(scpsmanAuthorityDO.ouCode.eq(paramVO.getOuCode()));
        }
        if (paramVO.getOuId() != null ) {
            predicates.add(scpsmanAuthorityDO.ouId.eq(paramVO.getOuId()));
        }
        if (StrUtil.isNotBlank(paramVO.getOuName())) {
            predicates.add(scpsmanAuthorityDO.ouName.like("%"+paramVO.getOuName()+"%"));
        }
        if (paramVO.getType() != null ) {
            predicates.add(scpsmanAuthorityDDO.type.eq(Math.toIntExact(paramVO.getType())));
        }
        if(CollectionUtil.isNotEmpty(paramVO.getTypes())){
            predicates.add(scpsmanAuthorityDDO.type.in(paramVO.getTypes()));
        }
        if (StrUtil.isNotBlank(paramVO.getStWhCode())) {
            predicates.add(scpsmanAuthorityDDO.stWhCode.eq(paramVO.getStWhCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getStWhName())) {
            predicates.add(scpsmanAuthorityDDO.stWhName.like("%"+paramVO.getStWhName()+"%"));
        }
        if (paramVO.getEnableStatus() != null) {
            predicates.add(scpsmanAuthorityDO.enableStatus.eq(paramVO.getEnableStatus()));
        }

        if (StrUtil.isNotBlank(paramVO.getLoginAccount())) {
            predicates.add(scpsmanInfoDO.loginAccount.eq(paramVO.getLoginAccount()));
        }
        if(CollectionUtil.isNotEmpty(paramVO.getStWhCodeList())){
            predicates.add(scpsmanAuthorityDDO.stWhCode.in(paramVO.getStWhCodeList()));
        }
        if(CollectionUtil.isNotEmpty(paramVO.getStWhNameList())){
            predicates.add(scpsmanAuthorityDDO.stWhName.in(paramVO.getStWhNameList()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void changeStatus(List<Long> ids, Boolean status) {
        JPAUpdateClause update = jpaQueryFactory.update(scpsmanAuthorityDO)
                .set(scpsmanAuthorityDO.enableStatus, status)
                .where(scpsmanAuthorityDO.id.in(ids));
        update.execute();
    }

    public Long deleteByIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpsmanAuthorityDO.id.in(ids));
        var delete = jpaQueryFactory.delete(scpsmanAuthorityDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

    public List<ScpManAuthorityPageRespVO> findByScpsmanNoIn(List<String> scpsmanNoList) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ScpManAuthorityPageRespVO.class,
                        scpsmanAuthorityDO.id,
                        scpsmanAuthorityDO.scpsmanId,
                        scpsmanAuthorityDO.scpsmanNo,
                        scpsmanAuthorityDO.ouId,
                        scpsmanAuthorityDO.ouName,
                        scpsmanAuthorityDO.ouCode,
                        scpsmanAuthorityDO.enableStatus,
                        scpsmanAuthorityDO.creator,
                        scpsmanAuthorityDO.createUserId,
                        scpsmanAuthorityDO.createTime,
                        scpsmanAuthorityDO.updater,
                        scpsmanAuthorityDO.modifyUserId,
                        scpsmanAuthorityDO.modifyTime,
                        scpsmanAuthorityDDO.id.as("detailId"),
                        scpsmanAuthorityDDO.masId,
                        scpsmanAuthorityDDO.type,
                        scpsmanAuthorityDDO.stWhId,
                        scpsmanAuthorityDDO.stWhCode,
                        scpsmanAuthorityDDO.stWhName
                ))
                .from(scpsmanAuthorityDO)
                .leftJoin(scpsmanAuthorityDDO).on(scpsmanAuthorityDO.id.eq(scpsmanAuthorityDDO.masId));
        jpaQuery.where(scpsmanAuthorityDO.scpsmanNo.in(scpsmanNoList));
        return jpaQuery.fetch();
    }

    public Long getIdByScpsManId(long scpsmanId) {
        return super.getIdByValue(scpsmanAuthorityDO.scpsmanId, scpsmanId);
    }

    public List<ScpManAuthorityPageRespVO> queryStoreCodeAndScpNo(){
       return jpaQueryFactory.select(Projections.bean(
                        ScpManAuthorityPageRespVO.class,scpsmanAuthorityDDO.stWhCode, scpsmanAuthorityDO.scpsmanNo,scpsmanAuthorityDDO.id))
                .from(scpsmanAuthorityDO)
                .leftJoin(scpsmanAuthorityDDO).on(scpsmanAuthorityDO.id.eq(scpsmanAuthorityDDO.masId))
                .where(scpsmanAuthorityDO.enableStatus.eq(true)).fetch();
    }
}
