package com.elitesland.scp.application.facade.vo.freight;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.scp.domain.entity.freight.ScpStoreOrderFreightDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.utils.BeanUtils;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("门店订单运费明细返回")
public class ScpStoreOrderFreightRespVO implements Serializable {

    @ApiModelProperty("需求门店编码或'all'")
    private String storeCode;

    @ApiModelProperty("需求门店名称或'全部'")
    private String storeName;

    @ApiModelProperty("记录ID，用于判断是否是修改")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("订货类型")
    @SysCode(sys = "yst-suplan", mod = "FREIGHT_ORDER_TYPE")
    private String orderType;
    private String orderTypeName;

    @ApiModelProperty("运费收取方式")
    @SysCode(sys = "yst-suplan", mod = "FREIGHT_METHOD")
    private String freightMethod;
    private String freightMethodName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品品类")
    private String itemCategoryCode;

    @ApiModelProperty("需求类型")
    private String demandType;

    @ApiModelProperty("运费收取比例")
    private BigDecimal freightRate;

    @ApiModelProperty("按数量收取金额")
    private BigDecimal amountPerQuantity;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer status;

    public static ScpStoreOrderFreightRespVO from(ScpStoreOrderFreightDO d) {
        if(d == null) {
            return null;
        }
        ScpStoreOrderFreightRespVO b = new ScpStoreOrderFreightRespVO();
        BeanUtils.copyProperties(d, b);
        if (b.getOrderType() != null){
            if (b.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_WD.getValueCode())) {
                b.setOrderTypeName(ScpUdcEnum.STORE_ORDER_TYPE_WD.getValueCodeName());
            } else if (b.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_DD.getValueCode())) {
                b.setOrderTypeName(ScpUdcEnum.STORE_ORDER_TYPE_DD.getValueCodeName());
            }
        }
        if (b.getFreightMethod() != null){
            if (b.getFreightMethod().equals(ScpUdcEnum.STORE_ORDER_FREIGHT_QU.getValueCode())) {
                b.setFreightMethodName(ScpUdcEnum.STORE_ORDER_FREIGHT_QU.getValueCodeName());
            } else if (b.getFreightMethod().equals(ScpUdcEnum.STORE_ORDER_FREIGHT_PR.getValueCode())) {
                b.setFreightMethodName(ScpUdcEnum.STORE_ORDER_FREIGHT_PR.getValueCodeName());
            }
        }
        return b;
    }
}
