package com.elitesland.scp.application.service.strategy;

import cn.hutool.core.lang.Assert;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderComputeVO;
import lombok.AllArgsConstructor;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
@AllArgsConstructor
public class EventContext implements InitializingBean {

    private final List<EventStrategy> eventStrategieList;
    private static Map<String, EventStrategy> STRATEGY_MAP = new HashMap<>(16);

    public void consumeEventInvStk(List<ScpDemandOrderComputeVO> storeParamVOS, BigDecimal warehouse, String allocRuleType) {
        var eventStrategy = STRATEGY_MAP.get(allocRuleType);
        Assert.notNull(eventStrategy, "找不到对应的分配策略");
        eventStrategy.handleInvStk(storeParamVOS, warehouse);
    }

    /**
     * 获取策略
     *
     * @param allocRuleType
     * @return
     */
    public EventStrategy getEvent(@NonNull String allocRuleType) {
        return STRATEGY_MAP.get(allocRuleType);
    }

    @Override
    public void afterPropertiesSet() {
        eventStrategieList.forEach(eventStrategy -> {
            eventStrategy.getAllocRuleTypes().forEach(allocRuleType -> {
                STRATEGY_MAP.put((String) allocRuleType, eventStrategy);
                log.info("策略类型：{}，策略实现：{}", allocRuleType, eventStrategy.getClass().getName());
            });
        });
    }
}
