/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.scp.boh.StoreReceiveSendParam;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRedisDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingStoreRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class StoreReceiveCancelListener
implements MessageQueueListener<StoreReceiveSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveCancelListener.class);
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveDRepo storeReceiveDRepo;
    private final RedisTemplate redisClient;
    private final TransactionTemplate transactionTemplate;
    private final ScpAllocSettingStoreRepo scpAllocSettingStoreRepo;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_order_cancel"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveSendParam storeReceiveSendParam) {
        log.info("\u8c03\u62e8\u8ba2\u5355\u53d6\u6d88\uff1a" + JSON.toJSONString((Object)storeReceiveSendParam));
        if ("TRO_AUTO_CLOSE".equals(storeReceiveSendParam.getDocType())) {
            log.info("\u8c03\u62e8\u8ba2\u5355\u81ea\u52a8\u5173\u95ed\u4e0d\u505a\u4e1a\u52a1\u5904\u7406:{}");
            return;
        }
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollUtil.isNotEmpty(receiveDOS) && "T".equals(receiveDOS.get(0).getRtType())) {
            StoreReceiveDO storeReceiveDO = receiveDOS.get(0);
            this.storeReceiveRepo.deleteAllById(storeReceiveDO.getId());
            this.storeReceiveDRepo.deleteAllByMasId(storeReceiveDO.getId());
        } else {
            List<Long> dIds = storeReceiveSendParam.getItems().stream().map(StoreReceiveSendParam.OrderItem::getOrderDid).collect(Collectors.toList());
            this.scpDemandOrderDDomainService.cancelOrderByDIds(dIds);
            this.scpDemandOrderDomainService.updateDocStatusById(storeReceiveSendParam.getOrderId(), "CANCEL");
        }
        Optional<ScpDemandOrderDTO> demandOrder = this.scpDemandOrderDomainService.findDemandOrderById(storeReceiveSendParam.getOrderId());
        if (demandOrder.isPresent()) {
            ScpDemandOrderDTO demandOrderDTO = demandOrder.get();
            List<ScpDemandOrderDDTO> demandOrderDDTOList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(demandOrderDTO.getId());
            List activityIds = demandOrderDDTOList.stream().map(ScpDemandOrderDDTO::getActivityId).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollUtil.isEmpty(activityIds)) {
                return;
            }
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(trans -> {
                try {
                    ScpAllocSettingRedisDO scpAllocSettingRedisDO = new ScpAllocSettingRedisDO();
                    String key = "SCP:ALLOC:SETTING:" + demandOrderDTO.getDemandWhStCode();
                    Object obj = this.redisClient.opsForValue().get((Object)key);
                    if (obj != null) {
                        String str = (String)obj;
                        ScpAllocSettingRedisDO setting = (ScpAllocSettingRedisDO)JSON.parseObject((String)str, ScpAllocSettingRedisDO.class);
                        List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList().stream().filter(row -> {
                            if (!activityIds.contains(row.getActivityId())) {
                                return false;
                            }
                            return row.getAllocNum() - 1 > 0;
                        }).map(row -> {
                            row.setAllocNum(row.getAllocNum() - 1);
                            return row;
                        }).collect(Collectors.toList());
                        scpAllocSettingRedisDO.setActivityList(activityList);
                        this.redisClient.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)scpAllocSettingRedisDO));
                    }
                    this.scpAllocSettingStoreRepo.minAllocNumByParam(activityIds, demandOrderDTO.getDemandWhStCode());
                    return null;
                }
                catch (Exception e) {
                    trans.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.getMessage());
                }
            });
        }
    }

    public StoreReceiveCancelListener(ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, StoreReceiveRepo storeReceiveRepo, StoreReceiveDRepo storeReceiveDRepo, RedisTemplate redisClient, TransactionTemplate transactionTemplate, ScpAllocSettingStoreRepo scpAllocSettingStoreRepo) {
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.storeReceiveRepo = storeReceiveRepo;
        this.storeReceiveDRepo = storeReceiveDRepo;
        this.redisClient = redisClient;
        this.transactionTemplate = transactionTemplate;
        this.scpAllocSettingStoreRepo = scpAllocSettingStoreRepo;
    }
}

