package com.elitesland.scp.domain.service.whnet;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.*;
import com.elitesland.scp.domain.convert.inv.ScpWhNetRelationConvert;
import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import com.elitesland.scp.infr.dto.whnet.ScpWhNetRelationDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepo;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 21日 11:00
 * @version: 1.0
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpWhNetRelationDomainServiceImpl implements ScpWhNetRelationDomainService {

    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;

    private final ScpWhNetRelationRepo scpWhNetRelationRepo;

    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpWhNetRelationPageVO> page = scpWhNetRelationRepoProc.page(queryParam);
        if(CollUtil.isNotEmpty(page.getRecords())) {
            List<String> concatKey = page.getRecords().stream().map(d -> d.getDemandWhStCode()
                     + setEmptyStringStr(d.getItemCateCode()) + setEmptyStringStr(d.getItemCode())).collect(Collectors.toList());
            List<ScpWhNetRelationDO> relationDOList = scpWhNetRelationRepo.findByConcatKey(concatKey);
            Map<String, List<ScpWhNetRelationDO>> scpWhNetMap = relationDOList.stream()
                    .collect(Collectors.groupingBy(d -> d.getDemandWhStCode() +
                    setEmptyStringStr(d.getItemCateCode()) + setEmptyStringStr(d.getItemCode())));
            page.getRecords().forEach(d -> {
                if (scpWhNetMap.get(d.getDemandWhStCode()  + setEmptyStringStr(d.getItemCateCode()) +setEmptyStringStr(d.getItemCode())) != null) {
                    BigDecimal sum = scpWhNetMap.get(d.getDemandWhStCode()  + setEmptyStringStr(d.getItemCateCode()) +setEmptyStringStr(d.getItemCode()) ).stream()
                            .map(ScpWhNetRelationDO::getSupplyPercentage)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    d.setSupplyPercentageSum(sum);
                }
            });
        }
        return page;
    }

    public String setEmptyStringStr(String str){
        return str == null ? "":str;
    }

    @Override
    public List<ScpWhNetRelationDO> findByConcatKey(Set<String> concatKey) {
        List<String> stringList = new ArrayList<>(concatKey);
        return scpWhNetRelationRepo.findByConcatKey(stringList);
    }

    @Override
    public List<ScpWhNetRelationDO> findByAllConcatKey(Set<String> concatKey) {
        List<String> stringList = new ArrayList<>(concatKey);
        return scpWhNetRelationRepo.findByAllConcatKey(stringList);
    }

    @Override
    public List<ScpWhNetRelationDO> findByBussinessKey(String concatKey) {
        return scpWhNetRelationRepo.findByAllBussinessKey(concatKey);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByConcatKey(Set<String> concatKey) {
        if(CollUtil.isEmpty(concatKey)){
            return;
        }
        List<String> stringList = new ArrayList<>(concatKey);
        scpWhNetRelationRepo.deleteByConcatKey(stringList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(List<ScpWhNetRelationDTO> scpWhNetRelationList) {
        scpWhNetRelationRepo.saveAll(scpWhNetRelationList.stream()
                .map(ScpWhNetRelationConvert.INSTANCE::dtoToDo)
                .collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> ids) {
        scpWhNetRelationRepo.deleteAllById(ids);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO queryParam) {
        PagingVO<ScpWhNetRelationExportRespVO> page = scpWhNetRelationRepoProc.exportSearch(queryParam);
        if(CollUtil.isNotEmpty(page.getRecords())){
            pageHandeler(page);
        }
        return page;
    }

    /**
     * 小程序端根据门店查询商品
     * @param paramVO
     * @return
     */
    @Override
    @SysCodeProc
    public PagingVO<ScpWhNetRelationPageVO> queryitemByStoreCode(AppItemPageParamVO paramVO) {
        PagingVO<ScpWhNetRelationPageVO> page = scpWhNetRelationRepoProc.queryitemByStoreCode(paramVO);
        return page;
    }

    @Override
    public List<ScpWhNetRelationDO> findByIds(List<Long> ids) {
        return scpWhNetRelationRepo.findByIdIn(ids);
    }

    private void pageHandeler(PagingVO<ScpWhNetRelationExportRespVO> page) {
        List<String> concatKey = page.getRecords().stream().map(d -> d.getDemandWhStCode()
                + setEmptyStringStr(d.getItemCateCode()) + setEmptyStringStr(d.getItemCode())).collect(Collectors.toList());
        List<ScpWhNetRelationDO> relationDOList = scpWhNetRelationRepo.findByConcatKey(concatKey);
        Map<String, List<ScpWhNetRelationDO>> scpWhNetMap = relationDOList.stream()
                .collect(Collectors.groupingBy(d -> d.getDemandWhStCode() +
                        setEmptyStringStr(d.getItemCateCode()) + setEmptyStringStr(d.getItemCode())));
        page.getRecords().forEach(d -> {
            d.setStatusName("启用");
            if(Boolean.FALSE.equals(d.getStatus())){
                d.setStatusName("禁用");
            }
            if (scpWhNetMap.get(d.getDemandWhStCode()  + setEmptyStringStr(d.getItemCateCode()) +setEmptyStringStr(d.getItemCode())) != null) {
                BigDecimal sum = scpWhNetMap.get(d.getDemandWhStCode()  + setEmptyStringStr(d.getItemCateCode()) +setEmptyStringStr(d.getItemCode()) ).stream()
                        .map(ScpWhNetRelationDO::getSupplyPercentage)
                        .filter(Objects::nonNull)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                d.setSupplyPercentageSum(sum);
            }
        });
    }
}
