/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.service.CrmCustRpcService;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiCrmRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiCrmRpcService.class);
    private final CrmCustRpcService crmCustRpcService;

    public ApiResult<List<CrmCustDTO>> listCustById(@NonNull List<Long> custIds) {
        if (custIds == null) {
            throw new NullPointerException("custIds is marked non-null but is null");
        }
        try {
            ApiResult listApiResult = this.crmCustRpcService.listCustById(custIds);
            return listApiResult;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u5f02\u5e38:{}", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
    }

    public ApiResult<CrmCustDTO> getCustInfo(String custCode) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a" + custCode);
        try {
            return this.crmCustRpcService.getCustInfo(custCode);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u9500\u552e\u652f\u6301\u4e2d\u5fc3\uff0c\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u9500\u552e\u652f\u6301\u4e2d\u5fc3\uff0c\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38" + e);
        }
    }

    public RmiCrmRpcService(CrmCustRpcService crmCustRpcService) {
        this.crmCustRpcService = crmCustRpcService;
    }
}

