package com.elitesland.scp.domain.entity.template;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 16:01
 * @Description:
 */

@Entity
@Table(name = "scp_template_set")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "scp_template_set", comment = "订货模板")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "scp_template_set", description = "订货模板表")
public class ScpTemplateSetDO extends BaseModel {
    private static final long serialVersionUID = -7234922868683108335L;

    @ApiModelProperty("订货模板编号")
    @Column(name = "demand_tem_code", columnDefinition = "varchar(30) comment '订货模板编号'")
    private String demandTemCode;

    @ApiModelProperty("订货模板名称")
    @Column(name = "demand_tem_name", columnDefinition = "varchar(100) comment '订货模板名称'")
    private String demandTemName;

    @ApiModelProperty("起始日期")
    @Column(name = "start_date", columnDefinition = "date comment '起始日期'")
    private Date startDate;

    @ApiModelProperty("截止日期")
    @Column(name = "end_date", columnDefinition = "date comment '截止日期'")
    private Date endDate;

    @ApiModelProperty("详细日期")
    @Column(name = "detailed_time", columnDefinition = "varchar(50) comment '详细日期'")
    private String detailedTime;

    @ApiModelProperty("状态，1:启用，0:禁用")
    @Column(name = "demand_tem_status", columnDefinition = "tinyint(1) default 1 comment '状态，1:启用，0:禁用'")
    private Integer demandTemStatus;

    @ApiModelProperty("单据类型")
    @Column(name = "doc_type", columnDefinition = "varchar(30) comment '单据类型'")
    private String docType;

    @ApiModelProperty("类型")
    @Comment("类型")
    @Column()
    private String type;
}
