package com.elitesland.scp.infr.repo.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.order.ScpComputeDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.*;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.QScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.item.QScpCateItemDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.QScpDemandOrderDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanInfoDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.utils.PartitionJpaUtil;
import com.elitesland.scp.utils.SysUtils;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
public class ScpDemandOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QScpDemandOrderDO scpDemandOrderDO = QScpDemandOrderDO.scpDemandOrderDO;
    private final QScpDemandOrderDDO scpDemandOrderDDO = QScpDemandOrderDDO.scpDemandOrderDDO;
    private final QScpCateItemDO scpCateItemDO = QScpCateItemDO.scpCateItemDO;
    private static final QScpsmanAuthorityDO scpsmanAuthorityDO = QScpsmanAuthorityDO.scpsmanAuthorityDO;
    private static final QScpsmanAuthorityDDO scpsmanAuthorityDDO = QScpsmanAuthorityDDO.scpsmanAuthorityDDO;
    private static final QScpsmanInfoDO scpsmanInfoDO = QScpsmanInfoDO.scpsmanInfoDO;

    private final QBean<ScpDemandOrderPageRespVO> pageList = Projections.bean(
            ScpDemandOrderPageRespVO.class,
            scpDemandOrderDO.id.add(scpDemandOrderDDO.id.coalesce(0L)).as("uniqueId"),
            scpDemandOrderDO.id,
            scpDemandOrderDO.type,
            scpDemandOrderDO.demandId,
            scpDemandOrderDO.demandCode,
            scpDemandOrderDO.demandName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.demandWhStId,
            scpDemandOrderDO.demandWhStCode,
            scpDemandOrderDO.demandWhStName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.storeType2,
            scpDemandOrderDO.docCode,
            scpDemandOrderDO.docType,
            scpDemandOrderDO.docCls,
            scpDemandOrderDO.docStatus,
            scpDemandOrderDO.remark,
            scpDemandOrderDDO.id.as("detailId"),
            scpDemandOrderDDO.sourceId,
            scpDemandOrderDDO.supplyType,
            scpDemandOrderDDO.itemCode,
            scpDemandOrderDDO.itemId,
            scpDemandOrderDDO.itemName,
            scpDemandOrderDDO.demandQuantity,
            scpDemandOrderDDO.allocationDeQuantity,
            scpDemandOrderDDO.unit,
            scpDemandOrderDDO.unitName,
            scpDemandOrderDDO.price,
            scpDemandOrderDDO.currency,
            scpDemandOrderDDO.allocationQuantity,
            scpDemandOrderDDO.planQuantity,
            scpDemandOrderDDO.suppWhId,
            scpDemandOrderDDO.suppWhCode,
            scpDemandOrderDDO.suppWhName,
            scpDemandOrderDDO.ouId,
            scpDemandOrderDDO.ouCode,
            scpDemandOrderDDO.ouName,
            scpDemandOrderDDO.srcDocId,
            scpDemandOrderDDO.srcDocNo,
            scpDemandOrderDDO.srcDocCls,
            scpDemandOrderDDO.srcDocLineNo,
            scpDemandOrderDDO.quantity,
            scpDemandOrderDDO.isPushed,
            scpDemandOrderDDO.isCalculated,
            scpDemandOrderDDO.creator,
            scpDemandOrderDDO.createTime,
            scpDemandOrderDDO.createUserId,
            scpDemandOrderDDO.modifyTime,
            scpDemandOrderDDO.modifyUserId,
            scpDemandOrderDDO.updater,
            scpDemandOrderDDO.syncMsg,
            scpDemandOrderDDO.remark.as("ddRemark"),
            scpDemandOrderDDO.uom2,
            scpDemandOrderDDO.uom2Name,
            scpDemandOrderDDO.qty2,
            scpDemandOrderDDO.saleOuCode,
            scpDemandOrderDDO.saleOuName,
            scpDemandOrderDDO.payStatus
    );

    private final QBean<ScpDemandOrderTitlePageRespVO> titlePageList = Projections.bean(
            ScpDemandOrderTitlePageRespVO.class,
            scpDemandOrderDO.id,
            scpDemandOrderDO.type,
            scpDemandOrderDO.demandId,
            scpDemandOrderDO.demandCode,
            scpDemandOrderDO.demandName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.demandWhStId,
            scpDemandOrderDO.demandWhStCode,
            scpDemandOrderDO.demandWhStName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.storeType2,
            scpDemandOrderDO.docCode,
            scpDemandOrderDO.docCls,
            scpDemandOrderDO.docStatus,
            scpDemandOrderDO.remark,
            scpDemandOrderDO.payStatus,
            scpDemandOrderDO.docType,
            scpDemandOrderDO.createTime,
            scpDemandOrderDO.creator,
            scpDemandOrderDO.updater,
            scpDemandOrderDO.modifyTime,
            scpDemandOrderDO.isCalculated,
            scpDemandOrderDO.isPushed
    );

    private final QBean<ScpDemandOrderDTO> demandOrderList = Projections.bean(
            ScpDemandOrderDTO.class,
            scpDemandOrderDO.id,
            scpDemandOrderDO.type,
            scpDemandOrderDO.demandId,
            scpDemandOrderDO.demandCode,
            scpDemandOrderDO.demandName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.demandWhStId,
            scpDemandOrderDO.demandWhStCode,
            scpDemandOrderDO.demandWhStName,
            scpDemandOrderDO.demandDate,
            scpDemandOrderDO.docType,
            scpDemandOrderDO.storeType2,
            scpDemandOrderDO.docCode,
            scpDemandOrderDO.docCls,
            scpDemandOrderDO.docStatus
    );

    public long countDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId))
                .leftJoin(scpsmanAuthorityDDO).on(scpDemandOrderDO.demandWhStCode.eq(scpsmanAuthorityDDO.stWhCode));
        jpaQuery.where(scpsmanAuthorityDDO.masId.in(paramVO.getAuthIds()));
        //分区查询字段
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDDO.class, paramVO);
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDO.class, paramVO);
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public long countDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDO)
                .leftJoin(scpsmanAuthorityDDO).on(scpDemandOrderDO.demandWhStCode.eq(scpsmanAuthorityDDO.stWhCode));
        jpaQuery.where(scpsmanAuthorityDDO.masId.in(paramVO.getAuthIds()));
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        //分区查询字段
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDO.class, paramVO);
        if (paramVO.getIsHeader()) {
            jpaQuery.groupBy(scpDemandOrderDO.id);
        }
        return jpaQuery.fetchCount();
    }

    public long countDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDO);
        jpaQuery.where(this.whereAppDemandOrderPage(paramVO));
        if (StrUtil.isNotBlank(paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            var subQuery = JPAExpressions.selectOne().from(scpDemandOrderDDO)
                    .where(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
            if (StrUtil.isNotBlank(paramVO.getKeyword())) {
                subQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
            }
            jpaQuery.where(subQuery.exists());
        }
        return jpaQuery.fetchCount();
    }


    public List<AppDemandOrderCountRespVO> countAppDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(
                scpDemandOrderDO.docStatus,
                scpDemandOrderDO.count().as("count")).from(scpDemandOrderDO);
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            jpaQuery.where(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            jpaQuery.where(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            jpaQuery.where(scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            jpaQuery.where(scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            Predicate predicate = scpDemandOrderDDO.isNotNull();
            jpaQuery.where(ExpressionUtils.and(predicate, scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        jpaQuery.groupBy(scpDemandOrderDO.docStatus);
        List<Tuple> tuples = jpaQuery.fetch();
        return tuples.stream().map(tuple -> {
            val orderCountRespVO = new AppDemandOrderCountRespVO();
            orderCountRespVO.setDocStatus(tuple.get(0, String.class));
            orderCountRespVO.setCount(tuple.get(1, Long.class));
            return orderCountRespVO;
        }).collect(Collectors.toList());
    }


    public List<ScpDemandOrderPageRespVO> queryDemandOrder(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId))
                .leftJoin(scpsmanAuthorityDDO).on(scpDemandOrderDO.demandWhStCode.eq(scpsmanAuthorityDDO.stWhCode));
        jpaQuery.where(scpsmanAuthorityDDO.masId.in(paramVO.getAuthIds()));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandOrderDDO);
        //分区查询字段
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDDO.class, paramVO);
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDO.class, paramVO);
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<Long> queryIdsByAccount(String account) {
        var subQuery = jpaQueryFactory.select(scpsmanAuthorityDO.id).distinct()
                .from(scpsmanAuthorityDO)
                .leftJoin(scpsmanInfoDO).on(scpsmanInfoDO.scpsmanNo.eq(scpsmanAuthorityDO.scpsmanNo))
                .where(scpsmanAuthorityDO.enableStatus.eq(Boolean.TRUE).and(scpsmanInfoDO.loginAccount.eq(account)));
        return subQuery.fetch();
    }

    public List<ScpDemandOrderTitlePageRespVO> queryDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(titlePageList)
                .from(scpDemandOrderDO)
                .leftJoin(scpsmanAuthorityDDO).on(scpDemandOrderDO.demandWhStCode.eq(scpsmanAuthorityDDO.stWhCode));
        jpaQuery.where(scpsmanAuthorityDDO.masId.in(paramVO.getAuthIds()));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandOrderDO);
        //分区查询字段
        PartitionJpaUtil.appendYmConditionToPredicate(jpaQuery, ScpDemandOrderDO.class, paramVO);
        jpaQuery.where(this.whereDemandOrderPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderPageRespVO> queryDemandOrderHeader(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ScpDemandOrderPageRespVO.class,
                        scpDemandOrderDO.id,
                        scpDemandOrderDO.type,
                        scpDemandOrderDO.demandId,
                        scpDemandOrderDO.demandCode,
                        scpDemandOrderDO.demandName,
                        scpDemandOrderDO.demandDate,
                        scpDemandOrderDO.demandWhStId,
                        scpDemandOrderDO.demandWhStCode,
                        scpDemandOrderDO.demandWhStName,
                        scpDemandOrderDO.demandDate,
                        scpDemandOrderDO.storeType2,
                        scpDemandOrderDO.docCode,
                        scpDemandOrderDO.docCls,
                        scpDemandOrderDO.docType,
                        scpDemandOrderDO.docStatus,
                        scpDemandOrderDO.remark,
                        scpDemandOrderDO.creator,
                        scpDemandOrderDO.createTime,
                        scpDemandOrderDO.replyFlag,
                        scpDemandOrderDO.isPushed
                ))
                .from(scpDemandOrderDO);
        if(paramVO.getListFlag()==null || !paramVO.getListFlag()){
            paramVO.setPaging(jpaQuery);
        }
        paramVO.fillOrders(jpaQuery, scpDemandOrderDO);
        if (StrUtil.isNotBlank(paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            var subQuery = JPAExpressions.selectOne().from(scpDemandOrderDDO)
                    .where(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
            if (StrUtil.isNotBlank(paramVO.getKeyword())) {
                subQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
            }
            jpaQuery.where(subQuery.exists());
        }
        jpaQuery.where(this.whereAppDemandOrderPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderPageRespVO> sumDemandAmt(List<Long> masId) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                        ScpDemandOrderPageRespVO.class,
                        scpDemandOrderDDO.masId.as("id"),
                        scpDemandOrderDDO.allocationDeQuantity.coalesce(BigDecimal.ZERO).sum().as("demandSumQuantity"),
                        scpDemandOrderDDO.price.coalesce(BigDecimal.ZERO).multiply(scpDemandOrderDDO.allocationDeQuantity.coalesce(BigDecimal.ZERO)).sum().as("demandSumAmt")
                ))
                .from(scpDemandOrderDDO);
        jpaQuery.where(scpDemandOrderDDO.masId.in(masId));
        jpaQuery.groupBy(scpDemandOrderDDO.masId);
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderDTO> findDemandOrderByParam(ScpDemandOrderParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(demandOrderList)
                .from(scpDemandOrderDO);
        jpaQuery.where(this.whereDemandOrder(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> getItemAndWarehouseByIds(List<Long> ids) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpDemandOrderComputeVO.class,
                scpDemandOrderDDO.id,
                scpDemandOrderDDO.itemId,
                scpDemandOrderDDO.itemCode,
                scpDemandOrderDDO.suppWhCode,
                scpDemandOrderDDO.suppWhId,
                scpDemandOrderDDO.demandQuantity,
                scpDemandOrderDDO.ouId,
                scpDemandOrderDDO.ouCode,
                scpDemandOrderDDO.allocationDeQuantity,
                scpDemandOrderDDO.planQuantity,
                scpDemandOrderDO.demandCode,
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.demandWhStId,
                scpDemandOrderDO.demandWhStCode,
                scpDemandOrderDO.storeLevel,
                scpDemandOrderDDO.unit
        )).from(scpDemandOrderDDO).leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.id.in(ids));
        jpaQuery.where(scpDemandOrderDDO.supplyType.eq(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode()));
        jpaQuery.where(scpDemandOrderDDO.isCalculated.eq(Boolean.FALSE).and(scpDemandOrderDDO.isPushed.eq(Boolean.FALSE)));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> findDemandOrderInfo(Long demandId) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpDemandOrderComputeVO.class,
                scpDemandOrderDDO.id,
                scpDemandOrderDDO.itemId,
                scpDemandOrderDDO.itemCode,
                scpDemandOrderDDO.suppWhCode,
                scpDemandOrderDDO.suppWhId,
                scpDemandOrderDDO.demandQuantity,
                scpDemandOrderDDO.allocationDeQuantity,
                scpDemandOrderDO.demandCode,
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.storeLevel,
                scpDemandOrderDO.docStatus,
                scpDemandOrderDDO.unit,
                scpDemandOrderDDO.isPushed,
                scpDemandOrderDDO.isCalculated
        )).from(scpDemandOrderDDO).leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.demandId.eq(demandId));
        return jpaQuery.fetch();
    }

    public List<ScpDemandOrderComputeVO> findDemandOrderById(Long id) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpDemandOrderComputeVO.class,
                scpDemandOrderDDO.id,
                scpDemandOrderDDO.itemId,
                scpDemandOrderDDO.itemCode,
                scpDemandOrderDDO.suppWhCode,
                scpDemandOrderDDO.suppWhId,
                scpDemandOrderDDO.demandQuantity,
                scpDemandOrderDDO.allocationDeQuantity,
                scpDemandOrderDO.demandCode,
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.storeLevel,
                scpDemandOrderDO.docStatus,
                scpDemandOrderDDO.unit,
                scpDemandOrderDDO.isPushed,
                scpDemandOrderDDO.isCalculated
        )).from(scpDemandOrderDDO).leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.id.eq(id));
        return jpaQuery.fetch();
    }

    private Predicate whereAppDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDemandCode())) {
            predicates.add(scpDemandOrderDO.demandCode.like(paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            predicates.add(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            predicates.add(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            predicates.add(scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            predicates.add(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (CollUtil.isNotEmpty(paramVO.getDemandWhStCodes())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.in(paramVO.getDemandWhStCodes()));
        }
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            predicates.add(scpDemandOrderDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getPayStatusList())) {
            predicates.add(scpDemandOrderDO.payStatus.in(paramVO.getPayStatusList()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            predicates.add(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (paramVO.getReplyFlag() != null) {
            predicates.add(scpDemandOrderDO.replyFlag.eq(paramVO.getReplyFlag()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getCreateTimeFrom()) && !ObjectUtils.isEmpty(paramVO.getCreateTimeTo())) {
            predicates.add(scpDemandOrderDO.createTime.between(paramVO.getCreateTimeFrom(), paramVO.getCreateTimeTo()));
        }
        if (paramVO.getIsPushed() != null) {
            predicates.add(scpDemandOrderDO.isPushed.eq(paramVO.getIsPushed()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    private Predicate whereDemandOrderPage(ScpDemandOrderPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDemandCode())) {
            predicates.add(scpDemandOrderDO.demandCode.like(paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            predicates.add(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            predicates.add(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocStatusList())) {
            predicates.add(scpDemandOrderDO.docStatus.in(paramVO.getDocStatusList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.like(paramVO.getDemandWhStCode() + "%"));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            Predicate predicate = scpDemandOrderDDO.isNotNull();
            predicates.add(ExpressionUtils.and(predicate, scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%"))));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            predicates.add(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            predicates.add(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (CollUtil.isNotEmpty(paramVO.getDemandWhStCodes())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.in(paramVO.getDemandWhStCodes()));
        }
        if (CollUtil.isNotEmpty(paramVO.getIdSet())) {
            predicates.add(scpDemandOrderDDO.masId.add(scpDemandOrderDDO.id.coalesce(0L)).in(paramVO.getIdSet()));
        }
        if (StrUtil.isNotBlank(paramVO.getSuppWhCode())) {
            predicates.add(scpDemandOrderDDO.suppWhCode.eq(paramVO.getSuppWhCode()));
        }
        if (CollUtil.isNotEmpty(paramVO.getSuppWhCodes())) {
            predicates.add(scpDemandOrderDDO.suppWhCode.in(paramVO.getSuppWhCodes()));
        }
        if (StrUtil.isNotBlank(paramVO.getSupplyType())) {
            predicates.add(scpDemandOrderDDO.supplyType.eq(paramVO.getSupplyType()));
        }
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            predicates.add(scpDemandOrderDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getPayStatusList())) {
            predicates.add(scpDemandOrderDO.payStatus.in(paramVO.getPayStatusList()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            predicates.add(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (paramVO.getReplyFlag() != null) {
            predicates.add(scpDemandOrderDO.replyFlag.eq(paramVO.getReplyFlag()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getCreateTimeFrom()) && !ObjectUtils.isEmpty(paramVO.getCreateTimeTo())) {
            predicates.add(scpDemandOrderDO.createTime.between(paramVO.getCreateTimeFrom(), paramVO.getCreateTimeTo()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    private Predicate whereDemandOrder(ScpDemandOrderParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDemandCode())) {
            predicates.add(scpDemandOrderDO.demandCode.eq(paramVO.getDemandCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            predicates.add(scpDemandOrderDO.docCode.eq(paramVO.getDocCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocStatus())) {
            predicates.add(scpDemandOrderDO.docStatus.eq(paramVO.getDocStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            predicates.add(scpDemandOrderDO.demandWhStCode.eq(paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void updateOrderStatusByCode(String docCode, String status, Boolean isCalculated) {
        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.docStatus, status)
                .where(scpDemandOrderDO.docCode.eq(docCode));
        if (isCalculated != null) {
            update.set(scpDemandOrderDO.isCalculated, isCalculated);
        }
        update.execute();
    }

    public void updateOrderStatusById(Long id, String status, Boolean isPushed) {
        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.docStatus, status)
                .where(scpDemandOrderDO.id.eq(id));
        if (isPushed != null) {
            update.set(scpDemandOrderDO.isPushed, isPushed);
        }
        update.execute();
    }

    public void updatePayStatusById(Long id, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.payStatus, status)
                .where(scpDemandOrderDO.id.eq(id));
        update.execute();
    }

    public void updateOrderStatusAndPayStatusById(Long id, String status, String payStatus) {
        String orderSetting = SysUtils.getOrderSetting();

        JPAUpdateClause update = jpaQueryFactory.update(scpDemandOrderDO)
                .set(scpDemandOrderDO.docStatus, status)
                .set(scpDemandOrderDO.payStatus, payStatus)
                .where(scpDemandOrderDO.id.eq(id));
        if ("1".equals(orderSetting)) {
            update.set(scpDemandOrderDO.isCalculated, Boolean.TRUE);
        }
        update.execute();
    }

    public long countUnPushedItemByDemandId(Long demandId) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.demandId.eq(demandId));
        jpaQuery.where(scpDemandOrderDDO.isPushed.eq(Boolean.FALSE).and(scpDemandOrderDDO.isCalculated.eq(Boolean.TRUE)));
        return jpaQuery.fetchCount();
    }

    public List<ScpDemandOrderDO> findByDemandWhStCodeInAndByCreateTime(List<String> collect, LocalDateTime fromTime, LocalDateTime toTime) {
        JPAQuery<ScpDemandOrderDO> jpaQuery = jpaQueryFactory.select(scpDemandOrderDO)
                .from(scpDemandOrderDO);

        if (CollectionUtil.isNotEmpty(collect)) {
            jpaQuery.where(scpDemandOrderDO.demandWhStCode.in(collect));
        }
        if (fromTime != null) {
            jpaQuery.where(scpDemandOrderDO.createTime.goe(fromTime));
        }
        if (toTime != null) {
            jpaQuery.where(scpDemandOrderDO.createTime.loe(toTime));
        }
        return jpaQuery.fetch();
    }

    public long countDemandOrderByDemandIds(List<Long> demandIds) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.count())
                .from(scpDemandOrderDO);
        jpaQuery.where(scpDemandOrderDO.demandId.in(demandIds));
        return jpaQuery.fetchCount();
    }

    public List<ScpDemandOrderComputeVO> findComputeDemandOrderDByParam(List<Long> orderIds) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpDemandOrderComputeVO.class,
                scpDemandOrderDDO.id,
                scpDemandOrderDDO.itemId,
                scpDemandOrderDDO.itemCode,
                scpDemandOrderDDO.suppWhCode,
                scpDemandOrderDDO.suppWhId,
                scpDemandOrderDDO.demandQuantity,
                scpDemandOrderDDO.ouId,
                scpDemandOrderDDO.ouCode,
                scpDemandOrderDDO.allocationDeQuantity,
                scpDemandOrderDDO.planQuantity,
                scpDemandOrderDO.demandCode,
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.demandWhStId,
                scpDemandOrderDO.demandWhStCode,
                scpDemandOrderDO.storeLevel,
                scpDemandOrderDDO.unit
        )).from(scpDemandOrderDDO).leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        jpaQuery.where(scpDemandOrderDO.id.in(orderIds));
        jpaQuery.where(scpDemandOrderDDO.isCalculated.eq(Boolean.FALSE).and(scpDemandOrderDDO.isPushed.eq(Boolean.FALSE)));
        return jpaQuery.fetch();
    }

    public List<Long> pageDemandOrderIds(ScpComputeDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.id)
                .from(scpDemandOrderDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandOrderDO);
        jpaQuery.where(scpDemandOrderDO.demandId.eq(paramVO.getDemandId()));
        return jpaQuery.fetch();
    }

    public long countAppPayPage(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDDO.count())
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            jpaQuery.where(scpDemandOrderDDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            jpaQuery.where(scpDemandOrderDO.demandWhStCode.eq(paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            jpaQuery.where(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            jpaQuery.where(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            jpaQuery.where(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            jpaQuery.where(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getPayStatusList())) {
            jpaQuery.where(scpDemandOrderDDO.payStatus.in(paramVO.getPayStatusList()));
        }
        jpaQuery.where(scpDemandOrderDO.docStatus.eq(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()));
        jpaQuery.where(scpDemandOrderDDO.srcDocId.isNotNull());
        jpaQuery.groupBy(scpDemandOrderDDO.srcDocNo);
        return jpaQuery.fetchCount();
    }

    public List<ScpPayOrderPageRespVO> payPage(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpPayOrderPageRespVO.class,
                        scpDemandOrderDDO.srcDocCls,
                        scpDemandOrderDDO.srcDocId,
                        scpDemandOrderDDO.srcDocNo,
                        scpDemandOrderDDO.saleOuName,
                        scpDemandOrderDDO.saleOuCode,
                        scpDemandOrderDDO.masId.as("docId"),
                        scpDemandOrderDDO.payStatus,
                        scpDemandOrderDDO.planAmt.sum().as("amt")
                ))
                .from(scpDemandOrderDDO)
                .leftJoin(scpDemandOrderDO).on(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
        paramVO.setPaging(jpaQuery);
        if (StrUtil.isNotBlank(paramVO.getPayStatus())) {
            jpaQuery.where(scpDemandOrderDDO.payStatus.eq(paramVO.getPayStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getDemandWhStCode())) {
            jpaQuery.where(scpDemandOrderDO.demandWhStCode.eq(paramVO.getDemandWhStCode()));
        }
        if (StrUtil.isNotBlank(paramVO.getKeyword())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            jpaQuery.where(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
        }
        if (!ObjectUtils.isEmpty(paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty(paramVO.getDemandDateTo())) {
            jpaQuery.where(scpDemandOrderDO.demandDate.between(paramVO.getDemandDateFrom(), paramVO.getDemandDateTo()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getDocTypeList())) {
            jpaQuery.where(scpDemandOrderDO.docType.in(paramVO.getDocTypeList()));
        }
        if (paramVO.getDocType()!=null) {
            jpaQuery.where(scpDemandOrderDO.docType.eq(paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            jpaQuery.where(scpDemandOrderDO.type.eq(paramVO.getType()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocCode())) {
            jpaQuery.where(scpDemandOrderDO.docCode.like(paramVO.getDocCode() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getPayStatusList())) {
            jpaQuery.where(scpDemandOrderDDO.payStatus.in(paramVO.getPayStatusList()));
        }
        jpaQuery.where(scpDemandOrderDO.docStatus.eq(ScpUdcEnum.DEO_STATUS_PUSHED.getValueCode()));
        jpaQuery.where(scpDemandOrderDDO.srcDocId.isNotNull());
        jpaQuery.groupBy(scpDemandOrderDDO.srcDocNo, scpDemandOrderDDO.masId, scpDemandOrderDDO.srcDocCls,
                scpDemandOrderDDO.srcDocId, scpDemandOrderDDO.payStatus, scpDemandOrderDDO.saleOuCode, scpDemandOrderDDO.saleOuName);
        jpaQuery.orderBy(scpDemandOrderDDO.masId.desc());
        return jpaQuery.fetch();
    }

    public List<ScpPayOrderPageRespVO> findDemandOrderByIds(List<Long> ids) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpPayOrderPageRespVO.class,
                scpDemandOrderDO.id.as("docId"),
                scpDemandOrderDO.docCode,
                scpDemandOrderDO.docCls,
                scpDemandOrderDO.docType,
                scpDemandOrderDO.docStatus,
                scpDemandOrderDO.createTime
        )).from(scpDemandOrderDO);
        jpaQuery.where(scpDemandOrderDO.id.in(ids));
        return jpaQuery.fetch();
    }

    public AppPayOrderRespVO findPayOrderById(Long srcDocId) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(AppPayOrderRespVO.class,
                        scpDemandOrderDDO.srcDocCls,
                        scpDemandOrderDDO.srcDocId,
                        scpDemandOrderDDO.srcDocNo,
                        scpDemandOrderDDO.saleOuCode,
                        scpDemandOrderDDO.saleOuName,
                        scpDemandOrderDDO.masId.as("docId"),
                        scpDemandOrderDDO.payStatus,
                        scpDemandOrderDDO.onlinePayFlag,
                        scpDemandOrderDDO.payerName
                ))
                .from(scpDemandOrderDDO);
        jpaQuery.where(scpDemandOrderDDO.srcDocId.eq(srcDocId));
        jpaQuery.groupBy(scpDemandOrderDDO.srcDocNo, scpDemandOrderDDO.masId, scpDemandOrderDDO.srcDocCls,
                scpDemandOrderDDO.srcDocId, scpDemandOrderDDO.payStatus, scpDemandOrderDDO.saleOuCode, scpDemandOrderDDO.saleOuName,
                scpDemandOrderDDO.onlinePayFlag, scpDemandOrderDDO.payerName);
        return jpaQuery.fetchOne();
    }

    public Long countAppOrderByParam(ScpDemandOrderPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.count())
                .from(scpDemandOrderDO)
                .where(this.whereAppDemandOrderPage(paramVO));
        if (StrUtil.isNotBlank(paramVO.getKeyword()) || CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
            var subQuery = JPAExpressions.selectOne().from(scpDemandOrderDDO)
                    .where(scpDemandOrderDO.id.eq(scpDemandOrderDDO.masId));
            if (StrUtil.isNotBlank(paramVO.getKeyword())) {
                subQuery.where(scpDemandOrderDDO.itemCode.like(paramVO.getKeyword() + "%").or(scpDemandOrderDDO.itemName.like("%" + paramVO.getKeyword() + "%")));
            }
            if (CollectionUtil.isNotEmpty(paramVO.getItemCodes())) {
                subQuery.where(scpDemandOrderDDO.itemCode.in(paramVO.getItemCodes()));
            }
            jpaQuery.where(subQuery.exists());
        }
        return jpaQuery.fetchOne();
    }

    public String getOrderTypeById(Long id) {
        return jpaQueryFactory.select(scpDemandOrderDO.type)
                .from(scpDemandOrderDO)
                .where(scpDemandOrderDO.id.eq(id))
                .fetchOne();
    }

    public Long countUnReply(Long storeId, LocalDateTime dateTime) {
        var jpaQuery = jpaQueryFactory.select(scpDemandOrderDO.count())
                .from(scpDemandOrderDO)
                .where(scpDemandOrderDO.demandWhStId.eq(storeId));
        jpaQuery.where(scpDemandOrderDO.docStatus.eq(ScpUdcEnum.DEO_STATUS_RECV.getValueCode()));
        jpaQuery.where(scpDemandOrderDO.replyFlag.eq(Boolean.FALSE));
        jpaQuery.where(scpDemandOrderDO.createTime.goe(dateTime));
        return jpaQuery.fetchCount();
    }
}
