package com.elitesland.scp.application.facade.vo.param.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel(value = "商品规格弹窗查询入参")
public class AppItemSpecParamVO implements Serializable {
    private static final long serialVersionUID = -8387700128516698775L;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "商品spuId", required = true)
    @NotNull(message = "商品spuId不能为空")
    private Long spuId;

    @ApiModelProperty(value = "商品编码", required = true)
    @NotNull(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty(value = "单据类型", required = true)
//    @NotBlank(message = "单据类型不能为空")
    private String docType;

    @ApiModelProperty(value = "业务类型", required = true)
    @NotBlank(message = "业务类型不能为空")
    private String businessType;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;
}
