package com.elitesland.scp.application.facade.vo.save.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "订货订单保存参数")
public class ScpDemandOrderSaveVO implements Serializable {
    private static final long serialVersionUID = 2310302359745458378L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "订货集ID", required = true)
    @NotNull(message = "订货集ID不能为空")
    private Long demandId;

    @ApiModelProperty(value = "订货集编码", required = true)
    @NotBlank(message = "订货集编码不能为空")
    private String demandCode;

    @ApiModelProperty(value = "订货集名称", required = true)
    @NotBlank(message = "订货集名称不能为空")
    private String demandName;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty(value = "单据类别", required = true)
    @NotBlank(message = "单据类别不能为空")
    private String docCls;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty(value = "类型，0:门店，1:仓库", required = true)
    @NotBlank(message = "类型不能为空")
    private String type;

    @ApiModelProperty(value = "需求仓库id/门店id", required = true)
    @NotNull(message = "门店ID不能为空")
    private Long demandWhStId;

    @ApiModelProperty(value = "需求仓库编码/门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "需求仓库名称/门店名称", required = true)
    @NotBlank(message = "门店名称不能为空")
    private String demandWhStName;

    @ApiModelProperty(value = "需求日期", required = true)
    @NotNull(message = "需求日期不能为空")
    private LocalDateTime demandDate;

    @ApiModelProperty("门店经营性质")
    private String storeType2;

    @ApiModelProperty("店面等级")
    private String storeLevel;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货国家")
    private String recvCountry;

    @ApiModelProperty("收货省")
    private String recvProvince;

    @ApiModelProperty("收货市")
    private String recvCity;

    @ApiModelProperty("收货区县")
    private String recvCounty;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    private String ouCode;

    private String brandCode;
}
