package com.elitesland.scp.pay.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Data
@ConfigurationProperties(prefix = "entpay")
public class EntpayProperties {

    public static final String CONFIG_PREFIX = "entpay";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 平台id
     */
    private String platformId;

    /**
     * 后端支付结果通知url，支付结果通知的平台后台回调地址，通知url必须为外网可访问的url，不能携带参数
     */
    private String serverNotifyUrl;

    /**
     * 平台私钥序列号
     */
    private String platformPrivateCertSerialNo;

    /**
     * 微企付公钥序列号
     */
    private String tbepSerialNo;

    /**
     * 微企付公钥
     */
    private String tbepPublicKey;

    /**
     * 平台私钥
     */
    private String platformPrivateKey;

    /**
     * 环境：SANDBOX-沙箱环境，PRO-生产环境
     */
    private String env;

    /**
     * Mp 支付完成前端回跳小程序appid
     */
    private String mpAppid;

    /**
     * Mp 支付完成前端回跳小程序路径，路径和参数内容由开发者设置，受环境限制目前腾讯微企付在 iOS 里使用 wx.navigateBackMiniProgram ，
     * 在 Android 里使用wx.navigateToMiniProgram 回跳到你的小程序，建议路径为订单详情或结果页，onShow 时查询最新的订单状态按需展示
     */
    private String mpPath;

    /**
     * Mp 支付完成前端回跳小程序原始id
     */
    private String mpUsername;

    /**
     * 租户编码
     */
    private String tenantCode;

    /**
     * 后端账户绑定结果通知url，账户绑定结果通知的平台后台回调地址，通知url必须为外网可访问的url，不能携带参数
     */
    private String serverAccountBindNotifyUrl;

    /**
     * 后端退款结果通知url，退款结果通知的平台后台回调地址，通知url必须为外网可访问的url，不能携带参数
     */
    private String serverRefundNotifyUrl;

}
