/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.setting;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingBaseParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingBaseVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.setting.ScpOrderSettingSaveVO;
import com.elitesland.scp.application.service.setting.ScpOrderSettingService;
import com.elitesland.scp.domain.convert.setting.ScpOrderSettingConvert;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpOrderSettingServiceImpl
implements ScpOrderSettingService {
    private static final Logger log = LoggerFactory.getLogger(ScpOrderSettingServiceImpl.class);
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final RmiItemService rmiItemService;

    @Override
    public PagingVO<ScpOrderSettingPageRespVO> page(ScpOrderSettingPageParamVO paramVO) {
        return this.scpOrderSettingDomainService.queryOrderSettingList(paramVO);
    }

    @Override
    public Optional<ScpOrderSettingRespVO> findOrderSettingById(Long id) {
        return this.scpOrderSettingDomainService.findOrderSettingById(id).map(ScpOrderSettingConvert.INSTANCE::dtoToRespVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrderSetting(ScpOrderSettingSaveVO saveVO) {
        this.checkSetting(saveVO);
        return this.scpOrderSettingDomainService.saveOrderSetting(saveVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpOrderSettingDomainService.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeOrderSettingStatus(ScpOrderSettingStatusParamVO paramVO) {
        this.scpOrderSettingDomainService.enableOrderSetting(paramVO.getIds(), paramVO.getStatus());
    }

    @Override
    @SysCodeProc
    public List<ScpOrderSettingRespVO> queryOrderSettingList(ScpOrderSettingParamVO paramVO) {
        List<ScpOrderSettingRespVO> settingList = this.scpOrderSettingDomainService.findByParam(paramVO);
        if (CollUtil.isEmpty(settingList)) {
            return CollUtil.newArrayList((Object[])new ScpOrderSettingRespVO[0]);
        }
        settingList.forEach(setting -> setting.setItemCates(StrUtil.split((CharSequence)setting.getItemCate(), (char)',')));
        return settingList;
    }

    @Override
    public String getFirstItemCate(ScpOrderSettingBaseParamVO paramVO) {
        ScpOrderSettingRespVO cacheByDocType = this.scpOrderSettingDomainService.findCacheByDocType(paramVO.getDocType(), "0");
        List itemTypes = StrUtil.split((CharSequence)cacheByDocType.getItemCate(), (CharSequence)",");
        List<String> cateCodes = this.scpCateItemRepoProc.getFirstCateByType(itemTypes, paramVO.getBrands());
        return this.rmiItemService.getFirstCateByCodes(cateCodes);
    }

    private void checkSetting(ScpOrderSettingSaveVO saveVO) {
        if (saveVO.getFirstPriority().equals(saveVO.getSecPriority())) {
            throw new BusinessException("\u7b2c\u4e00\u4f18\u5148\u7ea7\u548c\u7b2c\u4e8c\u4f18\u5148\u7ea7\u4e0d\u80fd\u76f8\u540c");
        }
        ScpOrderSettingParamVO paramVO = new ScpOrderSettingParamVO();
        List<ScpOrderSettingRespVO> settings = this.scpOrderSettingDomainService.findByParam(paramVO);
        if (CollUtil.isEmpty(settings)) {
            return;
        }
        Map<String, List<ScpOrderSettingRespVO>> typeMap = settings.stream().collect(Collectors.groupingBy(row -> row.getDocType() + "@" + row.getType()));
        Map<String, Long> itemCateMap = settings.stream().flatMap(row -> StrUtil.split((CharSequence)row.getItemCate(), (CharSequence)",").stream().map(cate -> {
            ScpOrderSettingBaseVO result = new ScpOrderSettingBaseVO();
            result.setId(row.getId());
            result.setItemCate((String)cate);
            result.setType(row.getType());
            return result;
        })).collect(Collectors.toMap(row -> row.getItemCate() + "@" + row.getType(), ScpOrderSettingBaseVO::getId));
        if (saveVO.getId() == null) {
            if (typeMap.get(saveVO.getDocType() + "@" + saveVO.getType()) != null) {
                throw new BusinessException("\u5b58\u5728\u5355\u636e\u7c7b\u578b\u548c\u8981\u8d27\u7c7b\u578b,\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
            for (String itemCate : saveVO.getItemCates()) {
                if (!itemCateMap.containsKey(itemCate + "@" + saveVO.getType())) continue;
                throw new BusinessException("\u5546\u54c1\u5206\u7c7b\u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
        } else {
            if (CollUtil.isEmpty(settings)) {
                return;
            }
            List<ScpOrderSettingRespVO> settingRespVOS = typeMap.get(saveVO.getDocType() + "@" + saveVO.getType());
            if (CollUtil.isEmpty(settingRespVOS)) {
                return;
            }
            List ids = settingRespVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            if (!ids.contains(saveVO.getId())) {
                throw new BusinessException("\u5b58\u5728\u5355\u636e\u7c7b\u578b\u548c\u8981\u8d27\u7c7b\u578b,\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
            for (String itemCate : saveVO.getItemCates()) {
                String cateType = itemCate + "@" + saveVO.getType();
                if (!itemCateMap.containsKey(cateType) || itemCateMap.get(cateType).equals(saveVO.getId())) continue;
                throw new BusinessException("\u5546\u54c1\u5206\u7c7b\u5df2\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
        }
    }

    public ScpOrderSettingServiceImpl(ScpOrderSettingDomainService scpOrderSettingDomainService, ScpCateItemRepoProc scpCateItemRepoProc, RmiItemService rmiItemService) {
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpCateItemRepoProc = scpCateItemRepoProc;
        this.rmiItemService = rmiItemService;
    }
}

