/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.sale.api.vo.resp.crm.CustBaseAndBelongOuDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBelongOuDTO;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.sale.service.CrmCustRpcService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiSalRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiSalRpcService.class);
    private final CrmCustRpcService crmCustRpcService;

    public List<CrmCustDTO> listCustByCode(List<String> custCodes) {
        if (CollUtil.isEmpty(custCodes)) {
            return new ArrayList<CrmCustDTO>();
        }
        ApiResult custListResult = this.crmCustRpcService.listCustByCode(custCodes);
        if (!custListResult.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        return (List)custListResult.getData();
    }

    public List<CustBaseInfoDTO> getCustBaseInfoByCode(List<String> custCodes) {
        if (CollectionUtil.isEmpty(custCodes)) {
            return Collections.EMPTY_LIST;
        }
        CustCode2BaseParam custCode2BaseParam = new CustCode2BaseParam();
        custCode2BaseParam.setCustCode(custCodes);
        ApiResult custListResult = this.crmCustRpcService.getCustBaseInfoByCode(custCode2BaseParam);
        if (!custListResult.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237(getCustBaseInfoByCode)\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        return (List)custListResult.getData();
    }

    public List<CustBaseDTO> findBaseByParam(List<String> custCodes) {
        if (CollectionUtil.isEmpty(custCodes)) {
            return Collections.EMPTY_LIST;
        }
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(custCodes);
        ApiResult custListResult = this.crmCustRpcService.findBaseByParam(custBaseRpcParam);
        if (!custListResult.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237(findBaseByParam)\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        return (List)custListResult.getData();
    }

    public List<CustBelongOuDTO> getCustByCode(String custCode) {
        try {
            return this.crmCustRpcService.findCustBelongOuByCustCode(custCode);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba2\u6237\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f\u5f02\u5e38:{}", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public List<CustBelongOuDTO> getCustByCodes(List<String> custCodes) {
        try {
            return this.crmCustRpcService.findCustBelongOuByCustCodes(custCodes);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba2\u6237\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f\u5f02\u5e38:{}", (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public Map<String, List<CustBelongOuDTO>> findPreCustBaseAndBelongOuMap(List<String> custCodes) {
        log.info("\u67e5\u8be2\u4e3b\u5ba2\u6237\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr(custCodes));
        if (CollUtil.isEmpty(custCodes)) {
            return new HashMap<String, List<CustBelongOuDTO>>();
        }
        ApiResult custBelongOu = this.crmCustRpcService.findPreCustBelongOuByCustCodes(custCodes);
        if (!custBelongOu.isSuccess()) {
            log.error("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38:{},\u8be6\u60c5:{}", (Object)custBelongOu.getErrorMsg(), (Object)JSONUtil.toJsonStr((Object)custBelongOu));
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        Map data = (Map)custBelongOu.getData();
        if (CollUtil.isEmpty((Map)data)) {
            return new HashMap<String, List<CustBelongOuDTO>>();
        }
        log.info("\u67e5\u8be2\u4e3b\u5ba2\u6237\u5f52\u5c5e\u516c\u53f8\u4fe1\u606f\u7ed3\u679c:{}", (Object)data);
        return data;
    }

    public List<CustBaseAndBelongOuDTO> findCustBaseAndBelongOuByParam(List<String> custCodes) {
        if (CollUtil.isEmpty(custCodes)) {
            return new ArrayList<CustBaseAndBelongOuDTO>();
        }
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(custCodes);
        ApiResult result = this.crmCustRpcService.findCustBaseAndBelongOuByParam(custBaseRpcParam);
        if (!result.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        return (List)result.getData();
    }

    public Map<String, CustBaseDTO> getCustBaseMapByCode(List<String> custCodes) {
        if (CollectionUtil.isEmpty(custCodes)) {
            return new HashMap<String, CustBaseDTO>();
        }
        CustBaseRpcParam custBaseParam = new CustBaseRpcParam();
        custBaseParam.setCustCodeList(custCodes);
        ApiResult custListResult = this.crmCustRpcService.findBaseByParam(custBaseParam);
        if (!custListResult.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237(findBaseByParam)\u6570\u636e\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
        return ((List)custListResult.getData()).stream().collect(Collectors.toMap(CustBaseDTO::getCustCode, Function.identity()));
    }

    public RmiSalRpcService(CrmCustRpcService crmCustRpcService) {
        this.crmCustRpcService = crmCustRpcService;
    }
}

