package com.elitesland.scp.application.facade.vo.freight;

import com.el.coordinator.core.common.jpa.entiry.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * @author jeesie
 * @description: 用于保存相关信息
 * @datetime: 2025年 08月 14日 9:14
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpStoreOrderFreightSaveParamVO", description = "门店订货运费保存关键条件")
public class ScpStoreOrderFreightSaveParamVO {

    @ApiModelProperty("需求门店编码或'all'")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty("需求门店名称或'全部'")
    private String storeName;

    @ApiModelProperty("记录ID，用于判断是否是修改")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("订货类型")
    private String orderType;

    @ApiModelProperty("运费收取方式")
    private String freightMethod;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品品类")
    private String itemCategoryCode;

    @ApiModelProperty("需求类型")
    private String demandType;

    @ApiModelProperty("运费收取比例")
    private BigDecimal freightRate;

    @ApiModelProperty("按数量收取金额")
    private BigDecimal amountPerQuantity;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer status;
}
