package com.elitesland.scp.application.web.cart;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.cart.*;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.web.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 16:32
 * @Description:
 */
@Slf4j
@RestController
@RequestMapping(value = "/cart", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
@Api(value = "移动端-采购车管理", tags = {"移动端-采购车管理"})
public class CartManageController extends BaseController {

    private final ScpStoreCartService scpStoreCartService;

    @PostMapping(value = "/detail")
    @ApiOperation(value = "采购车详情")
    public ApiResult<List<CartDetailRespVO>> detail(@RequestBody @Validated CartDetailParamVO paramVO) {
        log.info("[SCP-CART] detail  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpStoreCartService.detail(paramVO));
    }

    @PostMapping(value = "/count")
    @ApiOperation(value = "采购车数量汇总")
    public ApiResult<Map<String, Integer>> count(@RequestBody @Validated StoreCartQueryParamVO paramVO) {
        log.info("[SCP-CART] count  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpStoreCartService.getCartCount(paramVO));
    }

    @PostMapping(value = "/addItem")
    @ApiOperation(value = "采购车添加商品")
    public ApiResult<String> addItem(@RequestBody @Validated StoreCartSaveVO saveVO) {
        log.info("[SCP-CART] addItem  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpStoreCartService.saveCart(saveVO));
    }

    @PostMapping(value = "/batch/addItem")
    @ApiOperation(value = "采购车批量添加商品")
    public ApiResult<String> batchAddItem(@RequestBody @Validated StoreCartBatchSaveVO saveVO) {
        log.info("[SCP-CART] batchAddItem  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpStoreCartService.batchSaveCart(saveVO.getDemandWhStCode(), saveVO.getCartType(), saveVO.getCartSaveVOList()));
    }

    @PostMapping(value = "/updateCount")
    @ApiOperation(value = "采购车更新数量")
    public ApiResult<Object> updateCount(@RequestBody CartCountParamVO cartCountParamVO) {
        log.info("[SCP-CART] updateCount  saveVO ={}", JSONUtil.toJsonStr(cartCountParamVO));
        scpStoreCartService.updateCount(cartCountParamVO);
        return ApiResult.ok();
    }

    @PostMapping(value = "/deleteItem")
    @ApiOperation(value = "采购车删除商品")
    public ApiResult<String> deleteItem(@RequestBody @Validated CartDeleteItemParamVO paramVO) {
        log.info("[SCP-CART] deleteItem  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        scpStoreCartService.deleteItem(paramVO);
        return ApiResult.ok();
    }

    @PostMapping(value = "/clearCart")
    @ApiOperation(value = "采购车清除接口")
    public ApiResult<String> clearCart(@RequestBody @Validated CartClearParamVO paramVO) {
        log.info("[SCP-CART] deleteItem  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        scpStoreCartService.clearCart(paramVO);
        return ApiResult.ok();
    }

    @PostMapping(value = "/dataSummary")
    @ApiOperation(value = "采购车数据汇总")
    public ApiResult<CartDataSummaryRespVO> dataSummary(@RequestBody @Validated CartDataSummaryParamVO paramVO) {
        log.info("[SCP-CART] dataSummary  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpStoreCartService.dataSummary(paramVO));
    }

    @PostMapping(value = "/order")
    @ApiOperation(value = "下单")
    public ApiResult<OrderCheckRespVO> order(@RequestBody @Validated OrderCheckParamVO orderCheckParamVO) {
        log.info("[SCP-CART] order  paramVO ={}", JSONUtil.toJsonStr(orderCheckParamVO));
        return ApiResult.ok(scpStoreCartService.order(orderCheckParamVO));
    }

    @PostMapping(value = "/changeSelectedStatus")
    @ApiOperation(value = "采购车选择状态更新")
    public ApiResult<String> changeSelectedStatus(@RequestBody @Validated CartChangeSelectedStatusParamVO paramVO) {
        log.info("[SCP-CART] changeSelectedStatus  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        scpStoreCartService.changeSelectedStatus(paramVO);
        return ApiResult.ok();
    }

    @PostMapping(value = "/changeSelectedStatus/all")
    @ApiOperation(value = "采购车全选/取消全选状态更新")
    public ApiResult<String> changeSelectedStatusAll(@RequestBody @Validated CartChangeSelectedStatusAllParamVO paramVO) {
        log.info("[SCP-CART] changeSelectedStatusAll  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        scpStoreCartService.changeSelectedStatusAll(paramVO);
        return ApiResult.ok();
    }
}
