
package com.elitesland.scp.rmi;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.support.provider.org.param.OrgAddrQueryRpcParam;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/4/7 7:19 下午
 * @version:v1.0
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class RmiOrgRegionRpcService {

    private final OrgRegionRpcService orgRegionRpcService;


    public Map<String, String> findRpcDtoByRegionCodes(Set<String> regionCodes) {
        log.info("调用支撑域-根据区域编码获取列表，时间：{}，入参：{}", LocalDateTime.now(), regionCodes);
        try {

            ApiResult<Map<String, String>> apiResult = orgRegionRpcService.getNameByCode(regionCodes);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("findRpcDtoByAddrNo error:", e);
        }
        return null;
    }

}
