/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.freight;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightExportRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightImportVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightPageParamVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightQuaryParamVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightQuaryRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightRespVO;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightSaveParamVO;
import com.elitesland.scp.application.facade.vo.resp.freight.ScpStoreOrderFreightPageRespVO;
import com.elitesland.scp.application.service.freight.ScpStoreOrderFreightService;
import com.elitesland.scp.domain.entity.freight.ScpStoreOrderFreightDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.freight.ScpStoreOrderFreightRepo;
import com.elitesland.scp.infr.repo.freight.ScpStoreOrderFreightRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpStoreOrderFreightServiceImpl
implements ScpStoreOrderFreightService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreOrderFreightServiceImpl.class);
    private final ScpStoreOrderFreightRepo scpStoreOrderFreightRepo;
    private final ScpStoreOrderFreightRepoProc scpStoreOrderFreightRepoProc;
    private final InvWhProvider invWhProvider;
    private final OrgStoreRpcService orgStoreRpcService;
    private final RmiItemService rmiItemService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;

    private void validate(ScpStoreOrderFreightSaveParamVO param) {
        if (param.getId() != null && param.getId() == 0L) {
            param.setId(null);
        }
        if (param.getOrderType() == null || param.getFreightMethod() == null) {
            throw new BusinessException("\u8ba2\u8d27\u7c7b\u578b\u548c\u8fd0\u8d39\u6536\u53d6\u65b9\u5f0f\u5747\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_WD.getValueCode())) {
            if (param.getWhCode() == null) {
                throw new BusinessException("\u76f4\u9001\u8ba2\u8d27\u7c7b\u578b\uff0c\u4f9b\u8d27\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (param.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_DD.getValueCode())) {
            param.setWhCode(null);
            param.setWhName(null);
        } else {
            throw new BusinessException("\u8ba2\u8d27\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        if (param.getFreightMethod().equals(ScpUdcEnum.STORE_ORDER_FREIGHT_PR.getValueCode())) {
            if (param.getFreightRate() == null) {
                throw new BusinessException("PRPR\u8fd0\u8d39\u6536\u53d6\u65b9\u5f0f\uff0c\u8fd0\u8d39\u6536\u53d6\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (param.getFreightMethod().equals(ScpUdcEnum.STORE_ORDER_FREIGHT_QU.getValueCode())) {
            if (param.getAmountPerQuantity() == null) {
                throw new BusinessException("QU\u8fd0\u8d39\u6536\u53d6\u65b9\u5f0f\uff0c\u6bcf\u4ef6\u8fd0\u8d39\u6536\u53d6\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            throw new BusinessException("\u8fd0\u8d39\u6536\u53d6\u65b9\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (param.getStatus() == null) {
            throw new BusinessException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getStatus() != 0 && param.getStatus() != 1) {
            throw new BusinessException("\u72b6\u6001\u4e0d\u5408\u6cd5");
        }
        if (param.getStatus() == 0) {
            return;
        }
        List<ScpStoreOrderFreightDO> byParam2 = this.scpStoreOrderFreightRepoProc.findByParam2(param);
        if (Objects.isNull(param.getId()) && !byParam2.isEmpty()) {
            for (ScpStoreOrderFreightDO scpStoreOrderFreightDO : byParam2) {
                this.deleteStoreOrderFreight(scpStoreOrderFreightDO.getId());
            }
        }
    }

    public ScpStoreOrderFreightSaveParamVO validateAndToSaveVO(ScpStoreOrderFreightImportVO param) {
        ScpStoreOrderFreightSaveParamVO scpStoreOrderFreightSaveParamVO = (ScpStoreOrderFreightSaveParamVO)BeanUtils.copyProperties((Object)param, ScpStoreOrderFreightSaveParamVO.class, (String[])new String[0]);
        if (param.getOrderTypeName() == null || param.getFreightMethodName() == null) {
            throw new BusinessException("\u8ba2\u8d27\u7c7b\u578b\u548c\u8fd0\u8d39\u6536\u53d6\u65b9\u5f0f\u5747\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getFreightMethodName().equals(ScpUdcEnum.STORE_ORDER_FREIGHT_PR.getValueCodeName())) {
            scpStoreOrderFreightSaveParamVO.setFreightMethod(ScpUdcEnum.STORE_ORDER_FREIGHT_PR.getValueCode());
        }
        if (param.getFreightMethodName().equals(ScpUdcEnum.STORE_ORDER_FREIGHT_QU.getValueCodeName())) {
            scpStoreOrderFreightSaveParamVO.setFreightMethod(ScpUdcEnum.STORE_ORDER_FREIGHT_QU.getValueCode());
        }
        if (param.getOrderTypeName().equals(ScpUdcEnum.STORE_ORDER_TYPE_WD.getValueCodeName())) {
            scpStoreOrderFreightSaveParamVO.setOrderType(ScpUdcEnum.STORE_ORDER_TYPE_WD.getValueCode());
        }
        if (param.getOrderTypeName().equals(ScpUdcEnum.STORE_ORDER_TYPE_DD.getValueCodeName())) {
            scpStoreOrderFreightSaveParamVO.setOrderType(ScpUdcEnum.STORE_ORDER_TYPE_DD.getValueCode());
        }
        scpStoreOrderFreightSaveParamVO.setStatus(1);
        if (param.getSupplyWhCode() != null) {
            scpStoreOrderFreightSaveParamVO.setWhCode(param.getSupplyWhCode());
        }
        if (param.getDemandWhStCode() != null) {
            if ("ALL".equals(param.getDemandWhStCode())) {
                scpStoreOrderFreightSaveParamVO.setStoreCode("all");
            } else {
                scpStoreOrderFreightSaveParamVO.setStoreCode(param.getDemandWhStCode());
            }
        }
        scpStoreOrderFreightSaveParamVO.setDemandType("\u95e8\u5e97");
        this.validate(scpStoreOrderFreightSaveParamVO);
        return scpStoreOrderFreightSaveParamVO;
    }

    @Override
    @Transactional
    public ScpStoreOrderFreightDO saveStoreOrderFreight(ScpStoreOrderFreightSaveParamVO param) {
        this.validate(param);
        ScpStoreOrderFreightDO scpStoreOrderFreightDO = (ScpStoreOrderFreightDO)BeanUtils.copyProperties((Object)param, ScpStoreOrderFreightDO.class, (String[])new String[0]);
        return (ScpStoreOrderFreightDO)this.scpStoreOrderFreightRepo.save(scpStoreOrderFreightDO);
    }

    @Override
    @Transactional
    public List<ScpStoreOrderFreightDO> saveAllStoreOrderFreight(List<ScpStoreOrderFreightSaveParamVO> param) {
        ArrayList<ScpStoreOrderFreightDO> scpStoreOrderFreightDOS = new ArrayList<ScpStoreOrderFreightDO>();
        HashSet<CallSite> orderCodeAndStoreTyprAndWhCodeAndItemCode = new HashSet<CallSite>();
        for (ScpStoreOrderFreightSaveParamVO paramVO : param) {
            this.validate(paramVO);
            ScpStoreOrderFreightDO scpStoreOrderFreightDO = (ScpStoreOrderFreightDO)BeanUtils.copyProperties((Object)paramVO, ScpStoreOrderFreightDO.class, (String[])new String[0]);
            String orderCodeAndStoreTyprAndWhCodeAndItemCodeStr = scpStoreOrderFreightDO.getOrderType() + "-" + scpStoreOrderFreightDO.getWhCode() + "-" + scpStoreOrderFreightDO.getStoreCode() + "-" + scpStoreOrderFreightDO.getItemCode();
            if (orderCodeAndStoreTyprAndWhCodeAndItemCode.contains(orderCodeAndStoreTyprAndWhCodeAndItemCodeStr)) {
                throw new BusinessException("\u4fdd\u5b58/\u5bfc\u5165\u5931\u8d25\uff1a\u91cd\u590d\u7684\u6761\u76ee");
            }
            orderCodeAndStoreTyprAndWhCodeAndItemCode.add((CallSite)((Object)orderCodeAndStoreTyprAndWhCodeAndItemCodeStr));
            scpStoreOrderFreightDOS.add(scpStoreOrderFreightDO);
        }
        return this.scpStoreOrderFreightRepo.saveAll(scpStoreOrderFreightDOS);
    }

    @Override
    public void deleteStoreOrderFreight(Long id) {
        this.scpStoreOrderFreightRepo.deleteById(id);
    }

    @Override
    public PagingVO<ScpStoreOrderFreightPageRespVO> pageStoreOrderFreight(ScpStoreOrderFreightPageParamVO param) {
        PagingVO<ScpStoreOrderFreightPageRespVO> scpStoreOrderFreightRespVOPagingVO = this.scpStoreOrderFreightRepoProc.findByParam(param);
        log.info("\u5206\u9875\u67e5\u8be2\u7ed3\u679c\uff1a{}", scpStoreOrderFreightRespVOPagingVO);
        if (scpStoreOrderFreightRespVOPagingVO == null || scpStoreOrderFreightRespVOPagingVO.isEmpty()) {
            return scpStoreOrderFreightRespVOPagingVO;
        }
        for (ScpStoreOrderFreightPageRespVO scpStoreOrderFreightRespVO : scpStoreOrderFreightRespVOPagingVO.getRecords()) {
            scpStoreOrderFreightRespVO.update();
        }
        return scpStoreOrderFreightRespVOPagingVO;
    }

    @Override
    public List<ScpStoreOrderFreightPageRespVO> listStoreOrderFreight(ScpStoreOrderFreightPageParamVO param) {
        List<ScpStoreOrderFreightPageRespVO> scpStoreOrderFreightRespVOList = this.scpStoreOrderFreightRepoProc.listByParam(param);
        if (scpStoreOrderFreightRespVOList == null || scpStoreOrderFreightRespVOList.isEmpty()) {
            return scpStoreOrderFreightRespVOList;
        }
        for (ScpStoreOrderFreightPageRespVO scpStoreOrderFreightRespVO : scpStoreOrderFreightRespVOList) {
            scpStoreOrderFreightRespVO.update();
        }
        return scpStoreOrderFreightRespVOList;
    }

    @Override
    @Transactional(rollbackOn={BusinessException.class})
    public ScpStoreOrderFreightQuaryRespVO freightBatchQuery(ScpStoreOrderFreightQuaryParamVO param) {
        ScpStoreOrderFreightQuaryRespVO scpStoreOrderFreightQuaryRespVO = new ScpStoreOrderFreightQuaryRespVO();
        BeanUtils.copyProperties((Object)param, (Object)scpStoreOrderFreightQuaryRespVO, (String[])new String[0]);
        scpStoreOrderFreightQuaryRespVO.setFreightAmt(new BigDecimal(0));
        if (param.getStoreCode() == null) {
            throw new BusinessException("\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getItemCode() == null || param.getItemCode().isEmpty()) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScpStoreOrderFreightDO scpStoreOrderFreightDO = null;
        if (param.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_DD.getValueCode())) {
            scpStoreOrderFreightDO = this.scpStoreOrderFreightRepo.findByStoreCodeAndItemCode(param.getStoreCode(), param.getItemCode());
            if (scpStoreOrderFreightDO == null) {
                scpStoreOrderFreightDO = this.scpStoreOrderFreightRepo.findByStoreCodeAndItemCode("all", param.getItemCode());
            }
            if (scpStoreOrderFreightDO == null) {
                scpStoreOrderFreightDO = this.scpStoreOrderFreightRepo.findByStoreCodeAndItemCode(param.getStoreCode(), "");
            }
            if (scpStoreOrderFreightDO == null) {
                scpStoreOrderFreightDO = this.scpStoreOrderFreightRepo.findByStoreCodeAndItemCode("all", "");
            }
        } else if (param.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_WD.getValueCode())) {
            if (param.getWhCode() == null || param.getWhCode().isEmpty()) {
                throw new BusinessException("\u8ba2\u8d27\u7c7b\u578b\u662f\u4ed3\u914d\uff0c\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
            }
            scpStoreOrderFreightDO = this.scpStoreOrderFreightRepo.findByStoreCodeAndWhCodeAndItemCode(param.getStoreCode(), param.getWhCode(), param.getItemCode());
            if (scpStoreOrderFreightDO == null) {
                scpStoreOrderFreightDO = this.scpStoreOrderFreightRepo.findByStoreCodeAndWhCodeAndItemCode("all", param.getWhCode(), param.getItemCode());
            }
            if (scpStoreOrderFreightDO == null) {
                scpStoreOrderFreightDO = this.scpStoreOrderFreightRepo.findByStoreCodeAndWhCodeAndItemCode(param.getStoreCode(), param.getWhCode(), "");
            }
            if (scpStoreOrderFreightDO == null) {
                scpStoreOrderFreightDO = this.scpStoreOrderFreightRepo.findByStoreCodeAndWhCodeAndItemCode("all", param.getWhCode(), "");
            }
        }
        if (scpStoreOrderFreightDO != null) {
            if (scpStoreOrderFreightDO.getFreightMethod().equals(ScpUdcEnum.STORE_ORDER_FREIGHT_PR.getValueCode())) {
                scpStoreOrderFreightQuaryRespVO.setFreightAmt(param.getDemandQuantity().multiply(scpStoreOrderFreightDO.getFreightRate().multiply(BigDecimal.valueOf(0.01f))));
            } else if (scpStoreOrderFreightDO.getFreightMethod().equals(ScpUdcEnum.STORE_ORDER_FREIGHT_QU.getValueCode())) {
                scpStoreOrderFreightQuaryRespVO.setFreightAmt(param.getPlanAmt().multiply(scpStoreOrderFreightDO.getAmountPerQuantity()));
            } else {
                throw new BusinessException("\u6570\u636e\u9519\u8bef\uff1a\u8fd0\u8d39\u6536\u53d6\u65b9\u5f0f\u672a\u77e5");
            }
        }
        return scpStoreOrderFreightQuaryRespVO;
    }

    @Override
    @Transactional(rollbackOn={BusinessException.class})
    public List<ScpStoreOrderFreightQuaryRespVO> freightBatchQueryAll(List<ScpStoreOrderFreightQuaryParamVO> param) {
        ArrayList<ScpStoreOrderFreightQuaryRespVO> scpStoreOrderFreightQuaryRespVOList = new ArrayList<ScpStoreOrderFreightQuaryRespVO>();
        for (ScpStoreOrderFreightQuaryParamVO paramVO : param) {
            scpStoreOrderFreightQuaryRespVOList.add(this.freightBatchQuery(paramVO));
        }
        return scpStoreOrderFreightQuaryRespVOList;
    }

    @Override
    public ScpStoreOrderFreightRespVO getStoreOrderFreightDetail(Long id) {
        ScpStoreOrderFreightDO s = this.scpStoreOrderFreightRepo.findById(id).orElse(null);
        return ScpStoreOrderFreightRespVO.from(s);
    }

    @Override
    @org.springframework.transaction.annotation.Transactional(rollbackFor={Exception.class})
    public List<String> executeImport(List<ScpStoreOrderFreightImportVO> scpStoreOrderFreightImportVOList, int startRowIndex) {
        this.checkImportData(scpStoreOrderFreightImportVOList, startRowIndex);
        if (CollUtil.isEmpty(scpStoreOrderFreightImportVOList)) {
            return Collections.emptyList();
        }
        log.info("\u5f00\u59cb\u5bfc\u5165\u95e8\u5e97\u8fd0\u8d39\u6570\u636e,{}", scpStoreOrderFreightImportVOList);
        ArrayList<ScpStoreOrderFreightSaveParamVO> scpStoreOrderFreightSaveParamVOList = new ArrayList<ScpStoreOrderFreightSaveParamVO>();
        ArrayList<String> errorList = new ArrayList<String>();
        HashMap<String, String> successMapForWh = new HashMap<String, String>();
        HashMap<String, String> successMapForStore = new HashMap<String, String>();
        HashSet<String> errorSetForWh = new HashSet<String>();
        HashSet<String> errorSetForStore = new HashSet<String>();
        HashSet<CallSite> orderCodeAndStoreTyprAndWhCodeAndItemCode = new HashSet<CallSite>();
        List itemCodes = scpStoreOrderFreightImportVOList.stream().map(ScpStoreOrderFreightImportVO::getItemCode).distinct().collect(Collectors.toList());
        List<Object> itemBaseRpcDtoByParam = new ArrayList();
        if (CollUtil.isNotEmpty(itemCodes)) {
            itemBaseRpcDtoByParam = this.rmiItemService.findItemBaseRpcDtoByParam(ItmItemBaseRpcParam.builder().itemCodes(itemCodes).build());
        }
        for (ScpStoreOrderFreightImportVO scpStoreOrderFreightImportVO : scpStoreOrderFreightImportVOList) {
            try {
                ScpStoreOrderFreightSaveParamVO scpStoreOrderFreightSaveParamVO = this.validateAndToSaveVO(scpStoreOrderFreightImportVO);
                if (successMapForWh.containsKey(scpStoreOrderFreightSaveParamVO.getWhCode())) {
                    scpStoreOrderFreightSaveParamVO.setWhName((String)successMapForWh.get(scpStoreOrderFreightSaveParamVO.getWhCode()));
                } else {
                    if (errorSetForWh.contains(scpStoreOrderFreightSaveParamVO.getWhCode())) {
                        throw new BusinessException("\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
                    }
                    try {
                        ApiResult i2 = this.invWhProvider.findSimpleWhByWhCodes(List.of(scpStoreOrderFreightSaveParamVO.getWhCode()));
                        if (i2.getData() == null || ((List)i2.getData()).isEmpty()) {
                            throw new BusinessException("\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
                        }
                        successMapForWh.put(scpStoreOrderFreightSaveParamVO.getWhCode(), ((InvWhRpcSimpleDTO)((List)i2.getData()).get(0)).getWhName());
                        scpStoreOrderFreightSaveParamVO.setWhName(((InvWhRpcSimpleDTO)((List)i2.getData()).get(0)).getWhName());
                    }
                    catch (Exception e) {
                        errorSetForWh.add(scpStoreOrderFreightSaveParamVO.getWhCode());
                        throw new BusinessException("\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
                    }
                }
                if (scpStoreOrderFreightSaveParamVO.getStoreCode().equals("all")) {
                    scpStoreOrderFreightSaveParamVO.setStoreName("\u5168\u90e8");
                } else if (successMapForStore.containsKey(scpStoreOrderFreightSaveParamVO.getStoreCode())) {
                    scpStoreOrderFreightSaveParamVO.setStoreName((String)successMapForStore.get(scpStoreOrderFreightSaveParamVO.getStoreCode()));
                } else {
                    if (errorSetForStore.contains(scpStoreOrderFreightSaveParamVO.getStoreCode())) {
                        throw new BusinessException("\u95e8\u5e97\u7f16\u7801\u4e0d\u5b58\u5728");
                    }
                    try {
                        OrgStoreDetailRpcDTO o = this.orgStoreRpcService.getByCode(scpStoreOrderFreightSaveParamVO.getStoreCode());
                        successMapForStore.put(scpStoreOrderFreightSaveParamVO.getStoreCode(), o.getStoreName());
                        scpStoreOrderFreightSaveParamVO.setStoreName(o.getStoreName());
                    }
                    catch (Exception e) {
                        errorSetForStore.add(scpStoreOrderFreightSaveParamVO.getStoreCode());
                        throw new BusinessException("\u95e8\u5e97\u7f16\u7801\u4e0d\u5b58\u5728");
                    }
                }
                if (CollUtil.isNotEmpty(itemBaseRpcDtoByParam)) {
                    Optional<ItmItemBaseRpcDTO> first = itemBaseRpcDtoByParam.stream().filter(i -> i.getItemCode().equals(scpStoreOrderFreightSaveParamVO.getItemCode())).findFirst();
                    if (first.isEmpty()) {
                        throw new BusinessException("\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
                    }
                    scpStoreOrderFreightSaveParamVO.setItemName(first.get().getItemName());
                }
                if (orderCodeAndStoreTyprAndWhCodeAndItemCode.contains(scpStoreOrderFreightSaveParamVO.getOrderType() + "-" + scpStoreOrderFreightSaveParamVO.getStoreCode() + "-" + scpStoreOrderFreightSaveParamVO.getWhCode() + "-" + scpStoreOrderFreightSaveParamVO.getItemCode())) {
                    throw new BusinessException("\u91cd\u590d\u5bfc\u5165");
                }
                orderCodeAndStoreTyprAndWhCodeAndItemCode.add((CallSite)((Object)(scpStoreOrderFreightSaveParamVO.getOrderType() + "-" + scpStoreOrderFreightSaveParamVO.getStoreCode() + "-" + scpStoreOrderFreightSaveParamVO.getWhCode() + "-" + scpStoreOrderFreightSaveParamVO.getItemCode())));
                scpStoreOrderFreightSaveParamVOList.add(scpStoreOrderFreightSaveParamVO);
                errorList.add("");
            }
            catch (Exception e) {
                errorList.add("\u7b2c" + (startRowIndex + scpStoreOrderFreightImportVOList.indexOf(scpStoreOrderFreightImportVO)) + "\u884c\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        log.info("\u5f00\u59cb\u4fdd\u5b58\u95e8\u5e97\u8fd0\u8d39\u6570\u636e,{}", scpStoreOrderFreightSaveParamVOList);
        if (CollUtil.isNotEmpty(scpStoreOrderFreightSaveParamVOList)) {
            this.saveAllStoreOrderFreight(scpStoreOrderFreightSaveParamVOList);
        }
        log.info("\u4fdd\u5b58\u95e8\u5e97\u8fd0\u8d39\u6570\u636e\u5b8c\u6210,{}", errorList);
        return errorList;
    }

    private void checkImportData(List<ScpStoreOrderFreightImportVO> scpStoreOrderFreightImportVOList, int startRowIndex) {
        List supplyWhCodeList = scpStoreOrderFreightImportVOList.stream().map(e -> e.getSupplyWhCode()).collect(Collectors.toList());
        List<String> demandWhStCodeList = scpStoreOrderFreightImportVOList.stream().map(e -> e.getDemandWhStCode()).collect(Collectors.toList());
        List itemCodeList = scpStoreOrderFreightImportVOList.stream().map(e -> e.getItemCode()).collect(Collectors.toList());
        ApiResult orgWhDTOSResult = this.invWhProvider.findSimpleWhByWhCodes(supplyWhCodeList);
        List orgWhDTOS = new ArrayList();
        if (orgWhDTOSResult.getData() != null && !((List)orgWhDTOSResult.getData()).isEmpty()) {
            orgWhDTOS = (List)orgWhDTOSResult.getData();
        }
        List<OrgStoreDetailRpcDTO> orgStoreDTOS = this.rmiOrgStoreRpcService.queryByStoreCodes(demandWhStCodeList);
        List<ItmItemBaseRpcDTO> itmItemBaseDTOS = this.rmiItemService.findItemBaseRpcDtoByParam(ItmItemBaseRpcParam.builder().itemCodes(itemCodeList).build());
        Map<String, String> whMap = orgWhDTOS.stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhCode, InvWhRpcSimpleDTO::getWhName));
        Map<String, String> storeMap = orgStoreDTOS.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, OrgStoreDetailRpcDTO::getStoreName));
        Map<String, String> itemMap = itmItemBaseDTOS.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode, ItmItemBaseRpcDTO::getItemName));
        for (int i = 0; i < scpStoreOrderFreightImportVOList.size(); ++i) {
            ScpStoreOrderFreightImportVO vo = scpStoreOrderFreightImportVOList.get(i);
            int rowNum = startRowIndex;
            if (vo.getSupplyWhCode() != null) {
                if (vo.getSupplyWhName() == null) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u4ed3\u5e93\u7f16\u7801 " + vo.getSupplyWhCode() + " \u5bf9\u5e94\u4ed3\u5e93\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!whMap.containsKey(vo.getSupplyWhCode())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u4ed3\u5e93\u7f16\u7801 " + vo.getSupplyWhCode() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!whMap.get(vo.getSupplyWhCode()).equals(vo.getSupplyWhName())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u4ed3\u5e93\u7f16\u7801 " + vo.getSupplyWhCode() + " \u4e0e\u4ed3\u5e93\u540d\u79f0 " + vo.getSupplyWhName() + "\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            if (vo.getDemandWhStCode() != null) {
                if (vo.getDemandWhStName() == null) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u95e8\u5e97\u7f16\u7801 " + vo.getDemandWhStCode() + " \u5bf9\u5e94\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!storeMap.containsKey(vo.getDemandWhStCode())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u95e8\u5e97\u7f16\u7801 " + vo.getDemandWhStCode() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!storeMap.get(vo.getDemandWhStCode()).equals(vo.getDemandWhStName())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u95e8\u5e97\u7f16\u7801 " + vo.getDemandWhStCode() + " \u4e0e\u95e8\u5e97\u540d\u79f0 " + vo.getDemandWhStName() + " \u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            } else {
                throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u95e8\u5e97\u7f16\u7801 " + vo.getDemandWhStCode() + " \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (vo.getItemCode() == null) continue;
            if (vo.getItemName() == null) {
                throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u5546\u54c1\u7f16\u7801 " + vo.getItemCode() + " \u5bf9\u5e94\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (!itemMap.containsKey(vo.getItemCode())) {
                throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u5546\u54c1\u7f16\u7801 " + vo.getItemCode() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (itemMap.get(vo.getItemCode()).equals(vo.getItemName())) continue;
            throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u5546\u54c1\u7f16\u7801 " + vo.getItemCode() + " \u4e0e\u5546\u54c1\u540d\u79f0 " + vo.getItemName() + " \u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    @Override
    public PagingVO<ScpStoreOrderFreightExportRespVO> exportSearch(ScpStoreOrderFreightPageParamVO queryParam) {
        PagingVO<ScpStoreOrderFreightPageRespVO> res = this.scpStoreOrderFreightRepoProc.findAll(queryParam);
        ArrayList list = new ArrayList();
        res.getRecords().forEach(e -> {
            e.update();
            list.add((ScpStoreOrderFreightExportRespVO)BeanUtils.copyProperties((Object)e, ScpStoreOrderFreightExportRespVO.class, (String[])new String[0]));
        });
        PagingVO pagingVO = new PagingVO();
        pagingVO.setRecords(list);
        pagingVO.setTotal(res.getTotal());
        pagingVO.setAggregatedData(res.getAggregatedData());
        return pagingVO;
    }

    public ScpStoreOrderFreightServiceImpl(ScpStoreOrderFreightRepo scpStoreOrderFreightRepo, ScpStoreOrderFreightRepoProc scpStoreOrderFreightRepoProc, InvWhProvider invWhProvider, OrgStoreRpcService orgStoreRpcService, RmiItemService rmiItemService, RmiOrgStoreRpcService rmiOrgStoreRpcService) {
        this.scpStoreOrderFreightRepo = scpStoreOrderFreightRepo;
        this.scpStoreOrderFreightRepoProc = scpStoreOrderFreightRepoProc;
        this.invWhProvider = invWhProvider;
        this.orgStoreRpcService = orgStoreRpcService;
        this.rmiItemService = rmiItemService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
    }
}

