/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.order;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.udc.UdcProvider;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderTemplatePageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpOrderTemplatePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpOrderTemplateRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpOrderTemplateImportVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpOrderTemplateSaveVO;
import com.elitesland.scp.application.service.order.ScpOrderTemplateService;
import com.elitesland.scp.domain.convert.order.ScpOrderTemplateConvert;
import com.elitesland.scp.domain.entity.order.ScpOrderTemplateDO;
import com.elitesland.scp.infr.repo.order.ScpOrderTemplateRepo;
import com.elitesland.scp.infr.repo.order.ScpOrderTemplateRepoProc;
import com.elitesland.scp.rmi.RmiOrgRegionRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpOrderTemplateServiceImpl
implements ScpOrderTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ScpOrderTemplateServiceImpl.class);
    private final ScpOrderTemplateRepo scpOrderTemplateRepo;
    private final ScpOrderTemplateRepoProc scpOrderTemplateRepoProc;
    private final UdcProvider udcProvider;
    private final RmiOrgStoreRpcService rmiOrgStoreService;
    private final RmiOrgRegionRpcService rmiOrgRegionRpcService;
    private final OrgRegionRpcService orgRegionRpcService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;

    @Override
    public List<Long> addOrUpdate(List<ScpOrderTemplateSaveVO> scpOrderTemplateSaveVOss) {
        if (scpOrderTemplateSaveVOss == null || scpOrderTemplateSaveVOss.isEmpty()) {
            throw new IllegalArgumentException("\u6a21\u677f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ScpOrderTemplateDO> all = new ArrayList<ScpOrderTemplateDO>(ScpOrderTemplateConvert.INSTANCE.saveVoToDO(scpOrderTemplateSaveVOss));
        List<ScpOrderTemplateDO> existList = this.scpOrderTemplateRepo.findByIsActive(1);
        all.addAll(existList);
        this.validateDuplicates(all);
        Map<String, List<ScpOrderTemplateSaveVO>> groupMap = scpOrderTemplateSaveVOss.stream().collect(Collectors.groupingBy(a -> a.getType() + a.getDocType() + a.getStoreCode() + a.getRegionCode()));
        groupMap.forEach((key, value) -> this.validateDateConflicts((List<ScpOrderTemplateSaveVO>)value));
        Map<String, List<ScpOrderTemplateDO>> existMap = existList.stream().collect(Collectors.groupingBy(this::buildUniqueKey2));
        ArrayList<ScpOrderTemplateDO> scpOrderTemplateDOS = new ArrayList<ScpOrderTemplateDO>();
        ScpOrderTemplateConvert.INSTANCE.saveVoToDO(scpOrderTemplateSaveVOss).forEach(saveDo -> scpOrderTemplateDOS.addAll(this.handleTimeSplit((ScpOrderTemplateDO)saveDo, (List)existMap.get(this.buildUniqueKey2((ScpOrderTemplateDO)saveDo)))));
        return this.saveSplitAndNewTemplates(scpOrderTemplateDOS);
    }

    private List<ScpOrderTemplateDO> handleTimeSplit(ScpOrderTemplateDO newVo, List<ScpOrderTemplateDO> historyTemplates) {
        ArrayList<ScpOrderTemplateDO> splitTemplates = new ArrayList<ScpOrderTemplateDO>();
        splitTemplates.add(newVo);
        LocalDate newStart = newVo.getStartDate();
        LocalDate newEnd = newVo.getEndDate();
        if (newStart.isEqual(newEnd) || CollectionUtils.isEmpty(historyTemplates)) {
            return splitTemplates;
        }
        for (ScpOrderTemplateDO history : historyTemplates) {
            LocalDate historyStart = history.getStartDate();
            LocalDate historyEnd = history.getEndDate();
            if (newStart.isBefore(historyStart) && newEnd.isAfter(historyEnd)) {
                this.scpOrderTemplateRepo.deleteById(history.getId());
                continue;
            }
            if (historyEnd.isBefore(newStart) || historyStart.isAfter(newEnd)) continue;
            this.scpOrderTemplateRepo.deleteById(history.getId());
            if (historyStart.isBefore(newStart)) {
                ScpOrderTemplateDO beforePart = new ScpOrderTemplateDO();
                BeanUtils.copyProperties((Object)history, (Object)beforePart, (String[])new String[0]);
                history.setId(null);
                beforePart.setEndDate(newStart.minusDays(1L));
                splitTemplates.add(beforePart);
            }
            if (!historyEnd.isAfter(newEnd)) continue;
            ScpOrderTemplateDO afterPart = new ScpOrderTemplateDO();
            BeanUtils.copyProperties((Object)history, (Object)afterPart, (String[])new String[0]);
            history.setId(null);
            afterPart.setStartDate(newEnd.plusDays(1L));
            if (afterPart.getStartDate().isAfter(afterPart.getEndDate())) continue;
            splitTemplates.add(afterPart);
        }
        return splitTemplates;
    }

    private List<Long> saveSplitAndNewTemplates(List<ScpOrderTemplateDO> splitTemplates) {
        return this.scpOrderTemplateRepo.saveAll(splitTemplates.stream().collect(Collectors.toList())).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    private void validateDateConflicts(List<ScpOrderTemplateSaveVO> templates) {
        for (ScpOrderTemplateSaveVO template : templates) {
            LocalDate startDate = template.getStartDate();
            LocalDate endDate = template.getEndDate();
            if (startDate == null || endDate == null) {
                throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!startDate.isAfter(endDate)) continue;
            throw new BusinessException("\u5f00\u59cb\u65f6\u95f4(" + startDate + ")\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4(" + endDate + ")");
        }
        for (int i = 0; i < templates.size(); ++i) {
            for (int j = i + 1; j < templates.size(); ++j) {
                String t2;
                boolean hasConflict;
                ScpOrderTemplateSaveVO template1 = templates.get(i);
                ScpOrderTemplateSaveVO template2 = templates.get(j);
                LocalDate s1 = template1.getStartDate();
                LocalDate e1 = template1.getEndDate();
                LocalDate s2 = template2.getStartDate();
                LocalDate e2 = template2.getEndDate();
                String t1 = template1.getDocType();
                boolean bl = hasConflict = t1.equals(t2 = template2.getDocType()) && !e1.isBefore(s2) && !e2.isBefore(s1);
                if (!hasConflict) continue;
                throw new BusinessException("\u65f6\u95f4\u5b58\u5728\u51b2\u7a81\uff0c\u65f6\u95f4\u8303\u56f4\u5206\u522b\u4e3a: " + s1 + "\u81f3" + e1 + " \u548c " + s2 + "\u81f3" + e2);
            }
        }
    }

    private void validateDuplicates(List<ScpOrderTemplateDO> templates) {
        HashMap<String, Long> uniqueKeyToId = new HashMap<String, Long>();
        for (ScpOrderTemplateDO template : templates) {
            if (StringUtils.isNotBlank((String)template.getStoreCode()) && StringUtils.isNotBlank((String)template.getRegionCode())) {
                throw new BusinessException("\u95e8\u5e97\u533a\u57df\u4e0d\u80fd\u540c\u65f6\u6dfb\u52a0, \u5e94\u7528\u95e8\u5e97=" + template.getStoreCode() + ", \u533a\u57df=" + template.getRegionCode());
            }
            String uniqueKey = this.buildUniqueKey(template);
            Long existingId = (Long)uniqueKeyToId.get(uniqueKey);
            if (existingId != null && !Objects.equals(existingId, template.getId())) {
                throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u6a21\u677f\u914d\u7f6e\uff1a\u7c7b\u578b=" + template.getType() + ", \u5355\u636e\u7c7b\u578b=" + template.getDocType() + ", \u5e94\u7528\u95e8\u5e97=" + template.getStoreCode() + ", \u533a\u57df=" + template.getRegionCode() + ", \u751f\u6548\u65e5\u671f=" + template.getStartDate() + ", \u5931\u6548\u65e5\u671f=" + template.getEndDate());
            }
            uniqueKeyToId.put(uniqueKey, template.getId());
        }
    }

    private String buildUniqueKey(ScpOrderTemplateDO template) {
        return String.join((CharSequence)"|", Objects.toString(template.getType(), ""), Objects.toString(template.getDocType(), ""), Objects.toString(template.getStoreCode(), ""), Objects.toString(template.getRegionCode(), ""), Objects.toString(template.getStartDate(), ""), Objects.toString(template.getEndDate(), ""));
    }

    private String buildUniqueKey2(ScpOrderTemplateDO template) {
        return String.join((CharSequence)"|", Objects.toString(template.getType(), ""), Objects.toString(template.getDocType(), ""), Objects.toString(template.getStoreCode(), ""), Objects.toString(template.getRegionCode(), ""));
    }

    @Override
    public void delete(Long id) {
        this.scpOrderTemplateRepo.deleteById(id);
    }

    @Override
    public ScpOrderTemplateRespVO query(Long id) {
        Optional<ScpOrderTemplateDO> s = this.scpOrderTemplateRepo.findById(id);
        if (s.isPresent()) {
            ScpOrderTemplateRespVO scpOrderTemplateRespVO = new ScpOrderTemplateRespVO();
            BeanUtils.copyProperties((Object)s.get(), (Object)scpOrderTemplateRespVO, (String[])new String[0]);
            scpOrderTemplateRespVO.update((com.elitescloud.boot.core.base.UdcProvider)this.udcProvider);
            return scpOrderTemplateRespVO;
        }
        return null;
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpOrderTemplatePageRespVO> page(ScpOrderTemplatePageParamVO scpOrderTemplatePageParamVO) {
        PagingVO<ScpOrderTemplatePageRespVO> s = this.scpOrderTemplateRepoProc.page(scpOrderTemplatePageParamVO);
        Set regionCodes = s.getRecords().stream().map(ScpOrderTemplatePageRespVO::getRegionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map regionMap = new HashMap();
        if (CollectionUtils.isNotEmpty(regionCodes)) {
            regionMap = (Map)this.orgRegionRpcService.getNameByCode(regionCodes).computeData();
        }
        HashMap finalRegionMap = regionMap;
        s.getRecords().forEach(e -> e.setRegionName((String)finalRegionMap.get(e.getRegionCode())));
        return s;
    }

    @Override
    @Transactional
    public List<String> executeImport(List<ScpOrderTemplateImportVO> dataList, int startRowIndex) {
        this.checkImportData(dataList, startRowIndex);
        ArrayList<String> errorList = new ArrayList<String>();
        DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
        Map demandSetType = this.udcProvider.getValueMapByUdcCode("yst-suplan", "DEMAND_SET_TYPE");
        Map obDocType = this.udcProvider.getValueMapByUdcCode("yst-suplan", "OB_DOC_TYPE");
        Map<String, String> obDocTypeMap = obDocType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> demandSetTypeMap = demandSetType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Set storeCodes = dataList.stream().map(ScpOrderTemplateImportVO::getStoreCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> regionCodes = dataList.stream().map(ScpOrderTemplateImportVO::getRegionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        HashMap<String, OrgStoreDetailRpcDTO> storeDetailRpcDTOMap = new HashMap();
        HashMap<String, String> rpcDtoByRegionCodes = new HashMap();
        if (!storeCodes.isEmpty()) {
            storeDetailRpcDTOMap = this.rmiOrgStoreService.queryByStoreCodes(new ArrayList<String>(storeCodes)).stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, Function.identity()));
        }
        if (!regionCodes.isEmpty()) {
            rpcDtoByRegionCodes = this.rmiOrgRegionRpcService.findRpcDtoByRegionCodes(regionCodes);
        }
        ArrayList<ScpOrderTemplateSaveVO> scpOrderTemplateSaveVOS = new ArrayList<ScpOrderTemplateSaveVO>();
        for (int i = 0; i < dataList.size(); ++i) {
            int rowIndex = startRowIndex + i;
            try {
                ScpOrderTemplateImportVO importVO = dataList.get(i);
                this.validateRow(importVO, rowIndex, storeDetailRpcDTOMap, rpcDtoByRegionCodes, errorList);
                ScpOrderTemplateSaveVO saveVO = this.convertToSaveVO(importVO, obDocTypeMap, demandSetTypeMap, DATE_FORMATTER, TIME_FORMATTER, storeDetailRpcDTOMap);
                scpOrderTemplateSaveVOS.add(saveVO);
                errorList.add("");
                continue;
            }
            catch (Exception e) {
                errorList.add("\u7b2c" + rowIndex + "\u884c\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty(scpOrderTemplateSaveVOS)) {
            this.addOrUpdate(scpOrderTemplateSaveVOS);
        }
        return errorList;
    }

    private void checkImportData(List<ScpOrderTemplateImportVO> dataList, int startRowIndex) {
        Set<String> regionCodes = dataList.stream().map(ScpOrderTemplateImportVO::getRegionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<String> storeCodes = dataList.stream().map(e -> e.getStoreCode()).collect(Collectors.toList());
        Map<String, String> regionMap = this.rmiOrgRegionRpcService.findRpcDtoByRegionCodes(regionCodes);
        List<OrgStoreDetailRpcDTO> orgStoreDTOS = this.rmiOrgStoreRpcService.queryByStoreCodes(storeCodes);
        Map<String, String> storeMap = orgStoreDTOS.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, OrgStoreDetailRpcDTO::getStoreName));
        for (int i = 0; i < dataList.size(); ++i) {
            ScpOrderTemplateImportVO vo = dataList.get(i);
            int rowNum = startRowIndex;
            if (vo.getRegionCode() != null) {
                if (vo.getRegion() == null) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u533a\u57df\u7f16\u7801 " + vo.getRegionCode() + " \u5bf9\u5e94\u9700\u6c42\u533a\u57df\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!regionMap.containsKey(vo.getRegionCode())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u533a\u57df\u7f16\u7801 " + vo.getRegionCode() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                if (!regionMap.get(vo.getRegionCode()).equals(vo.getRegion())) {
                    throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u533a\u57df\u7f16\u7801 " + vo.getRegionCode() + " \u4e0e\u9700\u6c42\u533a\u57df\u540d\u79f0 " + vo.getRegion() + "\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            if (vo.getStoreCode() == null) continue;
            if (vo.getStoreName() == null) {
                throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u95e8\u5e97\u7f16\u7801 " + vo.getStoreCode() + " \u5bf9\u5e94\u9700\u6c42\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (!storeMap.containsKey(vo.getStoreCode())) {
                throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u95e8\u5e97\u7f16\u7801 " + vo.getStoreCode() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (storeMap.get(vo.getStoreCode()).equals(vo.getStoreName())) continue;
            throw new BusinessException("\u7b2c " + rowNum + " \u884c\uff1a\u9700\u6c42\u95e8\u5e97\u7f16\u7801 " + vo.getStoreCode() + " \u4e0e\u9700\u6c42\u95e8\u5e97\u540d\u79f0 " + vo.getStoreName() + " \u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void validateRow(ScpOrderTemplateImportVO importVO, int rowIndex, Map<String, OrgStoreDetailRpcDTO> storeDetailRpcDTOMap, Map<String, String> rpcDtoByRegionCodes, List<String> errorList) {
        boolean hasStoreCode = StringUtils.isNotBlank((String)importVO.getStoreCode());
        boolean hasRegionCode = StringUtils.isNotBlank((String)importVO.getRegionCode());
        if (!hasStoreCode && !hasRegionCode) {
            throw new RuntimeException("\u95e8\u5e97\u4ee3\u7801,\u533a\u57df\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (hasStoreCode && hasRegionCode) {
            throw new RuntimeException("\u95e8\u5e97\u4ee3\u7801,\u533a\u57df\u4e0d\u80fd\u540c\u65f6\u586b\u5199");
        }
        if (hasStoreCode && !storeDetailRpcDTOMap.containsKey(importVO.getStoreCode())) {
            throw new RuntimeException("\u95e8\u5e97\u7f16\u7801:" + importVO.getStoreCode() + "\u4e0d\u5b58\u5728");
        }
        if (hasRegionCode && !rpcDtoByRegionCodes.containsKey(importVO.getRegionCode())) {
            throw new RuntimeException("\u533a\u57df\u7f16\u7801:" + importVO.getRegionCode() + "\u4e0d\u5b58\u5728");
        }
    }

    private ScpOrderTemplateSaveVO convertToSaveVO(ScpOrderTemplateImportVO importVO, Map<String, String> obDocTypeMap, Map<String, String> demandSetTypeMap, DateTimeFormatter dateFormatter, DateTimeFormatter timeFormatter, Map<String, OrgStoreDetailRpcDTO> storeDetailRpcDTOMap) {
        ScpOrderTemplateSaveVO saveVO = new ScpOrderTemplateSaveVO();
        BeanUtils.copyProperties((Object)importVO, (Object)saveVO, (String[])new String[0]);
        saveVO.setDocType(obDocTypeMap.get(importVO.getDocTypeName()));
        saveVO.setType(demandSetTypeMap.get(importVO.getType()));
        try {
            saveVO.setStartDate(LocalDate.parse(importVO.getStartDate(), dateFormatter));
            saveVO.setEndDate(LocalDate.parse(importVO.getEndDate(), dateFormatter));
            saveVO.setDeadlineTime(LocalTime.parse(importVO.getDeadlineTime(), timeFormatter));
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u6570\u636e", e);
        }
        saveVO.setStoreName(Optional.ofNullable(storeDetailRpcDTOMap.get(importVO.getStoreCode())).map(OrgStoreDetailRpcDTO::getStoreName).orElse(null));
        return saveVO;
    }

    public ScpOrderTemplateServiceImpl(ScpOrderTemplateRepo scpOrderTemplateRepo, ScpOrderTemplateRepoProc scpOrderTemplateRepoProc, UdcProvider udcProvider, RmiOrgStoreRpcService rmiOrgStoreService, RmiOrgRegionRpcService rmiOrgRegionRpcService, OrgRegionRpcService orgRegionRpcService, RmiOrgStoreRpcService rmiOrgStoreRpcService) {
        this.scpOrderTemplateRepo = scpOrderTemplateRepo;
        this.scpOrderTemplateRepoProc = scpOrderTemplateRepoProc;
        this.udcProvider = udcProvider;
        this.rmiOrgStoreService = rmiOrgStoreService;
        this.rmiOrgRegionRpcService = rmiOrgRegionRpcService;
        this.orgRegionRpcService = orgRegionRpcService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
    }
}

